package com.yim.core

import android.content.Context
import com.yim.manager.YIMConversationManager
import com.yim.manager.YIMEventManager
import com.yim.manager.YIMListenerManager
import com.yim.manager.YIMMessageManager
import com.yim.manager.YIMSDKManager
import com.yim.manager.YIMTeamManager
import com.yim.manager.YIMUserManager
import com.yim.manager.YIMUtilsManager
import com.yim.model.YIMOption

class _YIMCore {
    companion object {
        fun init(context: Context, option: YIMOption) = YIMSDKManager.instance.init(context, option)
        val utilsManager by lazy { YIMUtilsManager.instance }
        val userManager by lazy { YIMUserManager.instance }
        val listenerManager by lazy { YIMListenerManager.instance }
        val conversationManager by lazy { YIMConversationManager.instance }
        val messageManager by lazy { YIMMessageManager.instance }
        val teamManager by lazy { YIMTeamManager.instance }
        val eventManager by lazy { YIMEventManager.instance }
    }
}
