package com.yim.manager

import com.yim.model.YIMEnum_EventOnline
import com.yim.model._YIMSDK

class YIMEventManager private constructor() {
    init {
        if (_YIMSDK.option == null || _YIMSDK.context == null) _YIMSDK.utils.yimLog("${javaClass.simpleName}:Please init First!")
    }

    companion object {
        internal val instance by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) { YIMEventManager() }
    }

    internal val _event_users = mutableSetOf<String>()
    internal var _event_onlineStatus: ((user: String, event: YIMEnum_EventOnline) -> Unit)? = null

    fun register_onlineStatus(
        users: List<String>,
        onRegister: ((isSuccess: Boolean) -> Unit)? = null,
        onEvent: ((user: String, event: YIMEnum_EventOnline) -> Unit),
    ) {
        if (users.isEmpty() || users.toSet().size != users.size) {
            _YIMSDK.utils.runOnUIThread {
                onRegister?.invoke(false)
            }
            return
        }
        _YIMSDK.server.emit(
            "register_online", mapOf(
                "users" to _YIMSDK.utils.toJson(users),
            )
        ) { isSuccess, results, code, msg ->
            if (isSuccess) {
                _event_users.addAll(users)
                _event_onlineStatus = onEvent
            }
            _YIMSDK.utils.runOnUIThread {
                onRegister?.invoke(isSuccess)
            }
        }
    }

    fun unRegister_onlineStatus(
        users: List<String>,
        onUnRegister: ((isSuccess: Boolean) -> Unit)? = null,
    ) {
        if (users.isEmpty() || users.toSet().size != users.size) {
            _YIMSDK.utils.runOnUIThread {
                onUnRegister?.invoke(false)
            }
            return
        }
        _YIMSDK.server.emit(
            "register_offline", mapOf(
                "users" to _YIMSDK.utils.toJson(users),
            )
        ) { isSuccess, results, code, msg ->
            if (isSuccess) {
                users.forEach { _event_users.remove(it) }
                if (_event_users.isEmpty()) _event_onlineStatus = null
            }
            _YIMSDK.utils.runOnUIThread {
                onUnRegister?.invoke(isSuccess)
            }
        }
    }
}
