package com.yim.manager

import com.yim.model.YIMBroadcastMessage
import com.yim.model.YIMEnum_OnlineState
import com.yim.model.YIMMessage
import com.yim.model.YIMNotificationMessage
import com.yim.model.YIMResult
import com.yim.model.YIMRevokeMessage
import com.yim.model._YIMSDK

class YIMListenerManager private constructor() {
    init {
        if (_YIMSDK.option == null || _YIMSDK.context == null) _YIMSDK.utils.yimLog("${javaClass.simpleName}:Please init First!")
    }

    companion object {
        internal val instance by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) { YIMListenerManager() }
    }

    internal var callback_status_online: ((result: YIMResult<YIMEnum_OnlineState>) -> (Unit))? = null
    internal var callback_recentConversation: (() -> (Unit))? = null
    internal var callback_message: ((messages: List<YIMMessage>) -> (Unit))? = null
    internal var callback_broadcast: ((broadcastMessage: YIMBroadcastMessage) -> (Unit))? = null
    internal var callback_notification: ((notificationMessage: YIMNotificationMessage) -> (Unit))? = null
    internal var callback_revoke: ((revokeMessage: YIMRevokeMessage) -> (Unit))? = null
    internal var callback_status_msg_receipt: ((messageID: String) -> (Unit))? = null

    fun register_status_online(callback: (result: YIMResult<YIMEnum_OnlineState>) -> (Unit)) = callback.also { this.callback_status_online = it }
    fun unRegister_status_online() = null.also { callback_status_online = it }
    fun register_recentConversation(callback: () -> (Unit)) = callback.also { this.callback_recentConversation = it }
    fun unRegister_recentConversation() = null.also { callback_recentConversation = it }
    fun register_message(callback: (messages: List<YIMMessage>) -> (Unit)) = callback.also { this.callback_message = it }
    fun unRegister_message() = null.also { callback_message = it }
    fun register_broadcast(callback: (broadcastMessage: YIMBroadcastMessage) -> (Unit)) = callback.also { this.callback_broadcast = it }
    fun unRegister_broadcast() = null.also { callback_broadcast = it }
    fun register_notification(callback: (notificationMessage: YIMNotificationMessage) -> (Unit)) = callback.also { this.callback_notification = it }
    fun unRegister_notification() = null.also { callback_notification = it }
    fun register_revoke(callback: (revokeMessage: YIMRevokeMessage) -> (Unit)) = callback.also { this.callback_revoke = it }
    fun unRegister_revoke() = null.also { callback_revoke = it }
    fun register_status_msg_receipt(callback: (messageID: String) -> (Unit)) = callback.also { this.callback_status_msg_receipt = it }
    fun unRegister_status_msg_receipt() = null.also { callback_status_msg_receipt = it }
}
