package com.yim.manager

import android.content.Context
import com.yim.model.YIMOption
import com.yim.model._YIMSDK

internal class YIMSDKManager private constructor() {
    companion object {
        internal val instance by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) { YIMSDKManager() }
    }

    fun init(
        context: Context,
        option: YIMOption,
    ) {
        _YIMSDK.context = context
        _YIMSDK.option = option
        if (!option.server.isNullOrEmpty()) _YIMSDK.config.server = option.server!!
        if (option.debug != null) _YIMSDK.config.debug = option.debug!!
    }
}
