package com.yim.manager

import com.google.gson.Gson
import com.yim.core._YIMCore
import com.yim.model.YIMTeam
import com.yim.model._YIMSDK

class YIMTeamManager private constructor() {
    init {
        if (_YIMSDK.option == null || _YIMSDK.context == null) _YIMSDK.utils.yimLog("${javaClass.simpleName}:Please init First!")
    }

    companion object {
        internal val instance by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) { YIMTeamManager() }
    }

    fun queryInfo(
        teamID: String,
        callback: (isSuccess: Boolean, team: YIMTeam?) -> Unit,
    ) {
        if (!_YIMCore.userManager.isLogin()) {
            _YIMSDK.utils.runOnUIThread {
                callback.invoke(false, null)
            }
            return
        }
        _YIMSDK.server.emit(
            "queryTeamInfo", mapOf(
                "teamID" to teamID,
            )
        ) { isSuccess, results, code, msg ->
            if (!isSuccess) {
                _YIMSDK.utils.runOnUIThread {
                    callback.invoke(false, null)
                }
                return@emit
            }
            _YIMSDK.utils.runOnUIThread {
                callback.invoke(true, Gson().fromJson(_YIMSDK.utils.toJson(results!!["team"]!!), YIMTeam::class.java))
            }
        }
    }
}
