package com.yim.manager

import com.google.gson.Gson
import com.yim.core._YIMCore
import com.yim.model.YIMEnum_LoginResult
import com.yim.model.YIMResult
import com.yim.model.YIMUser
import com.yim.model._YIMSDK

class YIMUserManager private constructor() {
    init {
        if (_YIMSDK.option == null || _YIMSDK.context == null) _YIMSDK.utils.yimLog("${javaClass.simpleName}:Please init First!")
    }

    companion object {
        internal val instance by lazy(mode = LazyThreadSafetyMode.SYNCHRONIZED) { YIMUserManager() }
    }

    fun login(
        user: String,
        token: String,
        callback: ((YIMResult<YIMEnum_LoginResult>) -> Unit)? = null
    ) {
        _YIMSDK.server.init(user, token, callback)
    }

    fun logout() {
        _YIMCore.eventManager._event_users.clear()
        _YIMCore.eventManager._event_onlineStatus = null
        _YIMSDK.db.dispose()
        _YIMSDK.server.dispose(false)
        _YIMSDK.currentUser = null
    }

    fun isLogin(
        needCheckConnect: Boolean = false,
    ): Boolean {
        return if (needCheckConnect) {
            _YIMSDK.currentUser != null && (_YIMSDK.server.socket?.connected() ?: false)
        } else {
            _YIMSDK.currentUser != null
        }
    }

    fun queryInfo(
        user: String,
        callback: (isSuccess: Boolean, user: YIMUser?) -> Unit,
    ) {
        if (!_YIMCore.userManager.isLogin()) {
            _YIMSDK.utils.runOnUIThread {
                callback.invoke(false, null)
            }
            return
        }
        _YIMSDK.server.emit(
            "queryUserInfo", mapOf(
                "accid" to user,
            )
        ) { isSuccess, results, code, msg ->
            if (!isSuccess) {
                _YIMSDK.utils.runOnUIThread {
                    callback.invoke(false, null)
                }
                return@emit
            }
            _YIMSDK.utils.runOnUIThread {
                callback.invoke(
                    true,
                    Gson().fromJson(_YIMSDK.utils.toJson(results!!["user"]!!), YIMUser::class.java)
                )
            }
        }
    }
}
