package com.yim.model

import com.google.gson.annotations.SerializedName

enum class YIMEnum_LoginResult {
    Success, Failed, Exception
}

enum class YIMEnum_OnlineState {
    Reconnecting, Reconnected, Kick
}

enum class YIMEnum_ConversationType(val rawValue: String) {
    @SerializedName("")
    UnKnown(""),

    @SerializedName("0")
    P2P("0"),

    @SerializedName("1")
    Team("1"),

    @SerializedName("2")
    ChatRoom("2")
}

enum class YIMEnum_QueryDirection(val rawValue: String) {
    @SerializedName("")
    UnKnown(""),

    @SerializedName("1")
    Old("1"),

    @SerializedName("2")
    New("2")
}

enum class YIMEnum_MessageState(val rawValue: String) {
    @SerializedName("")
    UnKnown(""),

    @SerializedName("1")
    Sending("1"),

    @SerializedName("2")
    Success_UnRead("2"),

    @SerializedName("3")
    Success_Read("3"),

    @SerializedName("4")
    Fail("4")
}

enum class YIMEnum_EventOnline { Online, Offline }

enum class YIMEnum_MessageType(val rawValue: String) {
    @SerializedName("")
    UnKnown(""),

    @SerializedName("0")
    Text("0"),

    @SerializedName("1")
    Audio("1"),

    @SerializedName("2")
    Image("2"),

    @SerializedName("3")
    Video("3"),

    @SerializedName("4")
    File("4"),

    @SerializedName("5")
    Custom("5"),
}

enum class YIMEnum_AttachmentType(val rawValue: String) {
    @SerializedName("")
    UnKnown(""),

    @SerializedName("1")
    Audio("1"),

    @SerializedName("2")
    Image("2"),

    @SerializedName("3")
    Video("3"),

    @SerializedName("4")
    File("4")
}

internal enum class _YIMEnum_ConversatypeUnRead { Plus, Minus, Zero, Nothing }