package com.yim.model

import android.content.Context
import com.google.gson.Gson
import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import com.google.gson.JsonObject
import com.google.gson.JsonPrimitive
import com.google.gson.JsonSerializationContext
import com.google.gson.JsonSerializer
import com.google.gson.annotations.JsonAdapter
import com.yim.config.YIMConfig
import com.yim.utils._YIMCompress
import com.yim.utils._YIMDB
import com.yim.utils._YIMOSS
import com.yim.utils._YIMPush
import com.yim.utils._YIMServer
import com.yim.utils._YIMTable_Conversation
import com.yim.utils._YIMTable_Message
import com.yim.utils._YIMUtils
import io.objectbox.annotation.Convert
import io.objectbox.converter.PropertyConverter
import java.lang.reflect.Type
import java.util.Locale

internal object _YIMSDK {
    var context: Context? = null
    var option: YIMOption? = null
    var currentUser: String? = null
    var oss = _YIMOSS()
    var push = _YIMPush()
    var compress = _YIMCompress()
    var db = _YIMDB()
    var server = _YIMServer()
    var utils = _YIMUtils()
    var config = YIMConfig()
}

class YIMResult<T> {
    constructor(code: T, msg: String) {
        this.code = code
        this.msg = msg
    }

    val code: T
    val msg: String
}

class YIMOption {
    @JvmOverloads
    constructor(appKey: String, server: String? = null, debug: Boolean? = null) {
        this.appKey = appKey
        this.server = server
        this.debug = debug
    }

    val appKey: String
    var server: String? = null
    var debug: Boolean? = null
}

class YIMMessage {
    internal constructor()

    internal constructor(message: _YIMTable_Message) {
        this.id = message.id
        this.content = message.content
        this.from = message.from
        this.to = message.to
        this.conversationType = message.conversationType
        this.messageType = message.messageType
        this.messageState = message.messageState
        this.time = message.time
        this.localExt = message.localExt
        this.isRevoke = message.isRevoke
        this.attachment = message.attachment
    }

    var id: String = ""
    var content: String? = null
    var from: String = ""
    var to: String = ""
    var conversationType: YIMEnum_ConversationType = YIMEnum_ConversationType.UnKnown
    var messageType: YIMEnum_MessageType = YIMEnum_MessageType.UnKnown
    var messageState: YIMEnum_MessageState = YIMEnum_MessageState.UnKnown
    var time: Long = 0
    var localExt: Map<String, Any>? = null
    var isRevoke: Boolean = false
    var attachment: YIMAttachment? = null

    fun getConversationID(): String {
        return when (conversationType) {
            YIMEnum_ConversationType.P2P -> if (getIsMine()) to else from
            YIMEnum_ConversationType.Team -> to
            YIMEnum_ConversationType.ChatRoom -> to
            else -> ""
        }
    }

    fun getIsMine(): Boolean {
        return from == _YIMSDK.currentUser
    }
}

class YIMConversation {
    internal constructor(conversation: _YIMTable_Conversation) {
        this.lastMessage = YIMMessage(conversation.lastMessage)
        this.unRead = conversation.unRead
    }

    var lastMessage: YIMMessage
    var unRead: Int = 0
}

class YIMBroadcastMessage {
    var id: String = ""
    var from: String = ""
    var content: String = ""
    var time: Long = 0
}

class YIMNotificationMessage {
    var id: String = ""
    var from: String = ""
    var content: String = ""
    var time: Long = 0
}

class YIMRevokeMessage {
    var messageID: String = ""
    var conversationID: String = ""
    var conversationType = YIMEnum_ConversationType.UnKnown
}

class YIMUser {
    var id: String = ""
    var name: String = ""
    var icon: String = ""
    var ext: String = ""
}

class YIMTeam {
    var id: String = ""
    var name: String = ""
    var icon: String = ""
    var ext: String = ""
}

class YIMAttachment {
    @Convert(converter = YIMEnum_AttachmentType_Converter::class, dbType = String::class)
    var type: YIMEnum_AttachmentType = YIMEnum_AttachmentType.UnKnown
    var url: String = ""
    var size: Long = 0
    var format: String = ""

    @Convert(converter = YIMAttachmentExt_Converter::class, dbType = String::class)
    @JsonAdapter(value = YIMAttachmentExtJsonAdapter::class)
    var ext: _YIMAttachmentExt? = null

    internal class YIMEnum_AttachmentType_Converter : PropertyConverter<YIMEnum_AttachmentType?, String?> {
        override fun convertToEntityProperty(databaseValue: String?) = (if (databaseValue == null) null else YIMEnum_AttachmentType.values().first { it.rawValue == databaseValue })
        override fun convertToDatabaseValue(entityProperty: YIMEnum_AttachmentType?) = entityProperty?.rawValue
    }

    internal class YIMAttachmentExt_Converter : PropertyConverter<_YIMAttachmentExt?, String?> {
        override fun convertToEntityProperty(databaseValue: String?): _YIMAttachmentExt? {
            if (databaseValue == null) return null
            return when (Gson().fromJson(databaseValue, _YIMAttachmentExt::class.java).type) {
                YIMEnum_AttachmentType.Audio -> Gson().fromJson(databaseValue, YIMAttachmentExt_Audio::class.java)
                YIMEnum_AttachmentType.Image -> Gson().fromJson(databaseValue, YIMAttachmentExt_Image::class.java)
                YIMEnum_AttachmentType.Video -> Gson().fromJson(databaseValue, YIMAttachmentExt_Video::class.java)
                YIMEnum_AttachmentType.File -> Gson().fromJson(databaseValue, YIMAttachmentExt_File::class.java)
                else -> null
            }
        }

        override fun convertToDatabaseValue(entityProperty: _YIMAttachmentExt?) = if (entityProperty == null) null else _YIMSDK.utils.toJson(entityProperty)
    }

    internal class YIMAttachmentExtJsonAdapter : JsonDeserializer<_YIMAttachmentExt>, JsonSerializer<_YIMAttachmentExt> {
        override fun deserialize(json: JsonElement?, typeOfT: Type?, context: JsonDeserializationContext?): _YIMAttachmentExt? {
            if (json == null) return null
            return when (YIMEnum_AttachmentType.values().first { it.rawValue == json.asJsonObject.get("type").asString }) {
                YIMEnum_AttachmentType.Audio -> Gson().fromJson(json.toString(), YIMAttachmentExt_Audio::class.java)
                YIMEnum_AttachmentType.Image -> Gson().fromJson(json.toString(), YIMAttachmentExt_Image::class.java)
                YIMEnum_AttachmentType.Video -> Gson().fromJson(json.toString(), YIMAttachmentExt_Video::class.java)
                YIMEnum_AttachmentType.File -> Gson().fromJson(json.toString(), YIMAttachmentExt_File::class.java)
                else -> null
            }
        }

        override fun serialize(src: _YIMAttachmentExt?, typeOfSrc: Type?, context: JsonSerializationContext?): JsonElement {
            return Gson().fromJson(Gson().toJson(src), JsonObject::class.java)
        }
    }

    internal class BooleanJsonAdapter : JsonDeserializer<Boolean>, JsonSerializer<Boolean> {
        override fun deserialize(json: JsonElement, typeOfT: Type?, context: JsonDeserializationContext?): Boolean {
            val jsonPrimitive = json.asJsonPrimitive
            return if (jsonPrimitive.isBoolean) {
                jsonPrimitive.asBoolean
            } else if (jsonPrimitive.isNumber) {
                jsonPrimitive.asNumber.toInt() == 1
            } else if (jsonPrimitive.isString) {
                listOf("true", "1", "yes").contains(jsonPrimitive.asString.lowercase(Locale.getDefault()))
            } else false
        }

        override fun serialize(src: Boolean, typeOfSrc: Type?, context: JsonSerializationContext?): JsonElement {
            return JsonPrimitive(if (src) "1" else "0")
        }
    }
}

open class _YIMAttachmentExt {
    var type: YIMEnum_AttachmentType = YIMEnum_AttachmentType.UnKnown
}

class YIMAttachmentExt_Audio : _YIMAttachmentExt() {
    init {
        type = YIMEnum_AttachmentType.Audio
    }

    var duration: Long = 0
}

class YIMAttachmentExt_Image : _YIMAttachmentExt() {
    init {
        type = YIMEnum_AttachmentType.Image
    }

    @JsonAdapter(value = YIMAttachment.BooleanJsonAdapter::class)
    var compress: Boolean = false
}

class YIMAttachmentExt_Video : _YIMAttachmentExt() {
    init {
        type = YIMEnum_AttachmentType.Video
    }

    var duration: Long = 0
    var image: String = ""

    @JsonAdapter(value = YIMAttachment.BooleanJsonAdapter::class)
    var compress: Boolean = false
}

class YIMAttachmentExt_File : _YIMAttachmentExt() {
    init {
        type = YIMEnum_AttachmentType.File
    }

    var name: String = ""
}

class YIMPushOption {
    var title: String? = null
    var content: String? = null
    var extras: Map<*, *>? = null
    var configs: YIMPushOption_Config? = null
}

class YIMPushOption_Config {
    var android: YIMPushOption_Config_Android? = null
    var ios: YIMPushOption_Config_Ios? = null
}

class YIMPushOption_Config_Android {
    var intent_uri: String? = null
}

class YIMPushOption_Config_Ios {
    var isSandbox: Boolean? = null
}