package com.yim.utils

import android.graphics.Bitmap
import android.graphics.BitmapFactory
import android.media.MediaMetadataRetriever
import com.otaliastudios.transcoder.Transcoder
import com.otaliastudios.transcoder.TranscoderListener
import com.otaliastudios.transcoder.strategy.DefaultAudioStrategy
import com.otaliastudios.transcoder.strategy.DefaultVideoStrategy
import com.yim.model._YIMSDK
import top.zibin.luban.Luban
import top.zibin.luban.OnCompressListener
import java.io.ByteArrayOutputStream
import java.io.File
import java.io.FileOutputStream
import java.text.SimpleDateFormat
import java.util.Date
import java.util.Locale

internal class _YIMCompress {
    private fun getFileName(path: String) = path.split("/").last()
    private fun getFileExtName(path: String) = path.split("/").last().split(".").last().lowercase(Locale.getDefault())
    private fun getDir(dir: String): String {
        val path = "${_YIMSDK.context!!.filesDir}/${dir}/"
        if (!File(path).exists()) File(path).mkdirs()
        return path
    }

    fun compressImage(imagePath: String, onFinish: (result: String?) -> Unit) {
        fun convertHeicToJpeg(heic: String): String {
            try {
                val bitmap = BitmapFactory.decodeFile(heic)
                val file = File("${_YIMSDK.context!!.cacheDir}/${System.currentTimeMillis()}.jpg")
                file.createNewFile()
                bitmap.compress(Bitmap.CompressFormat.JPEG, 100, FileOutputStream(file))
                return file.path
            } catch (_: Exception) {
            }
            return heic
        }

        val file = File(imagePath)
        val extName = getFileExtName(file.path)
        if (extName == "gif") return onFinish(file.path)
        val path = convertHeicToJpeg(file.path)
        Luban.with(_YIMSDK.context)
            .load(path)
            .ignoreBy(100)
            .setTargetDir(getDir("compress/image"))
            .setCompressListener(object : OnCompressListener {
                override fun onStart() {}
                override fun onSuccess(file: File) {
                    onFinish(file.path)
                }

                override fun onError(e: Throwable) {
                    onFinish(path)
                }
            }).launch()
    }

    fun compressVideo(videoPath: String, onFinish: (result: String?) -> Unit) {
        val tempDir: String = _YIMSDK.context!!.getExternalFilesDir("video_compress")!!.absolutePath
        val out = SimpleDateFormat("yyyy-MM-dd hh-mm-ss").format(Date())
        val destPath: String = tempDir + File.separator + "VID_" + out + videoPath.hashCode() + ".mp4"
        Transcoder.into(destPath)
            .addDataSource(videoPath)
            .setAudioTrackStrategy(
                DefaultAudioStrategy.builder()
                    .channels(DefaultAudioStrategy.CHANNELS_AS_INPUT)
                    .sampleRate(DefaultAudioStrategy.SAMPLE_RATE_AS_INPUT)
                    .build()
            )
            .setVideoTrackStrategy(
                DefaultVideoStrategy.Builder()
                    .keyFrameInterval(3f)
                    .bitRate(1280 * 720 * 4.toLong())
                    .frameRate(30)
                    .build()
            )
            .setListener(object : TranscoderListener {
                override fun onTranscodeCanceled() {}
                override fun onTranscodeProgress(progress: Double) {}
                override fun onTranscodeCompleted(successCode: Int) {
                    onFinish(destPath)
                }

                override fun onTranscodeFailed(exception: Throwable) {
                    onFinish(destPath)
                }
            }).transcode()
    }

    fun getVideoFirstFrame(filePath: String): String {
        val retriever = MediaMetadataRetriever()
        retriever.setDataSource(filePath)
        val bmp = retriever.getFrameAtTime(-1, MediaMetadataRetriever.OPTION_CLOSEST_SYNC)!!
        val dir = _YIMSDK.context!!.getExternalFilesDir("video_compress")
        if (dir != null && !dir.exists()) dir.mkdirs()
        val stream = ByteArrayOutputStream()
        bmp.compress(Bitmap.CompressFormat.JPEG, 100, stream)
        bmp.recycle()
        val file = File(dir, filePath.substring(filePath.lastIndexOf('/'), filePath.lastIndexOf('.')) + ".jpg")
        try {
            if (file.exists()) file.delete()
            file.createNewFile()
            file.writeBytes(stream.toByteArray())
        } catch (_: Exception) {
        }
        return file.path
    }
}