package com.yim.utils

import com.alibaba.sdk.android.oss.ClientConfiguration
import com.alibaba.sdk.android.oss.ClientException
import com.alibaba.sdk.android.oss.OSSClient
import com.alibaba.sdk.android.oss.ServiceException
import com.alibaba.sdk.android.oss.callback.OSSCompletedCallback
import com.alibaba.sdk.android.oss.callback.OSSProgressCallback
import com.alibaba.sdk.android.oss.common.auth.OSSStsTokenCredentialProvider
import com.alibaba.sdk.android.oss.model.ObjectMetadata
import com.alibaba.sdk.android.oss.model.PutObjectRequest
import com.alibaba.sdk.android.oss.model.PutObjectResult
import com.yim.model._YIMSDK
import java.util.Locale
import java.util.UUID


internal class _YIMOSS {
    var ossClient: OSSClient? = null
    var endpoint = ""
    var bucketName = ""

    fun init(data: Map<*, *>?) {
        if (data == null) return
        endpoint = data["ossEndpoint"].toString()
        bucketName = data["bucketName"].toString()
        val accessKeyId = data["accessKey"].toString()
        val accessKeySecret = data["accessSecret"].toString()
        val securityToken = data["secureToken"].toString()
        val configuration = ClientConfiguration()
        ossClient = OSSClient(_YIMSDK.context, endpoint, OSSStsTokenCredentialProvider(accessKeyId, accessKeySecret, securityToken), configuration)
    }

    fun upload(
        filePath: String,
        dir: String,
        onProgress: ((count: Long, total: Long) -> Unit)?,
        onFinish: ((isSuccess: Boolean, url: String?, error: String?) -> Unit)?,
    ) {
        if (ossClient == null) {
            onFinish?.invoke(false, null, "can not upload file")
            return
        }

        val path = "client/${dir}/android_${UUID.randomUUID().toString().replace("-", "")}.${filePath.split("/").last().split(".").last()}"
        val put = PutObjectRequest(bucketName, path, filePath)
        put.progressCallback = OSSProgressCallback { request, currentSize, totalSize ->
            onProgress?.invoke(currentSize, totalSize)
        }
        val metadata = ObjectMetadata()
        metadata.setHeader("x-oss-forbid-overwrite", true)
        metadata.setHeader("x-oss-object-acl", "public-read")
        metadata.setHeader("x-oss-storage-class", "Standard")
        put.metadata = metadata
        ossClient!!.asyncPutObject(put, object : OSSCompletedCallback<PutObjectRequest?, PutObjectResult> {
            override fun onSuccess(request: PutObjectRequest?, result: PutObjectResult) {
                onFinish?.invoke(true, "https://${put.bucketName}.${endpoint}/$path", null)
            }

            override fun onFailure(request: PutObjectRequest?, clientExcepion: ClientException, serviceException: ServiceException) {
                onFinish?.invoke(false, null, null)
            }
        })
    }

    fun ossVideo2Image(videoUrl: String, width: Int = 0): String {
        return "$videoUrl?x-oss-process=video/snapshot,w_${width},t_1000,m_fast,f_jpg,ar_auto";
    }

    fun ossCompressImage(imageUrl: String, maxSize: Int = 1080, quality: Int = 70): String {
        val baseUrl = imageUrl.split('?').first()
        val format = baseUrl.split(".").last().uppercase(Locale.getDefault())
        return if (listOf("JPG", "JPEG", "WEBP").contains(format)) {
            "$baseUrl?x-oss-process=image/resize,m_lfit,limit_1,l_$maxSize/quality,Q_$quality"
        } else if (listOf("PNG", "GIF").contains(format)) {
            "$baseUrl?x-oss-process=image/resize,m_lfit,limit_1,l_$maxSize"
        } else {
            imageUrl
        }
    }
}