package com.yim.utils

import com.yim.model._YIMSDK
import com.ypush.YPush
import com.ypush.model.YPushOption
import com.ypush.model.YPushOption_HONOR
import com.ypush.model.YPushOption_HUAWEI
import com.ypush.model.YPushOption_MEIZU
import com.ypush.model.YPushOption_OPPO
import com.ypush.model.YPushOption_VIVO
import com.ypush.model.YPushOption_XIAOMI

internal class _YIMPush {
    fun init(data: Map<*, *>?) {
        if (data == null) return
        val appKey = data["appKey"].toString()
        val xiaomi = data["xiaomi"] as Map<*, *>?
        val huawei = data["huawei"] as Map<*, *>?
        val honor = data["honor"] as Map<*, *>?
        val oppo = data["oppo"] as Map<*, *>?
        val vivo = data["vivo"] as Map<*, *>?
        val meizu = data["meizu"] as Map<*, *>?
        YPush.init(
            _YIMSDK.context!!, YPushOption(
                appKey = appKey,
                xiaomi = if (xiaomi == null) null else YPushOption_XIAOMI(xiaomi["APP_ID"].toString(), xiaomi["APP_KEY"].toString()),
                huawei = if (huawei == null) null else YPushOption_HUAWEI(huawei["APP_ID"].toString()),
                honor = if (honor == null) null else YPushOption_HONOR(honor["app_id"].toString()),
                oppo = if (oppo == null) null else YPushOption_OPPO(oppo["appKey"].toString(), oppo["appSecret"].toString()),
                vivo = if (vivo == null) null else YPushOption_VIVO(vivo["app_id"].toString(), vivo["api_key"].toString()),
                meizu = if (meizu == null) null else YPushOption_MEIZU(meizu["AppId"].toString(), meizu["AppKey"].toString()),
            )
        )
        _YIMSDK.utils.runOnUIThread(2000) {
            YPush.setAlias(_YIMSDK.currentUser)
        }
    }
}