package com.yim.utils

import android.os.Handler
import android.os.Looper
import android.util.Log
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.yim.model._YIMSDK
import org.json.JSONArray
import org.json.JSONObject

internal class _YIMUtils {
    fun yimLog(content: String) {
        if (_YIMSDK.config.debug) Log.e("[YIMLog]", content)
    }

    fun toJson(obj: Any): String {
        if (obj is JSONObject || obj is JSONArray) return obj.toString()
        val jsonStr = Gson().toJson(obj)
        val excludeKeys = listOf("t_id")
        if (excludeKeys.isEmpty()) return jsonStr
        try {
            val list = Gson().fromJson(jsonStr, object : TypeToken<List<HashMap<*, *>>>() {})
            list.forEach { item ->
                excludeKeys.forEach { item.remove(it) }
            }
            return Gson().toJson(list)
        } catch (e: Exception) {
            try {
                val map = Gson().fromJson(jsonStr, HashMap::class.java)
                excludeKeys.forEach { map.remove(it) }
                return Gson().toJson(map)
            } catch (e: Exception) {
                return jsonStr
            }
        }
    }

    fun jsonObjectToMap(jsonObject: JSONObject?): Map<*, *>? {
        if (jsonObject == null) return null
        return Gson().fromJson(jsonObject.toString(), Map::class.java)
    }

//    fun jsonArrayToList(jsonArray: JSONArray?): List<*>? {
//        if (jsonArray == null) return null
//        return Gson().fromJson(jsonArray.toString(), List::class.java)
//    }

    fun runOnUIThread(delay: Long = 0, callback: () -> Unit) {
        try {
            Handler(Looper.getMainLooper()).postDelayed({
                try {
                    callback()
                } catch (_: Exception) {
                }
            }, delay)
        } catch (_: Exception) {
        }
    }
}