/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.integ.util;

import com.amazonaws.appflow.custom.connector.integ.providers.ServiceProvider;
import com.amazonaws.appflow.custom.connector.integ.util.PollingConfiguration;
import com.amazonaws.services.appflow.AmazonAppflow;
import com.amazonaws.services.appflow.model.DescribeFlowExecutionRecordsRequest;
import com.amazonaws.services.appflow.model.DescribeFlowExecutionRecordsResult;
import com.amazonaws.services.appflow.model.ExecutionRecord;
import com.amazonaws.services.appflow.model.ExecutionStatus;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowPoller {
    private final AmazonAppflow client = ServiceProvider.getAppflow();
    private static final long MILLISECONDS_IN_SECOND = 1000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(FlowPoller.class);

    public Optional<ExecutionRecord> pollForExecutionRecordsResponse(PollingConfiguration pollingConfig) {
        DescribeFlowExecutionRecordsResult describeFlowExecutionRecordsResult;
        Optional<ExecutionRecord> executionRecordOptional;
        LOGGER.info("Polling flow for completion with execution Id " + pollingConfig.executionId());
        int totalTime = 0;
        do {
            try {
                Thread.sleep((long)pollingConfig.timeBetweenPollsS() * 1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        } while ((!(executionRecordOptional = (describeFlowExecutionRecordsResult = this.client.describeFlowExecutionRecords(new DescribeFlowExecutionRecordsRequest().withFlowName(pollingConfig.flowName()))).getFlowExecutions().stream().filter(executionRecord -> executionRecord.getExecutionId().equals(pollingConfig.executionId())).findFirst()).isPresent() || ExecutionStatus.InProgress.name().equals(executionRecordOptional.get().getExecutionStatus())) && pollingConfig.maxPollTimeS() > (totalTime += pollingConfig.timeBetweenPollsS()));
        return executionRecordOptional;
    }
}

