/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model;

import com.amazonaws.appflow.custom.connector.model.CacheControl;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="CacheControl", generator="Immutables")
@Immutable
public final class ImmutableCacheControl
implements CacheControl {
    private final long timeToLive;
    @Nullable
    private final TimeUnit timeToLiveUnit;

    private ImmutableCacheControl(long timeToLive, @Nullable TimeUnit timeToLiveUnit) {
        this.timeToLive = timeToLive;
        this.timeToLiveUnit = timeToLiveUnit;
    }

    @Override
    @JsonProperty(value="timeToLive")
    public long timeToLive() {
        return this.timeToLive;
    }

    @Override
    @JsonProperty(value="timeToLiveUnit")
    @Nullable
    public TimeUnit timeToLiveUnit() {
        return this.timeToLiveUnit;
    }

    public final ImmutableCacheControl withTimeToLive(long value) {
        if (this.timeToLive == value) {
            return this;
        }
        return new ImmutableCacheControl(value, this.timeToLiveUnit);
    }

    public final ImmutableCacheControl withTimeToLiveUnit(@Nullable TimeUnit value) {
        if (this.timeToLiveUnit == value) {
            return this;
        }
        return new ImmutableCacheControl(this.timeToLive, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCacheControl && this.equalTo(0, (ImmutableCacheControl)another);
    }

    private boolean equalTo(int synthetic, ImmutableCacheControl another) {
        return this.timeToLive == another.timeToLive && Objects.equals((Object)this.timeToLiveUnit, (Object)another.timeToLiveUnit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Longs.hashCode((long)this.timeToLive);
        h += (h << 5) + Objects.hashCode((Object)this.timeToLiveUnit);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CacheControl").omitNullValues().add("timeToLive", this.timeToLive).add("timeToLiveUnit", (Object)this.timeToLiveUnit).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCacheControl fromJson(Json json) {
        Builder builder = ImmutableCacheControl.builder();
        if (json.timeToLiveIsSet) {
            builder.timeToLive(json.timeToLive);
        }
        if (json.timeToLiveUnit != null) {
            builder.timeToLiveUnit(json.timeToLiveUnit);
        }
        return builder.build();
    }

    public static ImmutableCacheControl copyOf(CacheControl instance) {
        if (instance instanceof ImmutableCacheControl) {
            return (ImmutableCacheControl)instance;
        }
        return ImmutableCacheControl.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CacheControl", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TIME_TO_LIVE = 1L;
        private long initBits = 1L;
        private long timeToLive;
        @Nullable
        private TimeUnit timeToLiveUnit;

        private Builder() {
        }

        public final Builder from(CacheControl instance) {
            Objects.requireNonNull(instance, "instance");
            this.timeToLive(instance.timeToLive());
            TimeUnit timeToLiveUnitValue = instance.timeToLiveUnit();
            if (timeToLiveUnitValue != null) {
                this.timeToLiveUnit(timeToLiveUnitValue);
            }
            return this;
        }

        @JsonProperty(value="timeToLive")
        public final Builder timeToLive(long timeToLive) {
            this.timeToLive = timeToLive;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="timeToLiveUnit")
        public final Builder timeToLiveUnit(@Nullable TimeUnit timeToLiveUnit) {
            this.timeToLiveUnit = timeToLiveUnit;
            return this;
        }

        public ImmutableCacheControl build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCacheControl(this.timeToLive, this.timeToLiveUnit);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("timeToLive");
            }
            return "Cannot build CacheControl, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CacheControl", generator="Immutables")
    static final class Json
    implements CacheControl {
        long timeToLive;
        boolean timeToLiveIsSet;
        @Nullable
        TimeUnit timeToLiveUnit;

        Json() {
        }

        @JsonProperty(value="timeToLive")
        public void setTimeToLive(long timeToLive) {
            this.timeToLive = timeToLive;
            this.timeToLiveIsSet = true;
        }

        @JsonProperty(value="timeToLiveUnit")
        public void setTimeToLiveUnit(@Nullable TimeUnit timeToLiveUnit) {
            this.timeToLiveUnit = timeToLiveUnit;
        }

        @Override
        public long timeToLive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TimeUnit timeToLiveUnit() {
            throw new UnsupportedOperationException();
        }
    }
}

