/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth;

import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.AuthParameter;
import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.auth.CustomAuthConfig;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="CustomAuthConfig", generator="Immutables")
@Immutable
public final class ImmutableCustomAuthConfig
implements CustomAuthConfig {
    private final String authenticationType;
    private final ImmutableList<AuthParameter> authParameters;

    private ImmutableCustomAuthConfig(String authenticationType, ImmutableList<AuthParameter> authParameters) {
        this.authenticationType = authenticationType;
        this.authParameters = authParameters;
    }

    @Override
    @JsonProperty(value="authenticationType")
    public String authenticationType() {
        return this.authenticationType;
    }

    @JsonProperty(value="authParameters")
    public ImmutableList<AuthParameter> authParameters() {
        return this.authParameters;
    }

    public final ImmutableCustomAuthConfig withAuthenticationType(String value) {
        String newValue = Objects.requireNonNull(value, "authenticationType");
        if (this.authenticationType.equals(newValue)) {
            return this;
        }
        return new ImmutableCustomAuthConfig(newValue, this.authParameters);
    }

    public final ImmutableCustomAuthConfig withAuthParameters(AuthParameter ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCustomAuthConfig(this.authenticationType, (ImmutableList<AuthParameter>)newValue);
    }

    public final ImmutableCustomAuthConfig withAuthParameters(Iterable<? extends AuthParameter> elements) {
        if (this.authParameters == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCustomAuthConfig(this.authenticationType, (ImmutableList<AuthParameter>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCustomAuthConfig && this.equalTo(0, (ImmutableCustomAuthConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableCustomAuthConfig another) {
        return this.authenticationType.equals(another.authenticationType) && this.authParameters.equals(another.authParameters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.authenticationType.hashCode();
        h += (h << 5) + this.authParameters.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CustomAuthConfig").omitNullValues().add("authenticationType", (Object)this.authenticationType).add("authParameters", this.authParameters).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCustomAuthConfig fromJson(Json json) {
        Builder builder = ImmutableCustomAuthConfig.builder();
        if (json.authenticationType != null) {
            builder.authenticationType(json.authenticationType);
        }
        if (json.authParameters != null) {
            builder.addAllAuthParameters(json.authParameters);
        }
        return builder.build();
    }

    public static ImmutableCustomAuthConfig copyOf(CustomAuthConfig instance) {
        if (instance instanceof ImmutableCustomAuthConfig) {
            return (ImmutableCustomAuthConfig)instance;
        }
        return ImmutableCustomAuthConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CustomAuthConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_AUTHENTICATION_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String authenticationType;
        private ImmutableList.Builder<AuthParameter> authParameters = ImmutableList.builder();

        private Builder() {
        }

        public final Builder from(CustomAuthConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.authenticationType(instance.authenticationType());
            this.addAllAuthParameters(instance.authParameters());
            return this;
        }

        @JsonProperty(value="authenticationType")
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = Objects.requireNonNull(authenticationType, "authenticationType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addAuthParameters(AuthParameter element) {
            this.authParameters.add((Object)element);
            return this;
        }

        public final Builder addAuthParameters(AuthParameter ... elements) {
            this.authParameters.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="authParameters")
        public final Builder authParameters(Iterable<? extends AuthParameter> elements) {
            this.authParameters = ImmutableList.builder();
            return this.addAllAuthParameters(elements);
        }

        public final Builder addAllAuthParameters(Iterable<? extends AuthParameter> elements) {
            this.authParameters.addAll(elements);
            return this;
        }

        public ImmutableCustomAuthConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCustomAuthConfig(this.authenticationType, this.authParameters.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("authenticationType");
            }
            return "Cannot build CustomAuthConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CustomAuthConfig", generator="Immutables")
    static final class Json
    implements CustomAuthConfig {
        @Nullable
        String authenticationType;
        @Nullable
        List<AuthParameter> authParameters = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="authenticationType")
        public void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @JsonProperty(value="authParameters")
        public void setAuthParameters(List<AuthParameter> authParameters) {
            this.authParameters = authParameters;
        }

        @Override
        public String authenticationType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AuthParameter> authParameters() {
            throw new UnsupportedOperationException();
        }
    }
}

