/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.credentials;

import com.amazonaws.appflow.custom.connector.model.credentials.CustomAuthCredentials;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="CustomAuthCredentials", generator="Immutables")
@Immutable
public final class ImmutableCustomAuthCredentials
implements CustomAuthCredentials {
    private final String customAuthenticationType;
    private final ImmutableMap<String, String> customCredentials;

    private ImmutableCustomAuthCredentials(String customAuthenticationType, ImmutableMap<String, String> customCredentials) {
        this.customAuthenticationType = customAuthenticationType;
        this.customCredentials = customCredentials;
    }

    @Override
    @JsonProperty(value="customAuthenticationType")
    public String customAuthenticationType() {
        return this.customAuthenticationType;
    }

    @JsonProperty(value="customCredentials")
    public ImmutableMap<String, String> customCredentials() {
        return this.customCredentials;
    }

    public final ImmutableCustomAuthCredentials withCustomAuthenticationType(String value) {
        String newValue = Objects.requireNonNull(value, "customAuthenticationType");
        if (this.customAuthenticationType.equals(newValue)) {
            return this;
        }
        return new ImmutableCustomAuthCredentials(newValue, this.customCredentials);
    }

    public final ImmutableCustomAuthCredentials withCustomCredentials(Map<String, ? extends String> entries) {
        if (this.customCredentials == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCustomAuthCredentials(this.customAuthenticationType, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCustomAuthCredentials && this.equalTo(0, (ImmutableCustomAuthCredentials)another);
    }

    private boolean equalTo(int synthetic, ImmutableCustomAuthCredentials another) {
        return this.customAuthenticationType.equals(another.customAuthenticationType) && this.customCredentials.equals(another.customCredentials);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.customAuthenticationType.hashCode();
        h += (h << 5) + this.customCredentials.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CustomAuthCredentials").omitNullValues().add("customAuthenticationType", (Object)this.customAuthenticationType).add("customCredentials", this.customCredentials).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCustomAuthCredentials fromJson(Json json) {
        Builder builder = ImmutableCustomAuthCredentials.builder();
        if (json.customAuthenticationType != null) {
            builder.customAuthenticationType(json.customAuthenticationType);
        }
        if (json.customCredentials != null) {
            builder.putAllCustomCredentials(json.customCredentials);
        }
        return builder.build();
    }

    public static ImmutableCustomAuthCredentials copyOf(CustomAuthCredentials instance) {
        if (instance instanceof ImmutableCustomAuthCredentials) {
            return (ImmutableCustomAuthCredentials)instance;
        }
        return ImmutableCustomAuthCredentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CustomAuthCredentials", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CUSTOM_AUTHENTICATION_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String customAuthenticationType;
        private ImmutableMap.Builder<String, String> customCredentials = ImmutableMap.builder();

        private Builder() {
        }

        public final Builder from(CustomAuthCredentials instance) {
            Objects.requireNonNull(instance, "instance");
            this.customAuthenticationType(instance.customAuthenticationType());
            this.putAllCustomCredentials(instance.customCredentials());
            return this;
        }

        @JsonProperty(value="customAuthenticationType")
        public final Builder customAuthenticationType(String customAuthenticationType) {
            this.customAuthenticationType = Objects.requireNonNull(customAuthenticationType, "customAuthenticationType");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder putCustomCredentials(String key, String value) {
            this.customCredentials.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putCustomCredentials(Map.Entry<String, ? extends String> entry) {
            this.customCredentials.put(entry);
            return this;
        }

        @JsonProperty(value="customCredentials")
        public final Builder customCredentials(Map<String, ? extends String> entries) {
            this.customCredentials = ImmutableMap.builder();
            return this.putAllCustomCredentials(entries);
        }

        public final Builder putAllCustomCredentials(Map<String, ? extends String> entries) {
            this.customCredentials.putAll(entries);
            return this;
        }

        public ImmutableCustomAuthCredentials build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCustomAuthCredentials(this.customAuthenticationType, this.customCredentials.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("customAuthenticationType");
            }
            return "Cannot build CustomAuthCredentials, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CustomAuthCredentials", generator="Immutables")
    static final class Json
    implements CustomAuthCredentials {
        @Nullable
        String customAuthenticationType;
        @Nullable
        Map<String, String> customCredentials = ImmutableMap.of();

        Json() {
        }

        @JsonProperty(value="customAuthenticationType")
        public void setCustomAuthenticationType(String customAuthenticationType) {
            this.customAuthenticationType = customAuthenticationType;
        }

        @JsonProperty(value="customCredentials")
        public void setCustomCredentials(Map<String, String> customCredentials) {
            this.customCredentials = customCredentials;
        }

        @Override
        public String customAuthenticationType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> customCredentials() {
            throw new UnsupportedOperationException();
        }
    }
}

