/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.metadata;

import com.amazonaws.appflow.custom.connector.model.connectorconfiguration.ConnectorOperator;
import com.amazonaws.appflow.custom.connector.model.metadata.FieldConstraints;
import com.amazonaws.appflow.custom.connector.model.metadata.FieldDataType;
import com.amazonaws.appflow.custom.connector.model.metadata.ImmutableFieldDefinition;
import com.amazonaws.appflow.custom.connector.model.metadata.ReadOperationProperty;
import com.amazonaws.appflow.custom.connector.model.metadata.WriteOperationProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableFieldDefinition.class)
@JsonDeserialize(as=ImmutableFieldDefinition.class)
@Value.Immutable
public interface FieldDefinition {
    public String fieldName();

    public FieldDataType dataType();

    @Value.Default
    default public String dataTypeLabel() {
        return this.dataType().name();
    }

    @Nullable
    public String label();

    @Nullable
    public String description();

    @Nullable
    public Boolean isPrimaryKey();

    @Nullable
    public String defaultValue();

    @Nullable
    public Boolean isDeprecated();

    @Nullable
    public FieldConstraints constraints();

    @Nullable
    public ReadOperationProperty readProperties();

    @Nullable
    public WriteOperationProperty writeProperties();

    @Value.Default
    default public List<ConnectorOperator> filterOperators() {
        switch (this.dataType()) {
            case Integer: 
            case Float: 
            case Double: 
            case Long: 
            case Short: 
            case BigInteger: 
            case BigDecimal: {
                return Arrays.asList(ConnectorOperator.NOT_EQUAL_TO, ConnectorOperator.EQUAL_TO, ConnectorOperator.LESS_THAN, ConnectorOperator.LESS_THAN_OR_EQUAL_TO, ConnectorOperator.GREATER_THAN, ConnectorOperator.GREATER_THAN_OR_EQUAL_TO);
            }
            case Date: 
            case DateTime: {
                return Arrays.asList(ConnectorOperator.EQUAL_TO, ConnectorOperator.LESS_THAN, ConnectorOperator.LESS_THAN_OR_EQUAL_TO, ConnectorOperator.GREATER_THAN, ConnectorOperator.GREATER_THAN_OR_EQUAL_TO, ConnectorOperator.BETWEEN);
            }
            case String: {
                return Arrays.asList(ConnectorOperator.CONTAINS, ConnectorOperator.EQUAL_TO, ConnectorOperator.NOT_EQUAL_TO);
            }
            case Boolean: {
                return Arrays.asList(ConnectorOperator.EQUAL_TO, ConnectorOperator.NOT_EQUAL_TO);
            }
            case Map: 
            case List: {
                return Collections.singletonList(ConnectorOperator.CONTAINS);
            }
            case Struct: 
            case ByteArray: {
                return Collections.emptyList();
            }
        }
        throw new IllegalArgumentException("FilterOperators are not defined for dataType " + (Object)((Object)this.dataType()));
    }

    @Nullable
    public Map<String, String> customProperties();
}

