/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.metadata;

import com.amazonaws.appflow.custom.connector.model.metadata.Entity;
import com.amazonaws.appflow.custom.connector.model.metadata.EntityDefinition;
import com.amazonaws.appflow.custom.connector.model.metadata.FieldDefinition;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="EntityDefinition", generator="Immutables")
@Immutable
public final class ImmutableEntityDefinition
implements EntityDefinition {
    private final Entity entity;
    private final ImmutableList<FieldDefinition> fields;
    @Nullable
    private final ImmutableMap<String, String> customProperties;

    private ImmutableEntityDefinition(Entity entity, ImmutableList<FieldDefinition> fields, @Nullable ImmutableMap<String, String> customProperties) {
        this.entity = entity;
        this.fields = fields;
        this.customProperties = customProperties;
    }

    @Override
    @JsonProperty(value="entity")
    public Entity entity() {
        return this.entity;
    }

    @JsonProperty(value="fields")
    public ImmutableList<FieldDefinition> fields() {
        return this.fields;
    }

    @JsonProperty(value="customProperties")
    @Nullable
    public ImmutableMap<String, String> customProperties() {
        return this.customProperties;
    }

    public final ImmutableEntityDefinition withEntity(Entity value) {
        if (this.entity == value) {
            return this;
        }
        Entity newValue = Objects.requireNonNull(value, "entity");
        return new ImmutableEntityDefinition(newValue, this.fields, this.customProperties);
    }

    public final ImmutableEntityDefinition withFields(FieldDefinition ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableEntityDefinition(this.entity, (ImmutableList<FieldDefinition>)newValue, this.customProperties);
    }

    public final ImmutableEntityDefinition withFields(Iterable<? extends FieldDefinition> elements) {
        if (this.fields == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableEntityDefinition(this.entity, (ImmutableList<FieldDefinition>)newValue, this.customProperties);
    }

    public final ImmutableEntityDefinition withCustomProperties(@Nullable Map<String, ? extends String> entries) {
        if (this.customProperties == entries) {
            return this;
        }
        ImmutableMap newValue = entries == null ? null : ImmutableMap.copyOf(entries);
        return new ImmutableEntityDefinition(this.entity, this.fields, (ImmutableMap<String, String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEntityDefinition && this.equalTo(0, (ImmutableEntityDefinition)another);
    }

    private boolean equalTo(int synthetic, ImmutableEntityDefinition another) {
        return this.entity.equals(another.entity) && this.fields.equals(another.fields) && Objects.equals(this.customProperties, another.customProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.entity.hashCode();
        h += (h << 5) + this.fields.hashCode();
        h += (h << 5) + Objects.hashCode(this.customProperties);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"EntityDefinition").omitNullValues().add("entity", (Object)this.entity).add("fields", this.fields).add("customProperties", this.customProperties).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEntityDefinition fromJson(Json json) {
        Builder builder = ImmutableEntityDefinition.builder();
        if (json.entity != null) {
            builder.entity(json.entity);
        }
        if (json.fields != null) {
            builder.addAllFields(json.fields);
        }
        if (json.customProperties != null) {
            builder.putAllCustomProperties(json.customProperties);
        }
        return builder.build();
    }

    public static ImmutableEntityDefinition copyOf(EntityDefinition instance) {
        if (instance instanceof ImmutableEntityDefinition) {
            return (ImmutableEntityDefinition)instance;
        }
        return ImmutableEntityDefinition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EntityDefinition", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ENTITY = 1L;
        private long initBits = 1L;
        @Nullable
        private Entity entity;
        private ImmutableList.Builder<FieldDefinition> fields = ImmutableList.builder();
        private ImmutableMap.Builder<String, String> customProperties = null;

        private Builder() {
        }

        public final Builder from(EntityDefinition instance) {
            Objects.requireNonNull(instance, "instance");
            this.entity(instance.entity());
            this.addAllFields(instance.fields());
            Map<String, String> customPropertiesValue = instance.customProperties();
            if (customPropertiesValue != null) {
                this.putAllCustomProperties(customPropertiesValue);
            }
            return this;
        }

        @JsonProperty(value="entity")
        public final Builder entity(Entity entity) {
            this.entity = Objects.requireNonNull(entity, "entity");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addFields(FieldDefinition element) {
            this.fields.add((Object)element);
            return this;
        }

        public final Builder addFields(FieldDefinition ... elements) {
            this.fields.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="fields")
        public final Builder fields(Iterable<? extends FieldDefinition> elements) {
            this.fields = ImmutableList.builder();
            return this.addAllFields(elements);
        }

        public final Builder addAllFields(Iterable<? extends FieldDefinition> elements) {
            this.fields.addAll(elements);
            return this;
        }

        public final Builder putCustomProperties(String key, String value) {
            if (this.customProperties == null) {
                this.customProperties = ImmutableMap.builder();
            }
            this.customProperties.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putCustomProperties(Map.Entry<String, ? extends String> entry) {
            if (this.customProperties == null) {
                this.customProperties = ImmutableMap.builder();
            }
            this.customProperties.put(entry);
            return this;
        }

        @JsonProperty(value="customProperties")
        public final Builder customProperties(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.customProperties = null;
                return this;
            }
            this.customProperties = ImmutableMap.builder();
            return this.putAllCustomProperties(entries);
        }

        public final Builder putAllCustomProperties(Map<String, ? extends String> entries) {
            if (this.customProperties == null) {
                this.customProperties = ImmutableMap.builder();
            }
            this.customProperties.putAll(entries);
            return this;
        }

        public ImmutableEntityDefinition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEntityDefinition(this.entity, this.fields.build(), this.customProperties == null ? null : this.customProperties.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("entity");
            }
            return "Cannot build EntityDefinition, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EntityDefinition", generator="Immutables")
    static final class Json
    implements EntityDefinition {
        @Nullable
        Entity entity;
        @Nullable
        List<FieldDefinition> fields = ImmutableList.of();
        @Nullable
        Map<String, String> customProperties = null;

        Json() {
        }

        @JsonProperty(value="entity")
        public void setEntity(Entity entity) {
            this.entity = entity;
        }

        @JsonProperty(value="fields")
        public void setFields(List<FieldDefinition> fields) {
            this.fields = fields;
        }

        @JsonProperty(value="customProperties")
        public void setCustomProperties(@Nullable Map<String, String> customProperties) {
            this.customProperties = customProperties;
        }

        @Override
        public Entity entity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FieldDefinition> fields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> customProperties() {
            throw new UnsupportedOperationException();
        }
    }
}

