/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.appflow.custom.connector.model.metadata;

import com.amazonaws.appflow.custom.connector.model.ConnectorContext;
import com.amazonaws.appflow.custom.connector.model.metadata.ListEntitiesRequest;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@JsonTypeName(value="ListEntitiesRequest")
@Generated(from="ListEntitiesRequest", generator="Immutables")
@Immutable
public final class ImmutableListEntitiesRequest
implements ListEntitiesRequest {
    @Nullable
    private final String entitiesPath;
    @Nullable
    private final Long maxResult;
    @Nullable
    private final String nextToken;
    private final ConnectorContext connectorContext;

    private ImmutableListEntitiesRequest(Builder builder) {
        this.entitiesPath = builder.entitiesPath;
        this.nextToken = builder.nextToken;
        this.connectorContext = builder.connectorContext;
        this.maxResult = builder.maxResultIsSet() ? builder.maxResult : ListEntitiesRequest.super.maxResult();
    }

    private ImmutableListEntitiesRequest(@Nullable String entitiesPath, @Nullable Long maxResult, @Nullable String nextToken, ConnectorContext connectorContext) {
        this.entitiesPath = entitiesPath;
        this.maxResult = maxResult;
        this.nextToken = nextToken;
        this.connectorContext = connectorContext;
    }

    @Override
    @JsonProperty(value="entitiesPath")
    @Nullable
    public String entitiesPath() {
        return this.entitiesPath;
    }

    @Override
    @JsonProperty(value="maxResult")
    @Nullable
    public Long maxResult() {
        return this.maxResult;
    }

    @Override
    @JsonProperty(value="nextToken")
    @Nullable
    public String nextToken() {
        return this.nextToken;
    }

    @Override
    @JsonProperty(value="connectorContext")
    public ConnectorContext connectorContext() {
        return this.connectorContext;
    }

    public final ImmutableListEntitiesRequest withEntitiesPath(@Nullable String value) {
        if (Objects.equals(this.entitiesPath, value)) {
            return this;
        }
        return new ImmutableListEntitiesRequest(value, this.maxResult, this.nextToken, this.connectorContext);
    }

    public final ImmutableListEntitiesRequest withMaxResult(@Nullable Long value) {
        if (Objects.equals(this.maxResult, value)) {
            return this;
        }
        return new ImmutableListEntitiesRequest(this.entitiesPath, value, this.nextToken, this.connectorContext);
    }

    public final ImmutableListEntitiesRequest withNextToken(@Nullable String value) {
        if (Objects.equals(this.nextToken, value)) {
            return this;
        }
        return new ImmutableListEntitiesRequest(this.entitiesPath, this.maxResult, value, this.connectorContext);
    }

    public final ImmutableListEntitiesRequest withConnectorContext(ConnectorContext value) {
        if (this.connectorContext == value) {
            return this;
        }
        ConnectorContext newValue = Objects.requireNonNull(value, "connectorContext");
        return new ImmutableListEntitiesRequest(this.entitiesPath, this.maxResult, this.nextToken, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableListEntitiesRequest && this.equalTo(0, (ImmutableListEntitiesRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableListEntitiesRequest another) {
        return Objects.equals(this.entitiesPath, another.entitiesPath) && Objects.equals(this.maxResult, another.maxResult) && Objects.equals(this.nextToken, another.nextToken) && this.connectorContext.equals(another.connectorContext);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.entitiesPath);
        h += (h << 5) + Objects.hashCode(this.maxResult);
        h += (h << 5) + Objects.hashCode(this.nextToken);
        h += (h << 5) + this.connectorContext.hashCode();
        return h;
    }

    public String toString() {
        return "ListEntitiesRequest{entitiesPath=" + this.entitiesPath + ", maxResult=" + this.maxResult + ", nextToken=" + this.nextToken + ", connectorContext=" + this.connectorContext + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableListEntitiesRequest fromJson(Json json) {
        Builder builder = ImmutableListEntitiesRequest.builder();
        if (json.entitiesPath != null) {
            builder.entitiesPath(json.entitiesPath);
        }
        if (json.maxResultIsSet) {
            builder.maxResult(json.maxResult);
        }
        if (json.nextToken != null) {
            builder.nextToken(json.nextToken);
        }
        if (json.connectorContext != null) {
            builder.connectorContext(json.connectorContext);
        }
        return builder.build();
    }

    public static ImmutableListEntitiesRequest copyOf(ListEntitiesRequest instance) {
        if (instance instanceof ImmutableListEntitiesRequest) {
            return (ImmutableListEntitiesRequest)instance;
        }
        return ImmutableListEntitiesRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ListEntitiesRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONNECTOR_CONTEXT = 1L;
        private static final long OPT_BIT_MAX_RESULT = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String entitiesPath;
        @Nullable
        private Long maxResult;
        @Nullable
        private String nextToken;
        @Nullable
        private ConnectorContext connectorContext;

        private Builder() {
        }

        public final Builder from(ListEntitiesRequest instance) {
            String nextTokenValue;
            Long maxResultValue;
            Objects.requireNonNull(instance, "instance");
            String entitiesPathValue = instance.entitiesPath();
            if (entitiesPathValue != null) {
                this.entitiesPath(entitiesPathValue);
            }
            if ((maxResultValue = instance.maxResult()) != null) {
                this.maxResult(maxResultValue);
            }
            if ((nextTokenValue = instance.nextToken()) != null) {
                this.nextToken(nextTokenValue);
            }
            this.connectorContext(instance.connectorContext());
            return this;
        }

        @JsonProperty(value="entitiesPath")
        public final Builder entitiesPath(@Nullable String entitiesPath) {
            this.entitiesPath = entitiesPath;
            return this;
        }

        @JsonProperty(value="maxResult")
        public final Builder maxResult(@Nullable Long maxResult) {
            this.maxResult = maxResult;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="nextToken")
        public final Builder nextToken(@Nullable String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @JsonProperty(value="connectorContext")
        public final Builder connectorContext(ConnectorContext connectorContext) {
            this.connectorContext = Objects.requireNonNull(connectorContext, "connectorContext");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableListEntitiesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableListEntitiesRequest(this);
        }

        private boolean maxResultIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("connectorContext");
            }
            return "Cannot build ListEntitiesRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ListEntitiesRequest", generator="Immutables")
    static final class Json
    implements ListEntitiesRequest {
        @Nullable
        String entitiesPath;
        @Nullable
        Long maxResult;
        boolean maxResultIsSet;
        @Nullable
        String nextToken;
        @Nullable
        ConnectorContext connectorContext;

        Json() {
        }

        @JsonProperty(value="entitiesPath")
        public void setEntitiesPath(@Nullable String entitiesPath) {
            this.entitiesPath = entitiesPath;
        }

        @JsonProperty(value="maxResult")
        public void setMaxResult(@Nullable Long maxResult) {
            this.maxResult = maxResult;
            this.maxResultIsSet = true;
        }

        @JsonProperty(value="nextToken")
        public void setNextToken(@Nullable String nextToken) {
            this.nextToken = nextToken;
        }

        @JsonProperty(value="connectorContext")
        public void setConnectorContext(ConnectorContext connectorContext) {
            this.connectorContext = connectorContext;
        }

        @Override
        public String entitiesPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long maxResult() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String nextToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConnectorContext connectorContext() {
            throw new UnsupportedOperationException();
        }
    }
}

