package software.amazon.awscdk.services.appsync;

/**
 * (experimental) The authorization config in case the HTTP endpoint requires authorization.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api = GraphqlApi.Builder.create(this, "api")
 *         .name("api")
 *         .schema(Schema.fromAsset(join(__dirname, "schema.graphql")))
 *         .build();
 * HttpDataSource httpDs = api.addHttpDataSource("ds", "https://states.amazonaws.com", HttpDataSourceOptions.builder()
 *         .name("httpDsWithStepF")
 *         .description("from appsync to StepFunctions Workflow")
 *         .authorizationConfig(AwsIamConfig.builder()
 *                 .signingRegion("us-east-1")
 *                 .signingServiceName("states")
 *                 .build())
 *         .build());
 * httpDs.createResolver(BaseResolverProps.builder()
 *         .typeName("Mutation")
 *         .fieldName("callStepFunction")
 *         .requestMappingTemplate(MappingTemplate.fromFile("request.vtl"))
 *         .responseMappingTemplate(MappingTemplate.fromFile("response.vtl"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:21.061Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appsync.$Module.class, fqn = "@aws-cdk/aws-appsync.AwsIamConfig")
@software.amazon.jsii.Jsii.Proxy(AwsIamConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AwsIamConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The signing region for AWS IAM authorization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getSigningRegion();

    /**
     * (experimental) The signing service name for AWS IAM authorization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getSigningServiceName();

    /**
     * @return a {@link Builder} of {@link AwsIamConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsIamConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AwsIamConfig> {
        java.lang.String signingRegion;
        java.lang.String signingServiceName;

        /**
         * Sets the value of {@link AwsIamConfig#getSigningRegion}
         * @param signingRegion The signing region for AWS IAM authorization. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder signingRegion(java.lang.String signingRegion) {
            this.signingRegion = signingRegion;
            return this;
        }

        /**
         * Sets the value of {@link AwsIamConfig#getSigningServiceName}
         * @param signingServiceName The signing service name for AWS IAM authorization. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder signingServiceName(java.lang.String signingServiceName) {
            this.signingServiceName = signingServiceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsIamConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AwsIamConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AwsIamConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsIamConfig {
        private final java.lang.String signingRegion;
        private final java.lang.String signingServiceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.signingRegion = software.amazon.jsii.Kernel.get(this, "signingRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.signingServiceName = software.amazon.jsii.Kernel.get(this, "signingServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.signingRegion = java.util.Objects.requireNonNull(builder.signingRegion, "signingRegion is required");
            this.signingServiceName = java.util.Objects.requireNonNull(builder.signingServiceName, "signingServiceName is required");
        }

        @Override
        public final java.lang.String getSigningRegion() {
            return this.signingRegion;
        }

        @Override
        public final java.lang.String getSigningServiceName() {
            return this.signingServiceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("signingRegion", om.valueToTree(this.getSigningRegion()));
            data.set("signingServiceName", om.valueToTree(this.getSigningServiceName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-appsync.AwsIamConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsIamConfig.Jsii$Proxy that = (AwsIamConfig.Jsii$Proxy) o;

            if (!signingRegion.equals(that.signingRegion)) return false;
            return this.signingServiceName.equals(that.signingServiceName);
        }

        @Override
        public final int hashCode() {
            int result = this.signingRegion.hashCode();
            result = 31 * result + (this.signingServiceName.hashCode());
            return result;
        }
    }
}
