package software.amazon.awscdk.services.appsync;

/**
 * (experimental) props used by implementations of BaseDataSource to provide configuration.
 * <p>
 * Should not be used directly.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * ExtendedDataSourceProps extendedDataSourceProps = ExtendedDataSourceProps.builder()
 *         .type("type")
 *         // the properties below are optional
 *         .dynamoDbConfig(DynamoDBConfigProperty.builder()
 *                 .awsRegion("awsRegion")
 *                 .tableName("tableName")
 *                 // the properties below are optional
 *                 .deltaSyncConfig(DeltaSyncConfigProperty.builder()
 *                         .baseTableTtl("baseTableTtl")
 *                         .deltaSyncTableName("deltaSyncTableName")
 *                         .deltaSyncTableTtl("deltaSyncTableTtl")
 *                         .build())
 *                 .useCallerCredentials(false)
 *                 .versioned(false)
 *                 .build())
 *         .elasticsearchConfig(ElasticsearchConfigProperty.builder()
 *                 .awsRegion("awsRegion")
 *                 .endpoint("endpoint")
 *                 .build())
 *         .httpConfig(HttpConfigProperty.builder()
 *                 .endpoint("endpoint")
 *                 // the properties below are optional
 *                 .authorizationConfig(AuthorizationConfigProperty.builder()
 *                         .authorizationType("authorizationType")
 *                         // the properties below are optional
 *                         .awsIamConfig(AwsIamConfigProperty.builder()
 *                                 .signingRegion("signingRegion")
 *                                 .signingServiceName("signingServiceName")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .lambdaConfig(LambdaConfigProperty.builder()
 *                 .lambdaFunctionArn("lambdaFunctionArn")
 *                 .build())
 *         .openSearchServiceConfig(OpenSearchServiceConfigProperty.builder()
 *                 .awsRegion("awsRegion")
 *                 .endpoint("endpoint")
 *                 .build())
 *         .relationalDatabaseConfig(RelationalDatabaseConfigProperty.builder()
 *                 .relationalDatabaseSourceType("relationalDatabaseSourceType")
 *                 // the properties below are optional
 *                 .rdsHttpEndpointConfig(RdsHttpEndpointConfigProperty.builder()
 *                         .awsRegion("awsRegion")
 *                         .awsSecretStoreArn("awsSecretStoreArn")
 *                         .dbClusterIdentifier("dbClusterIdentifier")
 *                         // the properties below are optional
 *                         .databaseName("databaseName")
 *                         .schema("schema")
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:21.173Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appsync.$Module.class, fqn = "@aws-cdk/aws-appsync.ExtendedDataSourceProps")
@software.amazon.jsii.Jsii.Proxy(ExtendedDataSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ExtendedDataSourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) the type of the AppSync datasource.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * (experimental) configuration for DynamoDB Datasource.
     * <p>
     * Default: - No config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDynamoDbConfig() {
        return null;
    }

    /**
     * (deprecated) configuration for Elasticsearch data source.
     * <p>
     * Default: - No config
     * <p>
     * @deprecated - use `openSearchConfig`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.Object getElasticsearchConfig() {
        return null;
    }

    /**
     * (experimental) configuration for HTTP Datasource.
     * <p>
     * Default: - No config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Object getHttpConfig() {
        return null;
    }

    /**
     * (experimental) configuration for Lambda Datasource.
     * <p>
     * Default: - No config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaConfig() {
        return null;
    }

    /**
     * (experimental) configuration for OpenSearch data source.
     * <p>
     * Default: - No config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Object getOpenSearchServiceConfig() {
        return null;
    }

    /**
     * (experimental) configuration for RDS Datasource.
     * <p>
     * Default: - No config
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRelationalDatabaseConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ExtendedDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ExtendedDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ExtendedDataSourceProps> {
        java.lang.String type;
        java.lang.Object dynamoDbConfig;
        java.lang.Object elasticsearchConfig;
        java.lang.Object httpConfig;
        java.lang.Object lambdaConfig;
        java.lang.Object openSearchServiceConfig;
        java.lang.Object relationalDatabaseConfig;

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getType}
         * @param type the type of the AppSync datasource. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getDynamoDbConfig}
         * @param dynamoDbConfig configuration for DynamoDB Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dynamoDbConfig(software.amazon.awscdk.core.IResolvable dynamoDbConfig) {
            this.dynamoDbConfig = dynamoDbConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getDynamoDbConfig}
         * @param dynamoDbConfig configuration for DynamoDB Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dynamoDbConfig(software.amazon.awscdk.services.appsync.CfnDataSource.DynamoDBConfigProperty dynamoDbConfig) {
            this.dynamoDbConfig = dynamoDbConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getElasticsearchConfig}
         * @param elasticsearchConfig configuration for Elasticsearch data source.
         * @return {@code this}
         * @deprecated - use `openSearchConfig`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder elasticsearchConfig(software.amazon.awscdk.core.IResolvable elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getElasticsearchConfig}
         * @param elasticsearchConfig configuration for Elasticsearch data source.
         * @return {@code this}
         * @deprecated - use `openSearchConfig`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder elasticsearchConfig(software.amazon.awscdk.services.appsync.CfnDataSource.ElasticsearchConfigProperty elasticsearchConfig) {
            this.elasticsearchConfig = elasticsearchConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getHttpConfig}
         * @param httpConfig configuration for HTTP Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpConfig(software.amazon.awscdk.core.IResolvable httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getHttpConfig}
         * @param httpConfig configuration for HTTP Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder httpConfig(software.amazon.awscdk.services.appsync.CfnDataSource.HttpConfigProperty httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getLambdaConfig}
         * @param lambdaConfig configuration for Lambda Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lambdaConfig(software.amazon.awscdk.core.IResolvable lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getLambdaConfig}
         * @param lambdaConfig configuration for Lambda Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lambdaConfig(software.amazon.awscdk.services.appsync.CfnDataSource.LambdaConfigProperty lambdaConfig) {
            this.lambdaConfig = lambdaConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getOpenSearchServiceConfig}
         * @param openSearchServiceConfig configuration for OpenSearch data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder openSearchServiceConfig(software.amazon.awscdk.core.IResolvable openSearchServiceConfig) {
            this.openSearchServiceConfig = openSearchServiceConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getOpenSearchServiceConfig}
         * @param openSearchServiceConfig configuration for OpenSearch data source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder openSearchServiceConfig(software.amazon.awscdk.services.appsync.CfnDataSource.OpenSearchServiceConfigProperty openSearchServiceConfig) {
            this.openSearchServiceConfig = openSearchServiceConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getRelationalDatabaseConfig}
         * @param relationalDatabaseConfig configuration for RDS Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder relationalDatabaseConfig(software.amazon.awscdk.core.IResolvable relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig;
            return this;
        }

        /**
         * Sets the value of {@link ExtendedDataSourceProps#getRelationalDatabaseConfig}
         * @param relationalDatabaseConfig configuration for RDS Datasource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder relationalDatabaseConfig(software.amazon.awscdk.services.appsync.CfnDataSource.RelationalDatabaseConfigProperty relationalDatabaseConfig) {
            this.relationalDatabaseConfig = relationalDatabaseConfig;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ExtendedDataSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ExtendedDataSourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ExtendedDataSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ExtendedDataSourceProps {
        private final java.lang.String type;
        private final java.lang.Object dynamoDbConfig;
        private final java.lang.Object elasticsearchConfig;
        private final java.lang.Object httpConfig;
        private final java.lang.Object lambdaConfig;
        private final java.lang.Object openSearchServiceConfig;
        private final java.lang.Object relationalDatabaseConfig;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dynamoDbConfig = software.amazon.jsii.Kernel.get(this, "dynamoDbConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.elasticsearchConfig = software.amazon.jsii.Kernel.get(this, "elasticsearchConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.httpConfig = software.amazon.jsii.Kernel.get(this, "httpConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.lambdaConfig = software.amazon.jsii.Kernel.get(this, "lambdaConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.openSearchServiceConfig = software.amazon.jsii.Kernel.get(this, "openSearchServiceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.relationalDatabaseConfig = software.amazon.jsii.Kernel.get(this, "relationalDatabaseConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.dynamoDbConfig = builder.dynamoDbConfig;
            this.elasticsearchConfig = builder.elasticsearchConfig;
            this.httpConfig = builder.httpConfig;
            this.lambdaConfig = builder.lambdaConfig;
            this.openSearchServiceConfig = builder.openSearchServiceConfig;
            this.relationalDatabaseConfig = builder.relationalDatabaseConfig;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getDynamoDbConfig() {
            return this.dynamoDbConfig;
        }

        @Override
        public final java.lang.Object getElasticsearchConfig() {
            return this.elasticsearchConfig;
        }

        @Override
        public final java.lang.Object getHttpConfig() {
            return this.httpConfig;
        }

        @Override
        public final java.lang.Object getLambdaConfig() {
            return this.lambdaConfig;
        }

        @Override
        public final java.lang.Object getOpenSearchServiceConfig() {
            return this.openSearchServiceConfig;
        }

        @Override
        public final java.lang.Object getRelationalDatabaseConfig() {
            return this.relationalDatabaseConfig;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getDynamoDbConfig() != null) {
                data.set("dynamoDbConfig", om.valueToTree(this.getDynamoDbConfig()));
            }
            if (this.getElasticsearchConfig() != null) {
                data.set("elasticsearchConfig", om.valueToTree(this.getElasticsearchConfig()));
            }
            if (this.getHttpConfig() != null) {
                data.set("httpConfig", om.valueToTree(this.getHttpConfig()));
            }
            if (this.getLambdaConfig() != null) {
                data.set("lambdaConfig", om.valueToTree(this.getLambdaConfig()));
            }
            if (this.getOpenSearchServiceConfig() != null) {
                data.set("openSearchServiceConfig", om.valueToTree(this.getOpenSearchServiceConfig()));
            }
            if (this.getRelationalDatabaseConfig() != null) {
                data.set("relationalDatabaseConfig", om.valueToTree(this.getRelationalDatabaseConfig()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-appsync.ExtendedDataSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ExtendedDataSourceProps.Jsii$Proxy that = (ExtendedDataSourceProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.dynamoDbConfig != null ? !this.dynamoDbConfig.equals(that.dynamoDbConfig) : that.dynamoDbConfig != null) return false;
            if (this.elasticsearchConfig != null ? !this.elasticsearchConfig.equals(that.elasticsearchConfig) : that.elasticsearchConfig != null) return false;
            if (this.httpConfig != null ? !this.httpConfig.equals(that.httpConfig) : that.httpConfig != null) return false;
            if (this.lambdaConfig != null ? !this.lambdaConfig.equals(that.lambdaConfig) : that.lambdaConfig != null) return false;
            if (this.openSearchServiceConfig != null ? !this.openSearchServiceConfig.equals(that.openSearchServiceConfig) : that.openSearchServiceConfig != null) return false;
            return this.relationalDatabaseConfig != null ? this.relationalDatabaseConfig.equals(that.relationalDatabaseConfig) : that.relationalDatabaseConfig == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.dynamoDbConfig != null ? this.dynamoDbConfig.hashCode() : 0);
            result = 31 * result + (this.elasticsearchConfig != null ? this.elasticsearchConfig.hashCode() : 0);
            result = 31 * result + (this.httpConfig != null ? this.httpConfig.hashCode() : 0);
            result = 31 * result + (this.lambdaConfig != null ? this.lambdaConfig.hashCode() : 0);
            result = 31 * result + (this.openSearchServiceConfig != null ? this.openSearchServiceConfig.hashCode() : 0);
            result = 31 * result + (this.relationalDatabaseConfig != null ? this.relationalDatabaseConfig.hashCode() : 0);
            return result;
        }
    }
}
