package software.amazon.awscdk.services.appsync;

/**
 * (experimental) Properties for configuring a field.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Field field = Field.Builder.create()
 *         .returnType(GraphqlType.string())
 *         .args(Map.of(
 *                 "argument", GraphqlType.string()))
 *         .build();
 * InterfaceType type = InterfaceType.Builder.create("Node")
 *         .definition(Map.of("test", field))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:21.178Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appsync.$Module.class, fqn = "@aws-cdk/aws-appsync.FieldOptions")
@software.amazon.jsii.Jsii.Proxy(FieldOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FieldOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The return type for this field.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.GraphqlType getReturnType();

    /**
     * (experimental) The arguments for this field.
     * <p>
     * i.e. type Example (first: String second: String) {}
     * <p>
     * <ul>
     * <li>where 'first' and 'second' are key values for args
     * and 'String' is the GraphqlType</li>
     * </ul>
     * <p>
     * Default: - no arguments
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.GraphqlType> getArgs() {
        return null;
    }

    /**
     * (experimental) the directives for this field.
     * <p>
     * Default: - no directives
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.Directive> getDirectives() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FieldOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FieldOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<FieldOptions> {
        software.amazon.awscdk.services.appsync.GraphqlType returnType;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.GraphqlType> args;
        java.util.List<software.amazon.awscdk.services.appsync.Directive> directives;

        /**
         * Sets the value of {@link FieldOptions#getReturnType}
         * @param returnType The return type for this field. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder returnType(software.amazon.awscdk.services.appsync.GraphqlType returnType) {
            this.returnType = returnType;
            return this;
        }

        /**
         * Sets the value of {@link FieldOptions#getArgs}
         * @param args The arguments for this field.
         *             i.e. type Example (first: String second: String) {}
         *             <p>
         *             <ul>
         *             <li>where 'first' and 'second' are key values for args
         *             and 'String' is the GraphqlType</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder args(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.appsync.GraphqlType> args) {
            this.args = (java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.GraphqlType>)args;
            return this;
        }

        /**
         * Sets the value of {@link FieldOptions#getDirectives}
         * @param directives the directives for this field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder directives(java.util.List<? extends software.amazon.awscdk.services.appsync.Directive> directives) {
            this.directives = (java.util.List<software.amazon.awscdk.services.appsync.Directive>)directives;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FieldOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public FieldOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link FieldOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FieldOptions {
        private final software.amazon.awscdk.services.appsync.GraphqlType returnType;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.GraphqlType> args;
        private final java.util.List<software.amazon.awscdk.services.appsync.Directive> directives;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.returnType = software.amazon.jsii.Kernel.get(this, "returnType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
            this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class)));
            this.directives = software.amazon.jsii.Kernel.get(this, "directives", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Directive.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.returnType = java.util.Objects.requireNonNull(builder.returnType, "returnType is required");
            this.args = (java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.GraphqlType>)builder.args;
            this.directives = (java.util.List<software.amazon.awscdk.services.appsync.Directive>)builder.directives;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.GraphqlType getReturnType() {
            return this.returnType;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.GraphqlType> getArgs() {
            return this.args;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.Directive> getDirectives() {
            return this.directives;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("returnType", om.valueToTree(this.getReturnType()));
            if (this.getArgs() != null) {
                data.set("args", om.valueToTree(this.getArgs()));
            }
            if (this.getDirectives() != null) {
                data.set("directives", om.valueToTree(this.getDirectives()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-appsync.FieldOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FieldOptions.Jsii$Proxy that = (FieldOptions.Jsii$Proxy) o;

            if (!returnType.equals(that.returnType)) return false;
            if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
            return this.directives != null ? this.directives.equals(that.directives) : that.directives == null;
        }

        @Override
        public final int hashCode() {
            int result = this.returnType.hashCode();
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            result = 31 * result + (this.directives != null ? this.directives.hashCode() : 0);
            return result;
        }
    }
}
