package software.amazon.awscdk.services.appsync;

/**
 * (experimental) Resolvable Fields build upon Graphql Types and provide fields that can resolve into operations on a data source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * MappingTemplate dummyRequest;
 * MappingTemplate dummyResponse;
 * ObjectType info = ObjectType.Builder.create("Info")
 *         .definition(Map.of(
 *                 "node", ResolvableField.Builder.create()
 *                         .returnType(GraphqlType.string())
 *                         .args(Map.of(
 *                                 "id", GraphqlType.string()))
 *                         .dataSource(api.addNoneDataSource("none"))
 *                         .requestMappingTemplate(dummyRequest)
 *                         .responseMappingTemplate(dummyResponse)
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:21.249Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appsync.$Module.class, fqn = "@aws-cdk/aws-appsync.ResolvableField")
public class ResolvableField extends software.amazon.awscdk.services.appsync.Field implements software.amazon.awscdk.services.appsync.IField {

    protected ResolvableField(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ResolvableField(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public ResolvableField(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.ResolvableFieldOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) The options to make this field resolvable.
     * <p>
     * Default: - not a resolvable field
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.ResolvableFieldOptions getFieldOptions() {
        return software.amazon.jsii.Kernel.get(this, "fieldOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.ResolvableFieldOptions.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.appsync.ResolvableField}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.ResolvableField> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.appsync.ResolvableFieldOptions.Builder options;

        private Builder() {
            this.options = new software.amazon.awscdk.services.appsync.ResolvableFieldOptions.Builder();
        }

        /**
         * (experimental) The return type for this field.
         * <p>
         * @return {@code this}
         * @param returnType The return type for this field. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder returnType(final software.amazon.awscdk.services.appsync.GraphqlType returnType) {
            this.options.returnType(returnType);
            return this;
        }

        /**
         * (experimental) The arguments for this field.
         * <p>
         * i.e. type Example (first: String second: String) {}
         * <p>
         * <ul>
         * <li>where 'first' and 'second' are key values for args
         * and 'String' is the GraphqlType</li>
         * </ul>
         * <p>
         * Default: - no arguments
         * <p>
         * @return {@code this}
         * @param args The arguments for this field. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder args(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.appsync.GraphqlType> args) {
            this.options.args(args);
            return this;
        }

        /**
         * (experimental) the directives for this field.
         * <p>
         * Default: - no directives
         * <p>
         * @return {@code this}
         * @param directives the directives for this field. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder directives(final java.util.List<? extends software.amazon.awscdk.services.appsync.Directive> directives) {
            this.options.directives(directives);
            return this;
        }

        /**
         * (experimental) The data source creating linked to this resolvable field.
         * <p>
         * Default: - no data source
         * <p>
         * @return {@code this}
         * @param dataSource The data source creating linked to this resolvable field. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dataSource(final software.amazon.awscdk.services.appsync.BaseDataSource dataSource) {
            this.options.dataSource(dataSource);
            return this;
        }

        /**
         * (experimental) configuration of the pipeline resolver.
         * <p>
         * Default: - no pipeline resolver configuration
         * An empty array or undefined prop will set resolver to be of type unit
         * <p>
         * @return {@code this}
         * @param pipelineConfig configuration of the pipeline resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pipelineConfig(final java.util.List<? extends software.amazon.awscdk.services.appsync.IAppsyncFunction> pipelineConfig) {
            this.options.pipelineConfig(pipelineConfig);
            return this;
        }

        /**
         * (experimental) The request mapping template for this resolver.
         * <p>
         * Default: - No mapping template
         * <p>
         * @return {@code this}
         * @param requestMappingTemplate The request mapping template for this resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder requestMappingTemplate(final software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate) {
            this.options.requestMappingTemplate(requestMappingTemplate);
            return this;
        }

        /**
         * (experimental) The response mapping template for this resolver.
         * <p>
         * Default: - No mapping template
         * <p>
         * @return {@code this}
         * @param responseMappingTemplate The response mapping template for this resolver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder responseMappingTemplate(final software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate) {
            this.options.responseMappingTemplate(responseMappingTemplate);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appsync.ResolvableField}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.appsync.ResolvableField build() {
            return new software.amazon.awscdk.services.appsync.ResolvableField(
                this.options.build()
            );
        }
    }
}
