package software.amazon.awscdk.services.appsync;

/**
 * (experimental) Properties for configuring a resolvable field.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * ObjectType filmNode;
 * MappingTemplate dummyRequest;
 * MappingTemplate dummyResponse;
 * GraphqlType string = GraphqlType.string();
 * GraphqlType int = GraphqlType.int();
 * api.addMutation("addFilm", ResolvableField.Builder.create()
 *         .returnType(filmNode.attribute())
 *         .args(Map.of("name", string, "film_number", int))
 *         .dataSource(api.addNoneDataSource("none"))
 *         .requestMappingTemplate(dummyRequest)
 *         .responseMappingTemplate(dummyResponse)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:21.250Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appsync.$Module.class, fqn = "@aws-cdk/aws-appsync.ResolvableFieldOptions")
@software.amazon.jsii.Jsii.Proxy(ResolvableFieldOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ResolvableFieldOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appsync.FieldOptions {

    /**
     * (experimental) The data source creating linked to this resolvable field.
     * <p>
     * Default: - no data source
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.BaseDataSource getDataSource() {
        return null;
    }

    /**
     * (experimental) configuration of the pipeline resolver.
     * <p>
     * Default: - no pipeline resolver configuration
     * An empty array or undefined prop will set resolver to be of type unit
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.IAppsyncFunction> getPipelineConfig() {
        return null;
    }

    /**
     * (experimental) The request mapping template for this resolver.
     * <p>
     * Default: - No mapping template
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.MappingTemplate getRequestMappingTemplate() {
        return null;
    }

    /**
     * (experimental) The response mapping template for this resolver.
     * <p>
     * Default: - No mapping template
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.MappingTemplate getResponseMappingTemplate() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResolvableFieldOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResolvableFieldOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ResolvableFieldOptions> {
        software.amazon.awscdk.services.appsync.BaseDataSource dataSource;
        java.util.List<software.amazon.awscdk.services.appsync.IAppsyncFunction> pipelineConfig;
        software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate;
        software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate;
        software.amazon.awscdk.services.appsync.GraphqlType returnType;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.GraphqlType> args;
        java.util.List<software.amazon.awscdk.services.appsync.Directive> directives;

        /**
         * Sets the value of {@link ResolvableFieldOptions#getDataSource}
         * @param dataSource The data source creating linked to this resolvable field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dataSource(software.amazon.awscdk.services.appsync.BaseDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        /**
         * Sets the value of {@link ResolvableFieldOptions#getPipelineConfig}
         * @param pipelineConfig configuration of the pipeline resolver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder pipelineConfig(java.util.List<? extends software.amazon.awscdk.services.appsync.IAppsyncFunction> pipelineConfig) {
            this.pipelineConfig = (java.util.List<software.amazon.awscdk.services.appsync.IAppsyncFunction>)pipelineConfig;
            return this;
        }

        /**
         * Sets the value of {@link ResolvableFieldOptions#getRequestMappingTemplate}
         * @param requestMappingTemplate The request mapping template for this resolver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder requestMappingTemplate(software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        /**
         * Sets the value of {@link ResolvableFieldOptions#getResponseMappingTemplate}
         * @param responseMappingTemplate The response mapping template for this resolver.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder responseMappingTemplate(software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        /**
         * Sets the value of {@link ResolvableFieldOptions#getReturnType}
         * @param returnType The return type for this field. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder returnType(software.amazon.awscdk.services.appsync.GraphqlType returnType) {
            this.returnType = returnType;
            return this;
        }

        /**
         * Sets the value of {@link ResolvableFieldOptions#getArgs}
         * @param args The arguments for this field.
         *             i.e. type Example (first: String second: String) {}
         *             <p>
         *             <ul>
         *             <li>where 'first' and 'second' are key values for args
         *             and 'String' is the GraphqlType</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder args(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.appsync.GraphqlType> args) {
            this.args = (java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.GraphqlType>)args;
            return this;
        }

        /**
         * Sets the value of {@link ResolvableFieldOptions#getDirectives}
         * @param directives the directives for this field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder directives(java.util.List<? extends software.amazon.awscdk.services.appsync.Directive> directives) {
            this.directives = (java.util.List<software.amazon.awscdk.services.appsync.Directive>)directives;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResolvableFieldOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ResolvableFieldOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResolvableFieldOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResolvableFieldOptions {
        private final software.amazon.awscdk.services.appsync.BaseDataSource dataSource;
        private final java.util.List<software.amazon.awscdk.services.appsync.IAppsyncFunction> pipelineConfig;
        private final software.amazon.awscdk.services.appsync.MappingTemplate requestMappingTemplate;
        private final software.amazon.awscdk.services.appsync.MappingTemplate responseMappingTemplate;
        private final software.amazon.awscdk.services.appsync.GraphqlType returnType;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.GraphqlType> args;
        private final java.util.List<software.amazon.awscdk.services.appsync.Directive> directives;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataSource = software.amazon.jsii.Kernel.get(this, "dataSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.BaseDataSource.class));
            this.pipelineConfig = software.amazon.jsii.Kernel.get(this, "pipelineConfig", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IAppsyncFunction.class)));
            this.requestMappingTemplate = software.amazon.jsii.Kernel.get(this, "requestMappingTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class));
            this.responseMappingTemplate = software.amazon.jsii.Kernel.get(this, "responseMappingTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.MappingTemplate.class));
            this.returnType = software.amazon.jsii.Kernel.get(this, "returnType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class));
            this.args = software.amazon.jsii.Kernel.get(this, "args", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.GraphqlType.class)));
            this.directives = software.amazon.jsii.Kernel.get(this, "directives", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Directive.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataSource = builder.dataSource;
            this.pipelineConfig = (java.util.List<software.amazon.awscdk.services.appsync.IAppsyncFunction>)builder.pipelineConfig;
            this.requestMappingTemplate = builder.requestMappingTemplate;
            this.responseMappingTemplate = builder.responseMappingTemplate;
            this.returnType = java.util.Objects.requireNonNull(builder.returnType, "returnType is required");
            this.args = (java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.GraphqlType>)builder.args;
            this.directives = (java.util.List<software.amazon.awscdk.services.appsync.Directive>)builder.directives;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.BaseDataSource getDataSource() {
            return this.dataSource;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.IAppsyncFunction> getPipelineConfig() {
            return this.pipelineConfig;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.MappingTemplate getRequestMappingTemplate() {
            return this.requestMappingTemplate;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.MappingTemplate getResponseMappingTemplate() {
            return this.responseMappingTemplate;
        }

        @Override
        public final software.amazon.awscdk.services.appsync.GraphqlType getReturnType() {
            return this.returnType;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.GraphqlType> getArgs() {
            return this.args;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.Directive> getDirectives() {
            return this.directives;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDataSource() != null) {
                data.set("dataSource", om.valueToTree(this.getDataSource()));
            }
            if (this.getPipelineConfig() != null) {
                data.set("pipelineConfig", om.valueToTree(this.getPipelineConfig()));
            }
            if (this.getRequestMappingTemplate() != null) {
                data.set("requestMappingTemplate", om.valueToTree(this.getRequestMappingTemplate()));
            }
            if (this.getResponseMappingTemplate() != null) {
                data.set("responseMappingTemplate", om.valueToTree(this.getResponseMappingTemplate()));
            }
            data.set("returnType", om.valueToTree(this.getReturnType()));
            if (this.getArgs() != null) {
                data.set("args", om.valueToTree(this.getArgs()));
            }
            if (this.getDirectives() != null) {
                data.set("directives", om.valueToTree(this.getDirectives()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-appsync.ResolvableFieldOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResolvableFieldOptions.Jsii$Proxy that = (ResolvableFieldOptions.Jsii$Proxy) o;

            if (this.dataSource != null ? !this.dataSource.equals(that.dataSource) : that.dataSource != null) return false;
            if (this.pipelineConfig != null ? !this.pipelineConfig.equals(that.pipelineConfig) : that.pipelineConfig != null) return false;
            if (this.requestMappingTemplate != null ? !this.requestMappingTemplate.equals(that.requestMappingTemplate) : that.requestMappingTemplate != null) return false;
            if (this.responseMappingTemplate != null ? !this.responseMappingTemplate.equals(that.responseMappingTemplate) : that.responseMappingTemplate != null) return false;
            if (!returnType.equals(that.returnType)) return false;
            if (this.args != null ? !this.args.equals(that.args) : that.args != null) return false;
            return this.directives != null ? this.directives.equals(that.directives) : that.directives == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataSource != null ? this.dataSource.hashCode() : 0;
            result = 31 * result + (this.pipelineConfig != null ? this.pipelineConfig.hashCode() : 0);
            result = 31 * result + (this.requestMappingTemplate != null ? this.requestMappingTemplate.hashCode() : 0);
            result = 31 * result + (this.responseMappingTemplate != null ? this.responseMappingTemplate.hashCode() : 0);
            result = 31 * result + (this.returnType.hashCode());
            result = 31 * result + (this.args != null ? this.args.hashCode() : 0);
            result = 31 * result + (this.directives != null ? this.directives.hashCode() : 0);
            return result;
        }
    }
}
