package software.amazon.awscdk.services.appsync;

/**
 * (experimental) Specifies the attribute value assignments.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api = GraphqlApi.Builder.create(this, "Api")
 *         .name("demo")
 *         .schema(Schema.fromAsset(join(__dirname, "schema.graphql")))
 *         .authorizationConfig(AuthorizationConfig.builder()
 *                 .defaultAuthorization(AuthorizationMode.builder()
 *                         .authorizationType(AuthorizationType.IAM)
 *                         .build())
 *                 .build())
 *         .xrayEnabled(true)
 *         .build();
 * Table demoTable = Table.Builder.create(this, "DemoTable")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .build();
 * DynamoDbDataSource demoDS = api.addDynamoDbDataSource("demoDataSource", demoTable);
 * // Resolver for the Query "getDemos" that scans the DynamoDb table and returns the entire list.
 * demoDS.createResolver(BaseResolverProps.builder()
 *         .typeName("Query")
 *         .fieldName("getDemos")
 *         .requestMappingTemplate(MappingTemplate.dynamoDbScanTable())
 *         .responseMappingTemplate(MappingTemplate.dynamoDbResultList())
 *         .build());
 * // Resolver for the Mutation "addDemo" that puts the item into the DynamoDb table.
 * demoDS.createResolver(BaseResolverProps.builder()
 *         .typeName("Mutation")
 *         .fieldName("addDemo")
 *         .requestMappingTemplate(MappingTemplate.dynamoDbPutItem(PrimaryKey.partition("id").auto(), Values.projecting("input")))
 *         .responseMappingTemplate(MappingTemplate.dynamoDbResultItem())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:21.053Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appsync.$Module.class, fqn = "@aws-cdk/aws-appsync.AttributeValues")
public class AttributeValues extends software.amazon.jsii.JsiiObject {

    protected AttributeValues(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AttributeValues(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param container This parameter is required.
     * @param assignments
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AttributeValues(final @org.jetbrains.annotations.NotNull java.lang.String container, final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.Assign> assignments) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(container, "container is required"), assignments });
    }

    /**
     * @param container This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public AttributeValues(final @org.jetbrains.annotations.NotNull java.lang.String container) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(container, "container is required") });
    }

    /**
     * (experimental) Allows assigning a value to the specified attribute.
     * <p>
     * @param attr This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.AttributeValuesStep attribute(final @org.jetbrains.annotations.NotNull java.lang.String attr) {
        return software.amazon.jsii.Kernel.call(this, "attribute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AttributeValuesStep.class), new Object[] { java.util.Objects.requireNonNull(attr, "attr is required") });
    }

    /**
     * (experimental) Renders the attribute value assingments to a VTL string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String renderTemplate() {
        return software.amazon.jsii.Kernel.call(this, "renderTemplate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Renders the variables required for `renderTemplate`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String renderVariables() {
        return software.amazon.jsii.Kernel.call(this, "renderVariables", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
