package software.amazon.awscdk.services.appsync;

/**
 * Properties for defining a `CfnApiKey`.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appsync.*;
 * CfnApiKeyProps cfnApiKeyProps = CfnApiKeyProps.builder()
 *         .apiId("apiId")
 *         // the properties below are optional
 *         .apiKeyId("apiKeyId")
 *         .description("description")
 *         .expires(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:21.079Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appsync.$Module.class, fqn = "@aws-cdk/aws-appsync.CfnApiKeyProps")
@software.amazon.jsii.Jsii.Proxy(CfnApiKeyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnApiKeyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Unique AWS AppSync GraphQL API ID for this API key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiId();

    /**
     * The API key ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiKeyId() {
        return null;
    }

    /**
     * Unique description of your API key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The time after which the API key expires.
     * <p>
     * The date is represented as seconds since the epoch, rounded down to the nearest hour.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getExpires() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnApiKeyProps> {
        java.lang.String apiId;
        java.lang.String apiKeyId;
        java.lang.String description;
        java.lang.Number expires;

        /**
         * Sets the value of {@link CfnApiKeyProps#getApiId}
         * @param apiId Unique AWS AppSync GraphQL API ID for this API key. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiKeyProps#getApiKeyId}
         * @param apiKeyId The API key ID.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyId(java.lang.String apiKeyId) {
            this.apiKeyId = apiKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiKeyProps#getDescription}
         * @param description Unique description of your API key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnApiKeyProps#getExpires}
         * @param expires The time after which the API key expires.
         *                The date is represented as seconds since the epoch, rounded down to the nearest hour.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder expires(java.lang.Number expires) {
            this.expires = expires;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnApiKeyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnApiKeyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnApiKeyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnApiKeyProps {
        private final java.lang.String apiId;
        private final java.lang.String apiKeyId;
        private final java.lang.String description;
        private final java.lang.Number expires;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiId = software.amazon.jsii.Kernel.get(this, "apiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.apiKeyId = software.amazon.jsii.Kernel.get(this, "apiKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.expires = software.amazon.jsii.Kernel.get(this, "expires", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(builder.apiId, "apiId is required");
            this.apiKeyId = builder.apiKeyId;
            this.description = builder.description;
            this.expires = builder.expires;
        }

        @Override
        public final java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public final java.lang.String getApiKeyId() {
            return this.apiKeyId;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Number getExpires() {
            return this.expires;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiId", om.valueToTree(this.getApiId()));
            if (this.getApiKeyId() != null) {
                data.set("apiKeyId", om.valueToTree(this.getApiKeyId()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getExpires() != null) {
                data.set("expires", om.valueToTree(this.getExpires()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-appsync.CfnApiKeyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnApiKeyProps.Jsii$Proxy that = (CfnApiKeyProps.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (this.apiKeyId != null ? !this.apiKeyId.equals(that.apiKeyId) : that.apiKeyId != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            return this.expires != null ? this.expires.equals(that.expires) : that.expires == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.apiKeyId != null ? this.apiKeyId.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.expires != null ? this.expires.hashCode() : 0);
            return result;
        }
    }
}
