package software.amazon.awscdk.services.appsync;

/**
 * (experimental) Directives for types.
 * <p>
 * i.e. &#64;aws_iam or &#64;aws_subscribe
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * InterfaceType film;
 * api.addSubscription("addedFilm", Field.Builder.create()
 *         .returnType(film.attribute())
 *         .args(Map.of("id", GraphqlType.id(BaseTypeOptions.builder().isRequired(true).build())))
 *         .directives(List.of(Directive.subscribe("addFilm")))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:21.161Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appsync.$Module.class, fqn = "@aws-cdk/aws-appsync.Directive")
public class Directive extends software.amazon.jsii.JsiiObject {

    protected Directive(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Directive(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Add the @aws_api_key directive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Directive apiKey() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Directive.class, "apiKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Directive.class));
    }

    /**
     * (experimental) Add the @aws_auth or @aws_cognito_user_pools directive.
     * <p>
     * @param groups the groups to allow access to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Directive cognito(final @org.jetbrains.annotations.NotNull java.lang.String... groups) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Directive.class, "cognito", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Directive.class), java.util.Arrays.<Object>stream(groups).toArray(Object[]::new));
    }

    /**
     * (experimental) Add a custom directive.
     * <p>
     * @param statement - the directive statement to append. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Directive custom(final @org.jetbrains.annotations.NotNull java.lang.String statement) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Directive.class, "custom", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Directive.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * (experimental) Add the @aws_iam directive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Directive iam() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Directive.class, "iam", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Directive.class));
    }

    /**
     * (experimental) Add the @aws_oidc directive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Directive oidc() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Directive.class, "oidc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Directive.class));
    }

    /**
     * (experimental) Add the @aws_subscribe directive.
     * <p>
     * Only use for top level Subscription type.
     * <p>
     * @param mutations the mutation fields to link to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.Directive subscribe(final @org.jetbrains.annotations.NotNull java.lang.String... mutations) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appsync.Directive.class, "subscribe", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Directive.class), java.util.Arrays.<Object>stream(mutations).toArray(Object[]::new));
    }

    /**
     * (experimental) Generate the directive statement.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The authorization type of this directive.
     * <p>
     * Default: - not an authorization directive
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appsync.AuthorizationType getMode() {
        return software.amazon.jsii.Kernel.get(this, "mode", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationType.class));
    }

    /**
     * (experimental) Mutation fields for a subscription directive.
     * <p>
     * Default: - not a subscription directive
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getMutationFields() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "mutationFields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (experimental) the authorization modes for this intermediate type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AuthorizationType> getModes() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.appsync.AuthorizationType>)(software.amazon.jsii.Kernel.get(this, "modes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.AuthorizationType.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * (experimental) the authorization modes for this intermediate type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setModes(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.AuthorizationType> value) {
        software.amazon.jsii.Kernel.set(this, "modes", value);
    }
}
