package software.amazon.awscdk.services.appsync;

/**
 * (experimental) Properties for configuring an Object Type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api;
 * MappingTemplate dummyRequest;
 * MappingTemplate dummyResponse;
 * ObjectType info = ObjectType.Builder.create("Info")
 *         .definition(Map.of(
 *                 "node", ResolvableField.Builder.create()
 *                         .returnType(GraphqlType.string())
 *                         .args(Map.of(
 *                                 "id", GraphqlType.string()))
 *                         .dataSource(api.addNoneDataSource("none"))
 *                         .requestMappingTemplate(dummyRequest)
 *                         .responseMappingTemplate(dummyResponse)
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.74.0 (build 6d08790)", date = "2023-05-31T18:44:21.234Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.appsync.$Module.class, fqn = "@aws-cdk/aws-appsync.ObjectTypeOptions")
@software.amazon.jsii.Jsii.Proxy(ObjectTypeOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface ObjectTypeOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appsync.IntermediateTypeOptions {

    /**
     * (experimental) The Interface Types this Object Type implements.
     * <p>
     * Default: - no interface types
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appsync.InterfaceType> getInterfaceTypes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ObjectTypeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ObjectTypeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<ObjectTypeOptions> {
        java.util.List<software.amazon.awscdk.services.appsync.InterfaceType> interfaceTypes;
        java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.IField> definition;
        java.util.List<software.amazon.awscdk.services.appsync.Directive> directives;

        /**
         * Sets the value of {@link ObjectTypeOptions#getInterfaceTypes}
         * @param interfaceTypes The Interface Types this Object Type implements.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder interfaceTypes(java.util.List<? extends software.amazon.awscdk.services.appsync.InterfaceType> interfaceTypes) {
            this.interfaceTypes = (java.util.List<software.amazon.awscdk.services.appsync.InterfaceType>)interfaceTypes;
            return this;
        }

        /**
         * Sets the value of {@link ObjectTypeOptions#getDefinition}
         * @param definition the attributes of this type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder definition(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.appsync.IField> definition) {
            this.definition = (java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.IField>)definition;
            return this;
        }

        /**
         * Sets the value of {@link ObjectTypeOptions#getDirectives}
         * @param directives the directives for this object type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder directives(java.util.List<? extends software.amazon.awscdk.services.appsync.Directive> directives) {
            this.directives = (java.util.List<software.amazon.awscdk.services.appsync.Directive>)directives;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ObjectTypeOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public ObjectTypeOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ObjectTypeOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ObjectTypeOptions {
        private final java.util.List<software.amazon.awscdk.services.appsync.InterfaceType> interfaceTypes;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.IField> definition;
        private final java.util.List<software.amazon.awscdk.services.appsync.Directive> directives;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.interfaceTypes = software.amazon.jsii.Kernel.get(this, "interfaceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.InterfaceType.class)));
            this.definition = software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.IField.class)));
            this.directives = software.amazon.jsii.Kernel.get(this, "directives", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appsync.Directive.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.interfaceTypes = (java.util.List<software.amazon.awscdk.services.appsync.InterfaceType>)builder.interfaceTypes;
            this.definition = (java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.IField>)java.util.Objects.requireNonNull(builder.definition, "definition is required");
            this.directives = (java.util.List<software.amazon.awscdk.services.appsync.Directive>)builder.directives;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.InterfaceType> getInterfaceTypes() {
            return this.interfaceTypes;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.appsync.IField> getDefinition() {
            return this.definition;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appsync.Directive> getDirectives() {
            return this.directives;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getInterfaceTypes() != null) {
                data.set("interfaceTypes", om.valueToTree(this.getInterfaceTypes()));
            }
            data.set("definition", om.valueToTree(this.getDefinition()));
            if (this.getDirectives() != null) {
                data.set("directives", om.valueToTree(this.getDirectives()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-appsync.ObjectTypeOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ObjectTypeOptions.Jsii$Proxy that = (ObjectTypeOptions.Jsii$Proxy) o;

            if (this.interfaceTypes != null ? !this.interfaceTypes.equals(that.interfaceTypes) : that.interfaceTypes != null) return false;
            if (!definition.equals(that.definition)) return false;
            return this.directives != null ? this.directives.equals(that.directives) : that.directives == null;
        }

        @Override
        public final int hashCode() {
            int result = this.interfaceTypes != null ? this.interfaceTypes.hashCode() : 0;
            result = 31 * result + (this.definition.hashCode());
            result = 31 * result + (this.directives != null ? this.directives.hashCode() : 0);
            return result;
        }
    }
}
