package software.amazon.awscdk.services.apigateway;

/**
 * (experimental) Define a new VPC Link Specifies an API Gateway VPC link for a RestApi to access resources in an Amazon Virtual Private Cloud (VPC).
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:23:58.392Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.VpcLink")
public class VpcLink extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigateway.IVpcLink {

    protected VpcLink(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VpcLink(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public VpcLink(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.VpcLinkProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public VpcLink(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Import a VPC Link by its Id.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param vpcLinkId This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IVpcLink fromVpcLinkId(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String vpcLinkId) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.VpcLink.class, "fromVpcLinkId", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IVpcLink.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(vpcLinkId, "vpcLinkId is required") });
    }

    /**
     * @param targets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addTargets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer... targets) {
        software.amazon.jsii.Kernel.call(this, "addTargets", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(targets).toArray(Object[]::new));
    }

    /**
     * (experimental) Physical ID of the VpcLink resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVpcLinkId() {
        return software.amazon.jsii.Kernel.get(this, "vpcLinkId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.apigateway.VpcLink}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.VpcLink> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.apigateway.VpcLinkProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) The description of the VPC link.
         * <p>
         * Default: no description
         * <p>
         * @return {@code this}
         * @param description The description of the VPC link. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props().description(description);
            return this;
        }

        /**
         * (experimental) The network load balancers of the VPC targeted by the VPC link.
         * <p>
         * The network load balancers must be owned by the same AWS account of the API owner.
         * <p>
         * Default: - no targets. Use `addTargets` to add targets
         * <p>
         * @return {@code this}
         * @param targets The network load balancers of the VPC targeted by the VPC link. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder targets(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancer> targets) {
            this.props().targets(targets);
            return this;
        }

        /**
         * (experimental) The name used to label and identify the VPC link.
         * <p>
         * Default: - automatically generated name
         * <p>
         * @return {@code this}
         * @param vpcLinkName The name used to label and identify the VPC link. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcLinkName(final java.lang.String vpcLinkName) {
            this.props().vpcLinkName(vpcLinkName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.VpcLink}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.apigateway.VpcLink build() {
            return new software.amazon.awscdk.services.apigateway.VpcLink(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.VpcLinkProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.apigateway.VpcLinkProps.Builder();
            }
            return this.props;
        }
    }
}
