package software.amazon.awscdk.services.applicationautoscaling;

/**
 * (experimental) Properties for a scaling policy.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:01.982Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.StepScalingActionProps")
@software.amazon.jsii.Jsii.Proxy(StepScalingActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface StepScalingActionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The scalable target.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.IScalableTarget getScalingTarget();

    /**
     * (experimental) How the adjustment numbers are interpreted.
     * <p>
     * Default: ChangeInCapacity
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationautoscaling.AdjustmentType getAdjustmentType() {
        return null;
    }

    /**
     * (experimental) Grace period after scaling activity.
     * <p>
     * For scale out policies, multiple scale outs during the cooldown period are
     * squashed so that only the biggest scale out happens.
     * <p>
     * For scale in policies, subsequent scale ins during the cooldown period are
     * ignored.
     * <p>
     * Default: No cooldown period
     * <p>
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepScalingPolicyConfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getCooldown() {
        return null;
    }

    /**
     * (experimental) The aggregation type for the CloudWatch metrics.
     * <p>
     * Default: Average
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType getMetricAggregationType() {
        return null;
    }

    /**
     * (experimental) Minimum absolute number to adjust capacity with as result of percentage scaling.
     * <p>
     * Only when using AdjustmentType = PercentChangeInCapacity, this number controls
     * the minimum absolute effect size.
     * <p>
     * Default: No minimum scaling effect
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinAdjustmentMagnitude() {
        return null;
    }

    /**
     * (experimental) A name for the scaling policy.
     * <p>
     * Default: Automatically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getPolicyName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StepScalingActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StepScalingActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<StepScalingActionProps> {
        private software.amazon.awscdk.services.applicationautoscaling.IScalableTarget scalingTarget;
        private software.amazon.awscdk.services.applicationautoscaling.AdjustmentType adjustmentType;
        private software.amazon.awscdk.Duration cooldown;
        private software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType metricAggregationType;
        private java.lang.Number minAdjustmentMagnitude;
        private java.lang.String policyName;

        /**
         * Sets the value of {@link StepScalingActionProps#getScalingTarget}
         * @param scalingTarget The scalable target. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scalingTarget(software.amazon.awscdk.services.applicationautoscaling.IScalableTarget scalingTarget) {
            this.scalingTarget = scalingTarget;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingActionProps#getAdjustmentType}
         * @param adjustmentType How the adjustment numbers are interpreted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder adjustmentType(software.amazon.awscdk.services.applicationautoscaling.AdjustmentType adjustmentType) {
            this.adjustmentType = adjustmentType;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingActionProps#getCooldown}
         * @param cooldown Grace period after scaling activity.
         *                 For scale out policies, multiple scale outs during the cooldown period are
         *                 squashed so that only the biggest scale out happens.
         *                 <p>
         *                 For scale in policies, subsequent scale ins during the cooldown period are
         *                 ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cooldown(software.amazon.awscdk.Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingActionProps#getMetricAggregationType}
         * @param metricAggregationType The aggregation type for the CloudWatch metrics.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricAggregationType(software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType metricAggregationType) {
            this.metricAggregationType = metricAggregationType;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingActionProps#getMinAdjustmentMagnitude}
         * @param minAdjustmentMagnitude Minimum absolute number to adjust capacity with as result of percentage scaling.
         *                               Only when using AdjustmentType = PercentChangeInCapacity, this number controls
         *                               the minimum absolute effect size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minAdjustmentMagnitude(java.lang.Number minAdjustmentMagnitude) {
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            return this;
        }

        /**
         * Sets the value of {@link StepScalingActionProps#getPolicyName}
         * @param policyName A name for the scaling policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder policyName(java.lang.String policyName) {
            this.policyName = policyName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StepScalingActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public StepScalingActionProps build() {
            return new Jsii$Proxy(scalingTarget, adjustmentType, cooldown, metricAggregationType, minAdjustmentMagnitude, policyName);
        }
    }

    /**
     * An implementation for {@link StepScalingActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepScalingActionProps {
        private final software.amazon.awscdk.services.applicationautoscaling.IScalableTarget scalingTarget;
        private final software.amazon.awscdk.services.applicationautoscaling.AdjustmentType adjustmentType;
        private final software.amazon.awscdk.Duration cooldown;
        private final software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType metricAggregationType;
        private final java.lang.Number minAdjustmentMagnitude;
        private final java.lang.String policyName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scalingTarget = software.amazon.jsii.Kernel.get(this, "scalingTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.IScalableTarget.class));
            this.adjustmentType = software.amazon.jsii.Kernel.get(this, "adjustmentType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.AdjustmentType.class));
            this.cooldown = software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.metricAggregationType = software.amazon.jsii.Kernel.get(this, "metricAggregationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType.class));
            this.minAdjustmentMagnitude = software.amazon.jsii.Kernel.get(this, "minAdjustmentMagnitude", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.policyName = software.amazon.jsii.Kernel.get(this, "policyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.applicationautoscaling.IScalableTarget scalingTarget, final software.amazon.awscdk.services.applicationautoscaling.AdjustmentType adjustmentType, final software.amazon.awscdk.Duration cooldown, final software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType metricAggregationType, final java.lang.Number minAdjustmentMagnitude, final java.lang.String policyName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scalingTarget = java.util.Objects.requireNonNull(scalingTarget, "scalingTarget is required");
            this.adjustmentType = adjustmentType;
            this.cooldown = cooldown;
            this.metricAggregationType = metricAggregationType;
            this.minAdjustmentMagnitude = minAdjustmentMagnitude;
            this.policyName = policyName;
        }

        @Override
        public final software.amazon.awscdk.services.applicationautoscaling.IScalableTarget getScalingTarget() {
            return this.scalingTarget;
        }

        @Override
        public final software.amazon.awscdk.services.applicationautoscaling.AdjustmentType getAdjustmentType() {
            return this.adjustmentType;
        }

        @Override
        public final software.amazon.awscdk.Duration getCooldown() {
            return this.cooldown;
        }

        @Override
        public final software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType getMetricAggregationType() {
            return this.metricAggregationType;
        }

        @Override
        public final java.lang.Number getMinAdjustmentMagnitude() {
            return this.minAdjustmentMagnitude;
        }

        @Override
        public final java.lang.String getPolicyName() {
            return this.policyName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("scalingTarget", om.valueToTree(this.getScalingTarget()));
            if (this.getAdjustmentType() != null) {
                data.set("adjustmentType", om.valueToTree(this.getAdjustmentType()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getMetricAggregationType() != null) {
                data.set("metricAggregationType", om.valueToTree(this.getMetricAggregationType()));
            }
            if (this.getMinAdjustmentMagnitude() != null) {
                data.set("minAdjustmentMagnitude", om.valueToTree(this.getMinAdjustmentMagnitude()));
            }
            if (this.getPolicyName() != null) {
                data.set("policyName", om.valueToTree(this.getPolicyName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_applicationautoscaling.StepScalingActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StepScalingActionProps.Jsii$Proxy that = (StepScalingActionProps.Jsii$Proxy) o;

            if (!scalingTarget.equals(that.scalingTarget)) return false;
            if (this.adjustmentType != null ? !this.adjustmentType.equals(that.adjustmentType) : that.adjustmentType != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.metricAggregationType != null ? !this.metricAggregationType.equals(that.metricAggregationType) : that.metricAggregationType != null) return false;
            if (this.minAdjustmentMagnitude != null ? !this.minAdjustmentMagnitude.equals(that.minAdjustmentMagnitude) : that.minAdjustmentMagnitude != null) return false;
            return this.policyName != null ? this.policyName.equals(that.policyName) : that.policyName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.scalingTarget.hashCode();
            result = 31 * result + (this.adjustmentType != null ? this.adjustmentType.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.metricAggregationType != null ? this.metricAggregationType.hashCode() : 0);
            result = 31 * result + (this.minAdjustmentMagnitude != null ? this.minAdjustmentMagnitude.hashCode() : 0);
            result = 31 * result + (this.policyName != null ? this.policyName.hashCode() : 0);
            return result;
        }
    }
}
