package software.amazon.awscdk.services.applicationautoscaling;

/**
 * (experimental) Define a scaling strategy which scales depending on absolute values of some metric.
 * <p>
 * You can specify the scaling behavior for various values of the metric.
 * <p>
 * Implemented using one or more CloudWatch alarms and Step Scaling Policies.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:01.983Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_applicationautoscaling.StepScalingPolicy")
public class StepScalingPolicy extends software.constructs.Construct {

    protected StepScalingPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StepScalingPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public StepScalingPolicy(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.StepScalingPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationautoscaling.StepScalingAction getLowerAction() {
        return software.amazon.jsii.Kernel.get(this, "lowerAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.StepScalingAction.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.Alarm getLowerAlarm() {
        return software.amazon.jsii.Kernel.get(this, "lowerAlarm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Alarm.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.applicationautoscaling.StepScalingAction getUpperAction() {
        return software.amazon.jsii.Kernel.get(this, "upperAction", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.StepScalingAction.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.Alarm getUpperAlarm() {
        return software.amazon.jsii.Kernel.get(this, "upperAlarm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Alarm.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.applicationautoscaling.StepScalingPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.applicationautoscaling.StepScalingPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.applicationautoscaling.StepScalingPolicyProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.applicationautoscaling.StepScalingPolicyProps.Builder();
        }

        /**
         * (experimental) Metric to scale on.
         * <p>
         * @return {@code this}
         * @param metric Metric to scale on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metric(final software.amazon.awscdk.services.cloudwatch.IMetric metric) {
            this.props.metric(metric);
            return this;
        }

        /**
         * (experimental) The intervals for scaling.
         * <p>
         * Maps a range of metric values to a particular scaling behavior.
         * <p>
         * @return {@code this}
         * @param scalingSteps The intervals for scaling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scalingSteps(final java.util.List<? extends software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps) {
            this.props.scalingSteps(scalingSteps);
            return this;
        }

        /**
         * (experimental) How the adjustment numbers inside 'intervals' are interpreted.
         * <p>
         * Default: ChangeInCapacity
         * <p>
         * @return {@code this}
         * @param adjustmentType How the adjustment numbers inside 'intervals' are interpreted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder adjustmentType(final software.amazon.awscdk.services.applicationautoscaling.AdjustmentType adjustmentType) {
            this.props.adjustmentType(adjustmentType);
            return this;
        }

        /**
         * (experimental) Grace period after scaling activity.
         * <p>
         * Subsequent scale outs during the cooldown period are squashed so that only
         * the biggest scale out happens.
         * <p>
         * Subsequent scale ins during the cooldown period are ignored.
         * <p>
         * Default: No cooldown period
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepScalingPolicyConfiguration.html
         * @param cooldown Grace period after scaling activity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cooldown(final software.amazon.awscdk.Duration cooldown) {
            this.props.cooldown(cooldown);
            return this;
        }

        /**
         * (experimental) How many evaluation periods of the metric to wait before triggering a scaling action.
         * <p>
         * Raising this value can be used to smooth out the metric, at the expense
         * of slower response times.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param evaluationPeriods How many evaluation periods of the metric to wait before triggering a scaling action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder evaluationPeriods(final java.lang.Number evaluationPeriods) {
            this.props.evaluationPeriods(evaluationPeriods);
            return this;
        }

        /**
         * (experimental) Aggregation to apply to all data points over the evaluation periods.
         * <p>
         * Only has meaning if <code>evaluationPeriods != 1</code>.
         * <p>
         * Default: - The statistic from the metric if applicable (MIN, MAX, AVERAGE), otherwise AVERAGE.
         * <p>
         * @return {@code this}
         * @param metricAggregationType Aggregation to apply to all data points over the evaluation periods. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricAggregationType(final software.amazon.awscdk.services.applicationautoscaling.MetricAggregationType metricAggregationType) {
            this.props.metricAggregationType(metricAggregationType);
            return this;
        }

        /**
         * (experimental) Minimum absolute number to adjust capacity with as result of percentage scaling.
         * <p>
         * Only when using AdjustmentType = PercentChangeInCapacity, this number controls
         * the minimum absolute effect size.
         * <p>
         * Default: No minimum scaling effect
         * <p>
         * @return {@code this}
         * @param minAdjustmentMagnitude Minimum absolute number to adjust capacity with as result of percentage scaling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minAdjustmentMagnitude(final java.lang.Number minAdjustmentMagnitude) {
            this.props.minAdjustmentMagnitude(minAdjustmentMagnitude);
            return this;
        }

        /**
         * (experimental) The scaling target.
         * <p>
         * @return {@code this}
         * @param scalingTarget The scaling target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder scalingTarget(final software.amazon.awscdk.services.applicationautoscaling.IScalableTarget scalingTarget) {
            this.props.scalingTarget(scalingTarget);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.applicationautoscaling.StepScalingPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.applicationautoscaling.StepScalingPolicy build() {
            return new software.amazon.awscdk.services.applicationautoscaling.StepScalingPolicy(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
