package software.amazon.awscdk.services.appmesh;

/**
 * (experimental) VirtualService represents a service inside an AppMesh.
 * <p>
 * It routes traffic either to a Virtual Node or to a Virtual Router.
 * <p>
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_services.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:02.658Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualService")
public class VirtualService extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.appmesh.IVirtualService {

    protected VirtualService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected VirtualService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public VirtualService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Import an existing VirtualService given an ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param virtualServiceArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualService fromVirtualServiceArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String virtualServiceArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualService.class, "fromVirtualServiceArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualService.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(virtualServiceArn, "virtualServiceArn is required") });
    }

    /**
     * (experimental) Import an existing VirtualService given its attributes.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IVirtualService fromVirtualServiceAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.VirtualServiceAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.VirtualService.class, "fromVirtualServiceAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IVirtualService.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * (experimental) The Mesh which the VirtualService belongs to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh getMesh() {
        return software.amazon.jsii.Kernel.get(this, "mesh", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class));
    }

    /**
     * (experimental) The Amazon Resource Name (ARN) for the virtual service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualServiceArn() {
        return software.amazon.jsii.Kernel.get(this, "virtualServiceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the VirtualService, it is recommended this follows the fully-qualified domain name format.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVirtualServiceName() {
        return software.amazon.jsii.Kernel.get(this, "virtualServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.appmesh.VirtualService}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appmesh.VirtualService> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appmesh.VirtualServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appmesh.VirtualServiceProps.Builder();
        }

        /**
         * (experimental) The VirtualNode or VirtualRouter which the VirtualService uses as its provider.
         * <p>
         * @return {@code this}
         * @param virtualServiceProvider The VirtualNode or VirtualRouter which the VirtualService uses as its provider. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder virtualServiceProvider(final software.amazon.awscdk.services.appmesh.VirtualServiceProvider virtualServiceProvider) {
            this.props.virtualServiceProvider(virtualServiceProvider);
            return this;
        }

        /**
         * (experimental) The name of the VirtualService.
         * <p>
         * It is recommended this follows the fully-qualified domain name format,
         * such as "my-service.default.svc.cluster.local".
         * <p>
         * Default: - A name is automatically generated
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * service.domain.getLocal();}</pre></blockquote>
         * <p>
         * @return {@code this}
         * @param virtualServiceName The name of the VirtualService. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder virtualServiceName(final java.lang.String virtualServiceName) {
            this.props.virtualServiceName(virtualServiceName);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.appmesh.VirtualService}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.appmesh.VirtualService build() {
            return new software.amazon.awscdk.services.appmesh.VirtualService(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
