package software.amazon.awscdk.services.autoscaling;

/**
 * (experimental) Properties for a Target Tracking policy that include the metric but exclude the target.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:03.895Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.BasicTargetTrackingScalingPolicyProps")
@software.amazon.jsii.Jsii.Proxy(BasicTargetTrackingScalingPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BasicTargetTrackingScalingPolicyProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.autoscaling.BaseTargetTrackingProps {

    /**
     * (experimental) The target value for the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.Number getTargetValue();

    /**
     * (experimental) A custom metric for application autoscaling.
     * <p>
     * The metric must track utilization. Scaling out will happen if the metric is higher than
     * the target value, scaling in will happen in the metric is lower than the target value.
     * <p>
     * Exactly one of customMetric or predefinedMetric must be specified.
     * <p>
     * Default: - No custom metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.IMetric getCustomMetric() {
        return null;
    }

    /**
     * (experimental) A predefined metric for application autoscaling.
     * <p>
     * The metric must track utilization. Scaling out will happen if the metric is higher than
     * the target value, scaling in will happen in the metric is lower than the target value.
     * <p>
     * Exactly one of customMetric or predefinedMetric must be specified.
     * <p>
     * Default: - No predefined metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.autoscaling.PredefinedMetric getPredefinedMetric() {
        return null;
    }

    /**
     * (experimental) The resource label associated with the predefined metric.
     * <p>
     * Should be supplied if the predefined metric is ALBRequestCountPerTarget, and the
     * format should be:
     * <p>
     * app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>
     * <p>
     * Default: - No resource label.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceLabel() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BasicTargetTrackingScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BasicTargetTrackingScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BasicTargetTrackingScalingPolicyProps> {
        private java.lang.Number targetValue;
        private software.amazon.awscdk.services.cloudwatch.IMetric customMetric;
        private software.amazon.awscdk.services.autoscaling.PredefinedMetric predefinedMetric;
        private java.lang.String resourceLabel;
        private software.amazon.awscdk.Duration cooldown;
        private java.lang.Boolean disableScaleIn;
        private software.amazon.awscdk.Duration estimatedInstanceWarmup;

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getTargetValue}
         * @param targetValue The target value for the metric. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder targetValue(java.lang.Number targetValue) {
            this.targetValue = targetValue;
            return this;
        }

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getCustomMetric}
         * @param customMetric A custom metric for application autoscaling.
         *                     The metric must track utilization. Scaling out will happen if the metric is higher than
         *                     the target value, scaling in will happen in the metric is lower than the target value.
         *                     <p>
         *                     Exactly one of customMetric or predefinedMetric must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customMetric(software.amazon.awscdk.services.cloudwatch.IMetric customMetric) {
            this.customMetric = customMetric;
            return this;
        }

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getPredefinedMetric}
         * @param predefinedMetric A predefined metric for application autoscaling.
         *                         The metric must track utilization. Scaling out will happen if the metric is higher than
         *                         the target value, scaling in will happen in the metric is lower than the target value.
         *                         <p>
         *                         Exactly one of customMetric or predefinedMetric must be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder predefinedMetric(software.amazon.awscdk.services.autoscaling.PredefinedMetric predefinedMetric) {
            this.predefinedMetric = predefinedMetric;
            return this;
        }

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getResourceLabel}
         * @param resourceLabel The resource label associated with the predefined metric.
         *                      Should be supplied if the predefined metric is ALBRequestCountPerTarget, and the
         *                      format should be:
         *                      <p>
         *                      app/<load-balancer-name>/<load-balancer-id>/targetgroup/<target-group-name>/<target-group-id>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder resourceLabel(java.lang.String resourceLabel) {
            this.resourceLabel = resourceLabel;
            return this;
        }

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getCooldown}
         * @param cooldown Period after a scaling completes before another scaling activity can start.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cooldown(software.amazon.awscdk.Duration cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getDisableScaleIn}
         * @param disableScaleIn Indicates whether scale in by the target tracking policy is disabled.
         *                       If the value is true, scale in is disabled and the target tracking policy
         *                       won't remove capacity from the autoscaling group. Otherwise, scale in is
         *                       enabled and the target tracking policy can remove capacity from the
         *                       group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder disableScaleIn(java.lang.Boolean disableScaleIn) {
            this.disableScaleIn = disableScaleIn;
            return this;
        }

        /**
         * Sets the value of {@link BasicTargetTrackingScalingPolicyProps#getEstimatedInstanceWarmup}
         * @param estimatedInstanceWarmup Estimated time until a newly launched instance can send metrics to CloudWatch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder estimatedInstanceWarmup(software.amazon.awscdk.Duration estimatedInstanceWarmup) {
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BasicTargetTrackingScalingPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BasicTargetTrackingScalingPolicyProps build() {
            return new Jsii$Proxy(targetValue, customMetric, predefinedMetric, resourceLabel, cooldown, disableScaleIn, estimatedInstanceWarmup);
        }
    }

    /**
     * An implementation for {@link BasicTargetTrackingScalingPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasicTargetTrackingScalingPolicyProps {
        private final java.lang.Number targetValue;
        private final software.amazon.awscdk.services.cloudwatch.IMetric customMetric;
        private final software.amazon.awscdk.services.autoscaling.PredefinedMetric predefinedMetric;
        private final java.lang.String resourceLabel;
        private final software.amazon.awscdk.Duration cooldown;
        private final java.lang.Boolean disableScaleIn;
        private final software.amazon.awscdk.Duration estimatedInstanceWarmup;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.targetValue = software.amazon.jsii.Kernel.get(this, "targetValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.customMetric = software.amazon.jsii.Kernel.get(this, "customMetric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IMetric.class));
            this.predefinedMetric = software.amazon.jsii.Kernel.get(this, "predefinedMetric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.PredefinedMetric.class));
            this.resourceLabel = software.amazon.jsii.Kernel.get(this, "resourceLabel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cooldown = software.amazon.jsii.Kernel.get(this, "cooldown", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.disableScaleIn = software.amazon.jsii.Kernel.get(this, "disableScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.estimatedInstanceWarmup = software.amazon.jsii.Kernel.get(this, "estimatedInstanceWarmup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Number targetValue, final software.amazon.awscdk.services.cloudwatch.IMetric customMetric, final software.amazon.awscdk.services.autoscaling.PredefinedMetric predefinedMetric, final java.lang.String resourceLabel, final software.amazon.awscdk.Duration cooldown, final java.lang.Boolean disableScaleIn, final software.amazon.awscdk.Duration estimatedInstanceWarmup) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.targetValue = java.util.Objects.requireNonNull(targetValue, "targetValue is required");
            this.customMetric = customMetric;
            this.predefinedMetric = predefinedMetric;
            this.resourceLabel = resourceLabel;
            this.cooldown = cooldown;
            this.disableScaleIn = disableScaleIn;
            this.estimatedInstanceWarmup = estimatedInstanceWarmup;
        }

        @Override
        public final java.lang.Number getTargetValue() {
            return this.targetValue;
        }

        @Override
        public final software.amazon.awscdk.services.cloudwatch.IMetric getCustomMetric() {
            return this.customMetric;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.PredefinedMetric getPredefinedMetric() {
            return this.predefinedMetric;
        }

        @Override
        public final java.lang.String getResourceLabel() {
            return this.resourceLabel;
        }

        @Override
        public final software.amazon.awscdk.Duration getCooldown() {
            return this.cooldown;
        }

        @Override
        public final java.lang.Boolean getDisableScaleIn() {
            return this.disableScaleIn;
        }

        @Override
        public final software.amazon.awscdk.Duration getEstimatedInstanceWarmup() {
            return this.estimatedInstanceWarmup;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("targetValue", om.valueToTree(this.getTargetValue()));
            if (this.getCustomMetric() != null) {
                data.set("customMetric", om.valueToTree(this.getCustomMetric()));
            }
            if (this.getPredefinedMetric() != null) {
                data.set("predefinedMetric", om.valueToTree(this.getPredefinedMetric()));
            }
            if (this.getResourceLabel() != null) {
                data.set("resourceLabel", om.valueToTree(this.getResourceLabel()));
            }
            if (this.getCooldown() != null) {
                data.set("cooldown", om.valueToTree(this.getCooldown()));
            }
            if (this.getDisableScaleIn() != null) {
                data.set("disableScaleIn", om.valueToTree(this.getDisableScaleIn()));
            }
            if (this.getEstimatedInstanceWarmup() != null) {
                data.set("estimatedInstanceWarmup", om.valueToTree(this.getEstimatedInstanceWarmup()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.BasicTargetTrackingScalingPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BasicTargetTrackingScalingPolicyProps.Jsii$Proxy that = (BasicTargetTrackingScalingPolicyProps.Jsii$Proxy) o;

            if (!targetValue.equals(that.targetValue)) return false;
            if (this.customMetric != null ? !this.customMetric.equals(that.customMetric) : that.customMetric != null) return false;
            if (this.predefinedMetric != null ? !this.predefinedMetric.equals(that.predefinedMetric) : that.predefinedMetric != null) return false;
            if (this.resourceLabel != null ? !this.resourceLabel.equals(that.resourceLabel) : that.resourceLabel != null) return false;
            if (this.cooldown != null ? !this.cooldown.equals(that.cooldown) : that.cooldown != null) return false;
            if (this.disableScaleIn != null ? !this.disableScaleIn.equals(that.disableScaleIn) : that.disableScaleIn != null) return false;
            return this.estimatedInstanceWarmup != null ? this.estimatedInstanceWarmup.equals(that.estimatedInstanceWarmup) : that.estimatedInstanceWarmup == null;
        }

        @Override
        public final int hashCode() {
            int result = this.targetValue.hashCode();
            result = 31 * result + (this.customMetric != null ? this.customMetric.hashCode() : 0);
            result = 31 * result + (this.predefinedMetric != null ? this.predefinedMetric.hashCode() : 0);
            result = 31 * result + (this.resourceLabel != null ? this.resourceLabel.hashCode() : 0);
            result = 31 * result + (this.cooldown != null ? this.cooldown.hashCode() : 0);
            result = 31 * result + (this.disableScaleIn != null ? this.disableScaleIn.hashCode() : 0);
            result = 31 * result + (this.estimatedInstanceWarmup != null ? this.estimatedInstanceWarmup.hashCode() : 0);
            return result;
        }
    }
}
