package software.amazon.awscdk.services.autoscaling;

/**
 * (experimental) Properties for a Lifecycle hook.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:03.919Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.LifecycleHookProps")
@software.amazon.jsii.Jsii.Proxy(LifecycleHookProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface LifecycleHookProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.autoscaling.BasicLifecycleHookProps {

    /**
     * (experimental) The AutoScalingGroup to add the lifecycle hook to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup();

    /**
     * @return a {@link Builder} of {@link LifecycleHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LifecycleHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<LifecycleHookProps> {
        private software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        private software.amazon.awscdk.services.autoscaling.LifecycleTransition lifecycleTransition;
        private software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget notificationTarget;
        private software.amazon.awscdk.services.autoscaling.DefaultResult defaultResult;
        private software.amazon.awscdk.Duration heartbeatTimeout;
        private java.lang.String lifecycleHookName;
        private java.lang.String notificationMetadata;
        private software.amazon.awscdk.services.iam.IRole role;

        /**
         * Sets the value of {@link LifecycleHookProps#getAutoScalingGroup}
         * @param autoScalingGroup The AutoScalingGroup to add the lifecycle hook to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder autoScalingGroup(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleHookProps#getLifecycleTransition}
         * @param lifecycleTransition The state of the Amazon EC2 instance to which you want to attach the lifecycle hook. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycleTransition(software.amazon.awscdk.services.autoscaling.LifecycleTransition lifecycleTransition) {
            this.lifecycleTransition = lifecycleTransition;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleHookProps#getNotificationTarget}
         * @param notificationTarget The target of the lifecycle hook. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder notificationTarget(software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget notificationTarget) {
            this.notificationTarget = notificationTarget;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleHookProps#getDefaultResult}
         * @param defaultResult The action the Auto Scaling group takes when the lifecycle hook timeout elapses or if an unexpected failure occurs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultResult(software.amazon.awscdk.services.autoscaling.DefaultResult defaultResult) {
            this.defaultResult = defaultResult;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleHookProps#getHeartbeatTimeout}
         * @param heartbeatTimeout Maximum time between calls to RecordLifecycleActionHeartbeat for the hook.
         *                         If the lifecycle hook times out, perform the action in DefaultResult.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder heartbeatTimeout(software.amazon.awscdk.Duration heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleHookProps#getLifecycleHookName}
         * @param lifecycleHookName Name of the lifecycle hook.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder lifecycleHookName(java.lang.String lifecycleHookName) {
            this.lifecycleHookName = lifecycleHookName;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleHookProps#getNotificationMetadata}
         * @param notificationMetadata Additional data to pass to the lifecycle hook target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder notificationMetadata(java.lang.String notificationMetadata) {
            this.notificationMetadata = notificationMetadata;
            return this;
        }

        /**
         * Sets the value of {@link LifecycleHookProps#getRole}
         * @param role The role that allows publishing to the notification target.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LifecycleHookProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public LifecycleHookProps build() {
            return new Jsii$Proxy(autoScalingGroup, lifecycleTransition, notificationTarget, defaultResult, heartbeatTimeout, lifecycleHookName, notificationMetadata, role);
        }
    }

    /**
     * An implementation for {@link LifecycleHookProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LifecycleHookProps {
        private final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        private final software.amazon.awscdk.services.autoscaling.LifecycleTransition lifecycleTransition;
        private final software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget notificationTarget;
        private final software.amazon.awscdk.services.autoscaling.DefaultResult defaultResult;
        private final software.amazon.awscdk.Duration heartbeatTimeout;
        private final java.lang.String lifecycleHookName;
        private final java.lang.String notificationMetadata;
        private final software.amazon.awscdk.services.iam.IRole role;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingGroup = software.amazon.jsii.Kernel.get(this, "autoScalingGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup.class));
            this.lifecycleTransition = software.amazon.jsii.Kernel.get(this, "lifecycleTransition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.LifecycleTransition.class));
            this.notificationTarget = software.amazon.jsii.Kernel.get(this, "notificationTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget.class));
            this.defaultResult = software.amazon.jsii.Kernel.get(this, "defaultResult", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.DefaultResult.class));
            this.heartbeatTimeout = software.amazon.jsii.Kernel.get(this, "heartbeatTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.lifecycleHookName = software.amazon.jsii.Kernel.get(this, "lifecycleHookName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.notificationMetadata = software.amazon.jsii.Kernel.get(this, "notificationMetadata", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup, final software.amazon.awscdk.services.autoscaling.LifecycleTransition lifecycleTransition, final software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget notificationTarget, final software.amazon.awscdk.services.autoscaling.DefaultResult defaultResult, final software.amazon.awscdk.Duration heartbeatTimeout, final java.lang.String lifecycleHookName, final java.lang.String notificationMetadata, final software.amazon.awscdk.services.iam.IRole role) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingGroup = java.util.Objects.requireNonNull(autoScalingGroup, "autoScalingGroup is required");
            this.lifecycleTransition = java.util.Objects.requireNonNull(lifecycleTransition, "lifecycleTransition is required");
            this.notificationTarget = java.util.Objects.requireNonNull(notificationTarget, "notificationTarget is required");
            this.defaultResult = defaultResult;
            this.heartbeatTimeout = heartbeatTimeout;
            this.lifecycleHookName = lifecycleHookName;
            this.notificationMetadata = notificationMetadata;
            this.role = role;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup() {
            return this.autoScalingGroup;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.LifecycleTransition getLifecycleTransition() {
            return this.lifecycleTransition;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.ILifecycleHookTarget getNotificationTarget() {
            return this.notificationTarget;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.DefaultResult getDefaultResult() {
            return this.defaultResult;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final java.lang.String getLifecycleHookName() {
            return this.lifecycleHookName;
        }

        @Override
        public final java.lang.String getNotificationMetadata() {
            return this.notificationMetadata;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoScalingGroup", om.valueToTree(this.getAutoScalingGroup()));
            data.set("lifecycleTransition", om.valueToTree(this.getLifecycleTransition()));
            data.set("notificationTarget", om.valueToTree(this.getNotificationTarget()));
            if (this.getDefaultResult() != null) {
                data.set("defaultResult", om.valueToTree(this.getDefaultResult()));
            }
            if (this.getHeartbeatTimeout() != null) {
                data.set("heartbeatTimeout", om.valueToTree(this.getHeartbeatTimeout()));
            }
            if (this.getLifecycleHookName() != null) {
                data.set("lifecycleHookName", om.valueToTree(this.getLifecycleHookName()));
            }
            if (this.getNotificationMetadata() != null) {
                data.set("notificationMetadata", om.valueToTree(this.getNotificationMetadata()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.LifecycleHookProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LifecycleHookProps.Jsii$Proxy that = (LifecycleHookProps.Jsii$Proxy) o;

            if (!autoScalingGroup.equals(that.autoScalingGroup)) return false;
            if (!lifecycleTransition.equals(that.lifecycleTransition)) return false;
            if (!notificationTarget.equals(that.notificationTarget)) return false;
            if (this.defaultResult != null ? !this.defaultResult.equals(that.defaultResult) : that.defaultResult != null) return false;
            if (this.heartbeatTimeout != null ? !this.heartbeatTimeout.equals(that.heartbeatTimeout) : that.heartbeatTimeout != null) return false;
            if (this.lifecycleHookName != null ? !this.lifecycleHookName.equals(that.lifecycleHookName) : that.lifecycleHookName != null) return false;
            if (this.notificationMetadata != null ? !this.notificationMetadata.equals(that.notificationMetadata) : that.notificationMetadata != null) return false;
            return this.role != null ? this.role.equals(that.role) : that.role == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoScalingGroup.hashCode();
            result = 31 * result + (this.lifecycleTransition.hashCode());
            result = 31 * result + (this.notificationTarget.hashCode());
            result = 31 * result + (this.defaultResult != null ? this.defaultResult.hashCode() : 0);
            result = 31 * result + (this.heartbeatTimeout != null ? this.heartbeatTimeout.hashCode() : 0);
            result = 31 * result + (this.lifecycleHookName != null ? this.lifecycleHookName.hashCode() : 0);
            result = 31 * result + (this.notificationMetadata != null ? this.notificationMetadata.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            return result;
        }
    }
}
