package software.amazon.awscdk.services.autoscaling;

/**
 * (experimental) Options for customizing the rolling update.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:03.921Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.RollingUpdateOptions")
@software.amazon.jsii.Jsii.Proxy(RollingUpdateOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface RollingUpdateOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) The maximum number of instances that AWS CloudFormation updates at once.
     * <p>
     * This number affects the speed of the replacement.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxBatchSize() {
        return null;
    }

    /**
     * (experimental) The minimum number of instances that must be in service before more instances are replaced.
     * <p>
     * This number affects the speed of the replacement.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinInstancesInService() {
        return null;
    }

    /**
     * (experimental) The percentage of instances that must signal success for the update to succeed.
     * <p>
     * Default: - The `minSuccessPercentage` configured for `signals` on the AutoScalingGroup
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinSuccessPercentage() {
        return null;
    }

    /**
     * (experimental) The pause time after making a change to a batch of instances.
     * <p>
     * Default: - The `timeout` configured for `signals` on the AutoScalingGroup
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getPauseTime() {
        return null;
    }

    /**
     * (experimental) Specifies the Auto Scaling processes to suspend during a stack update.
     * <p>
     * Suspending processes prevents Auto Scaling from interfering with a stack
     * update.
     * <p>
     * Default: HealthCheck, ReplaceUnhealthy, AZRebalance, AlarmNotification, ScheduledActions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> getSuspendProcesses() {
        return null;
    }

    /**
     * (experimental) Specifies whether the Auto Scaling group waits on signals from new instances during an update.
     * <p>
     * Default: true if you configured `signals` on the AutoScalingGroup, false otherwise
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getWaitOnResourceSignals() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link RollingUpdateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link RollingUpdateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<RollingUpdateOptions> {
        private java.lang.Number maxBatchSize;
        private java.lang.Number minInstancesInService;
        private java.lang.Number minSuccessPercentage;
        private software.amazon.awscdk.Duration pauseTime;
        private java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> suspendProcesses;
        private java.lang.Boolean waitOnResourceSignals;

        /**
         * Sets the value of {@link RollingUpdateOptions#getMaxBatchSize}
         * @param maxBatchSize The maximum number of instances that AWS CloudFormation updates at once.
         *                     This number affects the speed of the replacement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxBatchSize(java.lang.Number maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateOptions#getMinInstancesInService}
         * @param minInstancesInService The minimum number of instances that must be in service before more instances are replaced.
         *                              This number affects the speed of the replacement.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minInstancesInService(java.lang.Number minInstancesInService) {
            this.minInstancesInService = minInstancesInService;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateOptions#getMinSuccessPercentage}
         * @param minSuccessPercentage The percentage of instances that must signal success for the update to succeed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minSuccessPercentage(java.lang.Number minSuccessPercentage) {
            this.minSuccessPercentage = minSuccessPercentage;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateOptions#getPauseTime}
         * @param pauseTime The pause time after making a change to a batch of instances.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pauseTime(software.amazon.awscdk.Duration pauseTime) {
            this.pauseTime = pauseTime;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateOptions#getSuspendProcesses}
         * @param suspendProcesses Specifies the Auto Scaling processes to suspend during a stack update.
         *                         Suspending processes prevents Auto Scaling from interfering with a stack
         *                         update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder suspendProcesses(java.util.List<? extends software.amazon.awscdk.services.autoscaling.ScalingProcess> suspendProcesses) {
            this.suspendProcesses = (java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess>)suspendProcesses;
            return this;
        }

        /**
         * Sets the value of {@link RollingUpdateOptions#getWaitOnResourceSignals}
         * @param waitOnResourceSignals Specifies whether the Auto Scaling group waits on signals from new instances during an update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder waitOnResourceSignals(java.lang.Boolean waitOnResourceSignals) {
            this.waitOnResourceSignals = waitOnResourceSignals;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RollingUpdateOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public RollingUpdateOptions build() {
            return new Jsii$Proxy(maxBatchSize, minInstancesInService, minSuccessPercentage, pauseTime, suspendProcesses, waitOnResourceSignals);
        }
    }

    /**
     * An implementation for {@link RollingUpdateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RollingUpdateOptions {
        private final java.lang.Number maxBatchSize;
        private final java.lang.Number minInstancesInService;
        private final java.lang.Number minSuccessPercentage;
        private final software.amazon.awscdk.Duration pauseTime;
        private final java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> suspendProcesses;
        private final java.lang.Boolean waitOnResourceSignals;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.maxBatchSize = software.amazon.jsii.Kernel.get(this, "maxBatchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minInstancesInService = software.amazon.jsii.Kernel.get(this, "minInstancesInService", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minSuccessPercentage = software.amazon.jsii.Kernel.get(this, "minSuccessPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.pauseTime = software.amazon.jsii.Kernel.get(this, "pauseTime", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.suspendProcesses = software.amazon.jsii.Kernel.get(this, "suspendProcesses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.ScalingProcess.class)));
            this.waitOnResourceSignals = software.amazon.jsii.Kernel.get(this, "waitOnResourceSignals", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.Number maxBatchSize, final java.lang.Number minInstancesInService, final java.lang.Number minSuccessPercentage, final software.amazon.awscdk.Duration pauseTime, final java.util.List<? extends software.amazon.awscdk.services.autoscaling.ScalingProcess> suspendProcesses, final java.lang.Boolean waitOnResourceSignals) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.maxBatchSize = maxBatchSize;
            this.minInstancesInService = minInstancesInService;
            this.minSuccessPercentage = minSuccessPercentage;
            this.pauseTime = pauseTime;
            this.suspendProcesses = (java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess>)suspendProcesses;
            this.waitOnResourceSignals = waitOnResourceSignals;
        }

        @Override
        public final java.lang.Number getMaxBatchSize() {
            return this.maxBatchSize;
        }

        @Override
        public final java.lang.Number getMinInstancesInService() {
            return this.minInstancesInService;
        }

        @Override
        public final java.lang.Number getMinSuccessPercentage() {
            return this.minSuccessPercentage;
        }

        @Override
        public final software.amazon.awscdk.Duration getPauseTime() {
            return this.pauseTime;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.autoscaling.ScalingProcess> getSuspendProcesses() {
            return this.suspendProcesses;
        }

        @Override
        public final java.lang.Boolean getWaitOnResourceSignals() {
            return this.waitOnResourceSignals;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getMaxBatchSize() != null) {
                data.set("maxBatchSize", om.valueToTree(this.getMaxBatchSize()));
            }
            if (this.getMinInstancesInService() != null) {
                data.set("minInstancesInService", om.valueToTree(this.getMinInstancesInService()));
            }
            if (this.getMinSuccessPercentage() != null) {
                data.set("minSuccessPercentage", om.valueToTree(this.getMinSuccessPercentage()));
            }
            if (this.getPauseTime() != null) {
                data.set("pauseTime", om.valueToTree(this.getPauseTime()));
            }
            if (this.getSuspendProcesses() != null) {
                data.set("suspendProcesses", om.valueToTree(this.getSuspendProcesses()));
            }
            if (this.getWaitOnResourceSignals() != null) {
                data.set("waitOnResourceSignals", om.valueToTree(this.getWaitOnResourceSignals()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.RollingUpdateOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            RollingUpdateOptions.Jsii$Proxy that = (RollingUpdateOptions.Jsii$Proxy) o;

            if (this.maxBatchSize != null ? !this.maxBatchSize.equals(that.maxBatchSize) : that.maxBatchSize != null) return false;
            if (this.minInstancesInService != null ? !this.minInstancesInService.equals(that.minInstancesInService) : that.minInstancesInService != null) return false;
            if (this.minSuccessPercentage != null ? !this.minSuccessPercentage.equals(that.minSuccessPercentage) : that.minSuccessPercentage != null) return false;
            if (this.pauseTime != null ? !this.pauseTime.equals(that.pauseTime) : that.pauseTime != null) return false;
            if (this.suspendProcesses != null ? !this.suspendProcesses.equals(that.suspendProcesses) : that.suspendProcesses != null) return false;
            return this.waitOnResourceSignals != null ? this.waitOnResourceSignals.equals(that.waitOnResourceSignals) : that.waitOnResourceSignals == null;
        }

        @Override
        public final int hashCode() {
            int result = this.maxBatchSize != null ? this.maxBatchSize.hashCode() : 0;
            result = 31 * result + (this.minInstancesInService != null ? this.minInstancesInService.hashCode() : 0);
            result = 31 * result + (this.minSuccessPercentage != null ? this.minSuccessPercentage.hashCode() : 0);
            result = 31 * result + (this.pauseTime != null ? this.pauseTime.hashCode() : 0);
            result = 31 * result + (this.suspendProcesses != null ? this.suspendProcesses.hashCode() : 0);
            result = 31 * result + (this.waitOnResourceSignals != null ? this.waitOnResourceSignals.hashCode() : 0);
            return result;
        }
    }
}
