/**
 * <h1>Lifecycle Hook for the CDK AWS AutoScaling Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This library contains integration classes for AutoScaling lifecycle hooks.
 * Instances of these classes should be passed to the
 * <code>autoScalingGroup.addLifecycleHook()</code> method.
 * <p>
 * Lifecycle hooks can be activated in one of the following ways:
 * <p>
 * <ul>
 * <li>Invoke a Lambda function</li>
 * <li>Publish to an SNS topic</li>
 * <li>Send to an SQS queue</li>
 * </ul>
 * <p>
 * For more information on using this library, see the README of the
 * <code>&#64;aws-cdk/aws-autoscaling</code> library.
 * <p>
 * For more information about lifecycle hooks, see
 * <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html">Amazon EC2 AutoScaling Lifecycle hooks</a> in the Amazon EC2 User Guide.
 */
package software.amazon.awscdk.services.autoscaling.hooktargets;
