package software.amazon.awscdk.services.backup;

/**
 * (experimental) Properties for a BackupVault.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:03.945Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.BackupVaultProps")
@software.amazon.jsii.Jsii.Proxy(BackupVaultProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface BackupVaultProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) A resource-based policy that is used to manage access permissions on the backup vault.
     * <p>
     * Default: - access is not restricted
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getAccessPolicy() {
        return null;
    }

    /**
     * (experimental) The name of a logical container where backups are stored.
     * <p>
     * Backup vaults
     * are identified by names that are unique to the account used to create
     * them and the AWS Region where they are created.
     * <p>
     * Default: - A CDK generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getBackupVaultName() {
        return null;
    }

    /**
     * (experimental) The server-side encryption key to use to protect your backups.
     * <p>
     * Default: - an Amazon managed KMS key
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return null;
    }

    /**
     * (experimental) The vault events to send.
     * <p>
     * Default: - all vault events if `notificationTopic` is defined
     * <p>
     * @see https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.backup.BackupVaultEvents> getNotificationEvents() {
        return null;
    }

    /**
     * (experimental) A SNS topic to send vault events to.
     * <p>
     * Default: - no notifications
     * <p>
     * @see https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.ITopic getNotificationTopic() {
        return null;
    }

    /**
     * (experimental) The removal policy to apply to the vault.
     * <p>
     * Note that removing a vault
     * that contains recovery points will fail.
     * <p>
     * Default: RemovalPolicy.RETAIN
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BackupVaultProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BackupVaultProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<BackupVaultProps> {
        private software.amazon.awscdk.services.iam.PolicyDocument accessPolicy;
        private java.lang.String backupVaultName;
        private software.amazon.awscdk.services.kms.IKey encryptionKey;
        private java.util.List<software.amazon.awscdk.services.backup.BackupVaultEvents> notificationEvents;
        private software.amazon.awscdk.services.sns.ITopic notificationTopic;
        private software.amazon.awscdk.RemovalPolicy removalPolicy;

        /**
         * Sets the value of {@link BackupVaultProps#getAccessPolicy}
         * @param accessPolicy A resource-based policy that is used to manage access permissions on the backup vault.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessPolicy(software.amazon.awscdk.services.iam.PolicyDocument accessPolicy) {
            this.accessPolicy = accessPolicy;
            return this;
        }

        /**
         * Sets the value of {@link BackupVaultProps#getBackupVaultName}
         * @param backupVaultName The name of a logical container where backups are stored.
         *                        Backup vaults
         *                        are identified by names that are unique to the account used to create
         *                        them and the AWS Region where they are created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder backupVaultName(java.lang.String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        /**
         * Sets the value of {@link BackupVaultProps#getEncryptionKey}
         * @param encryptionKey The server-side encryption key to use to protect your backups.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder encryptionKey(software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link BackupVaultProps#getNotificationEvents}
         * @param notificationEvents The vault events to send.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder notificationEvents(java.util.List<? extends software.amazon.awscdk.services.backup.BackupVaultEvents> notificationEvents) {
            this.notificationEvents = (java.util.List<software.amazon.awscdk.services.backup.BackupVaultEvents>)notificationEvents;
            return this;
        }

        /**
         * Sets the value of {@link BackupVaultProps#getNotificationTopic}
         * @param notificationTopic A SNS topic to send vault events to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder notificationTopic(software.amazon.awscdk.services.sns.ITopic notificationTopic) {
            this.notificationTopic = notificationTopic;
            return this;
        }

        /**
         * Sets the value of {@link BackupVaultProps#getRemovalPolicy}
         * @param removalPolicy The removal policy to apply to the vault.
         *                      Note that removing a vault
         *                      that contains recovery points will fail.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BackupVaultProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public BackupVaultProps build() {
            return new Jsii$Proxy(accessPolicy, backupVaultName, encryptionKey, notificationEvents, notificationTopic, removalPolicy);
        }
    }

    /**
     * An implementation for {@link BackupVaultProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BackupVaultProps {
        private final software.amazon.awscdk.services.iam.PolicyDocument accessPolicy;
        private final java.lang.String backupVaultName;
        private final software.amazon.awscdk.services.kms.IKey encryptionKey;
        private final java.util.List<software.amazon.awscdk.services.backup.BackupVaultEvents> notificationEvents;
        private final software.amazon.awscdk.services.sns.ITopic notificationTopic;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessPolicy = software.amazon.jsii.Kernel.get(this, "accessPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
            this.backupVaultName = software.amazon.jsii.Kernel.get(this, "backupVaultName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.encryptionKey = software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.notificationEvents = software.amazon.jsii.Kernel.get(this, "notificationEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.backup.BackupVaultEvents.class)));
            this.notificationTopic = software.amazon.jsii.Kernel.get(this, "notificationTopic", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.ITopic.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.iam.PolicyDocument accessPolicy, final java.lang.String backupVaultName, final software.amazon.awscdk.services.kms.IKey encryptionKey, final java.util.List<? extends software.amazon.awscdk.services.backup.BackupVaultEvents> notificationEvents, final software.amazon.awscdk.services.sns.ITopic notificationTopic, final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessPolicy = accessPolicy;
            this.backupVaultName = backupVaultName;
            this.encryptionKey = encryptionKey;
            this.notificationEvents = (java.util.List<software.amazon.awscdk.services.backup.BackupVaultEvents>)notificationEvents;
            this.notificationTopic = notificationTopic;
            this.removalPolicy = removalPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyDocument getAccessPolicy() {
            return this.accessPolicy;
        }

        @Override
        public final java.lang.String getBackupVaultName() {
            return this.backupVaultName;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
            return this.encryptionKey;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.backup.BackupVaultEvents> getNotificationEvents() {
            return this.notificationEvents;
        }

        @Override
        public final software.amazon.awscdk.services.sns.ITopic getNotificationTopic() {
            return this.notificationTopic;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccessPolicy() != null) {
                data.set("accessPolicy", om.valueToTree(this.getAccessPolicy()));
            }
            if (this.getBackupVaultName() != null) {
                data.set("backupVaultName", om.valueToTree(this.getBackupVaultName()));
            }
            if (this.getEncryptionKey() != null) {
                data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
            }
            if (this.getNotificationEvents() != null) {
                data.set("notificationEvents", om.valueToTree(this.getNotificationEvents()));
            }
            if (this.getNotificationTopic() != null) {
                data.set("notificationTopic", om.valueToTree(this.getNotificationTopic()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.BackupVaultProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BackupVaultProps.Jsii$Proxy that = (BackupVaultProps.Jsii$Proxy) o;

            if (this.accessPolicy != null ? !this.accessPolicy.equals(that.accessPolicy) : that.accessPolicy != null) return false;
            if (this.backupVaultName != null ? !this.backupVaultName.equals(that.backupVaultName) : that.backupVaultName != null) return false;
            if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
            if (this.notificationEvents != null ? !this.notificationEvents.equals(that.notificationEvents) : that.notificationEvents != null) return false;
            if (this.notificationTopic != null ? !this.notificationTopic.equals(that.notificationTopic) : that.notificationTopic != null) return false;
            return this.removalPolicy != null ? this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessPolicy != null ? this.accessPolicy.hashCode() : 0;
            result = 31 * result + (this.backupVaultName != null ? this.backupVaultName.hashCode() : 0);
            result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
            result = 31 * result + (this.notificationEvents != null ? this.notificationEvents.hashCode() : 0);
            result = 31 * result + (this.notificationTopic != null ? this.notificationTopic.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            return result;
        }
    }
}
