package software.amazon.awscdk.services.certificatemanager;

/**
 * (experimental) A certificate managed by AWS Certificate Manager.
 * <p>
 * Will be automatically
 * validated using DNS validation against the specified Route 53 hosted zone.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:03.979Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_certificatemanager.DnsValidatedCertificate")
public class DnsValidatedCertificate extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.certificatemanager.ICertificate, software.amazon.awscdk.ITaggable {

    protected DnsValidatedCertificate(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DnsValidatedCertificate(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public DnsValidatedCertificate(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Return the DaysToExpiry metric for this AWS Certificate Manager Certificate. By default, this is the minimum value over 1 day.
     * <p>
     * This metric is no longer emitted once the certificate has effectively
     * expired, so alarms configured on this metric should probably treat missing
     * data as "breaching".
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDaysToExpiry(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricDaysToExpiry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) Return the DaysToExpiry metric for this AWS Certificate Manager Certificate. By default, this is the minimum value over 1 day.
     * <p>
     * This metric is no longer emitted once the certificate has effectively
     * expired, so alarms configured on this metric should probably treat missing
     * data as "breaching".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDaysToExpiry() {
        return software.amazon.jsii.Kernel.call(this, "metricDaysToExpiry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) The certificate's ARN.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getCertificateArn() {
        return software.amazon.jsii.Kernel.get(this, "certificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Resource Tags.
     * <p>
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-certificatemanager-certificate.html#cfn-certificatemanager-certificate-tags
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * (experimental) If the certificate is provisionned in a different region than the containing stack, this should be the region in which the certificate lives so we can correctly create `Metric` instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificateProps.Builder();
        }

        /**
         * (experimental) Fully-qualified domain name to request a certificate for.
         * <p>
         * May contain wildcards, such as <code>*.domain.com</code>.
         * <p>
         * @return {@code this}
         * @param domainName Fully-qualified domain name to request a certificate for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * (experimental) Alternative domain names on your certificate.
         * <p>
         * Use this to register alternative domain names that represent the same site.
         * <p>
         * Default: - No additional FQDNs will be included as alternative domain names.
         * <p>
         * @return {@code this}
         * @param subjectAlternativeNames Alternative domain names on your certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder subjectAlternativeNames(final java.util.List<java.lang.String> subjectAlternativeNames) {
            this.props.subjectAlternativeNames(subjectAlternativeNames);
            return this;
        }

        /**
         * (experimental) How to validate this certificate.
         * <p>
         * Default: CertificateValidation.fromEmail()
         * <p>
         * @return {@code this}
         * @param validation How to validate this certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder validation(final software.amazon.awscdk.services.certificatemanager.CertificateValidation validation) {
            this.props.validation(validation);
            return this;
        }

        /**
         * (experimental) Route 53 Hosted Zone used to perform DNS validation of the request.
         * <p>
         * The zone
         * must be authoritative for the domain name specified in the Certificate Request.
         * <p>
         * @return {@code this}
         * @param hostedZone Route 53 Hosted Zone used to perform DNS validation of the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder hostedZone(final software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
            this.props.hostedZone(hostedZone);
            return this;
        }

        /**
         * (experimental) Role to use for the custom resource that creates the validated certificate.
         * <p>
         * Default: - A new role will be created
         * <p>
         * @return {@code this}
         * @param customResourceRole Role to use for the custom resource that creates the validated certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder customResourceRole(final software.amazon.awscdk.services.iam.IRole customResourceRole) {
            this.props.customResourceRole(customResourceRole);
            return this;
        }

        /**
         * (experimental) AWS region that will host the certificate.
         * <p>
         * This is needed especially
         * for certificates used for CloudFront distributions, which require the region
         * to be us-east-1.
         * <p>
         * Default: the region the stack is deployed in.
         * <p>
         * @return {@code this}
         * @param region AWS region that will host the certificate. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * (experimental) An endpoint of Route53 service, which is not necessary as AWS SDK could figure out the right endpoints for most regions, but for some regions such as those in aws-cn partition, the default endpoint is not working now, hence the right endpoint need to be specified through this prop.
         * <p>
         * Route53 is not been officially launched in China, it is only available for AWS
         * internal accounts now. To make DnsValidatedCertificate work for internal accounts
         * now, a special endpoint needs to be provided.
         * <p>
         * Default: - The AWS SDK will determine the Route53 endpoint to use based on region
         * <p>
         * @return {@code this}
         * @param route53Endpoint An endpoint of Route53 service, which is not necessary as AWS SDK could figure out the right endpoints for most regions, but for some regions such as those in aws-cn partition, the default endpoint is not working now, hence the right endpoint need to be specified through this prop. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder route53Endpoint(final java.lang.String route53Endpoint) {
            this.props.route53Endpoint(route53Endpoint);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate build() {
            return new software.amazon.awscdk.services.certificatemanager.DnsValidatedCertificate(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
