package software.amazon.awscdk.services.cloudfront;

/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:04.017Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution")
public class CfnDistribution extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnDistribution(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDistribution(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnDistribution.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::CloudFront::Distribution`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDistribution(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnDistributionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainName() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::CloudFront::Distribution.Tags`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * `AWS::CloudFront::Distribution.DistributionConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDistributionConfig() {
        return software.amazon.jsii.Kernel.get(this, "distributionConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * `AWS::CloudFront::Distribution.DistributionConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributionConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnDistribution.DistributionConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "distributionConfig", java.util.Objects.requireNonNull(value, "distributionConfig is required"));
    }

    /**
     * `AWS::CloudFront::Distribution.DistributionConfig`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributionConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "distributionConfig", java.util.Objects.requireNonNull(value, "distributionConfig is required"));
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.CacheBehaviorProperty")
    @software.amazon.jsii.Jsii.Proxy(CacheBehaviorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CacheBehaviorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.CacheBehaviorProperty.PathPattern`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPathPattern();

        /**
         * `CfnDistribution.CacheBehaviorProperty.TargetOriginId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetOriginId();

        /**
         * `CfnDistribution.CacheBehaviorProperty.ViewerProtocolPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getViewerProtocolPolicy();

        /**
         * `CfnDistribution.CacheBehaviorProperty.AllowedMethods`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedMethods() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.CachedMethods`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCachedMethods() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.CachePolicyId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCachePolicyId() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.Compress`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompress() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.DefaultTTL`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultTtl() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.FieldLevelEncryptionId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFieldLevelEncryptionId() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.ForwardedValues`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedValues() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.FunctionAssociations`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFunctionAssociations() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.LambdaFunctionAssociations`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaFunctionAssociations() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.MaxTTL`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxTtl() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.MinTTL`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTtl() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.OriginRequestPolicyId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginRequestPolicyId() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.RealtimeLogConfigArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRealtimeLogConfigArn() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.SmoothStreaming`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmoothStreaming() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.TrustedKeyGroups`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedKeyGroups() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.TrustedSigners`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedSigners() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CacheBehaviorProperty> {
            private java.lang.String pathPattern;
            private java.lang.String targetOriginId;
            private java.lang.String viewerProtocolPolicy;
            private java.util.List<java.lang.String> allowedMethods;
            private java.util.List<java.lang.String> cachedMethods;
            private java.lang.String cachePolicyId;
            private java.lang.Object compress;
            private java.lang.Number defaultTtl;
            private java.lang.String fieldLevelEncryptionId;
            private java.lang.Object forwardedValues;
            private java.lang.Object functionAssociations;
            private java.lang.Object lambdaFunctionAssociations;
            private java.lang.Number maxTtl;
            private java.lang.Number minTtl;
            private java.lang.String originRequestPolicyId;
            private java.lang.String realtimeLogConfigArn;
            private java.lang.Object smoothStreaming;
            private java.util.List<java.lang.String> trustedKeyGroups;
            private java.util.List<java.lang.String> trustedSigners;

            /**
             * Sets the value of {@link CacheBehaviorProperty#getPathPattern}
             * @param pathPattern `CfnDistribution.CacheBehaviorProperty.PathPattern`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pathPattern(java.lang.String pathPattern) {
                this.pathPattern = pathPattern;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getTargetOriginId}
             * @param targetOriginId `CfnDistribution.CacheBehaviorProperty.TargetOriginId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetOriginId(java.lang.String targetOriginId) {
                this.targetOriginId = targetOriginId;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getViewerProtocolPolicy}
             * @param viewerProtocolPolicy `CfnDistribution.CacheBehaviorProperty.ViewerProtocolPolicy`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewerProtocolPolicy(java.lang.String viewerProtocolPolicy) {
                this.viewerProtocolPolicy = viewerProtocolPolicy;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getAllowedMethods}
             * @param allowedMethods `CfnDistribution.CacheBehaviorProperty.AllowedMethods`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedMethods(java.util.List<java.lang.String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getCachedMethods}
             * @param cachedMethods `CfnDistribution.CacheBehaviorProperty.CachedMethods`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachedMethods(java.util.List<java.lang.String> cachedMethods) {
                this.cachedMethods = cachedMethods;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getCachePolicyId}
             * @param cachePolicyId `CfnDistribution.CacheBehaviorProperty.CachePolicyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachePolicyId(java.lang.String cachePolicyId) {
                this.cachePolicyId = cachePolicyId;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getCompress}
             * @param compress `CfnDistribution.CacheBehaviorProperty.Compress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compress(java.lang.Boolean compress) {
                this.compress = compress;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getCompress}
             * @param compress `CfnDistribution.CacheBehaviorProperty.Compress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compress(software.amazon.awscdk.IResolvable compress) {
                this.compress = compress;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getDefaultTtl}
             * @param defaultTtl `CfnDistribution.CacheBehaviorProperty.DefaultTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTtl(java.lang.Number defaultTtl) {
                this.defaultTtl = defaultTtl;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getFieldLevelEncryptionId}
             * @param fieldLevelEncryptionId `CfnDistribution.CacheBehaviorProperty.FieldLevelEncryptionId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldLevelEncryptionId(java.lang.String fieldLevelEncryptionId) {
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getForwardedValues}
             * @param forwardedValues `CfnDistribution.CacheBehaviorProperty.ForwardedValues`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedValues(software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getForwardedValues}
             * @param forwardedValues `CfnDistribution.CacheBehaviorProperty.ForwardedValues`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedValues(software.amazon.awscdk.IResolvable forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getFunctionAssociations}
             * @param functionAssociations `CfnDistribution.CacheBehaviorProperty.FunctionAssociations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionAssociations(software.amazon.awscdk.IResolvable functionAssociations) {
                this.functionAssociations = functionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getFunctionAssociations}
             * @param functionAssociations `CfnDistribution.CacheBehaviorProperty.FunctionAssociations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionAssociations(java.util.List<? extends java.lang.Object> functionAssociations) {
                this.functionAssociations = functionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getLambdaFunctionAssociations}
             * @param lambdaFunctionAssociations `CfnDistribution.CacheBehaviorProperty.LambdaFunctionAssociations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionAssociations(software.amazon.awscdk.IResolvable lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getLambdaFunctionAssociations}
             * @param lambdaFunctionAssociations `CfnDistribution.CacheBehaviorProperty.LambdaFunctionAssociations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionAssociations(java.util.List<? extends java.lang.Object> lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getMaxTtl}
             * @param maxTtl `CfnDistribution.CacheBehaviorProperty.MaxTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTtl(java.lang.Number maxTtl) {
                this.maxTtl = maxTtl;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getMinTtl}
             * @param minTtl `CfnDistribution.CacheBehaviorProperty.MinTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTtl(java.lang.Number minTtl) {
                this.minTtl = minTtl;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getOriginRequestPolicyId}
             * @param originRequestPolicyId `CfnDistribution.CacheBehaviorProperty.OriginRequestPolicyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originRequestPolicyId(java.lang.String originRequestPolicyId) {
                this.originRequestPolicyId = originRequestPolicyId;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getRealtimeLogConfigArn}
             * @param realtimeLogConfigArn `CfnDistribution.CacheBehaviorProperty.RealtimeLogConfigArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder realtimeLogConfigArn(java.lang.String realtimeLogConfigArn) {
                this.realtimeLogConfigArn = realtimeLogConfigArn;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getSmoothStreaming}
             * @param smoothStreaming `CfnDistribution.CacheBehaviorProperty.SmoothStreaming`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smoothStreaming(java.lang.Boolean smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getSmoothStreaming}
             * @param smoothStreaming `CfnDistribution.CacheBehaviorProperty.SmoothStreaming`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smoothStreaming(software.amazon.awscdk.IResolvable smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getTrustedKeyGroups}
             * @param trustedKeyGroups `CfnDistribution.CacheBehaviorProperty.TrustedKeyGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedKeyGroups(java.util.List<java.lang.String> trustedKeyGroups) {
                this.trustedKeyGroups = trustedKeyGroups;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getTrustedSigners}
             * @param trustedSigners `CfnDistribution.CacheBehaviorProperty.TrustedSigners`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedSigners(java.util.List<java.lang.String> trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CacheBehaviorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CacheBehaviorProperty build() {
                return new Jsii$Proxy(pathPattern, targetOriginId, viewerProtocolPolicy, allowedMethods, cachedMethods, cachePolicyId, compress, defaultTtl, fieldLevelEncryptionId, forwardedValues, functionAssociations, lambdaFunctionAssociations, maxTtl, minTtl, originRequestPolicyId, realtimeLogConfigArn, smoothStreaming, trustedKeyGroups, trustedSigners);
            }
        }

        /**
         * An implementation for {@link CacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CacheBehaviorProperty {
            private final java.lang.String pathPattern;
            private final java.lang.String targetOriginId;
            private final java.lang.String viewerProtocolPolicy;
            private final java.util.List<java.lang.String> allowedMethods;
            private final java.util.List<java.lang.String> cachedMethods;
            private final java.lang.String cachePolicyId;
            private final java.lang.Object compress;
            private final java.lang.Number defaultTtl;
            private final java.lang.String fieldLevelEncryptionId;
            private final java.lang.Object forwardedValues;
            private final java.lang.Object functionAssociations;
            private final java.lang.Object lambdaFunctionAssociations;
            private final java.lang.Number maxTtl;
            private final java.lang.Number minTtl;
            private final java.lang.String originRequestPolicyId;
            private final java.lang.String realtimeLogConfigArn;
            private final java.lang.Object smoothStreaming;
            private final java.util.List<java.lang.String> trustedKeyGroups;
            private final java.util.List<java.lang.String> trustedSigners;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pathPattern = software.amazon.jsii.Kernel.get(this, "pathPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetOriginId = software.amazon.jsii.Kernel.get(this, "targetOriginId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.viewerProtocolPolicy = software.amazon.jsii.Kernel.get(this, "viewerProtocolPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowedMethods = software.amazon.jsii.Kernel.get(this, "allowedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cachedMethods = software.amazon.jsii.Kernel.get(this, "cachedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cachePolicyId = software.amazon.jsii.Kernel.get(this, "cachePolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.compress = software.amazon.jsii.Kernel.get(this, "compress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultTtl = software.amazon.jsii.Kernel.get(this, "defaultTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fieldLevelEncryptionId = software.amazon.jsii.Kernel.get(this, "fieldLevelEncryptionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.forwardedValues = software.amazon.jsii.Kernel.get(this, "forwardedValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.functionAssociations = software.amazon.jsii.Kernel.get(this, "functionAssociations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaFunctionAssociations = software.amazon.jsii.Kernel.get(this, "lambdaFunctionAssociations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxTtl = software.amazon.jsii.Kernel.get(this, "maxTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minTtl = software.amazon.jsii.Kernel.get(this, "minTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.originRequestPolicyId = software.amazon.jsii.Kernel.get(this, "originRequestPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.realtimeLogConfigArn = software.amazon.jsii.Kernel.get(this, "realtimeLogConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.smoothStreaming = software.amazon.jsii.Kernel.get(this, "smoothStreaming", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.trustedKeyGroups = software.amazon.jsii.Kernel.get(this, "trustedKeyGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.trustedSigners = software.amazon.jsii.Kernel.get(this, "trustedSigners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String pathPattern, final java.lang.String targetOriginId, final java.lang.String viewerProtocolPolicy, final java.util.List<java.lang.String> allowedMethods, final java.util.List<java.lang.String> cachedMethods, final java.lang.String cachePolicyId, final java.lang.Object compress, final java.lang.Number defaultTtl, final java.lang.String fieldLevelEncryptionId, final java.lang.Object forwardedValues, final java.lang.Object functionAssociations, final java.lang.Object lambdaFunctionAssociations, final java.lang.Number maxTtl, final java.lang.Number minTtl, final java.lang.String originRequestPolicyId, final java.lang.String realtimeLogConfigArn, final java.lang.Object smoothStreaming, final java.util.List<java.lang.String> trustedKeyGroups, final java.util.List<java.lang.String> trustedSigners) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pathPattern = java.util.Objects.requireNonNull(pathPattern, "pathPattern is required");
                this.targetOriginId = java.util.Objects.requireNonNull(targetOriginId, "targetOriginId is required");
                this.viewerProtocolPolicy = java.util.Objects.requireNonNull(viewerProtocolPolicy, "viewerProtocolPolicy is required");
                this.allowedMethods = allowedMethods;
                this.cachedMethods = cachedMethods;
                this.cachePolicyId = cachePolicyId;
                this.compress = compress;
                this.defaultTtl = defaultTtl;
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                this.forwardedValues = forwardedValues;
                this.functionAssociations = functionAssociations;
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                this.maxTtl = maxTtl;
                this.minTtl = minTtl;
                this.originRequestPolicyId = originRequestPolicyId;
                this.realtimeLogConfigArn = realtimeLogConfigArn;
                this.smoothStreaming = smoothStreaming;
                this.trustedKeyGroups = trustedKeyGroups;
                this.trustedSigners = trustedSigners;
            }

            @Override
            public final java.lang.String getPathPattern() {
                return this.pathPattern;
            }

            @Override
            public final java.lang.String getTargetOriginId() {
                return this.targetOriginId;
            }

            @Override
            public final java.lang.String getViewerProtocolPolicy() {
                return this.viewerProtocolPolicy;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedMethods() {
                return this.allowedMethods;
            }

            @Override
            public final java.util.List<java.lang.String> getCachedMethods() {
                return this.cachedMethods;
            }

            @Override
            public final java.lang.String getCachePolicyId() {
                return this.cachePolicyId;
            }

            @Override
            public final java.lang.Object getCompress() {
                return this.compress;
            }

            @Override
            public final java.lang.Number getDefaultTtl() {
                return this.defaultTtl;
            }

            @Override
            public final java.lang.String getFieldLevelEncryptionId() {
                return this.fieldLevelEncryptionId;
            }

            @Override
            public final java.lang.Object getForwardedValues() {
                return this.forwardedValues;
            }

            @Override
            public final java.lang.Object getFunctionAssociations() {
                return this.functionAssociations;
            }

            @Override
            public final java.lang.Object getLambdaFunctionAssociations() {
                return this.lambdaFunctionAssociations;
            }

            @Override
            public final java.lang.Number getMaxTtl() {
                return this.maxTtl;
            }

            @Override
            public final java.lang.Number getMinTtl() {
                return this.minTtl;
            }

            @Override
            public final java.lang.String getOriginRequestPolicyId() {
                return this.originRequestPolicyId;
            }

            @Override
            public final java.lang.String getRealtimeLogConfigArn() {
                return this.realtimeLogConfigArn;
            }

            @Override
            public final java.lang.Object getSmoothStreaming() {
                return this.smoothStreaming;
            }

            @Override
            public final java.util.List<java.lang.String> getTrustedKeyGroups() {
                return this.trustedKeyGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getTrustedSigners() {
                return this.trustedSigners;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pathPattern", om.valueToTree(this.getPathPattern()));
                data.set("targetOriginId", om.valueToTree(this.getTargetOriginId()));
                data.set("viewerProtocolPolicy", om.valueToTree(this.getViewerProtocolPolicy()));
                if (this.getAllowedMethods() != null) {
                    data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                }
                if (this.getCachedMethods() != null) {
                    data.set("cachedMethods", om.valueToTree(this.getCachedMethods()));
                }
                if (this.getCachePolicyId() != null) {
                    data.set("cachePolicyId", om.valueToTree(this.getCachePolicyId()));
                }
                if (this.getCompress() != null) {
                    data.set("compress", om.valueToTree(this.getCompress()));
                }
                if (this.getDefaultTtl() != null) {
                    data.set("defaultTtl", om.valueToTree(this.getDefaultTtl()));
                }
                if (this.getFieldLevelEncryptionId() != null) {
                    data.set("fieldLevelEncryptionId", om.valueToTree(this.getFieldLevelEncryptionId()));
                }
                if (this.getForwardedValues() != null) {
                    data.set("forwardedValues", om.valueToTree(this.getForwardedValues()));
                }
                if (this.getFunctionAssociations() != null) {
                    data.set("functionAssociations", om.valueToTree(this.getFunctionAssociations()));
                }
                if (this.getLambdaFunctionAssociations() != null) {
                    data.set("lambdaFunctionAssociations", om.valueToTree(this.getLambdaFunctionAssociations()));
                }
                if (this.getMaxTtl() != null) {
                    data.set("maxTtl", om.valueToTree(this.getMaxTtl()));
                }
                if (this.getMinTtl() != null) {
                    data.set("minTtl", om.valueToTree(this.getMinTtl()));
                }
                if (this.getOriginRequestPolicyId() != null) {
                    data.set("originRequestPolicyId", om.valueToTree(this.getOriginRequestPolicyId()));
                }
                if (this.getRealtimeLogConfigArn() != null) {
                    data.set("realtimeLogConfigArn", om.valueToTree(this.getRealtimeLogConfigArn()));
                }
                if (this.getSmoothStreaming() != null) {
                    data.set("smoothStreaming", om.valueToTree(this.getSmoothStreaming()));
                }
                if (this.getTrustedKeyGroups() != null) {
                    data.set("trustedKeyGroups", om.valueToTree(this.getTrustedKeyGroups()));
                }
                if (this.getTrustedSigners() != null) {
                    data.set("trustedSigners", om.valueToTree(this.getTrustedSigners()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.CacheBehaviorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CacheBehaviorProperty.Jsii$Proxy that = (CacheBehaviorProperty.Jsii$Proxy) o;

                if (!pathPattern.equals(that.pathPattern)) return false;
                if (!targetOriginId.equals(that.targetOriginId)) return false;
                if (!viewerProtocolPolicy.equals(that.viewerProtocolPolicy)) return false;
                if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
                if (this.cachedMethods != null ? !this.cachedMethods.equals(that.cachedMethods) : that.cachedMethods != null) return false;
                if (this.cachePolicyId != null ? !this.cachePolicyId.equals(that.cachePolicyId) : that.cachePolicyId != null) return false;
                if (this.compress != null ? !this.compress.equals(that.compress) : that.compress != null) return false;
                if (this.defaultTtl != null ? !this.defaultTtl.equals(that.defaultTtl) : that.defaultTtl != null) return false;
                if (this.fieldLevelEncryptionId != null ? !this.fieldLevelEncryptionId.equals(that.fieldLevelEncryptionId) : that.fieldLevelEncryptionId != null) return false;
                if (this.forwardedValues != null ? !this.forwardedValues.equals(that.forwardedValues) : that.forwardedValues != null) return false;
                if (this.functionAssociations != null ? !this.functionAssociations.equals(that.functionAssociations) : that.functionAssociations != null) return false;
                if (this.lambdaFunctionAssociations != null ? !this.lambdaFunctionAssociations.equals(that.lambdaFunctionAssociations) : that.lambdaFunctionAssociations != null) return false;
                if (this.maxTtl != null ? !this.maxTtl.equals(that.maxTtl) : that.maxTtl != null) return false;
                if (this.minTtl != null ? !this.minTtl.equals(that.minTtl) : that.minTtl != null) return false;
                if (this.originRequestPolicyId != null ? !this.originRequestPolicyId.equals(that.originRequestPolicyId) : that.originRequestPolicyId != null) return false;
                if (this.realtimeLogConfigArn != null ? !this.realtimeLogConfigArn.equals(that.realtimeLogConfigArn) : that.realtimeLogConfigArn != null) return false;
                if (this.smoothStreaming != null ? !this.smoothStreaming.equals(that.smoothStreaming) : that.smoothStreaming != null) return false;
                if (this.trustedKeyGroups != null ? !this.trustedKeyGroups.equals(that.trustedKeyGroups) : that.trustedKeyGroups != null) return false;
                return this.trustedSigners != null ? this.trustedSigners.equals(that.trustedSigners) : that.trustedSigners == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pathPattern.hashCode();
                result = 31 * result + (this.targetOriginId.hashCode());
                result = 31 * result + (this.viewerProtocolPolicy.hashCode());
                result = 31 * result + (this.allowedMethods != null ? this.allowedMethods.hashCode() : 0);
                result = 31 * result + (this.cachedMethods != null ? this.cachedMethods.hashCode() : 0);
                result = 31 * result + (this.cachePolicyId != null ? this.cachePolicyId.hashCode() : 0);
                result = 31 * result + (this.compress != null ? this.compress.hashCode() : 0);
                result = 31 * result + (this.defaultTtl != null ? this.defaultTtl.hashCode() : 0);
                result = 31 * result + (this.fieldLevelEncryptionId != null ? this.fieldLevelEncryptionId.hashCode() : 0);
                result = 31 * result + (this.forwardedValues != null ? this.forwardedValues.hashCode() : 0);
                result = 31 * result + (this.functionAssociations != null ? this.functionAssociations.hashCode() : 0);
                result = 31 * result + (this.lambdaFunctionAssociations != null ? this.lambdaFunctionAssociations.hashCode() : 0);
                result = 31 * result + (this.maxTtl != null ? this.maxTtl.hashCode() : 0);
                result = 31 * result + (this.minTtl != null ? this.minTtl.hashCode() : 0);
                result = 31 * result + (this.originRequestPolicyId != null ? this.originRequestPolicyId.hashCode() : 0);
                result = 31 * result + (this.realtimeLogConfigArn != null ? this.realtimeLogConfigArn.hashCode() : 0);
                result = 31 * result + (this.smoothStreaming != null ? this.smoothStreaming.hashCode() : 0);
                result = 31 * result + (this.trustedKeyGroups != null ? this.trustedKeyGroups.hashCode() : 0);
                result = 31 * result + (this.trustedSigners != null ? this.trustedSigners.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.CookiesProperty")
    @software.amazon.jsii.Jsii.Proxy(CookiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CookiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.CookiesProperty.Forward`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getForward();

        /**
         * `CfnDistribution.CookiesProperty.WhitelistedNames`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getWhitelistedNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CookiesProperty> {
            private java.lang.String forward;
            private java.util.List<java.lang.String> whitelistedNames;

            /**
             * Sets the value of {@link CookiesProperty#getForward}
             * @param forward `CfnDistribution.CookiesProperty.Forward`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forward(java.lang.String forward) {
                this.forward = forward;
                return this;
            }

            /**
             * Sets the value of {@link CookiesProperty#getWhitelistedNames}
             * @param whitelistedNames `CfnDistribution.CookiesProperty.WhitelistedNames`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder whitelistedNames(java.util.List<java.lang.String> whitelistedNames) {
                this.whitelistedNames = whitelistedNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CookiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CookiesProperty build() {
                return new Jsii$Proxy(forward, whitelistedNames);
            }
        }

        /**
         * An implementation for {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CookiesProperty {
            private final java.lang.String forward;
            private final java.util.List<java.lang.String> whitelistedNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.forward = software.amazon.jsii.Kernel.get(this, "forward", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.whitelistedNames = software.amazon.jsii.Kernel.get(this, "whitelistedNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String forward, final java.util.List<java.lang.String> whitelistedNames) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.forward = java.util.Objects.requireNonNull(forward, "forward is required");
                this.whitelistedNames = whitelistedNames;
            }

            @Override
            public final java.lang.String getForward() {
                return this.forward;
            }

            @Override
            public final java.util.List<java.lang.String> getWhitelistedNames() {
                return this.whitelistedNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("forward", om.valueToTree(this.getForward()));
                if (this.getWhitelistedNames() != null) {
                    data.set("whitelistedNames", om.valueToTree(this.getWhitelistedNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.CookiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CookiesProperty.Jsii$Proxy that = (CookiesProperty.Jsii$Proxy) o;

                if (!forward.equals(that.forward)) return false;
                return this.whitelistedNames != null ? this.whitelistedNames.equals(that.whitelistedNames) : that.whitelistedNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.forward.hashCode();
                result = 31 * result + (this.whitelistedNames != null ? this.whitelistedNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.CustomErrorResponseProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomErrorResponseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomErrorResponseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.CustomErrorResponseProperty.ErrorCode`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getErrorCode();

        /**
         * `CfnDistribution.CustomErrorResponseProperty.ErrorCachingMinTTL`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getErrorCachingMinTtl() {
            return null;
        }

        /**
         * `CfnDistribution.CustomErrorResponseProperty.ResponseCode`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getResponseCode() {
            return null;
        }

        /**
         * `CfnDistribution.CustomErrorResponseProperty.ResponsePagePath`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResponsePagePath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomErrorResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomErrorResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomErrorResponseProperty> {
            private java.lang.Number errorCode;
            private java.lang.Number errorCachingMinTtl;
            private java.lang.Number responseCode;
            private java.lang.String responsePagePath;

            /**
             * Sets the value of {@link CustomErrorResponseProperty#getErrorCode}
             * @param errorCode `CfnDistribution.CustomErrorResponseProperty.ErrorCode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorCode(java.lang.Number errorCode) {
                this.errorCode = errorCode;
                return this;
            }

            /**
             * Sets the value of {@link CustomErrorResponseProperty#getErrorCachingMinTtl}
             * @param errorCachingMinTtl `CfnDistribution.CustomErrorResponseProperty.ErrorCachingMinTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorCachingMinTtl(java.lang.Number errorCachingMinTtl) {
                this.errorCachingMinTtl = errorCachingMinTtl;
                return this;
            }

            /**
             * Sets the value of {@link CustomErrorResponseProperty#getResponseCode}
             * @param responseCode `CfnDistribution.CustomErrorResponseProperty.ResponseCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseCode(java.lang.Number responseCode) {
                this.responseCode = responseCode;
                return this;
            }

            /**
             * Sets the value of {@link CustomErrorResponseProperty#getResponsePagePath}
             * @param responsePagePath `CfnDistribution.CustomErrorResponseProperty.ResponsePagePath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responsePagePath(java.lang.String responsePagePath) {
                this.responsePagePath = responsePagePath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomErrorResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomErrorResponseProperty build() {
                return new Jsii$Proxy(errorCode, errorCachingMinTtl, responseCode, responsePagePath);
            }
        }

        /**
         * An implementation for {@link CustomErrorResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomErrorResponseProperty {
            private final java.lang.Number errorCode;
            private final java.lang.Number errorCachingMinTtl;
            private final java.lang.Number responseCode;
            private final java.lang.String responsePagePath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.errorCode = software.amazon.jsii.Kernel.get(this, "errorCode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.errorCachingMinTtl = software.amazon.jsii.Kernel.get(this, "errorCachingMinTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.responseCode = software.amazon.jsii.Kernel.get(this, "responseCode", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.responsePagePath = software.amazon.jsii.Kernel.get(this, "responsePagePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Number errorCode, final java.lang.Number errorCachingMinTtl, final java.lang.Number responseCode, final java.lang.String responsePagePath) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorCode = java.util.Objects.requireNonNull(errorCode, "errorCode is required");
                this.errorCachingMinTtl = errorCachingMinTtl;
                this.responseCode = responseCode;
                this.responsePagePath = responsePagePath;
            }

            @Override
            public final java.lang.Number getErrorCode() {
                return this.errorCode;
            }

            @Override
            public final java.lang.Number getErrorCachingMinTtl() {
                return this.errorCachingMinTtl;
            }

            @Override
            public final java.lang.Number getResponseCode() {
                return this.responseCode;
            }

            @Override
            public final java.lang.String getResponsePagePath() {
                return this.responsePagePath;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("errorCode", om.valueToTree(this.getErrorCode()));
                if (this.getErrorCachingMinTtl() != null) {
                    data.set("errorCachingMinTtl", om.valueToTree(this.getErrorCachingMinTtl()));
                }
                if (this.getResponseCode() != null) {
                    data.set("responseCode", om.valueToTree(this.getResponseCode()));
                }
                if (this.getResponsePagePath() != null) {
                    data.set("responsePagePath", om.valueToTree(this.getResponsePagePath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.CustomErrorResponseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomErrorResponseProperty.Jsii$Proxy that = (CustomErrorResponseProperty.Jsii$Proxy) o;

                if (!errorCode.equals(that.errorCode)) return false;
                if (this.errorCachingMinTtl != null ? !this.errorCachingMinTtl.equals(that.errorCachingMinTtl) : that.errorCachingMinTtl != null) return false;
                if (this.responseCode != null ? !this.responseCode.equals(that.responseCode) : that.responseCode != null) return false;
                return this.responsePagePath != null ? this.responsePagePath.equals(that.responsePagePath) : that.responsePagePath == null;
            }

            @Override
            public final int hashCode() {
                int result = this.errorCode.hashCode();
                result = 31 * result + (this.errorCachingMinTtl != null ? this.errorCachingMinTtl.hashCode() : 0);
                result = 31 * result + (this.responseCode != null ? this.responseCode.hashCode() : 0);
                result = 31 * result + (this.responsePagePath != null ? this.responsePagePath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.CustomOriginConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomOriginConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomOriginConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.CustomOriginConfigProperty.OriginProtocolPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOriginProtocolPolicy();

        /**
         * `CfnDistribution.CustomOriginConfigProperty.HTTPPort`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHttpPort() {
            return null;
        }

        /**
         * `CfnDistribution.CustomOriginConfigProperty.HTTPSPort`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHttpsPort() {
            return null;
        }

        /**
         * `CfnDistribution.CustomOriginConfigProperty.OriginKeepaliveTimeout`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOriginKeepaliveTimeout() {
            return null;
        }

        /**
         * `CfnDistribution.CustomOriginConfigProperty.OriginReadTimeout`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOriginReadTimeout() {
            return null;
        }

        /**
         * `CfnDistribution.CustomOriginConfigProperty.OriginSSLProtocols`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOriginSslProtocols() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomOriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomOriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomOriginConfigProperty> {
            private java.lang.String originProtocolPolicy;
            private java.lang.Number httpPort;
            private java.lang.Number httpsPort;
            private java.lang.Number originKeepaliveTimeout;
            private java.lang.Number originReadTimeout;
            private java.util.List<java.lang.String> originSslProtocols;

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getOriginProtocolPolicy}
             * @param originProtocolPolicy `CfnDistribution.CustomOriginConfigProperty.OriginProtocolPolicy`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originProtocolPolicy(java.lang.String originProtocolPolicy) {
                this.originProtocolPolicy = originProtocolPolicy;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getHttpPort}
             * @param httpPort `CfnDistribution.CustomOriginConfigProperty.HTTPPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpPort(java.lang.Number httpPort) {
                this.httpPort = httpPort;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getHttpsPort}
             * @param httpsPort `CfnDistribution.CustomOriginConfigProperty.HTTPSPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpsPort(java.lang.Number httpsPort) {
                this.httpsPort = httpsPort;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getOriginKeepaliveTimeout}
             * @param originKeepaliveTimeout `CfnDistribution.CustomOriginConfigProperty.OriginKeepaliveTimeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originKeepaliveTimeout(java.lang.Number originKeepaliveTimeout) {
                this.originKeepaliveTimeout = originKeepaliveTimeout;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getOriginReadTimeout}
             * @param originReadTimeout `CfnDistribution.CustomOriginConfigProperty.OriginReadTimeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originReadTimeout(java.lang.Number originReadTimeout) {
                this.originReadTimeout = originReadTimeout;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getOriginSslProtocols}
             * @param originSslProtocols `CfnDistribution.CustomOriginConfigProperty.OriginSSLProtocols`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originSslProtocols(java.util.List<java.lang.String> originSslProtocols) {
                this.originSslProtocols = originSslProtocols;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomOriginConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomOriginConfigProperty build() {
                return new Jsii$Proxy(originProtocolPolicy, httpPort, httpsPort, originKeepaliveTimeout, originReadTimeout, originSslProtocols);
            }
        }

        /**
         * An implementation for {@link CustomOriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomOriginConfigProperty {
            private final java.lang.String originProtocolPolicy;
            private final java.lang.Number httpPort;
            private final java.lang.Number httpsPort;
            private final java.lang.Number originKeepaliveTimeout;
            private final java.lang.Number originReadTimeout;
            private final java.util.List<java.lang.String> originSslProtocols;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.originProtocolPolicy = software.amazon.jsii.Kernel.get(this, "originProtocolPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.httpPort = software.amazon.jsii.Kernel.get(this, "httpPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.httpsPort = software.amazon.jsii.Kernel.get(this, "httpsPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.originKeepaliveTimeout = software.amazon.jsii.Kernel.get(this, "originKeepaliveTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.originReadTimeout = software.amazon.jsii.Kernel.get(this, "originReadTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.originSslProtocols = software.amazon.jsii.Kernel.get(this, "originSslProtocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String originProtocolPolicy, final java.lang.Number httpPort, final java.lang.Number httpsPort, final java.lang.Number originKeepaliveTimeout, final java.lang.Number originReadTimeout, final java.util.List<java.lang.String> originSslProtocols) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.originProtocolPolicy = java.util.Objects.requireNonNull(originProtocolPolicy, "originProtocolPolicy is required");
                this.httpPort = httpPort;
                this.httpsPort = httpsPort;
                this.originKeepaliveTimeout = originKeepaliveTimeout;
                this.originReadTimeout = originReadTimeout;
                this.originSslProtocols = originSslProtocols;
            }

            @Override
            public final java.lang.String getOriginProtocolPolicy() {
                return this.originProtocolPolicy;
            }

            @Override
            public final java.lang.Number getHttpPort() {
                return this.httpPort;
            }

            @Override
            public final java.lang.Number getHttpsPort() {
                return this.httpsPort;
            }

            @Override
            public final java.lang.Number getOriginKeepaliveTimeout() {
                return this.originKeepaliveTimeout;
            }

            @Override
            public final java.lang.Number getOriginReadTimeout() {
                return this.originReadTimeout;
            }

            @Override
            public final java.util.List<java.lang.String> getOriginSslProtocols() {
                return this.originSslProtocols;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("originProtocolPolicy", om.valueToTree(this.getOriginProtocolPolicy()));
                if (this.getHttpPort() != null) {
                    data.set("httpPort", om.valueToTree(this.getHttpPort()));
                }
                if (this.getHttpsPort() != null) {
                    data.set("httpsPort", om.valueToTree(this.getHttpsPort()));
                }
                if (this.getOriginKeepaliveTimeout() != null) {
                    data.set("originKeepaliveTimeout", om.valueToTree(this.getOriginKeepaliveTimeout()));
                }
                if (this.getOriginReadTimeout() != null) {
                    data.set("originReadTimeout", om.valueToTree(this.getOriginReadTimeout()));
                }
                if (this.getOriginSslProtocols() != null) {
                    data.set("originSslProtocols", om.valueToTree(this.getOriginSslProtocols()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.CustomOriginConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomOriginConfigProperty.Jsii$Proxy that = (CustomOriginConfigProperty.Jsii$Proxy) o;

                if (!originProtocolPolicy.equals(that.originProtocolPolicy)) return false;
                if (this.httpPort != null ? !this.httpPort.equals(that.httpPort) : that.httpPort != null) return false;
                if (this.httpsPort != null ? !this.httpsPort.equals(that.httpsPort) : that.httpsPort != null) return false;
                if (this.originKeepaliveTimeout != null ? !this.originKeepaliveTimeout.equals(that.originKeepaliveTimeout) : that.originKeepaliveTimeout != null) return false;
                if (this.originReadTimeout != null ? !this.originReadTimeout.equals(that.originReadTimeout) : that.originReadTimeout != null) return false;
                return this.originSslProtocols != null ? this.originSslProtocols.equals(that.originSslProtocols) : that.originSslProtocols == null;
            }

            @Override
            public final int hashCode() {
                int result = this.originProtocolPolicy.hashCode();
                result = 31 * result + (this.httpPort != null ? this.httpPort.hashCode() : 0);
                result = 31 * result + (this.httpsPort != null ? this.httpsPort.hashCode() : 0);
                result = 31 * result + (this.originKeepaliveTimeout != null ? this.originKeepaliveTimeout.hashCode() : 0);
                result = 31 * result + (this.originReadTimeout != null ? this.originReadTimeout.hashCode() : 0);
                result = 31 * result + (this.originSslProtocols != null ? this.originSslProtocols.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.DefaultCacheBehaviorProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultCacheBehaviorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultCacheBehaviorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.TargetOriginId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetOriginId();

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.ViewerProtocolPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getViewerProtocolPolicy();

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.AllowedMethods`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedMethods() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.CachedMethods`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCachedMethods() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.CachePolicyId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCachePolicyId() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.Compress`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompress() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.DefaultTTL`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultTtl() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.FieldLevelEncryptionId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFieldLevelEncryptionId() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.ForwardedValues`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedValues() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.FunctionAssociations`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFunctionAssociations() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.LambdaFunctionAssociations`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaFunctionAssociations() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.MaxTTL`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxTtl() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.MinTTL`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTtl() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.OriginRequestPolicyId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginRequestPolicyId() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.RealtimeLogConfigArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRealtimeLogConfigArn() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.SmoothStreaming`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmoothStreaming() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.TrustedKeyGroups`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedKeyGroups() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.TrustedSigners`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedSigners() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultCacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultCacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultCacheBehaviorProperty> {
            private java.lang.String targetOriginId;
            private java.lang.String viewerProtocolPolicy;
            private java.util.List<java.lang.String> allowedMethods;
            private java.util.List<java.lang.String> cachedMethods;
            private java.lang.String cachePolicyId;
            private java.lang.Object compress;
            private java.lang.Number defaultTtl;
            private java.lang.String fieldLevelEncryptionId;
            private java.lang.Object forwardedValues;
            private java.lang.Object functionAssociations;
            private java.lang.Object lambdaFunctionAssociations;
            private java.lang.Number maxTtl;
            private java.lang.Number minTtl;
            private java.lang.String originRequestPolicyId;
            private java.lang.String realtimeLogConfigArn;
            private java.lang.Object smoothStreaming;
            private java.util.List<java.lang.String> trustedKeyGroups;
            private java.util.List<java.lang.String> trustedSigners;

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getTargetOriginId}
             * @param targetOriginId `CfnDistribution.DefaultCacheBehaviorProperty.TargetOriginId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetOriginId(java.lang.String targetOriginId) {
                this.targetOriginId = targetOriginId;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getViewerProtocolPolicy}
             * @param viewerProtocolPolicy `CfnDistribution.DefaultCacheBehaviorProperty.ViewerProtocolPolicy`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewerProtocolPolicy(java.lang.String viewerProtocolPolicy) {
                this.viewerProtocolPolicy = viewerProtocolPolicy;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getAllowedMethods}
             * @param allowedMethods `CfnDistribution.DefaultCacheBehaviorProperty.AllowedMethods`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedMethods(java.util.List<java.lang.String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getCachedMethods}
             * @param cachedMethods `CfnDistribution.DefaultCacheBehaviorProperty.CachedMethods`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachedMethods(java.util.List<java.lang.String> cachedMethods) {
                this.cachedMethods = cachedMethods;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getCachePolicyId}
             * @param cachePolicyId `CfnDistribution.DefaultCacheBehaviorProperty.CachePolicyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachePolicyId(java.lang.String cachePolicyId) {
                this.cachePolicyId = cachePolicyId;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getCompress}
             * @param compress `CfnDistribution.DefaultCacheBehaviorProperty.Compress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compress(java.lang.Boolean compress) {
                this.compress = compress;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getCompress}
             * @param compress `CfnDistribution.DefaultCacheBehaviorProperty.Compress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compress(software.amazon.awscdk.IResolvable compress) {
                this.compress = compress;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getDefaultTtl}
             * @param defaultTtl `CfnDistribution.DefaultCacheBehaviorProperty.DefaultTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTtl(java.lang.Number defaultTtl) {
                this.defaultTtl = defaultTtl;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getFieldLevelEncryptionId}
             * @param fieldLevelEncryptionId `CfnDistribution.DefaultCacheBehaviorProperty.FieldLevelEncryptionId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldLevelEncryptionId(java.lang.String fieldLevelEncryptionId) {
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getForwardedValues}
             * @param forwardedValues `CfnDistribution.DefaultCacheBehaviorProperty.ForwardedValues`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedValues(software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getForwardedValues}
             * @param forwardedValues `CfnDistribution.DefaultCacheBehaviorProperty.ForwardedValues`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedValues(software.amazon.awscdk.IResolvable forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getFunctionAssociations}
             * @param functionAssociations `CfnDistribution.DefaultCacheBehaviorProperty.FunctionAssociations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionAssociations(software.amazon.awscdk.IResolvable functionAssociations) {
                this.functionAssociations = functionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getFunctionAssociations}
             * @param functionAssociations `CfnDistribution.DefaultCacheBehaviorProperty.FunctionAssociations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionAssociations(java.util.List<? extends java.lang.Object> functionAssociations) {
                this.functionAssociations = functionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getLambdaFunctionAssociations}
             * @param lambdaFunctionAssociations `CfnDistribution.DefaultCacheBehaviorProperty.LambdaFunctionAssociations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionAssociations(software.amazon.awscdk.IResolvable lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getLambdaFunctionAssociations}
             * @param lambdaFunctionAssociations `CfnDistribution.DefaultCacheBehaviorProperty.LambdaFunctionAssociations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionAssociations(java.util.List<? extends java.lang.Object> lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getMaxTtl}
             * @param maxTtl `CfnDistribution.DefaultCacheBehaviorProperty.MaxTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTtl(java.lang.Number maxTtl) {
                this.maxTtl = maxTtl;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getMinTtl}
             * @param minTtl `CfnDistribution.DefaultCacheBehaviorProperty.MinTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTtl(java.lang.Number minTtl) {
                this.minTtl = minTtl;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getOriginRequestPolicyId}
             * @param originRequestPolicyId `CfnDistribution.DefaultCacheBehaviorProperty.OriginRequestPolicyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originRequestPolicyId(java.lang.String originRequestPolicyId) {
                this.originRequestPolicyId = originRequestPolicyId;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getRealtimeLogConfigArn}
             * @param realtimeLogConfigArn `CfnDistribution.DefaultCacheBehaviorProperty.RealtimeLogConfigArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder realtimeLogConfigArn(java.lang.String realtimeLogConfigArn) {
                this.realtimeLogConfigArn = realtimeLogConfigArn;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getSmoothStreaming}
             * @param smoothStreaming `CfnDistribution.DefaultCacheBehaviorProperty.SmoothStreaming`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smoothStreaming(java.lang.Boolean smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getSmoothStreaming}
             * @param smoothStreaming `CfnDistribution.DefaultCacheBehaviorProperty.SmoothStreaming`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smoothStreaming(software.amazon.awscdk.IResolvable smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getTrustedKeyGroups}
             * @param trustedKeyGroups `CfnDistribution.DefaultCacheBehaviorProperty.TrustedKeyGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedKeyGroups(java.util.List<java.lang.String> trustedKeyGroups) {
                this.trustedKeyGroups = trustedKeyGroups;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getTrustedSigners}
             * @param trustedSigners `CfnDistribution.DefaultCacheBehaviorProperty.TrustedSigners`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedSigners(java.util.List<java.lang.String> trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultCacheBehaviorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultCacheBehaviorProperty build() {
                return new Jsii$Proxy(targetOriginId, viewerProtocolPolicy, allowedMethods, cachedMethods, cachePolicyId, compress, defaultTtl, fieldLevelEncryptionId, forwardedValues, functionAssociations, lambdaFunctionAssociations, maxTtl, minTtl, originRequestPolicyId, realtimeLogConfigArn, smoothStreaming, trustedKeyGroups, trustedSigners);
            }
        }

        /**
         * An implementation for {@link DefaultCacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultCacheBehaviorProperty {
            private final java.lang.String targetOriginId;
            private final java.lang.String viewerProtocolPolicy;
            private final java.util.List<java.lang.String> allowedMethods;
            private final java.util.List<java.lang.String> cachedMethods;
            private final java.lang.String cachePolicyId;
            private final java.lang.Object compress;
            private final java.lang.Number defaultTtl;
            private final java.lang.String fieldLevelEncryptionId;
            private final java.lang.Object forwardedValues;
            private final java.lang.Object functionAssociations;
            private final java.lang.Object lambdaFunctionAssociations;
            private final java.lang.Number maxTtl;
            private final java.lang.Number minTtl;
            private final java.lang.String originRequestPolicyId;
            private final java.lang.String realtimeLogConfigArn;
            private final java.lang.Object smoothStreaming;
            private final java.util.List<java.lang.String> trustedKeyGroups;
            private final java.util.List<java.lang.String> trustedSigners;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetOriginId = software.amazon.jsii.Kernel.get(this, "targetOriginId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.viewerProtocolPolicy = software.amazon.jsii.Kernel.get(this, "viewerProtocolPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowedMethods = software.amazon.jsii.Kernel.get(this, "allowedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cachedMethods = software.amazon.jsii.Kernel.get(this, "cachedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cachePolicyId = software.amazon.jsii.Kernel.get(this, "cachePolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.compress = software.amazon.jsii.Kernel.get(this, "compress", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultTtl = software.amazon.jsii.Kernel.get(this, "defaultTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.fieldLevelEncryptionId = software.amazon.jsii.Kernel.get(this, "fieldLevelEncryptionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.forwardedValues = software.amazon.jsii.Kernel.get(this, "forwardedValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.functionAssociations = software.amazon.jsii.Kernel.get(this, "functionAssociations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaFunctionAssociations = software.amazon.jsii.Kernel.get(this, "lambdaFunctionAssociations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxTtl = software.amazon.jsii.Kernel.get(this, "maxTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minTtl = software.amazon.jsii.Kernel.get(this, "minTtl", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.originRequestPolicyId = software.amazon.jsii.Kernel.get(this, "originRequestPolicyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.realtimeLogConfigArn = software.amazon.jsii.Kernel.get(this, "realtimeLogConfigArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.smoothStreaming = software.amazon.jsii.Kernel.get(this, "smoothStreaming", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.trustedKeyGroups = software.amazon.jsii.Kernel.get(this, "trustedKeyGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.trustedSigners = software.amazon.jsii.Kernel.get(this, "trustedSigners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String targetOriginId, final java.lang.String viewerProtocolPolicy, final java.util.List<java.lang.String> allowedMethods, final java.util.List<java.lang.String> cachedMethods, final java.lang.String cachePolicyId, final java.lang.Object compress, final java.lang.Number defaultTtl, final java.lang.String fieldLevelEncryptionId, final java.lang.Object forwardedValues, final java.lang.Object functionAssociations, final java.lang.Object lambdaFunctionAssociations, final java.lang.Number maxTtl, final java.lang.Number minTtl, final java.lang.String originRequestPolicyId, final java.lang.String realtimeLogConfigArn, final java.lang.Object smoothStreaming, final java.util.List<java.lang.String> trustedKeyGroups, final java.util.List<java.lang.String> trustedSigners) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetOriginId = java.util.Objects.requireNonNull(targetOriginId, "targetOriginId is required");
                this.viewerProtocolPolicy = java.util.Objects.requireNonNull(viewerProtocolPolicy, "viewerProtocolPolicy is required");
                this.allowedMethods = allowedMethods;
                this.cachedMethods = cachedMethods;
                this.cachePolicyId = cachePolicyId;
                this.compress = compress;
                this.defaultTtl = defaultTtl;
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                this.forwardedValues = forwardedValues;
                this.functionAssociations = functionAssociations;
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                this.maxTtl = maxTtl;
                this.minTtl = minTtl;
                this.originRequestPolicyId = originRequestPolicyId;
                this.realtimeLogConfigArn = realtimeLogConfigArn;
                this.smoothStreaming = smoothStreaming;
                this.trustedKeyGroups = trustedKeyGroups;
                this.trustedSigners = trustedSigners;
            }

            @Override
            public final java.lang.String getTargetOriginId() {
                return this.targetOriginId;
            }

            @Override
            public final java.lang.String getViewerProtocolPolicy() {
                return this.viewerProtocolPolicy;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedMethods() {
                return this.allowedMethods;
            }

            @Override
            public final java.util.List<java.lang.String> getCachedMethods() {
                return this.cachedMethods;
            }

            @Override
            public final java.lang.String getCachePolicyId() {
                return this.cachePolicyId;
            }

            @Override
            public final java.lang.Object getCompress() {
                return this.compress;
            }

            @Override
            public final java.lang.Number getDefaultTtl() {
                return this.defaultTtl;
            }

            @Override
            public final java.lang.String getFieldLevelEncryptionId() {
                return this.fieldLevelEncryptionId;
            }

            @Override
            public final java.lang.Object getForwardedValues() {
                return this.forwardedValues;
            }

            @Override
            public final java.lang.Object getFunctionAssociations() {
                return this.functionAssociations;
            }

            @Override
            public final java.lang.Object getLambdaFunctionAssociations() {
                return this.lambdaFunctionAssociations;
            }

            @Override
            public final java.lang.Number getMaxTtl() {
                return this.maxTtl;
            }

            @Override
            public final java.lang.Number getMinTtl() {
                return this.minTtl;
            }

            @Override
            public final java.lang.String getOriginRequestPolicyId() {
                return this.originRequestPolicyId;
            }

            @Override
            public final java.lang.String getRealtimeLogConfigArn() {
                return this.realtimeLogConfigArn;
            }

            @Override
            public final java.lang.Object getSmoothStreaming() {
                return this.smoothStreaming;
            }

            @Override
            public final java.util.List<java.lang.String> getTrustedKeyGroups() {
                return this.trustedKeyGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getTrustedSigners() {
                return this.trustedSigners;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetOriginId", om.valueToTree(this.getTargetOriginId()));
                data.set("viewerProtocolPolicy", om.valueToTree(this.getViewerProtocolPolicy()));
                if (this.getAllowedMethods() != null) {
                    data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                }
                if (this.getCachedMethods() != null) {
                    data.set("cachedMethods", om.valueToTree(this.getCachedMethods()));
                }
                if (this.getCachePolicyId() != null) {
                    data.set("cachePolicyId", om.valueToTree(this.getCachePolicyId()));
                }
                if (this.getCompress() != null) {
                    data.set("compress", om.valueToTree(this.getCompress()));
                }
                if (this.getDefaultTtl() != null) {
                    data.set("defaultTtl", om.valueToTree(this.getDefaultTtl()));
                }
                if (this.getFieldLevelEncryptionId() != null) {
                    data.set("fieldLevelEncryptionId", om.valueToTree(this.getFieldLevelEncryptionId()));
                }
                if (this.getForwardedValues() != null) {
                    data.set("forwardedValues", om.valueToTree(this.getForwardedValues()));
                }
                if (this.getFunctionAssociations() != null) {
                    data.set("functionAssociations", om.valueToTree(this.getFunctionAssociations()));
                }
                if (this.getLambdaFunctionAssociations() != null) {
                    data.set("lambdaFunctionAssociations", om.valueToTree(this.getLambdaFunctionAssociations()));
                }
                if (this.getMaxTtl() != null) {
                    data.set("maxTtl", om.valueToTree(this.getMaxTtl()));
                }
                if (this.getMinTtl() != null) {
                    data.set("minTtl", om.valueToTree(this.getMinTtl()));
                }
                if (this.getOriginRequestPolicyId() != null) {
                    data.set("originRequestPolicyId", om.valueToTree(this.getOriginRequestPolicyId()));
                }
                if (this.getRealtimeLogConfigArn() != null) {
                    data.set("realtimeLogConfigArn", om.valueToTree(this.getRealtimeLogConfigArn()));
                }
                if (this.getSmoothStreaming() != null) {
                    data.set("smoothStreaming", om.valueToTree(this.getSmoothStreaming()));
                }
                if (this.getTrustedKeyGroups() != null) {
                    data.set("trustedKeyGroups", om.valueToTree(this.getTrustedKeyGroups()));
                }
                if (this.getTrustedSigners() != null) {
                    data.set("trustedSigners", om.valueToTree(this.getTrustedSigners()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.DefaultCacheBehaviorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultCacheBehaviorProperty.Jsii$Proxy that = (DefaultCacheBehaviorProperty.Jsii$Proxy) o;

                if (!targetOriginId.equals(that.targetOriginId)) return false;
                if (!viewerProtocolPolicy.equals(that.viewerProtocolPolicy)) return false;
                if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
                if (this.cachedMethods != null ? !this.cachedMethods.equals(that.cachedMethods) : that.cachedMethods != null) return false;
                if (this.cachePolicyId != null ? !this.cachePolicyId.equals(that.cachePolicyId) : that.cachePolicyId != null) return false;
                if (this.compress != null ? !this.compress.equals(that.compress) : that.compress != null) return false;
                if (this.defaultTtl != null ? !this.defaultTtl.equals(that.defaultTtl) : that.defaultTtl != null) return false;
                if (this.fieldLevelEncryptionId != null ? !this.fieldLevelEncryptionId.equals(that.fieldLevelEncryptionId) : that.fieldLevelEncryptionId != null) return false;
                if (this.forwardedValues != null ? !this.forwardedValues.equals(that.forwardedValues) : that.forwardedValues != null) return false;
                if (this.functionAssociations != null ? !this.functionAssociations.equals(that.functionAssociations) : that.functionAssociations != null) return false;
                if (this.lambdaFunctionAssociations != null ? !this.lambdaFunctionAssociations.equals(that.lambdaFunctionAssociations) : that.lambdaFunctionAssociations != null) return false;
                if (this.maxTtl != null ? !this.maxTtl.equals(that.maxTtl) : that.maxTtl != null) return false;
                if (this.minTtl != null ? !this.minTtl.equals(that.minTtl) : that.minTtl != null) return false;
                if (this.originRequestPolicyId != null ? !this.originRequestPolicyId.equals(that.originRequestPolicyId) : that.originRequestPolicyId != null) return false;
                if (this.realtimeLogConfigArn != null ? !this.realtimeLogConfigArn.equals(that.realtimeLogConfigArn) : that.realtimeLogConfigArn != null) return false;
                if (this.smoothStreaming != null ? !this.smoothStreaming.equals(that.smoothStreaming) : that.smoothStreaming != null) return false;
                if (this.trustedKeyGroups != null ? !this.trustedKeyGroups.equals(that.trustedKeyGroups) : that.trustedKeyGroups != null) return false;
                return this.trustedSigners != null ? this.trustedSigners.equals(that.trustedSigners) : that.trustedSigners == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetOriginId.hashCode();
                result = 31 * result + (this.viewerProtocolPolicy.hashCode());
                result = 31 * result + (this.allowedMethods != null ? this.allowedMethods.hashCode() : 0);
                result = 31 * result + (this.cachedMethods != null ? this.cachedMethods.hashCode() : 0);
                result = 31 * result + (this.cachePolicyId != null ? this.cachePolicyId.hashCode() : 0);
                result = 31 * result + (this.compress != null ? this.compress.hashCode() : 0);
                result = 31 * result + (this.defaultTtl != null ? this.defaultTtl.hashCode() : 0);
                result = 31 * result + (this.fieldLevelEncryptionId != null ? this.fieldLevelEncryptionId.hashCode() : 0);
                result = 31 * result + (this.forwardedValues != null ? this.forwardedValues.hashCode() : 0);
                result = 31 * result + (this.functionAssociations != null ? this.functionAssociations.hashCode() : 0);
                result = 31 * result + (this.lambdaFunctionAssociations != null ? this.lambdaFunctionAssociations.hashCode() : 0);
                result = 31 * result + (this.maxTtl != null ? this.maxTtl.hashCode() : 0);
                result = 31 * result + (this.minTtl != null ? this.minTtl.hashCode() : 0);
                result = 31 * result + (this.originRequestPolicyId != null ? this.originRequestPolicyId.hashCode() : 0);
                result = 31 * result + (this.realtimeLogConfigArn != null ? this.realtimeLogConfigArn.hashCode() : 0);
                result = 31 * result + (this.smoothStreaming != null ? this.smoothStreaming.hashCode() : 0);
                result = 31 * result + (this.trustedKeyGroups != null ? this.trustedKeyGroups.hashCode() : 0);
                result = 31 * result + (this.trustedSigners != null ? this.trustedSigners.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.DistributionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DistributionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DistributionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.DistributionConfigProperty.Enabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * `CfnDistribution.DistributionConfigProperty.Aliases`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAliases() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.CacheBehaviors`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCacheBehaviors() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.CNAMEs`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCnamEs() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.Comment`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.CustomErrorResponses`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomErrorResponses() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.CustomOrigin`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomOrigin() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.DefaultCacheBehavior`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultCacheBehavior() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.DefaultRootObject`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultRootObject() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.HttpVersion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpVersion() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.IPV6Enabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Enabled() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.Logging`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.OriginGroups`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOriginGroups() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.Origins`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOrigins() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.PriceClass`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPriceClass() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.Restrictions`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRestrictions() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.S3Origin`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Origin() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.ViewerCertificate`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getViewerCertificate() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.WebACLId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWebAclId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DistributionConfigProperty> {
            private java.lang.Object enabled;
            private java.util.List<java.lang.String> aliases;
            private java.lang.Object cacheBehaviors;
            private java.util.List<java.lang.String> cnamEs;
            private java.lang.String comment;
            private java.lang.Object customErrorResponses;
            private java.lang.Object customOrigin;
            private java.lang.Object defaultCacheBehavior;
            private java.lang.String defaultRootObject;
            private java.lang.String httpVersion;
            private java.lang.Object ipv6Enabled;
            private java.lang.Object logging;
            private java.lang.Object originGroups;
            private java.lang.Object origins;
            private java.lang.String priceClass;
            private java.lang.Object restrictions;
            private java.lang.Object s3Origin;
            private java.lang.Object viewerCertificate;
            private java.lang.String webAclId;

            /**
             * Sets the value of {@link DistributionConfigProperty#getEnabled}
             * @param enabled `CfnDistribution.DistributionConfigProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getEnabled}
             * @param enabled `CfnDistribution.DistributionConfigProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getAliases}
             * @param aliases `CfnDistribution.DistributionConfigProperty.Aliases`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aliases(java.util.List<java.lang.String> aliases) {
                this.aliases = aliases;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCacheBehaviors}
             * @param cacheBehaviors `CfnDistribution.DistributionConfigProperty.CacheBehaviors`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheBehaviors(software.amazon.awscdk.IResolvable cacheBehaviors) {
                this.cacheBehaviors = cacheBehaviors;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCacheBehaviors}
             * @param cacheBehaviors `CfnDistribution.DistributionConfigProperty.CacheBehaviors`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheBehaviors(java.util.List<? extends java.lang.Object> cacheBehaviors) {
                this.cacheBehaviors = cacheBehaviors;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCnamEs}
             * @param cnamEs `CfnDistribution.DistributionConfigProperty.CNAMEs`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cnamEs(java.util.List<java.lang.String> cnamEs) {
                this.cnamEs = cnamEs;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getComment}
             * @param comment `CfnDistribution.DistributionConfigProperty.Comment`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCustomErrorResponses}
             * @param customErrorResponses `CfnDistribution.DistributionConfigProperty.CustomErrorResponses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customErrorResponses(software.amazon.awscdk.IResolvable customErrorResponses) {
                this.customErrorResponses = customErrorResponses;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCustomErrorResponses}
             * @param customErrorResponses `CfnDistribution.DistributionConfigProperty.CustomErrorResponses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customErrorResponses(java.util.List<? extends java.lang.Object> customErrorResponses) {
                this.customErrorResponses = customErrorResponses;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCustomOrigin}
             * @param customOrigin `CfnDistribution.DistributionConfigProperty.CustomOrigin`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customOrigin(software.amazon.awscdk.services.cloudfront.CfnDistribution.LegacyCustomOriginProperty customOrigin) {
                this.customOrigin = customOrigin;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCustomOrigin}
             * @param customOrigin `CfnDistribution.DistributionConfigProperty.CustomOrigin`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customOrigin(software.amazon.awscdk.IResolvable customOrigin) {
                this.customOrigin = customOrigin;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getDefaultCacheBehavior}
             * @param defaultCacheBehavior `CfnDistribution.DistributionConfigProperty.DefaultCacheBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultCacheBehavior(software.amazon.awscdk.services.cloudfront.CfnDistribution.DefaultCacheBehaviorProperty defaultCacheBehavior) {
                this.defaultCacheBehavior = defaultCacheBehavior;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getDefaultCacheBehavior}
             * @param defaultCacheBehavior `CfnDistribution.DistributionConfigProperty.DefaultCacheBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultCacheBehavior(software.amazon.awscdk.IResolvable defaultCacheBehavior) {
                this.defaultCacheBehavior = defaultCacheBehavior;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getDefaultRootObject}
             * @param defaultRootObject `CfnDistribution.DistributionConfigProperty.DefaultRootObject`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultRootObject(java.lang.String defaultRootObject) {
                this.defaultRootObject = defaultRootObject;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getHttpVersion}
             * @param httpVersion `CfnDistribution.DistributionConfigProperty.HttpVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpVersion(java.lang.String httpVersion) {
                this.httpVersion = httpVersion;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getIpv6Enabled}
             * @param ipv6Enabled `CfnDistribution.DistributionConfigProperty.IPV6Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Enabled(java.lang.Boolean ipv6Enabled) {
                this.ipv6Enabled = ipv6Enabled;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getIpv6Enabled}
             * @param ipv6Enabled `CfnDistribution.DistributionConfigProperty.IPV6Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Enabled(software.amazon.awscdk.IResolvable ipv6Enabled) {
                this.ipv6Enabled = ipv6Enabled;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getLogging}
             * @param logging `CfnDistribution.DistributionConfigProperty.Logging`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.services.cloudfront.CfnDistribution.LoggingProperty logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getLogging}
             * @param logging `CfnDistribution.DistributionConfigProperty.Logging`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.IResolvable logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getOriginGroups}
             * @param originGroups `CfnDistribution.DistributionConfigProperty.OriginGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originGroups(software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginGroupsProperty originGroups) {
                this.originGroups = originGroups;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getOriginGroups}
             * @param originGroups `CfnDistribution.DistributionConfigProperty.OriginGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originGroups(software.amazon.awscdk.IResolvable originGroups) {
                this.originGroups = originGroups;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getOrigins}
             * @param origins `CfnDistribution.DistributionConfigProperty.Origins`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder origins(software.amazon.awscdk.IResolvable origins) {
                this.origins = origins;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getOrigins}
             * @param origins `CfnDistribution.DistributionConfigProperty.Origins`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder origins(java.util.List<? extends java.lang.Object> origins) {
                this.origins = origins;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getPriceClass}
             * @param priceClass `CfnDistribution.DistributionConfigProperty.PriceClass`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priceClass(java.lang.String priceClass) {
                this.priceClass = priceClass;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getRestrictions}
             * @param restrictions `CfnDistribution.DistributionConfigProperty.Restrictions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictions(software.amazon.awscdk.services.cloudfront.CfnDistribution.RestrictionsProperty restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getRestrictions}
             * @param restrictions `CfnDistribution.DistributionConfigProperty.Restrictions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictions(software.amazon.awscdk.IResolvable restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getS3Origin}
             * @param s3Origin `CfnDistribution.DistributionConfigProperty.S3Origin`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Origin(software.amazon.awscdk.services.cloudfront.CfnDistribution.LegacyS3OriginProperty s3Origin) {
                this.s3Origin = s3Origin;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getS3Origin}
             * @param s3Origin `CfnDistribution.DistributionConfigProperty.S3Origin`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Origin(software.amazon.awscdk.IResolvable s3Origin) {
                this.s3Origin = s3Origin;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getViewerCertificate}
             * @param viewerCertificate `CfnDistribution.DistributionConfigProperty.ViewerCertificate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewerCertificate(software.amazon.awscdk.services.cloudfront.CfnDistribution.ViewerCertificateProperty viewerCertificate) {
                this.viewerCertificate = viewerCertificate;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getViewerCertificate}
             * @param viewerCertificate `CfnDistribution.DistributionConfigProperty.ViewerCertificate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewerCertificate(software.amazon.awscdk.IResolvable viewerCertificate) {
                this.viewerCertificate = viewerCertificate;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getWebAclId}
             * @param webAclId `CfnDistribution.DistributionConfigProperty.WebACLId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webAclId(java.lang.String webAclId) {
                this.webAclId = webAclId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DistributionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DistributionConfigProperty build() {
                return new Jsii$Proxy(enabled, aliases, cacheBehaviors, cnamEs, comment, customErrorResponses, customOrigin, defaultCacheBehavior, defaultRootObject, httpVersion, ipv6Enabled, logging, originGroups, origins, priceClass, restrictions, s3Origin, viewerCertificate, webAclId);
            }
        }

        /**
         * An implementation for {@link DistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DistributionConfigProperty {
            private final java.lang.Object enabled;
            private final java.util.List<java.lang.String> aliases;
            private final java.lang.Object cacheBehaviors;
            private final java.util.List<java.lang.String> cnamEs;
            private final java.lang.String comment;
            private final java.lang.Object customErrorResponses;
            private final java.lang.Object customOrigin;
            private final java.lang.Object defaultCacheBehavior;
            private final java.lang.String defaultRootObject;
            private final java.lang.String httpVersion;
            private final java.lang.Object ipv6Enabled;
            private final java.lang.Object logging;
            private final java.lang.Object originGroups;
            private final java.lang.Object origins;
            private final java.lang.String priceClass;
            private final java.lang.Object restrictions;
            private final java.lang.Object s3Origin;
            private final java.lang.Object viewerCertificate;
            private final java.lang.String webAclId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.aliases = software.amazon.jsii.Kernel.get(this, "aliases", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cacheBehaviors = software.amazon.jsii.Kernel.get(this, "cacheBehaviors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cnamEs = software.amazon.jsii.Kernel.get(this, "cnamEs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customErrorResponses = software.amazon.jsii.Kernel.get(this, "customErrorResponses", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customOrigin = software.amazon.jsii.Kernel.get(this, "customOrigin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultCacheBehavior = software.amazon.jsii.Kernel.get(this, "defaultCacheBehavior", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultRootObject = software.amazon.jsii.Kernel.get(this, "defaultRootObject", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.httpVersion = software.amazon.jsii.Kernel.get(this, "httpVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ipv6Enabled = software.amazon.jsii.Kernel.get(this, "ipv6Enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logging = software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.originGroups = software.amazon.jsii.Kernel.get(this, "originGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.origins = software.amazon.jsii.Kernel.get(this, "origins", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.priceClass = software.amazon.jsii.Kernel.get(this, "priceClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.restrictions = software.amazon.jsii.Kernel.get(this, "restrictions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3Origin = software.amazon.jsii.Kernel.get(this, "s3Origin", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.viewerCertificate = software.amazon.jsii.Kernel.get(this, "viewerCertificate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.webAclId = software.amazon.jsii.Kernel.get(this, "webAclId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object enabled, final java.util.List<java.lang.String> aliases, final java.lang.Object cacheBehaviors, final java.util.List<java.lang.String> cnamEs, final java.lang.String comment, final java.lang.Object customErrorResponses, final java.lang.Object customOrigin, final java.lang.Object defaultCacheBehavior, final java.lang.String defaultRootObject, final java.lang.String httpVersion, final java.lang.Object ipv6Enabled, final java.lang.Object logging, final java.lang.Object originGroups, final java.lang.Object origins, final java.lang.String priceClass, final java.lang.Object restrictions, final java.lang.Object s3Origin, final java.lang.Object viewerCertificate, final java.lang.String webAclId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.aliases = aliases;
                this.cacheBehaviors = cacheBehaviors;
                this.cnamEs = cnamEs;
                this.comment = comment;
                this.customErrorResponses = customErrorResponses;
                this.customOrigin = customOrigin;
                this.defaultCacheBehavior = defaultCacheBehavior;
                this.defaultRootObject = defaultRootObject;
                this.httpVersion = httpVersion;
                this.ipv6Enabled = ipv6Enabled;
                this.logging = logging;
                this.originGroups = originGroups;
                this.origins = origins;
                this.priceClass = priceClass;
                this.restrictions = restrictions;
                this.s3Origin = s3Origin;
                this.viewerCertificate = viewerCertificate;
                this.webAclId = webAclId;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.util.List<java.lang.String> getAliases() {
                return this.aliases;
            }

            @Override
            public final java.lang.Object getCacheBehaviors() {
                return this.cacheBehaviors;
            }

            @Override
            public final java.util.List<java.lang.String> getCnamEs() {
                return this.cnamEs;
            }

            @Override
            public final java.lang.String getComment() {
                return this.comment;
            }

            @Override
            public final java.lang.Object getCustomErrorResponses() {
                return this.customErrorResponses;
            }

            @Override
            public final java.lang.Object getCustomOrigin() {
                return this.customOrigin;
            }

            @Override
            public final java.lang.Object getDefaultCacheBehavior() {
                return this.defaultCacheBehavior;
            }

            @Override
            public final java.lang.String getDefaultRootObject() {
                return this.defaultRootObject;
            }

            @Override
            public final java.lang.String getHttpVersion() {
                return this.httpVersion;
            }

            @Override
            public final java.lang.Object getIpv6Enabled() {
                return this.ipv6Enabled;
            }

            @Override
            public final java.lang.Object getLogging() {
                return this.logging;
            }

            @Override
            public final java.lang.Object getOriginGroups() {
                return this.originGroups;
            }

            @Override
            public final java.lang.Object getOrigins() {
                return this.origins;
            }

            @Override
            public final java.lang.String getPriceClass() {
                return this.priceClass;
            }

            @Override
            public final java.lang.Object getRestrictions() {
                return this.restrictions;
            }

            @Override
            public final java.lang.Object getS3Origin() {
                return this.s3Origin;
            }

            @Override
            public final java.lang.Object getViewerCertificate() {
                return this.viewerCertificate;
            }

            @Override
            public final java.lang.String getWebAclId() {
                return this.webAclId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getAliases() != null) {
                    data.set("aliases", om.valueToTree(this.getAliases()));
                }
                if (this.getCacheBehaviors() != null) {
                    data.set("cacheBehaviors", om.valueToTree(this.getCacheBehaviors()));
                }
                if (this.getCnamEs() != null) {
                    data.set("cnamEs", om.valueToTree(this.getCnamEs()));
                }
                if (this.getComment() != null) {
                    data.set("comment", om.valueToTree(this.getComment()));
                }
                if (this.getCustomErrorResponses() != null) {
                    data.set("customErrorResponses", om.valueToTree(this.getCustomErrorResponses()));
                }
                if (this.getCustomOrigin() != null) {
                    data.set("customOrigin", om.valueToTree(this.getCustomOrigin()));
                }
                if (this.getDefaultCacheBehavior() != null) {
                    data.set("defaultCacheBehavior", om.valueToTree(this.getDefaultCacheBehavior()));
                }
                if (this.getDefaultRootObject() != null) {
                    data.set("defaultRootObject", om.valueToTree(this.getDefaultRootObject()));
                }
                if (this.getHttpVersion() != null) {
                    data.set("httpVersion", om.valueToTree(this.getHttpVersion()));
                }
                if (this.getIpv6Enabled() != null) {
                    data.set("ipv6Enabled", om.valueToTree(this.getIpv6Enabled()));
                }
                if (this.getLogging() != null) {
                    data.set("logging", om.valueToTree(this.getLogging()));
                }
                if (this.getOriginGroups() != null) {
                    data.set("originGroups", om.valueToTree(this.getOriginGroups()));
                }
                if (this.getOrigins() != null) {
                    data.set("origins", om.valueToTree(this.getOrigins()));
                }
                if (this.getPriceClass() != null) {
                    data.set("priceClass", om.valueToTree(this.getPriceClass()));
                }
                if (this.getRestrictions() != null) {
                    data.set("restrictions", om.valueToTree(this.getRestrictions()));
                }
                if (this.getS3Origin() != null) {
                    data.set("s3Origin", om.valueToTree(this.getS3Origin()));
                }
                if (this.getViewerCertificate() != null) {
                    data.set("viewerCertificate", om.valueToTree(this.getViewerCertificate()));
                }
                if (this.getWebAclId() != null) {
                    data.set("webAclId", om.valueToTree(this.getWebAclId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.DistributionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DistributionConfigProperty.Jsii$Proxy that = (DistributionConfigProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.aliases != null ? !this.aliases.equals(that.aliases) : that.aliases != null) return false;
                if (this.cacheBehaviors != null ? !this.cacheBehaviors.equals(that.cacheBehaviors) : that.cacheBehaviors != null) return false;
                if (this.cnamEs != null ? !this.cnamEs.equals(that.cnamEs) : that.cnamEs != null) return false;
                if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
                if (this.customErrorResponses != null ? !this.customErrorResponses.equals(that.customErrorResponses) : that.customErrorResponses != null) return false;
                if (this.customOrigin != null ? !this.customOrigin.equals(that.customOrigin) : that.customOrigin != null) return false;
                if (this.defaultCacheBehavior != null ? !this.defaultCacheBehavior.equals(that.defaultCacheBehavior) : that.defaultCacheBehavior != null) return false;
                if (this.defaultRootObject != null ? !this.defaultRootObject.equals(that.defaultRootObject) : that.defaultRootObject != null) return false;
                if (this.httpVersion != null ? !this.httpVersion.equals(that.httpVersion) : that.httpVersion != null) return false;
                if (this.ipv6Enabled != null ? !this.ipv6Enabled.equals(that.ipv6Enabled) : that.ipv6Enabled != null) return false;
                if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
                if (this.originGroups != null ? !this.originGroups.equals(that.originGroups) : that.originGroups != null) return false;
                if (this.origins != null ? !this.origins.equals(that.origins) : that.origins != null) return false;
                if (this.priceClass != null ? !this.priceClass.equals(that.priceClass) : that.priceClass != null) return false;
                if (this.restrictions != null ? !this.restrictions.equals(that.restrictions) : that.restrictions != null) return false;
                if (this.s3Origin != null ? !this.s3Origin.equals(that.s3Origin) : that.s3Origin != null) return false;
                if (this.viewerCertificate != null ? !this.viewerCertificate.equals(that.viewerCertificate) : that.viewerCertificate != null) return false;
                return this.webAclId != null ? this.webAclId.equals(that.webAclId) : that.webAclId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.aliases != null ? this.aliases.hashCode() : 0);
                result = 31 * result + (this.cacheBehaviors != null ? this.cacheBehaviors.hashCode() : 0);
                result = 31 * result + (this.cnamEs != null ? this.cnamEs.hashCode() : 0);
                result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
                result = 31 * result + (this.customErrorResponses != null ? this.customErrorResponses.hashCode() : 0);
                result = 31 * result + (this.customOrigin != null ? this.customOrigin.hashCode() : 0);
                result = 31 * result + (this.defaultCacheBehavior != null ? this.defaultCacheBehavior.hashCode() : 0);
                result = 31 * result + (this.defaultRootObject != null ? this.defaultRootObject.hashCode() : 0);
                result = 31 * result + (this.httpVersion != null ? this.httpVersion.hashCode() : 0);
                result = 31 * result + (this.ipv6Enabled != null ? this.ipv6Enabled.hashCode() : 0);
                result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
                result = 31 * result + (this.originGroups != null ? this.originGroups.hashCode() : 0);
                result = 31 * result + (this.origins != null ? this.origins.hashCode() : 0);
                result = 31 * result + (this.priceClass != null ? this.priceClass.hashCode() : 0);
                result = 31 * result + (this.restrictions != null ? this.restrictions.hashCode() : 0);
                result = 31 * result + (this.s3Origin != null ? this.s3Origin.hashCode() : 0);
                result = 31 * result + (this.viewerCertificate != null ? this.viewerCertificate.hashCode() : 0);
                result = 31 * result + (this.webAclId != null ? this.webAclId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.ForwardedValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(ForwardedValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ForwardedValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.ForwardedValuesProperty.QueryString`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getQueryString();

        /**
         * `CfnDistribution.ForwardedValuesProperty.Cookies`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCookies() {
            return null;
        }

        /**
         * `CfnDistribution.ForwardedValuesProperty.Headers`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeaders() {
            return null;
        }

        /**
         * `CfnDistribution.ForwardedValuesProperty.QueryStringCacheKeys`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQueryStringCacheKeys() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ForwardedValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ForwardedValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ForwardedValuesProperty> {
            private java.lang.Object queryString;
            private java.lang.Object cookies;
            private java.util.List<java.lang.String> headers;
            private java.util.List<java.lang.String> queryStringCacheKeys;

            /**
             * Sets the value of {@link ForwardedValuesProperty#getQueryString}
             * @param queryString `CfnDistribution.ForwardedValuesProperty.QueryString`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(java.lang.Boolean queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getQueryString}
             * @param queryString `CfnDistribution.ForwardedValuesProperty.QueryString`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(software.amazon.awscdk.IResolvable queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getCookies}
             * @param cookies `CfnDistribution.ForwardedValuesProperty.Cookies`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookies(software.amazon.awscdk.services.cloudfront.CfnDistribution.CookiesProperty cookies) {
                this.cookies = cookies;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getCookies}
             * @param cookies `CfnDistribution.ForwardedValuesProperty.Cookies`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookies(software.amazon.awscdk.IResolvable cookies) {
                this.cookies = cookies;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getHeaders}
             * @param headers `CfnDistribution.ForwardedValuesProperty.Headers`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(java.util.List<java.lang.String> headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getQueryStringCacheKeys}
             * @param queryStringCacheKeys `CfnDistribution.ForwardedValuesProperty.QueryStringCacheKeys`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringCacheKeys(java.util.List<java.lang.String> queryStringCacheKeys) {
                this.queryStringCacheKeys = queryStringCacheKeys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ForwardedValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ForwardedValuesProperty build() {
                return new Jsii$Proxy(queryString, cookies, headers, queryStringCacheKeys);
            }
        }

        /**
         * An implementation for {@link ForwardedValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ForwardedValuesProperty {
            private final java.lang.Object queryString;
            private final java.lang.Object cookies;
            private final java.util.List<java.lang.String> headers;
            private final java.util.List<java.lang.String> queryStringCacheKeys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queryString = software.amazon.jsii.Kernel.get(this, "queryString", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.cookies = software.amazon.jsii.Kernel.get(this, "cookies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.queryStringCacheKeys = software.amazon.jsii.Kernel.get(this, "queryStringCacheKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object queryString, final java.lang.Object cookies, final java.util.List<java.lang.String> headers, final java.util.List<java.lang.String> queryStringCacheKeys) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queryString = java.util.Objects.requireNonNull(queryString, "queryString is required");
                this.cookies = cookies;
                this.headers = headers;
                this.queryStringCacheKeys = queryStringCacheKeys;
            }

            @Override
            public final java.lang.Object getQueryString() {
                return this.queryString;
            }

            @Override
            public final java.lang.Object getCookies() {
                return this.cookies;
            }

            @Override
            public final java.util.List<java.lang.String> getHeaders() {
                return this.headers;
            }

            @Override
            public final java.util.List<java.lang.String> getQueryStringCacheKeys() {
                return this.queryStringCacheKeys;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queryString", om.valueToTree(this.getQueryString()));
                if (this.getCookies() != null) {
                    data.set("cookies", om.valueToTree(this.getCookies()));
                }
                if (this.getHeaders() != null) {
                    data.set("headers", om.valueToTree(this.getHeaders()));
                }
                if (this.getQueryStringCacheKeys() != null) {
                    data.set("queryStringCacheKeys", om.valueToTree(this.getQueryStringCacheKeys()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.ForwardedValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ForwardedValuesProperty.Jsii$Proxy that = (ForwardedValuesProperty.Jsii$Proxy) o;

                if (!queryString.equals(that.queryString)) return false;
                if (this.cookies != null ? !this.cookies.equals(that.cookies) : that.cookies != null) return false;
                if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
                return this.queryStringCacheKeys != null ? this.queryStringCacheKeys.equals(that.queryStringCacheKeys) : that.queryStringCacheKeys == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queryString.hashCode();
                result = 31 * result + (this.cookies != null ? this.cookies.hashCode() : 0);
                result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
                result = 31 * result + (this.queryStringCacheKeys != null ? this.queryStringCacheKeys.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.FunctionAssociationProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionAssociationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionAssociationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.FunctionAssociationProperty.EventType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventType() {
            return null;
        }

        /**
         * `CfnDistribution.FunctionAssociationProperty.FunctionARN`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFunctionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionAssociationProperty> {
            private java.lang.String eventType;
            private java.lang.String functionArn;

            /**
             * Sets the value of {@link FunctionAssociationProperty#getEventType}
             * @param eventType `CfnDistribution.FunctionAssociationProperty.EventType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventType(java.lang.String eventType) {
                this.eventType = eventType;
                return this;
            }

            /**
             * Sets the value of {@link FunctionAssociationProperty#getFunctionArn}
             * @param functionArn `CfnDistribution.FunctionAssociationProperty.FunctionARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder functionArn(java.lang.String functionArn) {
                this.functionArn = functionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionAssociationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionAssociationProperty build() {
                return new Jsii$Proxy(eventType, functionArn);
            }
        }

        /**
         * An implementation for {@link FunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionAssociationProperty {
            private final java.lang.String eventType;
            private final java.lang.String functionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventType = software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.functionArn = software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String eventType, final java.lang.String functionArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventType = eventType;
                this.functionArn = functionArn;
            }

            @Override
            public final java.lang.String getEventType() {
                return this.eventType;
            }

            @Override
            public final java.lang.String getFunctionArn() {
                return this.functionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEventType() != null) {
                    data.set("eventType", om.valueToTree(this.getEventType()));
                }
                if (this.getFunctionArn() != null) {
                    data.set("functionArn", om.valueToTree(this.getFunctionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.FunctionAssociationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionAssociationProperty.Jsii$Proxy that = (FunctionAssociationProperty.Jsii$Proxy) o;

                if (this.eventType != null ? !this.eventType.equals(that.eventType) : that.eventType != null) return false;
                return this.functionArn != null ? this.functionArn.equals(that.functionArn) : that.functionArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventType != null ? this.eventType.hashCode() : 0;
                result = 31 * result + (this.functionArn != null ? this.functionArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.GeoRestrictionProperty")
    @software.amazon.jsii.Jsii.Proxy(GeoRestrictionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeoRestrictionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.GeoRestrictionProperty.RestrictionType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRestrictionType();

        /**
         * `CfnDistribution.GeoRestrictionProperty.Locations`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeoRestrictionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeoRestrictionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeoRestrictionProperty> {
            private java.lang.String restrictionType;
            private java.util.List<java.lang.String> locations;

            /**
             * Sets the value of {@link GeoRestrictionProperty#getRestrictionType}
             * @param restrictionType `CfnDistribution.GeoRestrictionProperty.RestrictionType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictionType(java.lang.String restrictionType) {
                this.restrictionType = restrictionType;
                return this;
            }

            /**
             * Sets the value of {@link GeoRestrictionProperty#getLocations}
             * @param locations `CfnDistribution.GeoRestrictionProperty.Locations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locations(java.util.List<java.lang.String> locations) {
                this.locations = locations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeoRestrictionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeoRestrictionProperty build() {
                return new Jsii$Proxy(restrictionType, locations);
            }
        }

        /**
         * An implementation for {@link GeoRestrictionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeoRestrictionProperty {
            private final java.lang.String restrictionType;
            private final java.util.List<java.lang.String> locations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.restrictionType = software.amazon.jsii.Kernel.get(this, "restrictionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.locations = software.amazon.jsii.Kernel.get(this, "locations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String restrictionType, final java.util.List<java.lang.String> locations) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.restrictionType = java.util.Objects.requireNonNull(restrictionType, "restrictionType is required");
                this.locations = locations;
            }

            @Override
            public final java.lang.String getRestrictionType() {
                return this.restrictionType;
            }

            @Override
            public final java.util.List<java.lang.String> getLocations() {
                return this.locations;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("restrictionType", om.valueToTree(this.getRestrictionType()));
                if (this.getLocations() != null) {
                    data.set("locations", om.valueToTree(this.getLocations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.GeoRestrictionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeoRestrictionProperty.Jsii$Proxy that = (GeoRestrictionProperty.Jsii$Proxy) o;

                if (!restrictionType.equals(that.restrictionType)) return false;
                return this.locations != null ? this.locations.equals(that.locations) : that.locations == null;
            }

            @Override
            public final int hashCode() {
                int result = this.restrictionType.hashCode();
                result = 31 * result + (this.locations != null ? this.locations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.LambdaFunctionAssociationProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaFunctionAssociationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaFunctionAssociationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.LambdaFunctionAssociationProperty.EventType`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventType() {
            return null;
        }

        /**
         * `CfnDistribution.LambdaFunctionAssociationProperty.IncludeBody`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeBody() {
            return null;
        }

        /**
         * `CfnDistribution.LambdaFunctionAssociationProperty.LambdaFunctionARN`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambdaFunctionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaFunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaFunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaFunctionAssociationProperty> {
            private java.lang.String eventType;
            private java.lang.Object includeBody;
            private java.lang.String lambdaFunctionArn;

            /**
             * Sets the value of {@link LambdaFunctionAssociationProperty#getEventType}
             * @param eventType `CfnDistribution.LambdaFunctionAssociationProperty.EventType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventType(java.lang.String eventType) {
                this.eventType = eventType;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionAssociationProperty#getIncludeBody}
             * @param includeBody `CfnDistribution.LambdaFunctionAssociationProperty.IncludeBody`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeBody(java.lang.Boolean includeBody) {
                this.includeBody = includeBody;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionAssociationProperty#getIncludeBody}
             * @param includeBody `CfnDistribution.LambdaFunctionAssociationProperty.IncludeBody`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeBody(software.amazon.awscdk.IResolvable includeBody) {
                this.includeBody = includeBody;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionAssociationProperty#getLambdaFunctionArn}
             * @param lambdaFunctionArn `CfnDistribution.LambdaFunctionAssociationProperty.LambdaFunctionARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionArn(java.lang.String lambdaFunctionArn) {
                this.lambdaFunctionArn = lambdaFunctionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaFunctionAssociationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaFunctionAssociationProperty build() {
                return new Jsii$Proxy(eventType, includeBody, lambdaFunctionArn);
            }
        }

        /**
         * An implementation for {@link LambdaFunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaFunctionAssociationProperty {
            private final java.lang.String eventType;
            private final java.lang.Object includeBody;
            private final java.lang.String lambdaFunctionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventType = software.amazon.jsii.Kernel.get(this, "eventType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeBody = software.amazon.jsii.Kernel.get(this, "includeBody", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaFunctionArn = software.amazon.jsii.Kernel.get(this, "lambdaFunctionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String eventType, final java.lang.Object includeBody, final java.lang.String lambdaFunctionArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventType = eventType;
                this.includeBody = includeBody;
                this.lambdaFunctionArn = lambdaFunctionArn;
            }

            @Override
            public final java.lang.String getEventType() {
                return this.eventType;
            }

            @Override
            public final java.lang.Object getIncludeBody() {
                return this.includeBody;
            }

            @Override
            public final java.lang.String getLambdaFunctionArn() {
                return this.lambdaFunctionArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEventType() != null) {
                    data.set("eventType", om.valueToTree(this.getEventType()));
                }
                if (this.getIncludeBody() != null) {
                    data.set("includeBody", om.valueToTree(this.getIncludeBody()));
                }
                if (this.getLambdaFunctionArn() != null) {
                    data.set("lambdaFunctionArn", om.valueToTree(this.getLambdaFunctionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.LambdaFunctionAssociationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaFunctionAssociationProperty.Jsii$Proxy that = (LambdaFunctionAssociationProperty.Jsii$Proxy) o;

                if (this.eventType != null ? !this.eventType.equals(that.eventType) : that.eventType != null) return false;
                if (this.includeBody != null ? !this.includeBody.equals(that.includeBody) : that.includeBody != null) return false;
                return this.lambdaFunctionArn != null ? this.lambdaFunctionArn.equals(that.lambdaFunctionArn) : that.lambdaFunctionArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.eventType != null ? this.eventType.hashCode() : 0;
                result = 31 * result + (this.includeBody != null ? this.includeBody.hashCode() : 0);
                result = 31 * result + (this.lambdaFunctionArn != null ? this.lambdaFunctionArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.LegacyCustomOriginProperty")
    @software.amazon.jsii.Jsii.Proxy(LegacyCustomOriginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LegacyCustomOriginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.LegacyCustomOriginProperty.DNSName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDnsName();

        /**
         * `CfnDistribution.LegacyCustomOriginProperty.OriginProtocolPolicy`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOriginProtocolPolicy();

        /**
         * `CfnDistribution.LegacyCustomOriginProperty.OriginSSLProtocols`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getOriginSslProtocols();

        /**
         * `CfnDistribution.LegacyCustomOriginProperty.HTTPPort`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHttpPort() {
            return null;
        }

        /**
         * `CfnDistribution.LegacyCustomOriginProperty.HTTPSPort`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHttpsPort() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LegacyCustomOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LegacyCustomOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LegacyCustomOriginProperty> {
            private java.lang.String dnsName;
            private java.lang.String originProtocolPolicy;
            private java.util.List<java.lang.String> originSslProtocols;
            private java.lang.Number httpPort;
            private java.lang.Number httpsPort;

            /**
             * Sets the value of {@link LegacyCustomOriginProperty#getDnsName}
             * @param dnsName `CfnDistribution.LegacyCustomOriginProperty.DNSName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsName(java.lang.String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            /**
             * Sets the value of {@link LegacyCustomOriginProperty#getOriginProtocolPolicy}
             * @param originProtocolPolicy `CfnDistribution.LegacyCustomOriginProperty.OriginProtocolPolicy`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originProtocolPolicy(java.lang.String originProtocolPolicy) {
                this.originProtocolPolicy = originProtocolPolicy;
                return this;
            }

            /**
             * Sets the value of {@link LegacyCustomOriginProperty#getOriginSslProtocols}
             * @param originSslProtocols `CfnDistribution.LegacyCustomOriginProperty.OriginSSLProtocols`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originSslProtocols(java.util.List<java.lang.String> originSslProtocols) {
                this.originSslProtocols = originSslProtocols;
                return this;
            }

            /**
             * Sets the value of {@link LegacyCustomOriginProperty#getHttpPort}
             * @param httpPort `CfnDistribution.LegacyCustomOriginProperty.HTTPPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpPort(java.lang.Number httpPort) {
                this.httpPort = httpPort;
                return this;
            }

            /**
             * Sets the value of {@link LegacyCustomOriginProperty#getHttpsPort}
             * @param httpsPort `CfnDistribution.LegacyCustomOriginProperty.HTTPSPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpsPort(java.lang.Number httpsPort) {
                this.httpsPort = httpsPort;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LegacyCustomOriginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LegacyCustomOriginProperty build() {
                return new Jsii$Proxy(dnsName, originProtocolPolicy, originSslProtocols, httpPort, httpsPort);
            }
        }

        /**
         * An implementation for {@link LegacyCustomOriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LegacyCustomOriginProperty {
            private final java.lang.String dnsName;
            private final java.lang.String originProtocolPolicy;
            private final java.util.List<java.lang.String> originSslProtocols;
            private final java.lang.Number httpPort;
            private final java.lang.Number httpsPort;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dnsName = software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originProtocolPolicy = software.amazon.jsii.Kernel.get(this, "originProtocolPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originSslProtocols = software.amazon.jsii.Kernel.get(this, "originSslProtocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.httpPort = software.amazon.jsii.Kernel.get(this, "httpPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.httpsPort = software.amazon.jsii.Kernel.get(this, "httpsPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String dnsName, final java.lang.String originProtocolPolicy, final java.util.List<java.lang.String> originSslProtocols, final java.lang.Number httpPort, final java.lang.Number httpsPort) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dnsName = java.util.Objects.requireNonNull(dnsName, "dnsName is required");
                this.originProtocolPolicy = java.util.Objects.requireNonNull(originProtocolPolicy, "originProtocolPolicy is required");
                this.originSslProtocols = java.util.Objects.requireNonNull(originSslProtocols, "originSslProtocols is required");
                this.httpPort = httpPort;
                this.httpsPort = httpsPort;
            }

            @Override
            public final java.lang.String getDnsName() {
                return this.dnsName;
            }

            @Override
            public final java.lang.String getOriginProtocolPolicy() {
                return this.originProtocolPolicy;
            }

            @Override
            public final java.util.List<java.lang.String> getOriginSslProtocols() {
                return this.originSslProtocols;
            }

            @Override
            public final java.lang.Number getHttpPort() {
                return this.httpPort;
            }

            @Override
            public final java.lang.Number getHttpsPort() {
                return this.httpsPort;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dnsName", om.valueToTree(this.getDnsName()));
                data.set("originProtocolPolicy", om.valueToTree(this.getOriginProtocolPolicy()));
                data.set("originSslProtocols", om.valueToTree(this.getOriginSslProtocols()));
                if (this.getHttpPort() != null) {
                    data.set("httpPort", om.valueToTree(this.getHttpPort()));
                }
                if (this.getHttpsPort() != null) {
                    data.set("httpsPort", om.valueToTree(this.getHttpsPort()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.LegacyCustomOriginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LegacyCustomOriginProperty.Jsii$Proxy that = (LegacyCustomOriginProperty.Jsii$Proxy) o;

                if (!dnsName.equals(that.dnsName)) return false;
                if (!originProtocolPolicy.equals(that.originProtocolPolicy)) return false;
                if (!originSslProtocols.equals(that.originSslProtocols)) return false;
                if (this.httpPort != null ? !this.httpPort.equals(that.httpPort) : that.httpPort != null) return false;
                return this.httpsPort != null ? this.httpsPort.equals(that.httpsPort) : that.httpsPort == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dnsName.hashCode();
                result = 31 * result + (this.originProtocolPolicy.hashCode());
                result = 31 * result + (this.originSslProtocols.hashCode());
                result = 31 * result + (this.httpPort != null ? this.httpPort.hashCode() : 0);
                result = 31 * result + (this.httpsPort != null ? this.httpsPort.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.LegacyS3OriginProperty")
    @software.amazon.jsii.Jsii.Proxy(LegacyS3OriginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LegacyS3OriginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.LegacyS3OriginProperty.DNSName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDnsName();

        /**
         * `CfnDistribution.LegacyS3OriginProperty.OriginAccessIdentity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginAccessIdentity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LegacyS3OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LegacyS3OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LegacyS3OriginProperty> {
            private java.lang.String dnsName;
            private java.lang.String originAccessIdentity;

            /**
             * Sets the value of {@link LegacyS3OriginProperty#getDnsName}
             * @param dnsName `CfnDistribution.LegacyS3OriginProperty.DNSName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsName(java.lang.String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            /**
             * Sets the value of {@link LegacyS3OriginProperty#getOriginAccessIdentity}
             * @param originAccessIdentity `CfnDistribution.LegacyS3OriginProperty.OriginAccessIdentity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originAccessIdentity(java.lang.String originAccessIdentity) {
                this.originAccessIdentity = originAccessIdentity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LegacyS3OriginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LegacyS3OriginProperty build() {
                return new Jsii$Proxy(dnsName, originAccessIdentity);
            }
        }

        /**
         * An implementation for {@link LegacyS3OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LegacyS3OriginProperty {
            private final java.lang.String dnsName;
            private final java.lang.String originAccessIdentity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dnsName = software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originAccessIdentity = software.amazon.jsii.Kernel.get(this, "originAccessIdentity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String dnsName, final java.lang.String originAccessIdentity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dnsName = java.util.Objects.requireNonNull(dnsName, "dnsName is required");
                this.originAccessIdentity = originAccessIdentity;
            }

            @Override
            public final java.lang.String getDnsName() {
                return this.dnsName;
            }

            @Override
            public final java.lang.String getOriginAccessIdentity() {
                return this.originAccessIdentity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dnsName", om.valueToTree(this.getDnsName()));
                if (this.getOriginAccessIdentity() != null) {
                    data.set("originAccessIdentity", om.valueToTree(this.getOriginAccessIdentity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.LegacyS3OriginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LegacyS3OriginProperty.Jsii$Proxy that = (LegacyS3OriginProperty.Jsii$Proxy) o;

                if (!dnsName.equals(that.dnsName)) return false;
                return this.originAccessIdentity != null ? this.originAccessIdentity.equals(that.originAccessIdentity) : that.originAccessIdentity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dnsName.hashCode();
                result = 31 * result + (this.originAccessIdentity != null ? this.originAccessIdentity.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.LoggingProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.LoggingProperty.Bucket`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * `CfnDistribution.LoggingProperty.IncludeCookies`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeCookies() {
            return null;
        }

        /**
         * `CfnDistribution.LoggingProperty.Prefix`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingProperty> {
            private java.lang.String bucket;
            private java.lang.Object includeCookies;
            private java.lang.String prefix;

            /**
             * Sets the value of {@link LoggingProperty#getBucket}
             * @param bucket `CfnDistribution.LoggingProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getIncludeCookies}
             * @param includeCookies `CfnDistribution.LoggingProperty.IncludeCookies`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeCookies(java.lang.Boolean includeCookies) {
                this.includeCookies = includeCookies;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getIncludeCookies}
             * @param includeCookies `CfnDistribution.LoggingProperty.IncludeCookies`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeCookies(software.amazon.awscdk.IResolvable includeCookies) {
                this.includeCookies = includeCookies;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getPrefix}
             * @param prefix `CfnDistribution.LoggingProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingProperty build() {
                return new Jsii$Proxy(bucket, includeCookies, prefix);
            }
        }

        /**
         * An implementation for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingProperty {
            private final java.lang.String bucket;
            private final java.lang.Object includeCookies;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeCookies = software.amazon.jsii.Kernel.get(this, "includeCookies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prefix = software.amazon.jsii.Kernel.get(this, "prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String bucket, final java.lang.Object includeCookies, final java.lang.String prefix) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
                this.includeCookies = includeCookies;
                this.prefix = prefix;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.Object getIncludeCookies() {
                return this.includeCookies;
            }

            @Override
            public final java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getIncludeCookies() != null) {
                    data.set("includeCookies", om.valueToTree(this.getIncludeCookies()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.LoggingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingProperty.Jsii$Proxy that = (LoggingProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (this.includeCookies != null ? !this.includeCookies.equals(that.includeCookies) : that.includeCookies != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.includeCookies != null ? this.includeCookies.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginCustomHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginCustomHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginCustomHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginCustomHeaderProperty.HeaderName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderName();

        /**
         * `CfnDistribution.OriginCustomHeaderProperty.HeaderValue`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderValue();

        /**
         * @return a {@link Builder} of {@link OriginCustomHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginCustomHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginCustomHeaderProperty> {
            private java.lang.String headerName;
            private java.lang.String headerValue;

            /**
             * Sets the value of {@link OriginCustomHeaderProperty#getHeaderName}
             * @param headerName `CfnDistribution.OriginCustomHeaderProperty.HeaderName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerName(java.lang.String headerName) {
                this.headerName = headerName;
                return this;
            }

            /**
             * Sets the value of {@link OriginCustomHeaderProperty#getHeaderValue}
             * @param headerValue `CfnDistribution.OriginCustomHeaderProperty.HeaderValue`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerValue(java.lang.String headerValue) {
                this.headerValue = headerValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginCustomHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginCustomHeaderProperty build() {
                return new Jsii$Proxy(headerName, headerValue);
            }
        }

        /**
         * An implementation for {@link OriginCustomHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginCustomHeaderProperty {
            private final java.lang.String headerName;
            private final java.lang.String headerValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headerName = software.amazon.jsii.Kernel.get(this, "headerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.headerValue = software.amazon.jsii.Kernel.get(this, "headerValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String headerName, final java.lang.String headerValue) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headerName = java.util.Objects.requireNonNull(headerName, "headerName is required");
                this.headerValue = java.util.Objects.requireNonNull(headerValue, "headerValue is required");
            }

            @Override
            public final java.lang.String getHeaderName() {
                return this.headerName;
            }

            @Override
            public final java.lang.String getHeaderValue() {
                return this.headerValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("headerName", om.valueToTree(this.getHeaderName()));
                data.set("headerValue", om.valueToTree(this.getHeaderValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginCustomHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginCustomHeaderProperty.Jsii$Proxy that = (OriginCustomHeaderProperty.Jsii$Proxy) o;

                if (!headerName.equals(that.headerName)) return false;
                return this.headerValue.equals(that.headerValue);
            }

            @Override
            public final int hashCode() {
                int result = this.headerName.hashCode();
                result = 31 * result + (this.headerValue.hashCode());
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupFailoverCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupFailoverCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupFailoverCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginGroupFailoverCriteriaProperty.StatusCodes`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatusCodes();

        /**
         * @return a {@link Builder} of {@link OriginGroupFailoverCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupFailoverCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupFailoverCriteriaProperty> {
            private java.lang.Object statusCodes;

            /**
             * Sets the value of {@link OriginGroupFailoverCriteriaProperty#getStatusCodes}
             * @param statusCodes `CfnDistribution.OriginGroupFailoverCriteriaProperty.StatusCodes`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCodes(software.amazon.awscdk.services.cloudfront.CfnDistribution.StatusCodesProperty statusCodes) {
                this.statusCodes = statusCodes;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupFailoverCriteriaProperty#getStatusCodes}
             * @param statusCodes `CfnDistribution.OriginGroupFailoverCriteriaProperty.StatusCodes`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCodes(software.amazon.awscdk.IResolvable statusCodes) {
                this.statusCodes = statusCodes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupFailoverCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupFailoverCriteriaProperty build() {
                return new Jsii$Proxy(statusCodes);
            }
        }

        /**
         * An implementation for {@link OriginGroupFailoverCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupFailoverCriteriaProperty {
            private final java.lang.Object statusCodes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCodes = software.amazon.jsii.Kernel.get(this, "statusCodes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object statusCodes) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCodes = java.util.Objects.requireNonNull(statusCodes, "statusCodes is required");
            }

            @Override
            public final java.lang.Object getStatusCodes() {
                return this.statusCodes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCodes", om.valueToTree(this.getStatusCodes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupFailoverCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupFailoverCriteriaProperty.Jsii$Proxy that = (OriginGroupFailoverCriteriaProperty.Jsii$Proxy) o;

                return this.statusCodes.equals(that.statusCodes);
            }

            @Override
            public final int hashCode() {
                int result = this.statusCodes.hashCode();
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupMemberProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupMemberProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupMemberProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginGroupMemberProperty.OriginId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOriginId();

        /**
         * @return a {@link Builder} of {@link OriginGroupMemberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupMemberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupMemberProperty> {
            private java.lang.String originId;

            /**
             * Sets the value of {@link OriginGroupMemberProperty#getOriginId}
             * @param originId `CfnDistribution.OriginGroupMemberProperty.OriginId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originId(java.lang.String originId) {
                this.originId = originId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupMemberProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupMemberProperty build() {
                return new Jsii$Proxy(originId);
            }
        }

        /**
         * An implementation for {@link OriginGroupMemberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupMemberProperty {
            private final java.lang.String originId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.originId = software.amazon.jsii.Kernel.get(this, "originId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String originId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.originId = java.util.Objects.requireNonNull(originId, "originId is required");
            }

            @Override
            public final java.lang.String getOriginId() {
                return this.originId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("originId", om.valueToTree(this.getOriginId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupMemberProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupMemberProperty.Jsii$Proxy that = (OriginGroupMemberProperty.Jsii$Proxy) o;

                return this.originId.equals(that.originId);
            }

            @Override
            public final int hashCode() {
                int result = this.originId.hashCode();
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupMembersProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupMembersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupMembersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginGroupMembersProperty.Items`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getItems();

        /**
         * `CfnDistribution.OriginGroupMembersProperty.Quantity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getQuantity();

        /**
         * @return a {@link Builder} of {@link OriginGroupMembersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupMembersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupMembersProperty> {
            private java.lang.Object items;
            private java.lang.Number quantity;

            /**
             * Sets the value of {@link OriginGroupMembersProperty#getItems}
             * @param items `CfnDistribution.OriginGroupMembersProperty.Items`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupMembersProperty#getItems}
             * @param items `CfnDistribution.OriginGroupMembersProperty.Items`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<? extends java.lang.Object> items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupMembersProperty#getQuantity}
             * @param quantity `CfnDistribution.OriginGroupMembersProperty.Quantity`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quantity(java.lang.Number quantity) {
                this.quantity = quantity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupMembersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupMembersProperty build() {
                return new Jsii$Proxy(items, quantity);
            }
        }

        /**
         * An implementation for {@link OriginGroupMembersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupMembersProperty {
            private final java.lang.Object items;
            private final java.lang.Number quantity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.quantity = software.amazon.jsii.Kernel.get(this, "quantity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object items, final java.lang.Number quantity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.items = java.util.Objects.requireNonNull(items, "items is required");
                this.quantity = java.util.Objects.requireNonNull(quantity, "quantity is required");
            }

            @Override
            public final java.lang.Object getItems() {
                return this.items;
            }

            @Override
            public final java.lang.Number getQuantity() {
                return this.quantity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("items", om.valueToTree(this.getItems()));
                data.set("quantity", om.valueToTree(this.getQuantity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupMembersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupMembersProperty.Jsii$Proxy that = (OriginGroupMembersProperty.Jsii$Proxy) o;

                if (!items.equals(that.items)) return false;
                return this.quantity.equals(that.quantity);
            }

            @Override
            public final int hashCode() {
                int result = this.items.hashCode();
                result = 31 * result + (this.quantity.hashCode());
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginGroupProperty.FailoverCriteria`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFailoverCriteria();

        /**
         * `CfnDistribution.OriginGroupProperty.Id`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * `CfnDistribution.OriginGroupProperty.Members`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMembers();

        /**
         * @return a {@link Builder} of {@link OriginGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupProperty> {
            private java.lang.Object failoverCriteria;
            private java.lang.String id;
            private java.lang.Object members;

            /**
             * Sets the value of {@link OriginGroupProperty#getFailoverCriteria}
             * @param failoverCriteria `CfnDistribution.OriginGroupProperty.FailoverCriteria`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverCriteria(software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginGroupFailoverCriteriaProperty failoverCriteria) {
                this.failoverCriteria = failoverCriteria;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupProperty#getFailoverCriteria}
             * @param failoverCriteria `CfnDistribution.OriginGroupProperty.FailoverCriteria`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverCriteria(software.amazon.awscdk.IResolvable failoverCriteria) {
                this.failoverCriteria = failoverCriteria;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupProperty#getId}
             * @param id `CfnDistribution.OriginGroupProperty.Id`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupProperty#getMembers}
             * @param members `CfnDistribution.OriginGroupProperty.Members`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder members(software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginGroupMembersProperty members) {
                this.members = members;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupProperty#getMembers}
             * @param members `CfnDistribution.OriginGroupProperty.Members`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder members(software.amazon.awscdk.IResolvable members) {
                this.members = members;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupProperty build() {
                return new Jsii$Proxy(failoverCriteria, id, members);
            }
        }

        /**
         * An implementation for {@link OriginGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupProperty {
            private final java.lang.Object failoverCriteria;
            private final java.lang.String id;
            private final java.lang.Object members;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failoverCriteria = software.amazon.jsii.Kernel.get(this, "failoverCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.members = software.amazon.jsii.Kernel.get(this, "members", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object failoverCriteria, final java.lang.String id, final java.lang.Object members) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failoverCriteria = java.util.Objects.requireNonNull(failoverCriteria, "failoverCriteria is required");
                this.id = java.util.Objects.requireNonNull(id, "id is required");
                this.members = java.util.Objects.requireNonNull(members, "members is required");
            }

            @Override
            public final java.lang.Object getFailoverCriteria() {
                return this.failoverCriteria;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.Object getMembers() {
                return this.members;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("failoverCriteria", om.valueToTree(this.getFailoverCriteria()));
                data.set("id", om.valueToTree(this.getId()));
                data.set("members", om.valueToTree(this.getMembers()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupProperty.Jsii$Proxy that = (OriginGroupProperty.Jsii$Proxy) o;

                if (!failoverCriteria.equals(that.failoverCriteria)) return false;
                if (!id.equals(that.id)) return false;
                return this.members.equals(that.members);
            }

            @Override
            public final int hashCode() {
                int result = this.failoverCriteria.hashCode();
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.members.hashCode());
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupsProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginGroupsProperty.Quantity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getQuantity();

        /**
         * `CfnDistribution.OriginGroupsProperty.Items`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getItems() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OriginGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupsProperty> {
            private java.lang.Number quantity;
            private java.lang.Object items;

            /**
             * Sets the value of {@link OriginGroupsProperty#getQuantity}
             * @param quantity `CfnDistribution.OriginGroupsProperty.Quantity`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quantity(java.lang.Number quantity) {
                this.quantity = quantity;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupsProperty#getItems}
             * @param items `CfnDistribution.OriginGroupsProperty.Items`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupsProperty#getItems}
             * @param items `CfnDistribution.OriginGroupsProperty.Items`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<? extends java.lang.Object> items) {
                this.items = items;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupsProperty build() {
                return new Jsii$Proxy(quantity, items);
            }
        }

        /**
         * An implementation for {@link OriginGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupsProperty {
            private final java.lang.Number quantity;
            private final java.lang.Object items;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.quantity = software.amazon.jsii.Kernel.get(this, "quantity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Number quantity, final java.lang.Object items) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.quantity = java.util.Objects.requireNonNull(quantity, "quantity is required");
                this.items = items;
            }

            @Override
            public final java.lang.Number getQuantity() {
                return this.quantity;
            }

            @Override
            public final java.lang.Object getItems() {
                return this.items;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("quantity", om.valueToTree(this.getQuantity()));
                if (this.getItems() != null) {
                    data.set("items", om.valueToTree(this.getItems()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginGroupsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupsProperty.Jsii$Proxy that = (OriginGroupsProperty.Jsii$Proxy) o;

                if (!quantity.equals(that.quantity)) return false;
                return this.items != null ? this.items.equals(that.items) : that.items == null;
            }

            @Override
            public final int hashCode() {
                int result = this.quantity.hashCode();
                result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginProperty.DomainName`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

        /**
         * `CfnDistribution.OriginProperty.Id`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * `CfnDistribution.OriginProperty.ConnectionAttempts`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConnectionAttempts() {
            return null;
        }

        /**
         * `CfnDistribution.OriginProperty.ConnectionTimeout`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConnectionTimeout() {
            return null;
        }

        /**
         * `CfnDistribution.OriginProperty.CustomOriginConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomOriginConfig() {
            return null;
        }

        /**
         * `CfnDistribution.OriginProperty.OriginCustomHeaders`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOriginCustomHeaders() {
            return null;
        }

        /**
         * `CfnDistribution.OriginProperty.OriginPath`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginPath() {
            return null;
        }

        /**
         * `CfnDistribution.OriginProperty.OriginShield`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOriginShield() {
            return null;
        }

        /**
         * `CfnDistribution.OriginProperty.S3OriginConfig`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3OriginConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginProperty> {
            private java.lang.String domainName;
            private java.lang.String id;
            private java.lang.Number connectionAttempts;
            private java.lang.Number connectionTimeout;
            private java.lang.Object customOriginConfig;
            private java.lang.Object originCustomHeaders;
            private java.lang.String originPath;
            private java.lang.Object originShield;
            private java.lang.Object s3OriginConfig;

            /**
             * Sets the value of {@link OriginProperty#getDomainName}
             * @param domainName `CfnDistribution.OriginProperty.DomainName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getId}
             * @param id `CfnDistribution.OriginProperty.Id`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getConnectionAttempts}
             * @param connectionAttempts `CfnDistribution.OriginProperty.ConnectionAttempts`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionAttempts(java.lang.Number connectionAttempts) {
                this.connectionAttempts = connectionAttempts;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getConnectionTimeout}
             * @param connectionTimeout `CfnDistribution.OriginProperty.ConnectionTimeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionTimeout(java.lang.Number connectionTimeout) {
                this.connectionTimeout = connectionTimeout;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getCustomOriginConfig}
             * @param customOriginConfig `CfnDistribution.OriginProperty.CustomOriginConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customOriginConfig(software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomOriginConfigProperty customOriginConfig) {
                this.customOriginConfig = customOriginConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getCustomOriginConfig}
             * @param customOriginConfig `CfnDistribution.OriginProperty.CustomOriginConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customOriginConfig(software.amazon.awscdk.IResolvable customOriginConfig) {
                this.customOriginConfig = customOriginConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginCustomHeaders}
             * @param originCustomHeaders `CfnDistribution.OriginProperty.OriginCustomHeaders`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originCustomHeaders(software.amazon.awscdk.IResolvable originCustomHeaders) {
                this.originCustomHeaders = originCustomHeaders;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginCustomHeaders}
             * @param originCustomHeaders `CfnDistribution.OriginProperty.OriginCustomHeaders`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originCustomHeaders(java.util.List<? extends java.lang.Object> originCustomHeaders) {
                this.originCustomHeaders = originCustomHeaders;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginPath}
             * @param originPath `CfnDistribution.OriginProperty.OriginPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originPath(java.lang.String originPath) {
                this.originPath = originPath;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginShield}
             * @param originShield `CfnDistribution.OriginProperty.OriginShield`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originShield(software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginShieldProperty originShield) {
                this.originShield = originShield;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginShield}
             * @param originShield `CfnDistribution.OriginProperty.OriginShield`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originShield(software.amazon.awscdk.IResolvable originShield) {
                this.originShield = originShield;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getS3OriginConfig}
             * @param s3OriginConfig `CfnDistribution.OriginProperty.S3OriginConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OriginConfig(software.amazon.awscdk.services.cloudfront.CfnDistribution.S3OriginConfigProperty s3OriginConfig) {
                this.s3OriginConfig = s3OriginConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getS3OriginConfig}
             * @param s3OriginConfig `CfnDistribution.OriginProperty.S3OriginConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OriginConfig(software.amazon.awscdk.IResolvable s3OriginConfig) {
                this.s3OriginConfig = s3OriginConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginProperty build() {
                return new Jsii$Proxy(domainName, id, connectionAttempts, connectionTimeout, customOriginConfig, originCustomHeaders, originPath, originShield, s3OriginConfig);
            }
        }

        /**
         * An implementation for {@link OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginProperty {
            private final java.lang.String domainName;
            private final java.lang.String id;
            private final java.lang.Number connectionAttempts;
            private final java.lang.Number connectionTimeout;
            private final java.lang.Object customOriginConfig;
            private final java.lang.Object originCustomHeaders;
            private final java.lang.String originPath;
            private final java.lang.Object originShield;
            private final java.lang.Object s3OriginConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.id = software.amazon.jsii.Kernel.get(this, "id", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectionAttempts = software.amazon.jsii.Kernel.get(this, "connectionAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.connectionTimeout = software.amazon.jsii.Kernel.get(this, "connectionTimeout", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.customOriginConfig = software.amazon.jsii.Kernel.get(this, "customOriginConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.originCustomHeaders = software.amazon.jsii.Kernel.get(this, "originCustomHeaders", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.originPath = software.amazon.jsii.Kernel.get(this, "originPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.originShield = software.amazon.jsii.Kernel.get(this, "originShield", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3OriginConfig = software.amazon.jsii.Kernel.get(this, "s3OriginConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String domainName, final java.lang.String id, final java.lang.Number connectionAttempts, final java.lang.Number connectionTimeout, final java.lang.Object customOriginConfig, final java.lang.Object originCustomHeaders, final java.lang.String originPath, final java.lang.Object originShield, final java.lang.Object s3OriginConfig) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
                this.id = java.util.Objects.requireNonNull(id, "id is required");
                this.connectionAttempts = connectionAttempts;
                this.connectionTimeout = connectionTimeout;
                this.customOriginConfig = customOriginConfig;
                this.originCustomHeaders = originCustomHeaders;
                this.originPath = originPath;
                this.originShield = originShield;
                this.s3OriginConfig = s3OriginConfig;
            }

            @Override
            public final java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public final java.lang.String getId() {
                return this.id;
            }

            @Override
            public final java.lang.Number getConnectionAttempts() {
                return this.connectionAttempts;
            }

            @Override
            public final java.lang.Number getConnectionTimeout() {
                return this.connectionTimeout;
            }

            @Override
            public final java.lang.Object getCustomOriginConfig() {
                return this.customOriginConfig;
            }

            @Override
            public final java.lang.Object getOriginCustomHeaders() {
                return this.originCustomHeaders;
            }

            @Override
            public final java.lang.String getOriginPath() {
                return this.originPath;
            }

            @Override
            public final java.lang.Object getOriginShield() {
                return this.originShield;
            }

            @Override
            public final java.lang.Object getS3OriginConfig() {
                return this.s3OriginConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domainName", om.valueToTree(this.getDomainName()));
                data.set("id", om.valueToTree(this.getId()));
                if (this.getConnectionAttempts() != null) {
                    data.set("connectionAttempts", om.valueToTree(this.getConnectionAttempts()));
                }
                if (this.getConnectionTimeout() != null) {
                    data.set("connectionTimeout", om.valueToTree(this.getConnectionTimeout()));
                }
                if (this.getCustomOriginConfig() != null) {
                    data.set("customOriginConfig", om.valueToTree(this.getCustomOriginConfig()));
                }
                if (this.getOriginCustomHeaders() != null) {
                    data.set("originCustomHeaders", om.valueToTree(this.getOriginCustomHeaders()));
                }
                if (this.getOriginPath() != null) {
                    data.set("originPath", om.valueToTree(this.getOriginPath()));
                }
                if (this.getOriginShield() != null) {
                    data.set("originShield", om.valueToTree(this.getOriginShield()));
                }
                if (this.getS3OriginConfig() != null) {
                    data.set("s3OriginConfig", om.valueToTree(this.getS3OriginConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginProperty.Jsii$Proxy that = (OriginProperty.Jsii$Proxy) o;

                if (!domainName.equals(that.domainName)) return false;
                if (!id.equals(that.id)) return false;
                if (this.connectionAttempts != null ? !this.connectionAttempts.equals(that.connectionAttempts) : that.connectionAttempts != null) return false;
                if (this.connectionTimeout != null ? !this.connectionTimeout.equals(that.connectionTimeout) : that.connectionTimeout != null) return false;
                if (this.customOriginConfig != null ? !this.customOriginConfig.equals(that.customOriginConfig) : that.customOriginConfig != null) return false;
                if (this.originCustomHeaders != null ? !this.originCustomHeaders.equals(that.originCustomHeaders) : that.originCustomHeaders != null) return false;
                if (this.originPath != null ? !this.originPath.equals(that.originPath) : that.originPath != null) return false;
                if (this.originShield != null ? !this.originShield.equals(that.originShield) : that.originShield != null) return false;
                return this.s3OriginConfig != null ? this.s3OriginConfig.equals(that.s3OriginConfig) : that.s3OriginConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.domainName.hashCode();
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.connectionAttempts != null ? this.connectionAttempts.hashCode() : 0);
                result = 31 * result + (this.connectionTimeout != null ? this.connectionTimeout.hashCode() : 0);
                result = 31 * result + (this.customOriginConfig != null ? this.customOriginConfig.hashCode() : 0);
                result = 31 * result + (this.originCustomHeaders != null ? this.originCustomHeaders.hashCode() : 0);
                result = 31 * result + (this.originPath != null ? this.originPath.hashCode() : 0);
                result = 31 * result + (this.originShield != null ? this.originShield.hashCode() : 0);
                result = 31 * result + (this.s3OriginConfig != null ? this.s3OriginConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginShieldProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginShieldProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginShieldProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginShieldProperty.Enabled`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * `CfnDistribution.OriginShieldProperty.OriginShieldRegion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginShieldRegion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OriginShieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginShieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginShieldProperty> {
            private java.lang.Object enabled;
            private java.lang.String originShieldRegion;

            /**
             * Sets the value of {@link OriginShieldProperty#getEnabled}
             * @param enabled `CfnDistribution.OriginShieldProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link OriginShieldProperty#getEnabled}
             * @param enabled `CfnDistribution.OriginShieldProperty.Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link OriginShieldProperty#getOriginShieldRegion}
             * @param originShieldRegion `CfnDistribution.OriginShieldProperty.OriginShieldRegion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originShieldRegion(java.lang.String originShieldRegion) {
                this.originShieldRegion = originShieldRegion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginShieldProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginShieldProperty build() {
                return new Jsii$Proxy(enabled, originShieldRegion);
            }
        }

        /**
         * An implementation for {@link OriginShieldProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginShieldProperty {
            private final java.lang.Object enabled;
            private final java.lang.String originShieldRegion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.originShieldRegion = software.amazon.jsii.Kernel.get(this, "originShieldRegion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object enabled, final java.lang.String originShieldRegion) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = enabled;
                this.originShieldRegion = originShieldRegion;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getOriginShieldRegion() {
                return this.originShieldRegion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getOriginShieldRegion() != null) {
                    data.set("originShieldRegion", om.valueToTree(this.getOriginShieldRegion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.OriginShieldProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginShieldProperty.Jsii$Proxy that = (OriginShieldProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.originShieldRegion != null ? this.originShieldRegion.equals(that.originShieldRegion) : that.originShieldRegion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.originShieldRegion != null ? this.originShieldRegion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.RestrictionsProperty")
    @software.amazon.jsii.Jsii.Proxy(RestrictionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RestrictionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.RestrictionsProperty.GeoRestriction`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getGeoRestriction();

        /**
         * @return a {@link Builder} of {@link RestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RestrictionsProperty> {
            private java.lang.Object geoRestriction;

            /**
             * Sets the value of {@link RestrictionsProperty#getGeoRestriction}
             * @param geoRestriction `CfnDistribution.RestrictionsProperty.GeoRestriction`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoRestriction(software.amazon.awscdk.services.cloudfront.CfnDistribution.GeoRestrictionProperty geoRestriction) {
                this.geoRestriction = geoRestriction;
                return this;
            }

            /**
             * Sets the value of {@link RestrictionsProperty#getGeoRestriction}
             * @param geoRestriction `CfnDistribution.RestrictionsProperty.GeoRestriction`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoRestriction(software.amazon.awscdk.IResolvable geoRestriction) {
                this.geoRestriction = geoRestriction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RestrictionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RestrictionsProperty build() {
                return new Jsii$Proxy(geoRestriction);
            }
        }

        /**
         * An implementation for {@link RestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestrictionsProperty {
            private final java.lang.Object geoRestriction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.geoRestriction = software.amazon.jsii.Kernel.get(this, "geoRestriction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object geoRestriction) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.geoRestriction = java.util.Objects.requireNonNull(geoRestriction, "geoRestriction is required");
            }

            @Override
            public final java.lang.Object getGeoRestriction() {
                return this.geoRestriction;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("geoRestriction", om.valueToTree(this.getGeoRestriction()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.RestrictionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RestrictionsProperty.Jsii$Proxy that = (RestrictionsProperty.Jsii$Proxy) o;

                return this.geoRestriction.equals(that.geoRestriction);
            }

            @Override
            public final int hashCode() {
                int result = this.geoRestriction.hashCode();
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.S3OriginConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OriginConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OriginConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.S3OriginConfigProperty.OriginAccessIdentity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginAccessIdentity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3OriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OriginConfigProperty> {
            private java.lang.String originAccessIdentity;

            /**
             * Sets the value of {@link S3OriginConfigProperty#getOriginAccessIdentity}
             * @param originAccessIdentity `CfnDistribution.S3OriginConfigProperty.OriginAccessIdentity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originAccessIdentity(java.lang.String originAccessIdentity) {
                this.originAccessIdentity = originAccessIdentity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OriginConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OriginConfigProperty build() {
                return new Jsii$Proxy(originAccessIdentity);
            }
        }

        /**
         * An implementation for {@link S3OriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OriginConfigProperty {
            private final java.lang.String originAccessIdentity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.originAccessIdentity = software.amazon.jsii.Kernel.get(this, "originAccessIdentity", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String originAccessIdentity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.originAccessIdentity = originAccessIdentity;
            }

            @Override
            public final java.lang.String getOriginAccessIdentity() {
                return this.originAccessIdentity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOriginAccessIdentity() != null) {
                    data.set("originAccessIdentity", om.valueToTree(this.getOriginAccessIdentity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.S3OriginConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OriginConfigProperty.Jsii$Proxy that = (S3OriginConfigProperty.Jsii$Proxy) o;

                return this.originAccessIdentity != null ? this.originAccessIdentity.equals(that.originAccessIdentity) : that.originAccessIdentity == null;
            }

            @Override
            public final int hashCode() {
                int result = this.originAccessIdentity != null ? this.originAccessIdentity.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.StatusCodesProperty")
    @software.amazon.jsii.Jsii.Proxy(StatusCodesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatusCodesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.StatusCodesProperty.Items`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getItems();

        /**
         * `CfnDistribution.StatusCodesProperty.Quantity`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getQuantity();

        /**
         * @return a {@link Builder} of {@link StatusCodesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatusCodesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatusCodesProperty> {
            private java.lang.Object items;
            private java.lang.Number quantity;

            /**
             * Sets the value of {@link StatusCodesProperty#getItems}
             * @param items `CfnDistribution.StatusCodesProperty.Items`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link StatusCodesProperty#getItems}
             * @param items `CfnDistribution.StatusCodesProperty.Items`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<? extends java.lang.Number> items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link StatusCodesProperty#getQuantity}
             * @param quantity `CfnDistribution.StatusCodesProperty.Quantity`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quantity(java.lang.Number quantity) {
                this.quantity = quantity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatusCodesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatusCodesProperty build() {
                return new Jsii$Proxy(items, quantity);
            }
        }

        /**
         * An implementation for {@link StatusCodesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatusCodesProperty {
            private final java.lang.Object items;
            private final java.lang.Number quantity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.quantity = software.amazon.jsii.Kernel.get(this, "quantity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.Object items, final java.lang.Number quantity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.items = java.util.Objects.requireNonNull(items, "items is required");
                this.quantity = java.util.Objects.requireNonNull(quantity, "quantity is required");
            }

            @Override
            public final java.lang.Object getItems() {
                return this.items;
            }

            @Override
            public final java.lang.Number getQuantity() {
                return this.quantity;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("items", om.valueToTree(this.getItems()));
                data.set("quantity", om.valueToTree(this.getQuantity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.StatusCodesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatusCodesProperty.Jsii$Proxy that = (StatusCodesProperty.Jsii$Proxy) o;

                if (!items.equals(that.items)) return false;
                return this.quantity.equals(that.quantity);
            }

            @Override
            public final int hashCode() {
                int result = this.items.hashCode();
                result = 31 * result + (this.quantity.hashCode());
                return result;
            }
        }
    }
    /**
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.CfnDistribution.ViewerCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(ViewerCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ViewerCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.ViewerCertificateProperty.AcmCertificateArn`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAcmCertificateArn() {
            return null;
        }

        /**
         * `CfnDistribution.ViewerCertificateProperty.CloudFrontDefaultCertificate`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudFrontDefaultCertificate() {
            return null;
        }

        /**
         * `CfnDistribution.ViewerCertificateProperty.IamCertificateId`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIamCertificateId() {
            return null;
        }

        /**
         * `CfnDistribution.ViewerCertificateProperty.MinimumProtocolVersion`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMinimumProtocolVersion() {
            return null;
        }

        /**
         * `CfnDistribution.ViewerCertificateProperty.SslSupportMethod`.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslSupportMethod() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ViewerCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ViewerCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ViewerCertificateProperty> {
            private java.lang.String acmCertificateArn;
            private java.lang.Object cloudFrontDefaultCertificate;
            private java.lang.String iamCertificateId;
            private java.lang.String minimumProtocolVersion;
            private java.lang.String sslSupportMethod;

            /**
             * Sets the value of {@link ViewerCertificateProperty#getAcmCertificateArn}
             * @param acmCertificateArn `CfnDistribution.ViewerCertificateProperty.AcmCertificateArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acmCertificateArn(java.lang.String acmCertificateArn) {
                this.acmCertificateArn = acmCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getCloudFrontDefaultCertificate}
             * @param cloudFrontDefaultCertificate `CfnDistribution.ViewerCertificateProperty.CloudFrontDefaultCertificate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFrontDefaultCertificate(java.lang.Boolean cloudFrontDefaultCertificate) {
                this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getCloudFrontDefaultCertificate}
             * @param cloudFrontDefaultCertificate `CfnDistribution.ViewerCertificateProperty.CloudFrontDefaultCertificate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFrontDefaultCertificate(software.amazon.awscdk.IResolvable cloudFrontDefaultCertificate) {
                this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getIamCertificateId}
             * @param iamCertificateId `CfnDistribution.ViewerCertificateProperty.IamCertificateId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamCertificateId(java.lang.String iamCertificateId) {
                this.iamCertificateId = iamCertificateId;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getMinimumProtocolVersion}
             * @param minimumProtocolVersion `CfnDistribution.ViewerCertificateProperty.MinimumProtocolVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumProtocolVersion(java.lang.String minimumProtocolVersion) {
                this.minimumProtocolVersion = minimumProtocolVersion;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getSslSupportMethod}
             * @param sslSupportMethod `CfnDistribution.ViewerCertificateProperty.SslSupportMethod`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslSupportMethod(java.lang.String sslSupportMethod) {
                this.sslSupportMethod = sslSupportMethod;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ViewerCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ViewerCertificateProperty build() {
                return new Jsii$Proxy(acmCertificateArn, cloudFrontDefaultCertificate, iamCertificateId, minimumProtocolVersion, sslSupportMethod);
            }
        }

        /**
         * An implementation for {@link ViewerCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ViewerCertificateProperty {
            private final java.lang.String acmCertificateArn;
            private final java.lang.Object cloudFrontDefaultCertificate;
            private final java.lang.String iamCertificateId;
            private final java.lang.String minimumProtocolVersion;
            private final java.lang.String sslSupportMethod;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acmCertificateArn = software.amazon.jsii.Kernel.get(this, "acmCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cloudFrontDefaultCertificate = software.amazon.jsii.Kernel.get(this, "cloudFrontDefaultCertificate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iamCertificateId = software.amazon.jsii.Kernel.get(this, "iamCertificateId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minimumProtocolVersion = software.amazon.jsii.Kernel.get(this, "minimumProtocolVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sslSupportMethod = software.amazon.jsii.Kernel.get(this, "sslSupportMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final java.lang.String acmCertificateArn, final java.lang.Object cloudFrontDefaultCertificate, final java.lang.String iamCertificateId, final java.lang.String minimumProtocolVersion, final java.lang.String sslSupportMethod) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acmCertificateArn = acmCertificateArn;
                this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
                this.iamCertificateId = iamCertificateId;
                this.minimumProtocolVersion = minimumProtocolVersion;
                this.sslSupportMethod = sslSupportMethod;
            }

            @Override
            public final java.lang.String getAcmCertificateArn() {
                return this.acmCertificateArn;
            }

            @Override
            public final java.lang.Object getCloudFrontDefaultCertificate() {
                return this.cloudFrontDefaultCertificate;
            }

            @Override
            public final java.lang.String getIamCertificateId() {
                return this.iamCertificateId;
            }

            @Override
            public final java.lang.String getMinimumProtocolVersion() {
                return this.minimumProtocolVersion;
            }

            @Override
            public final java.lang.String getSslSupportMethod() {
                return this.sslSupportMethod;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcmCertificateArn() != null) {
                    data.set("acmCertificateArn", om.valueToTree(this.getAcmCertificateArn()));
                }
                if (this.getCloudFrontDefaultCertificate() != null) {
                    data.set("cloudFrontDefaultCertificate", om.valueToTree(this.getCloudFrontDefaultCertificate()));
                }
                if (this.getIamCertificateId() != null) {
                    data.set("iamCertificateId", om.valueToTree(this.getIamCertificateId()));
                }
                if (this.getMinimumProtocolVersion() != null) {
                    data.set("minimumProtocolVersion", om.valueToTree(this.getMinimumProtocolVersion()));
                }
                if (this.getSslSupportMethod() != null) {
                    data.set("sslSupportMethod", om.valueToTree(this.getSslSupportMethod()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.CfnDistribution.ViewerCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ViewerCertificateProperty.Jsii$Proxy that = (ViewerCertificateProperty.Jsii$Proxy) o;

                if (this.acmCertificateArn != null ? !this.acmCertificateArn.equals(that.acmCertificateArn) : that.acmCertificateArn != null) return false;
                if (this.cloudFrontDefaultCertificate != null ? !this.cloudFrontDefaultCertificate.equals(that.cloudFrontDefaultCertificate) : that.cloudFrontDefaultCertificate != null) return false;
                if (this.iamCertificateId != null ? !this.iamCertificateId.equals(that.iamCertificateId) : that.iamCertificateId != null) return false;
                if (this.minimumProtocolVersion != null ? !this.minimumProtocolVersion.equals(that.minimumProtocolVersion) : that.minimumProtocolVersion != null) return false;
                return this.sslSupportMethod != null ? this.sslSupportMethod.equals(that.sslSupportMethod) : that.sslSupportMethod == null;
            }

            @Override
            public final int hashCode() {
                int result = this.acmCertificateArn != null ? this.acmCertificateArn.hashCode() : 0;
                result = 31 * result + (this.cloudFrontDefaultCertificate != null ? this.cloudFrontDefaultCertificate.hashCode() : 0);
                result = 31 * result + (this.iamCertificateId != null ? this.iamCertificateId.hashCode() : 0);
                result = 31 * result + (this.minimumProtocolVersion != null ? this.minimumProtocolVersion.hashCode() : 0);
                result = 31 * result + (this.sslSupportMethod != null ? this.sslSupportMethod.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnDistribution}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnDistribution> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnDistributionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnDistributionProps.Builder();
        }

        /**
         * `AWS::CloudFront::Distribution.DistributionConfig`.
         * <p>
         * @return {@code this}
         * @param distributionConfig `AWS::CloudFront::Distribution.DistributionConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionConfig(final software.amazon.awscdk.services.cloudfront.CfnDistribution.DistributionConfigProperty distributionConfig) {
            this.props.distributionConfig(distributionConfig);
            return this;
        }
        /**
         * `AWS::CloudFront::Distribution.DistributionConfig`.
         * <p>
         * @return {@code this}
         * @param distributionConfig `AWS::CloudFront::Distribution.DistributionConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionConfig(final software.amazon.awscdk.IResolvable distributionConfig) {
            this.props.distributionConfig(distributionConfig);
            return this;
        }

        /**
         * `AWS::CloudFront::Distribution.Tags`.
         * <p>
         * @return {@code this}
         * @param tags `AWS::CloudFront::Distribution.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnDistribution}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnDistribution build() {
            return new software.amazon.awscdk.services.cloudfront.CfnDistribution(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
