package software.amazon.awscdk.services.cloudfront.experimental;

/**
 * (experimental) A Lambda@Edge function.
 * <p>
 * Convenience resource for requesting a Lambda function in the 'us-east-1' region for use with Lambda&#64;Edge.
 * Implements several restrictions enforced by Lambda&#64;Edge.
 * <p>
 * Note that this construct requires that the 'us-east-1' region has been bootstrapped.
 * See https://docs.aws.amazon.com/cdk/latest/guide/bootstrapping.html or 'cdk bootstrap --help' for options.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:04.055Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.experimental.EdgeFunction")
public class EdgeFunction extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.lambda.IVersion {

    protected EdgeFunction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EdgeFunction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public EdgeFunction(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.experimental.EdgeFunctionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Defines an alias for this version.
     * <p>
     * @param aliasName This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Alias addAlias(final @org.jetbrains.annotations.NotNull java.lang.String aliasName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.AliasOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addAlias", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Alias.class), new Object[] { java.util.Objects.requireNonNull(aliasName, "aliasName is required"), options });
    }

    /**
     * (experimental) Defines an alias for this version.
     * <p>
     * @param aliasName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Alias addAlias(final @org.jetbrains.annotations.NotNull java.lang.String aliasName) {
        return software.amazon.jsii.Kernel.call(this, "addAlias", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.Alias.class), new Object[] { java.util.Objects.requireNonNull(aliasName, "aliasName is required") });
    }

    /**
     * (experimental) Adds an event source to this function.
     * <p>
     * @param source This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IEventSource source) {
        software.amazon.jsii.Kernel.call(this, "addEventSource", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(source, "source is required") });
    }

    /**
     * (experimental) Adds an event source that maps to this AWS Lambda function.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventSourceMapping addEventSourceMapping(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventSourceMappingOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addEventSourceMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.EventSourceMapping.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Adds a permission to the Lambda resource policy.
     * <p>
     * @param id This parameter is required.
     * @param permission This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addPermission(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.Permission permission) {
        software.amazon.jsii.Kernel.call(this, "addPermission", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(permission, "permission is required") });
    }

    /**
     * (experimental) Adds a statement to the IAM role assumed by the instance.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * (experimental) Configures options for asynchronous invocation.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void configureAsyncInvoke(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.EventInvokeConfigOptions options) {
        software.amazon.jsii.Kernel.call(this, "configureAsyncInvoke", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Grant the given identity permissions to invoke this Lambda.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantInvoke(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return software.amazon.jsii.Kernel.call(this, "grantInvoke", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * (experimental) Return the given named metric for this Lambda Return the given named metric for this Function.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * (experimental) Return the given named metric for this Lambda Return the given named metric for this Function.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * (experimental) Metric for the Duration of this Lambda How long execution of this Lambda takes.
     * <p>
     * Average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDuration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) Metric for the Duration of this Lambda How long execution of this Lambda takes.
     * <p>
     * Average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricDuration() {
        return software.amazon.jsii.Kernel.call(this, "metricDuration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) How many invocations of this Lambda fail.
     * <p>
     * Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricErrors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) How many invocations of this Lambda fail.
     * <p>
     * Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricErrors() {
        return software.amazon.jsii.Kernel.call(this, "metricErrors", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) Metric for the number of invocations of this Lambda How often this Lambda is invoked.
     * <p>
     * Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricInvocations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricInvocations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) Metric for the number of invocations of this Lambda How often this Lambda is invoked.
     * <p>
     * Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricInvocations() {
        return software.amazon.jsii.Kernel.call(this, "metricInvocations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
     * <p>
     * Sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThrottles(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricThrottles", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) Metric for the number of throttled invocations of this Lambda How often this Lambda is throttled.
     * <p>
     * Sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThrottles() {
        return software.amazon.jsii.Kernel.call(this, "metricThrottles", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) Not supported.
     * <p>
     * Connections are only applicable to VPC-enabled functions.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * (experimental) Convenience method to make `EdgeFunction` conform to the same interface as `Function`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion getCurrentVersion() {
        return software.amazon.jsii.Kernel.get(this, "currentVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IVersion.class));
    }

    /**
     * (experimental) The ARN of the version for Lambda@Edge.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getEdgeArn() {
        return software.amazon.jsii.Kernel.get(this, "edgeArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The ARN fo the function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn() {
        return software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getFunctionName() {
        return software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * (experimental) Whether or not this Lambda function was bound to a VPC.
     * <p>
     * If this is is <code>false</code>, trying to access the <code>connections</code> object will fail.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getIsBoundToVpc() {
        return software.amazon.jsii.Kernel.get(this, "isBoundToVpc", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * (experimental) The underlying AWS Lambda function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getLambda() {
        return software.amazon.jsii.Kernel.get(this, "lambda", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
    }

    /**
     * (experimental) The `$LATEST` version of this function.
     * <p>
     * Note that this is reference to a non-specific AWS Lambda version, which
     * means the function this version refers to can return different results in
     * different invocations.
     * <p>
     * To obtain a reference to an explicit version which references the current
     * function configuration, use <code>lambdaFunction.currentVersion</code> instead.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IVersion getLatestVersion() {
        return software.amazon.jsii.Kernel.get(this, "latestVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IVersion.class));
    }

    /**
     * (experimental) The construct node where permissions are attached.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.constructs.Node getPermissionsNode() {
        return software.amazon.jsii.Kernel.get(this, "permissionsNode", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
    }

    /**
     * (experimental) The most recently deployed version of this function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getVersion() {
        return software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The IAM role associated with this function.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.cloudfront.experimental.EdgeFunction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.experimental.EdgeFunction> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.experimental.EdgeFunctionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.experimental.EdgeFunctionProps.Builder();
        }

        /**
         * (experimental) The maximum age of a request that Lambda sends to a function for processing.
         * <p>
         * Minimum: 60 seconds
         * Maximum: 6 hours
         * <p>
         * Default: Duration.hours(6)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        /**
         * (experimental) The destination for failed invocations.
         * <p>
         * Default: - no destination
         * <p>
         * @return {@code this}
         * @param onFailure The destination for failed invocations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder onFailure(final software.amazon.awscdk.services.lambda.IDestination onFailure) {
            this.props.onFailure(onFailure);
            return this;
        }

        /**
         * (experimental) The destination for successful invocations.
         * <p>
         * Default: - no destination
         * <p>
         * @return {@code this}
         * @param onSuccess The destination for successful invocations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder onSuccess(final software.amazon.awscdk.services.lambda.IDestination onSuccess) {
            this.props.onSuccess(onSuccess);
            return this;
        }

        /**
         * (experimental) The maximum number of times to retry when the function returns an error.
         * <p>
         * Minimum: 0
         * Maximum: 2
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the function returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * (experimental) Whether to allow the Lambda to send all network traffic.
         * <p>
         * If set to false, you must individually add traffic rules to allow the
         * Lambda to connect to network targets.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param allowAllOutbound Whether to allow the Lambda to send all network traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowAllOutbound(final java.lang.Boolean allowAllOutbound) {
            this.props.allowAllOutbound(allowAllOutbound);
            return this;
        }

        /**
         * (experimental) Lambda Functions in a public subnet can NOT access the internet.
         * <p>
         * Use this property to acknowledge this limitation and still place the function in a public subnet.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @see https://stackoverflow.com/questions/52992085/why-cant-an-aws-lambda-function-inside-a-public-subnet-in-a-vpc-connect-to-the/52994841#52994841
         * @param allowPublicSubnet Lambda Functions in a public subnet can NOT access the internet. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder allowPublicSubnet(final java.lang.Boolean allowPublicSubnet) {
            this.props.allowPublicSubnet(allowPublicSubnet);
            return this;
        }

        /**
         * (experimental) Code signing config associated with this function.
         * <p>
         * Default: - Not Sign the Code
         * <p>
         * @return {@code this}
         * @param codeSigningConfig Code signing config associated with this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder codeSigningConfig(final software.amazon.awscdk.services.lambda.ICodeSigningConfig codeSigningConfig) {
            this.props.codeSigningConfig(codeSigningConfig);
            return this;
        }

        /**
         * (experimental) Options for the `lambda.Version` resource automatically created by the `fn.currentVersion` method.
         * <p>
         * Default: - default options as described in `VersionOptions`
         * <p>
         * @return {@code this}
         * @param currentVersionOptions Options for the `lambda.Version` resource automatically created by the `fn.currentVersion` method. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder currentVersionOptions(final software.amazon.awscdk.services.lambda.VersionOptions currentVersionOptions) {
            this.props.currentVersionOptions(currentVersionOptions);
            return this;
        }

        /**
         * (experimental) The SQS queue to use if DLQ is enabled.
         * <p>
         * Default: - SQS queue with 14 day retention period if `deadLetterQueueEnabled` is `true`
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to use if DLQ is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * (experimental) Enabled DLQ.
         * <p>
         * If <code>deadLetterQueue</code> is undefined,
         * an SQS queue with default options will be defined for your Function.
         * <p>
         * Default: - false unless `deadLetterQueue` is set, which implies DLQ is enabled.
         * <p>
         * @return {@code this}
         * @param deadLetterQueueEnabled Enabled DLQ. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deadLetterQueueEnabled(final java.lang.Boolean deadLetterQueueEnabled) {
            this.props.deadLetterQueueEnabled(deadLetterQueueEnabled);
            return this;
        }

        /**
         * (experimental) A description of the function.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * (experimental) Key-value pairs that Lambda caches and makes available for your Lambda functions.
         * <p>
         * Use environment variables to apply configuration changes, such
         * as test and production environment configurations, without changing your
         * Lambda function source code.
         * <p>
         * Default: - No environment variables.
         * <p>
         * @return {@code this}
         * @param environment Key-value pairs that Lambda caches and makes available for your Lambda functions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props.environment(environment);
            return this;
        }

        /**
         * (experimental) The AWS KMS key that's used to encrypt your function's environment variables.
         * <p>
         * Default: - AWS Lambda creates and uses an AWS managed customer master key (CMK).
         * <p>
         * @return {@code this}
         * @param environmentEncryption The AWS KMS key that's used to encrypt your function's environment variables. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environmentEncryption(final software.amazon.awscdk.services.kms.IKey environmentEncryption) {
            this.props.environmentEncryption(environmentEncryption);
            return this;
        }

        /**
         * (experimental) Event sources for this function.
         * <p>
         * You can also add event sources using <code>addEventSource</code>.
         * <p>
         * Default: - No event sources.
         * <p>
         * @return {@code this}
         * @param events Event sources for this function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder events(final java.util.List<? extends software.amazon.awscdk.services.lambda.IEventSource> events) {
            this.props.events(events);
            return this;
        }

        /**
         * (experimental) The filesystem configuration for the lambda function.
         * <p>
         * Default: - will not mount any filesystem
         * <p>
         * @return {@code this}
         * @param filesystem The filesystem configuration for the lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder filesystem(final software.amazon.awscdk.services.lambda.FileSystem filesystem) {
            this.props.filesystem(filesystem);
            return this;
        }

        /**
         * (experimental) A name for the function.
         * <p>
         * Default: - AWS CloudFormation generates a unique physical ID and uses that
         * ID for the function's name. For more information, see Name Type.
         * <p>
         * @return {@code this}
         * @param functionName A name for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder functionName(final java.lang.String functionName) {
            this.props.functionName(functionName);
            return this;
        }

        /**
         * (experimental) Initial policy statements to add to the created Lambda Role.
         * <p>
         * You can call <code>addToRolePolicy</code> to the created lambda to add statements post creation.
         * <p>
         * Default: - No policy statements are added to the created Lambda role.
         * <p>
         * @return {@code this}
         * @param initialPolicy Initial policy statements to add to the created Lambda Role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder initialPolicy(final java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> initialPolicy) {
            this.props.initialPolicy(initialPolicy);
            return this;
        }

        /**
         * (experimental) A list of layers to add to the function's execution environment.
         * <p>
         * You can configure your Lambda function to pull in
         * additional code during initialization in the form of layers. Layers are packages of libraries or other dependencies
         * that can be used by multiple functions.
         * <p>
         * Default: - No layers.
         * <p>
         * @return {@code this}
         * @param layers A list of layers to add to the function's execution environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder layers(final java.util.List<? extends software.amazon.awscdk.services.lambda.ILayerVersion> layers) {
            this.props.layers(layers);
            return this;
        }

        /**
         * (experimental) The number of days log events are kept in CloudWatch Logs.
         * <p>
         * When updating
         * this property, unsetting it doesn't remove the log retention policy. To
         * remove the retention policy, set the value to <code>INFINITE</code>.
         * <p>
         * Default: logs.RetentionDays.INFINITE
         * <p>
         * @return {@code this}
         * @param logRetention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logRetention(final software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.props.logRetention(logRetention);
            return this;
        }

        /**
         * (experimental) When log retention is specified, a custom resource attempts to create the CloudWatch log group.
         * <p>
         * These options control the retry policy when interacting with CloudWatch APIs.
         * <p>
         * Default: - Default AWS SDK retry options.
         * <p>
         * @return {@code this}
         * @param logRetentionRetryOptions When log retention is specified, a custom resource attempts to create the CloudWatch log group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logRetentionRetryOptions(final software.amazon.awscdk.services.lambda.LogRetentionRetryOptions logRetentionRetryOptions) {
            this.props.logRetentionRetryOptions(logRetentionRetryOptions);
            return this;
        }

        /**
         * (experimental) The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * <p>
         * Default: - A new role is created.
         * <p>
         * @return {@code this}
         * @param logRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logRetentionRole(final software.amazon.awscdk.services.iam.IRole logRetentionRole) {
            this.props.logRetentionRole(logRetentionRole);
            return this;
        }

        /**
         * (experimental) The amount of memory, in MB, that is allocated to your Lambda function.
         * <p>
         * Lambda uses this value to proportionally allocate the amount of CPU
         * power. For more information, see Resource Model in the AWS Lambda
         * Developer Guide.
         * <p>
         * Default: 128
         * <p>
         * @return {@code this}
         * @param memorySize The amount of memory, in MB, that is allocated to your Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memorySize(final java.lang.Number memorySize) {
            this.props.memorySize(memorySize);
            return this;
        }

        /**
         * (experimental) Enable profiling.
         * <p>
         * Default: - No profiling.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html
         * @param profiling Enable profiling. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder profiling(final java.lang.Boolean profiling) {
            this.props.profiling(profiling);
            return this;
        }

        /**
         * (experimental) Profiling Group.
         * <p>
         * Default: - A new profiling group will be created if `profiling` is set.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/codeguru/latest/profiler-ug/setting-up-lambda.html
         * @param profilingGroup Profiling Group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder profilingGroup(final software.amazon.awscdk.services.codeguruprofiler.IProfilingGroup profilingGroup) {
            this.props.profilingGroup(profilingGroup);
            return this;
        }

        /**
         * (experimental) The maximum of concurrent executions you want to reserve for the function.
         * <p>
         * Default: - No specific limit - account limit.
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/lambda/latest/dg/concurrent-executions.html
         * @param reservedConcurrentExecutions The maximum of concurrent executions you want to reserve for the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder reservedConcurrentExecutions(final java.lang.Number reservedConcurrentExecutions) {
            this.props.reservedConcurrentExecutions(reservedConcurrentExecutions);
            return this;
        }

        /**
         * (experimental) Lambda execution role.
         * <p>
         * This is the role that will be assumed by the function upon execution.
         * It controls the permissions that the function will have. The Role must
         * be assumable by the 'lambda.amazonaws.com' service principal.
         * <p>
         * The default Role automatically has permissions granted for Lambda execution. If you
         * provide a Role, you must add the relevant AWS managed policies yourself.
         * <p>
         * The relevant managed policies are "service-role/AWSLambdaBasicExecutionRole" and
         * "service-role/AWSLambdaVPCAccessExecutionRole".
         * <p>
         * Default: - A unique role will be generated for this lambda function.
         * Both supplied and generated roles can always be changed by calling `addToRolePolicy`.
         * <p>
         * @return {@code this}
         * @param role Lambda execution role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (experimental) The list of security groups to associate with the Lambda's network interfaces.
         * <p>
         * Only used if 'vpc' is supplied.
         * <p>
         * Default: - If the function is placed within a VPC and a security group is
         * not specified, either by this or securityGroup prop, a dedicated security
         * group will be created for this function.
         * <p>
         * @return {@code this}
         * @param securityGroups The list of security groups to associate with the Lambda's network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props.securityGroups(securityGroups);
            return this;
        }

        /**
         * (experimental) The function execution time (in seconds) after which Lambda terminates the function.
         * <p>
         * Because the execution time affects cost, set this value
         * based on the function's expected execution time.
         * <p>
         * Default: Duration.seconds(3)
         * <p>
         * @return {@code this}
         * @param timeout The function execution time (in seconds) after which Lambda terminates the function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * (experimental) Enable AWS X-Ray Tracing for Lambda Function.
         * <p>
         * Default: Tracing.Disabled
         * <p>
         * @return {@code this}
         * @param tracing Enable AWS X-Ray Tracing for Lambda Function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder tracing(final software.amazon.awscdk.services.lambda.Tracing tracing) {
            this.props.tracing(tracing);
            return this;
        }

        /**
         * (experimental) VPC network to place Lambda network interfaces.
         * <p>
         * Specify this if the Lambda function needs to access resources in a VPC.
         * <p>
         * Default: - Function is not placed within a VPC.
         * <p>
         * @return {@code this}
         * @param vpc VPC network to place Lambda network interfaces. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props.vpc(vpc);
            return this;
        }

        /**
         * (experimental) Where to place the network interfaces within the VPC.
         * <p>
         * Only used if 'vpc' is supplied. Note: internet access for Lambdas
         * requires a NAT gateway, so picking Public subnets is not allowed.
         * <p>
         * Default: - the Vpc default strategy if not specified
         * <p>
         * @return {@code this}
         * @param vpcSubnets Where to place the network interfaces within the VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpcSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.props.vpcSubnets(vpcSubnets);
            return this;
        }

        /**
         * (experimental) The source code of your Lambda function.
         * <p>
         * You can point to a file in an
         * Amazon Simple Storage Service (Amazon S3) bucket or specify your source
         * code as inline text.
         * <p>
         * @return {@code this}
         * @param code The source code of your Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder code(final software.amazon.awscdk.services.lambda.Code code) {
            this.props.code(code);
            return this;
        }

        /**
         * (experimental) The name of the method within your code that Lambda calls to execute your function.
         * <p>
         * The format includes the file name. It can also include
         * namespaces and other qualifiers, depending on the runtime.
         * For more information, see https://docs.aws.amazon.com/lambda/latest/dg/gettingstarted-features.html#gettingstarted-features-programmingmodel.
         * <p>
         * Use <code>Handler.FROM_IMAGE</code> when defining a function from a Docker image.
         * <p>
         * NOTE: If you specify your source code as inline text by specifying the
         * ZipFile property within the Code property, specify index.function_name as
         * the handler.
         * <p>
         * @return {@code this}
         * @param handler The name of the method within your code that Lambda calls to execute your function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder handler(final java.lang.String handler) {
            this.props.handler(handler);
            return this;
        }

        /**
         * (experimental) The runtime environment for the Lambda function that you are uploading.
         * <p>
         * For valid values, see the Runtime property in the AWS Lambda Developer
         * Guide.
         * <p>
         * Use <code>Runtime.FROM_IMAGE</code> when when defining a function from a Docker image.
         * <p>
         * @return {@code this}
         * @param runtime The runtime environment for the Lambda function that you are uploading. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runtime(final software.amazon.awscdk.services.lambda.Runtime runtime) {
            this.props.runtime(runtime);
            return this;
        }

        /**
         * (experimental) The stack ID of Lambda@Edge function.
         * <p>
         * Default: - `edge-lambda-stack-${region}`
         * <p>
         * @return {@code this}
         * @param stackId The stack ID of Lambda@Edge function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stackId(final java.lang.String stackId) {
            this.props.stackId(stackId);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudfront.experimental.EdgeFunction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cloudfront.experimental.EdgeFunction build() {
            return new software.amazon.awscdk.services.cloudfront.experimental.EdgeFunction(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
