package software.amazon.awscdk.services.cloudwatch;

/**
 * (experimental) A metric emitted by a service.
 * <p>
 * The metric is a combination of a metric identifier (namespace, name and dimensions)
 * and an aggregation function (statistic, period and unit).
 * <p>
 * It also contains metadata which is used only in graphs, such as color and label.
 * It makes sense to embed this in here, so that compound constructs can attach
 * that metadata to metrics they expose.
 * <p>
 * This class does not represent a resource, so hence is not a construct. Instead,
 * Metric is an abstraction that makes it easy to specify metrics for use in both
 * alarms and graphs.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:04.109Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.Metric")
public class Metric extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IMetric {

    protected Metric(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Metric(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Metric(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.MetricProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Grant permissions to the given identity to write metrics.
     * <p>
     * @param grantee The IAM identity to give permissions to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPutMetricData(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudwatch.Metric.class, "grantPutMetricData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * (experimental) Attach the metric object to the given construct scope.
     * <p>
     * Returns a Metric object that uses the account and region from the Stack
     * the given construct is defined in. If the metric is subsequently used
     * in a Dashboard or Alarm in a different Stack defined in a different
     * account or region, the appropriate 'region' and 'account' fields
     * will be added to it.
     * <p>
     * If the scope we attach to is in an environment-agnostic stack,
     * nothing is done and the same Metric object is returned.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric attachTo(final @org.jetbrains.annotations.NotNull software.constructs.IConstruct scope) {
        return software.amazon.jsii.Kernel.call(this, "attachTo", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }

    /**
     * (experimental) Make a new Alarm for this metric.
     * <p>
     * Combines both properties that may adjust the metric (aggregation) as well
     * as alarm properties.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Alarm createAlarm(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.CreateAlarmOptions props) {
        return software.amazon.jsii.Kernel.call(this, "createAlarm", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Alarm.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Inspect the details of the metric object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.MetricConfig toMetricConfig() {
        return software.amazon.jsii.Kernel.call(this, "toMetricConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.MetricConfig.class));
    }

    /**
     * (experimental) Returns a string representation of an object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Return a copy of Metric `with` properties changed.
     * <p>
     * All properties except namespace and metricName can be changed.
     * <p>
     * @param props The set of properties to change. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric with(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "with", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Name of this metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getMetricName() {
        return software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Namespace of this metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getNamespace() {
        return software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Period of this metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.Duration getPeriod() {
        return software.amazon.jsii.Kernel.get(this, "period", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * (experimental) Statistic of this metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getStatistic() {
        return software.amazon.jsii.Kernel.get(this, "statistic", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Account which this metric comes from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getAccount() {
        return software.amazon.jsii.Kernel.get(this, "account", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The hex color code used when this metric is rendered on a graph.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getColor() {
        return software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Dimensions of this metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getDimensions() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.Object>)(software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * (experimental) Label for this metric when added to a Graph in a Dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
        return software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Region which this metric comes from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable java.lang.String getRegion() {
        return software.amazon.jsii.Kernel.get(this, "region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) Unit of the metric.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.Unit getUnit() {
        return software.amazon.jsii.Kernel.get(this, "unit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Unit.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.Metric}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.Metric> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.cloudwatch.MetricProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.cloudwatch.MetricProps.Builder();
        }

        /**
         * (experimental) Account which this metric comes from.
         * <p>
         * Default: - Deployment account.
         * <p>
         * @return {@code this}
         * @param account Account which this metric comes from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder account(final java.lang.String account) {
            this.props.account(account);
            return this;
        }

        /**
         * (experimental) The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The `Color` class has a set of standard colors that can be used here.
         * <p>
         * Default: - Automatic color
         * <p>
         * @return {@code this}
         * @param color The hex color code, prefixed with '#' (e.g. '#00ff00'), to use when this metric is rendered on a graph. The `Color` class has a set of standard colors that can be used here. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder color(final java.lang.String color) {
            this.props.color(color);
            return this;
        }

        /**
         * (experimental) Dimensions of the metric.
         * <p>
         * Default: - No dimensions.
         * <p>
         * @return {@code this}
         * @param dimensionsMap Dimensions of the metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder dimensionsMap(final java.util.Map<java.lang.String, java.lang.String> dimensionsMap) {
            this.props.dimensionsMap(dimensionsMap);
            return this;
        }

        /**
         * (experimental) Label for this metric when added to a Graph in a Dashboard.
         * <p>
         * Default: - No label
         * <p>
         * @return {@code this}
         * @param label Label for this metric when added to a Graph in a Dashboard. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder label(final java.lang.String label) {
            this.props.label(label);
            return this;
        }

        /**
         * (experimental) The period over which the specified statistic is applied.
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param period The period over which the specified statistic is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder period(final software.amazon.awscdk.Duration period) {
            this.props.period(period);
            return this;
        }

        /**
         * (experimental) Region which this metric comes from.
         * <p>
         * Default: - Deployment region.
         * <p>
         * @return {@code this}
         * @param region Region which this metric comes from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder region(final java.lang.String region) {
            this.props.region(region);
            return this;
        }

        /**
         * (experimental) What function to use for aggregating.
         * <p>
         * Can be one of the following:
         * <p>
         * <ul>
         * <li>"Minimum" | "min"</li>
         * <li>"Maximum" | "max"</li>
         * <li>"Average" | "avg"</li>
         * <li>"Sum" | "sum"</li>
         * <li>"SampleCount | "n"</li>
         * <li>"pNN.NN"</li>
         * </ul>
         * <p>
         * Default: Average
         * <p>
         * @return {@code this}
         * @param statistic What function to use for aggregating. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder statistic(final java.lang.String statistic) {
            this.props.statistic(statistic);
            return this;
        }

        /**
         * (experimental) Unit used to filter the metric stream.
         * <p>
         * Only refer to datums emitted to the metric stream with the given unit and
         * ignore all others. Only useful when datums are being emitted to the same
         * metric stream under different units.
         * <p>
         * The default is to use all matric datums in the stream, regardless of unit,
         * which is recommended in nearly all cases.
         * <p>
         * CloudWatch does not honor this property for graphs.
         * <p>
         * Default: - All metric datums in the given metric stream
         * <p>
         * @return {@code this}
         * @param unit Unit used to filter the metric stream. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder unit(final software.amazon.awscdk.services.cloudwatch.Unit unit) {
            this.props.unit(unit);
            return this;
        }

        /**
         * (experimental) Name of the metric.
         * <p>
         * @return {@code this}
         * @param metricName Name of the metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder metricName(final java.lang.String metricName) {
            this.props.metricName(metricName);
            return this;
        }

        /**
         * (experimental) Namespace of the metric.
         * <p>
         * @return {@code this}
         * @param namespace Namespace of the metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder namespace(final java.lang.String namespace) {
            this.props.namespace(namespace);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.Metric}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.cloudwatch.Metric build() {
            return new software.amazon.awscdk.services.cloudwatch.Metric(
                this.props.build()
            );
        }
    }
}
