package software.amazon.awscdk.services.codecommit;

/**
 * (experimental) Provides a CodeCommit Repository.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:10.314Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codecommit.Repository")
public class Repository extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.codecommit.IRepository {

    protected Repository(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Repository(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Repository(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.RepositoryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Imports a codecommit repository.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param repositoryArn (e.g. `arn:aws:codecommit:us-east-1:123456789012:MyDemoRepo`). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.IRepository fromRepositoryArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String repositoryArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codecommit.Repository.class, "fromRepositoryArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.IRepository.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(repositoryArn, "repositoryArn is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param repositoryName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.IRepository fromRepositoryName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String repositoryName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codecommit.Repository.class, "fromRepositoryName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.IRepository.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(repositoryName, "repositoryName is required") });
    }

    /**
     * (experimental) Grant the given principal identity permissions to perform the actions on this repository.
     * <p>
     * @param grantee This parameter is required.
     * @param actions This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
        return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
    }

    /**
     * (experimental) Grant the given identity permissions to pull this repository.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPull(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantPull", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * (experimental) Grant the given identity permissions to pull and push this repository.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantPullPush(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantPullPush", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * (experimental) Grant the given identity permissions to read this repository.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * (experimental) Create a trigger to notify another service to run actions on repository events.
     * <p>
     * @param arn Arn of the resource that repository events will notify. This parameter is required.
     * @param options Trigger options to run actions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.Repository notify(final @org.jetbrains.annotations.NotNull java.lang.String arn, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codecommit.RepositoryTriggerOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notify", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.Repository.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required"), options });
    }

    /**
     * (experimental) Create a trigger to notify another service to run actions on repository events.
     * <p>
     * @param arn Arn of the resource that repository events will notify. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.Repository notify(final @org.jetbrains.annotations.NotNull java.lang.String arn) {
        return software.amazon.jsii.Kernel.call(this, "notify", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codecommit.Repository.class), new Object[] { java.util.Objects.requireNonNull(arn, "arn is required") });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a comment is made on a commit.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommentOnCommit(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onCommentOnCommit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a comment is made on a commit.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommentOnCommit(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onCommentOnCommit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a comment is made on a pull request.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommentOnPullRequest(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onCommentOnPullRequest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a comment is made on a pull request.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommentOnPullRequest(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onCommentOnPullRequest", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a commit is pushed to a branch.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommit(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codecommit.OnCommitOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onCommit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a commit is pushed to a branch.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onCommit(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onCommit", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers for repository events.
     * <p>
     * Use
     * <code>rule.addEventPattern(pattern)</code> to specify a filter.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers for repository events.
     * <p>
     * Use
     * <code>rule.addEventPattern(pattern)</code> to specify a filter.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a pull request state is changed.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onPullRequestStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onPullRequestStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a pull request state is changed.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onPullRequestStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onPullRequestStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a reference is created (i.e. a new branch/tag is created) to the repository.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceCreated(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onReferenceCreated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a reference is created (i.e. a new branch/tag is created) to the repository.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceCreated(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onReferenceCreated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a reference is delete (i.e. a branch/tag is deleted) from the repository.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceDeleted(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onReferenceDeleted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a reference is delete (i.e. a branch/tag is deleted) from the repository.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceDeleted(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onReferenceDeleted", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a reference is updated (i.e. a commit is pushed to an existing or new branch) from the repository.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceUpdated(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onReferenceUpdated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a reference is updated (i.e. a commit is pushed to an existing or new branch) from the repository.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onReferenceUpdated(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onReferenceUpdated", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a "CodeCommit Repository State Change" event occurs.
     * <p>
     * @param id This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Defines a CloudWatch event rule which triggers when a "CodeCommit Repository State Change" event occurs.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) The ARN of this Repository.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryArn() {
        return software.amazon.jsii.Kernel.get(this, "repositoryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The HTTPS (GRC) clone URL.
     * <p>
     * HTTPS (GRC) is the protocol to use with git-remote-codecommit (GRC).
     * <p>
     * It is the recommended method for supporting connections made with federated
     * access, identity providers, and temporary credentials.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryCloneUrlGrc() {
        return software.amazon.jsii.Kernel.get(this, "repositoryCloneUrlGrc", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The HTTP clone URL.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryCloneUrlHttp() {
        return software.amazon.jsii.Kernel.get(this, "repositoryCloneUrlHttp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The SSH clone URL.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryCloneUrlSsh() {
        return software.amazon.jsii.Kernel.get(this, "repositoryCloneUrlSsh", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The human-visible name of this Repository.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName() {
        return software.amazon.jsii.Kernel.get(this, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.codecommit.Repository}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codecommit.Repository> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codecommit.RepositoryProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codecommit.RepositoryProps.Builder();
        }

        /**
         * (experimental) Name of the repository.
         * <p>
         * This property is required for all CodeCommit repositories.
         * <p>
         * @return {@code this}
         * @param repositoryName Name of the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder repositoryName(final java.lang.String repositoryName) {
            this.props.repositoryName(repositoryName);
            return this;
        }

        /**
         * (experimental) A description of the repository.
         * <p>
         * Use the description to identify the
         * purpose of the repository.
         * <p>
         * Default: - No description.
         * <p>
         * @return {@code this}
         * @param description A description of the repository. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codecommit.Repository}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.codecommit.Repository build() {
            return new software.amazon.awscdk.services.codecommit.Repository(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
