package software.amazon.awscdk.services.codepipeline;

/**
 * (experimental) An AWS CodePipeline pipeline with its associated IAM role and S3 bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>{@code
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // create a pipeline
 * Object pipeline = new Pipeline(this, "Pipeline");
 * // add a stage
 * Object sourceStage = pipeline.addStage(Map.of("stageName", "Source"));
 * // add a source action to the stage
 * sourceStage.addAction(CodeCommitSourceAction.Builder.create()
 *         .actionName("Source")
 *         .outputArtifactName("SourceArtifact")
 *         .repository(repo)
 *         .build());}</pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:10.363Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.Pipeline")
public class Pipeline extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.codepipeline.IPipeline {

    protected Pipeline(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Pipeline(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Pipeline(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.PipelineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public Pipeline(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Import a pipeline into this app.
     * <p>
     * @param scope the scope into which to import this pipeline. This parameter is required.
     * @param id the logical ID of the returned pipeline construct. This parameter is required.
     * @param pipelineArn The ARN of the pipeline (e.g. `arn:aws:codepipeline:us-east-1:123456789012:MyDemoPipeline`). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IPipeline fromPipelineArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String pipelineArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codepipeline.Pipeline.class, "fromPipelineArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IPipeline.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(pipelineArn, "pipelineArn is required") });
    }

    /**
     * (experimental) Creates a new Stage, and adds it to this Pipeline.
     * <p>
     * @return the newly created Stage
     * @param props the creation properties of the new Stage. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage addStage(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.StageOptions props) {
        return software.amazon.jsii.Kernel.call(this, "addStage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IStage.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) Adds a statement to the pipeline role.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * (experimental) Returns a source configuration for notification rule.
     * <p>
     * @param _scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig bindAsNotificationRuleSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope) {
        return software.amazon.jsii.Kernel.call(this, "bindAsNotificationRuleSource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.NotificationRuleSourceConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
    }

    /**
     * (experimental) Defines a CodeStar notification rule triggered when the pipeline events emitted by you specified, it very similar to `onEvent` API.
     * <p>
     * You can also use the methods <code>notifyOnExecutionStateChange</code>, <code>notifyOnAnyStageStateChange</code>,
     * <code>notifyOnAnyActionStateChange</code> and <code>notifyOnAnyManualApprovalStateChange</code>
     * to define rules for these specific event emitted.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOn(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.PipelineNotifyOnOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Define an notification rule triggered by the set of the "Action execution" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyActionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnAnyActionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * (experimental) Define an notification rule triggered by the set of the "Action execution" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyActionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnAnyActionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * (experimental) Define an notification rule triggered by the set of the "Manual approval" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyManualApprovalStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnAnyManualApprovalStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * (experimental) Define an notification rule triggered by the set of the "Manual approval" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyManualApprovalStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnAnyManualApprovalStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * (experimental) Define an notification rule triggered by the set of the "Stage execution" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyStageStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnAnyStageStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * (experimental) Define an notification rule triggered by the set of the "Stage execution" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnAnyStageStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnAnyStageStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * (experimental) Define an notification rule triggered by the set of the "Pipeline execution" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnExecutionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codestarnotifications.NotificationRuleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnExecutionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required"), options });
    }

    /**
     * (experimental) Define an notification rule triggered by the set of the "Pipeline execution" events emitted from this pipeline.
     * <p>
     * @param id This parameter is required.
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRule notifyOnExecutionStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.INotificationRuleTarget target) {
        return software.amazon.jsii.Kernel.call(this, "notifyOnExecutionStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.INotificationRule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * (experimental) Defines an event rule triggered by this CodePipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     * @param options Additional options to pass to the event rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Defines an event rule triggered by this CodePipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onEvent(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Defines an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     * @param options Additional options to pass to the event rule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.OnEventOptions options) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), options });
    }

    /**
     * (experimental) Defines an event rule triggered by the "CodePipeline Pipeline Execution State Change" event emitted from this pipeline.
     * <p>
     * @param id Identifier for this event handler. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.Rule onStateChange(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.Kernel.call(this, "onStateChange", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.Rule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Access one of the pipeline's stages by stage name.
     * <p>
     * @param stageName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage(final @org.jetbrains.annotations.NotNull java.lang.String stageName) {
        return software.amazon.jsii.Kernel.call(this, "stage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IStage.class), new Object[] { java.util.Objects.requireNonNull(stageName, "stageName is required") });
    }

    /**
     * (experimental) Bucket used to store output artifacts.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getArtifactBucket() {
        return software.amazon.jsii.Kernel.get(this, "artifactBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
    }

    /**
     * (experimental) Returns all of the {@link CrossRegionSupportStack}s that were generated automatically when dealing with Actions that reside in a different region than the Pipeline itself.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, software.amazon.awscdk.services.codepipeline.CrossRegionSupport> getCrossRegionSupport() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "crossRegionSupport", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.CrossRegionSupport.class))));
    }

    /**
     * (experimental) ARN of this pipeline.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getPipelineArn() {
        return software.amazon.jsii.Kernel.get(this, "pipelineArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the pipeline.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getPipelineName() {
        return software.amazon.jsii.Kernel.get(this, "pipelineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The version of the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getPipelineVersion() {
        return software.amazon.jsii.Kernel.get(this, "pipelineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The IAM role AWS CodePipeline will use to perform actions or assume roles for actions with a more specific IAM role.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * (experimental) Get the number of Stages in this Pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.Number getStageCount() {
        return software.amazon.jsii.Kernel.get(this, "stageCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * (experimental) Returns the stages that comprise the pipeline.
     * <p>
     * <strong>Note</strong>: the returned array is a defensive copy,
     * so adding elements to it has no effect.
     * Instead, use the {&#64;link addStage} method if you want to add more stages
     * to the pipeline.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.codepipeline.IStage> getStages() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "stages", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.IStage.class))));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.codepipeline.Pipeline}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.Pipeline> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.codepipeline.PipelineProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) The S3 bucket used by this Pipeline to store artifacts.
         * <p>
         * Default: - A new S3 bucket will be created.
         * <p>
         * @return {@code this}
         * @param artifactBucket The S3 bucket used by this Pipeline to store artifacts. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder artifactBucket(final software.amazon.awscdk.services.s3.IBucket artifactBucket) {
            this.props().artifactBucket(artifactBucket);
            return this;
        }

        /**
         * (experimental) Create KMS keys for cross-account deployments.
         * <p>
         * This controls whether the pipeline is enabled for cross-account deployments.
         * <p>
         * By default cross-account deployments are enabled, but this feature requires
         * that KMS Customer Master Keys are created which have a cost of $1/month.
         * <p>
         * If you do not need cross-account deployments, you can set this to <code>false</code> to
         * not create those keys and save on that cost (the artifact bucket will be
         * encrypted with an AWS-managed key). However, cross-account deployments will
         * no longer be possible.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param crossAccountKeys Create KMS keys for cross-account deployments. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder crossAccountKeys(final java.lang.Boolean crossAccountKeys) {
            this.props().crossAccountKeys(crossAccountKeys);
            return this;
        }

        /**
         * (experimental) A map of region to S3 bucket name used for cross-region CodePipeline.
         * <p>
         * For every Action that you specify targeting a different region than the Pipeline itself,
         * if you don't provide an explicit Bucket for that region using this property,
         * the construct will automatically create a Stack containing an S3 Bucket in that region.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param crossRegionReplicationBuckets A map of region to S3 bucket name used for cross-region CodePipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder crossRegionReplicationBuckets(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.s3.IBucket> crossRegionReplicationBuckets) {
            this.props().crossRegionReplicationBuckets(crossRegionReplicationBuckets);
            return this;
        }

        /**
         * (experimental) Name of the pipeline.
         * <p>
         * Default: - AWS CloudFormation generates an ID and uses that for the pipeline name.
         * <p>
         * @return {@code this}
         * @param pipelineName Name of the pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder pipelineName(final java.lang.String pipelineName) {
            this.props().pipelineName(pipelineName);
            return this;
        }

        /**
         * (experimental) Indicates whether to rerun the AWS CodePipeline pipeline after you update it.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param restartExecutionOnUpdate Indicates whether to rerun the AWS CodePipeline pipeline after you update it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder restartExecutionOnUpdate(final java.lang.Boolean restartExecutionOnUpdate) {
            this.props().restartExecutionOnUpdate(restartExecutionOnUpdate);
            return this;
        }

        /**
         * (experimental) The IAM role to be assumed by this Pipeline.
         * <p>
         * Default: a new IAM role will be created.
         * <p>
         * @return {@code this}
         * @param role The IAM role to be assumed by this Pipeline. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props().role(role);
            return this;
        }

        /**
         * (experimental) The list of Stages, in order, to create this Pipeline with.
         * <p>
         * You can always add more Stages later by calling {&#64;link Pipeline#addStage}.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param stages The list of Stages, in order, to create this Pipeline with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stages(final java.util.List<? extends software.amazon.awscdk.services.codepipeline.StageProps> stages) {
            this.props().stages(stages);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codepipeline.Pipeline}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.codepipeline.Pipeline build() {
            return new software.amazon.awscdk.services.codepipeline.Pipeline(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.codepipeline.PipelineProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.codepipeline.PipelineProps.Builder();
            }
            return this.props;
        }
    }
}
