package software.amazon.awscdk.services.codepipeline.actions;

/**
 * (experimental) Source that is provided by a specific Amazon S3 object.
 * <p>
 * Will trigger the pipeline as soon as the S3 object changes, but only if there is
 * a CloudTrail Trail in the account that captures the S3 event.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:18.750Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.S3SourceAction")
public class S3SourceAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected S3SourceAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected S3SourceAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public S3SourceAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.S3SourceActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) This is a renamed version of the {@link IAction.bind} method.
     * <p>
     * @param _scope This parameter is required.
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) The variables emitted by this action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.S3SourceVariables getVariables() {
        return software.amazon.jsii.Kernel.get(this, "variables", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.S3SourceVariables.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.S3SourceAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.S3SourceAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.S3SourceActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.S3SourceActionProps.Builder();
        }

        /**
         * (experimental) The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * (experimental) The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * (experimental) The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * (experimental) The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your {&#64;link IAction.bind}
         * method in the {&#64;link ActionBindOptions.role} property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * (experimental) The Amazon S3 bucket that stores the source code.
         * <p>
         * If you import an encrypted bucket in your stack, please specify
         * the encryption key at import time by using <code>Bucket.fromBucketAttributes()</code> method.
         * <p>
         * @return {@code this}
         * @param bucket The Amazon S3 bucket that stores the source code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bucket(final software.amazon.awscdk.services.s3.IBucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        /**
         * (experimental) The key within the S3 bucket that stores the source code.
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>{@code
         * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         * "path/to/file.zip";}</pre></blockquote>
         * <p>
         * @return {@code this}
         * @param bucketKey The key within the S3 bucket that stores the source code. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder bucketKey(final java.lang.String bucketKey) {
            this.props.bucketKey(bucketKey);
            return this;
        }

        /**
         * @return {@code this}
         * @param output This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder output(final software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.props.output(output);
            return this;
        }

        /**
         * (experimental) How should CodePipeline detect source changes for this Action.
         * <p>
         * Note that if this is S3Trigger.EVENTS, you need to make sure to include the source Bucket in a CloudTrail Trail,
         * as otherwise the CloudWatch Events will not be emitted.
         * <p>
         * Default: S3Trigger.POLL
         * <p>
         * @return {@code this}
         * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/log-s3-data-events.html
         * @param trigger How should CodePipeline detect source changes for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder trigger(final software.amazon.awscdk.services.codepipeline.actions.S3Trigger trigger) {
            this.props.trigger(trigger);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.S3SourceAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.S3SourceAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.S3SourceAction(
                this.props.build()
            );
        }
    }
}
