package software.amazon.awscdk.services.codepipeline.actions;

/**
 * (experimental) Construction properties of the {@link StepFunctionsInvokeAction StepFunction Invoke Action}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:19.977Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.StepFunctionsInvokeActionProps")
@software.amazon.jsii.Jsii.Proxy(StepFunctionsInvokeActionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface StepFunctionsInvokeActionProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codepipeline.CommonAwsActionProps {

    /**
     * (experimental) The state machine to invoke.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IStateMachine getStateMachine();

    /**
     * (experimental) Prefix (optional).
     * <p>
     * By default, the action execution ID is used as the state machine execution name.
     * If a prefix is provided, it is prepended to the action execution ID with a hyphen and
     * together used as the state machine execution name.
     * <p>
     * Default: - action execution ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionNamePrefix() {
        return null;
    }

    /**
     * (experimental) The optional output Artifact of the Action.
     * <p>
     * Default: the Action will not have any outputs
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.Artifact getOutput() {
        return null;
    }

    /**
     * (experimental) Represents the input to the StateMachine.
     * <p>
     * This includes input artifact, input type and the statemachine input.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codepipeline.actions.StateMachineInput getStateMachineInput() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link StepFunctionsInvokeActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link StepFunctionsInvokeActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<StepFunctionsInvokeActionProps> {
        private software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine;
        private java.lang.String executionNamePrefix;
        private software.amazon.awscdk.services.codepipeline.Artifact output;
        private software.amazon.awscdk.services.codepipeline.actions.StateMachineInput stateMachineInput;
        private software.amazon.awscdk.services.iam.IRole role;
        private java.lang.String actionName;
        private java.lang.Number runOrder;
        private java.lang.String variablesNamespace;

        /**
         * Sets the value of {@link StepFunctionsInvokeActionProps#getStateMachine}
         * @param stateMachine The state machine to invoke. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stateMachine(software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine) {
            this.stateMachine = stateMachine;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsInvokeActionProps#getExecutionNamePrefix}
         * @param executionNamePrefix Prefix (optional).
         *                            By default, the action execution ID is used as the state machine execution name.
         *                            If a prefix is provided, it is prepended to the action execution ID with a hyphen and
         *                            together used as the state machine execution name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder executionNamePrefix(java.lang.String executionNamePrefix) {
            this.executionNamePrefix = executionNamePrefix;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsInvokeActionProps#getOutput}
         * @param output The optional output Artifact of the Action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder output(software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.output = output;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsInvokeActionProps#getStateMachineInput}
         * @param stateMachineInput Represents the input to the StateMachine.
         *                          This includes input artifact, input type and the statemachine input.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder stateMachineInput(software.amazon.awscdk.services.codepipeline.actions.StateMachineInput stateMachineInput) {
            this.stateMachineInput = stateMachineInput;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsInvokeActionProps#getRole}
         * @param role The Role in which context's this Action will be executing in.
         *             The Pipeline's Role will assume this Role
         *             (the required permissions for that will be granted automatically)
         *             right before executing this Action.
         *             This Action will be passed into your {&#64;link IAction.bind}
         *             method in the {&#64;link ActionBindOptions.role} property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsInvokeActionProps#getActionName}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         *                   Note that Action names must be unique within a single Stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder actionName(java.lang.String actionName) {
            this.actionName = actionName;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsInvokeActionProps#getRunOrder}
         * @param runOrder The runOrder property for this Action.
         *                 RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder runOrder(java.lang.Number runOrder) {
            this.runOrder = runOrder;
            return this;
        }

        /**
         * Sets the value of {@link StepFunctionsInvokeActionProps#getVariablesNamespace}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder variablesNamespace(java.lang.String variablesNamespace) {
            this.variablesNamespace = variablesNamespace;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StepFunctionsInvokeActionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public StepFunctionsInvokeActionProps build() {
            return new Jsii$Proxy(stateMachine, executionNamePrefix, output, stateMachineInput, role, actionName, runOrder, variablesNamespace);
        }
    }

    /**
     * An implementation for {@link StepFunctionsInvokeActionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StepFunctionsInvokeActionProps {
        private final software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine;
        private final java.lang.String executionNamePrefix;
        private final software.amazon.awscdk.services.codepipeline.Artifact output;
        private final software.amazon.awscdk.services.codepipeline.actions.StateMachineInput stateMachineInput;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.lang.String actionName;
        private final java.lang.Number runOrder;
        private final java.lang.String variablesNamespace;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.stateMachine = software.amazon.jsii.Kernel.get(this, "stateMachine", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IStateMachine.class));
            this.executionNamePrefix = software.amazon.jsii.Kernel.get(this, "executionNamePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.Artifact.class));
            this.stateMachineInput = software.amazon.jsii.Kernel.get(this, "stateMachineInput", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.actions.StateMachineInput.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.actionName = software.amazon.jsii.Kernel.get(this, "actionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runOrder = software.amazon.jsii.Kernel.get(this, "runOrder", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.variablesNamespace = software.amazon.jsii.Kernel.get(this, "variablesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.stepfunctions.IStateMachine stateMachine, final java.lang.String executionNamePrefix, final software.amazon.awscdk.services.codepipeline.Artifact output, final software.amazon.awscdk.services.codepipeline.actions.StateMachineInput stateMachineInput, final software.amazon.awscdk.services.iam.IRole role, final java.lang.String actionName, final java.lang.Number runOrder, final java.lang.String variablesNamespace) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.stateMachine = java.util.Objects.requireNonNull(stateMachine, "stateMachine is required");
            this.executionNamePrefix = executionNamePrefix;
            this.output = output;
            this.stateMachineInput = stateMachineInput;
            this.role = role;
            this.actionName = java.util.Objects.requireNonNull(actionName, "actionName is required");
            this.runOrder = runOrder;
            this.variablesNamespace = variablesNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IStateMachine getStateMachine() {
            return this.stateMachine;
        }

        @Override
        public final java.lang.String getExecutionNamePrefix() {
            return this.executionNamePrefix;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.Artifact getOutput() {
            return this.output;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.actions.StateMachineInput getStateMachineInput() {
            return this.stateMachineInput;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.lang.String getActionName() {
            return this.actionName;
        }

        @Override
        public final java.lang.Number getRunOrder() {
            return this.runOrder;
        }

        @Override
        public final java.lang.String getVariablesNamespace() {
            return this.variablesNamespace;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("stateMachine", om.valueToTree(this.getStateMachine()));
            if (this.getExecutionNamePrefix() != null) {
                data.set("executionNamePrefix", om.valueToTree(this.getExecutionNamePrefix()));
            }
            if (this.getOutput() != null) {
                data.set("output", om.valueToTree(this.getOutput()));
            }
            if (this.getStateMachineInput() != null) {
                data.set("stateMachineInput", om.valueToTree(this.getStateMachineInput()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            data.set("actionName", om.valueToTree(this.getActionName()));
            if (this.getRunOrder() != null) {
                data.set("runOrder", om.valueToTree(this.getRunOrder()));
            }
            if (this.getVariablesNamespace() != null) {
                data.set("variablesNamespace", om.valueToTree(this.getVariablesNamespace()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline_actions.StepFunctionsInvokeActionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            StepFunctionsInvokeActionProps.Jsii$Proxy that = (StepFunctionsInvokeActionProps.Jsii$Proxy) o;

            if (!stateMachine.equals(that.stateMachine)) return false;
            if (this.executionNamePrefix != null ? !this.executionNamePrefix.equals(that.executionNamePrefix) : that.executionNamePrefix != null) return false;
            if (this.output != null ? !this.output.equals(that.output) : that.output != null) return false;
            if (this.stateMachineInput != null ? !this.stateMachineInput.equals(that.stateMachineInput) : that.stateMachineInput != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (!actionName.equals(that.actionName)) return false;
            if (this.runOrder != null ? !this.runOrder.equals(that.runOrder) : that.runOrder != null) return false;
            return this.variablesNamespace != null ? this.variablesNamespace.equals(that.variablesNamespace) : that.variablesNamespace == null;
        }

        @Override
        public final int hashCode() {
            int result = this.stateMachine.hashCode();
            result = 31 * result + (this.executionNamePrefix != null ? this.executionNamePrefix.hashCode() : 0);
            result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
            result = 31 * result + (this.stateMachineInput != null ? this.stateMachineInput.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.actionName.hashCode());
            result = 31 * result + (this.runOrder != null ? this.runOrder.hashCode() : 0);
            result = 31 * result + (this.variablesNamespace != null ? this.variablesNamespace.hashCode() : 0);
            return result;
        }
    }
}
