package software.amazon.awscdk.services.cognito;

/**
 * (experimental) Options to create a UserPoolClient.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:20.035Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolClientOptions")
@software.amazon.jsii.Jsii.Proxy(UserPoolClientOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface UserPoolClientOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * (experimental) Validity of the access token.
     * <p>
     * Values between 5 minutes and 1 day are valid. The duration can not be longer than the refresh token validity.
     * <p>
     * Default: Duration.minutes(60)
     * <p>
     * @see https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-access-token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getAccessTokenValidity() {
        return null;
    }

    /**
     * (experimental) The set of OAuth authentication flows to enable on the client.
     * <p>
     * Default: - all auth flows disabled
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-authentication-flow.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.AuthFlow getAuthFlows() {
        return null;
    }

    /**
     * (experimental) Turns off all OAuth interactions for this client.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableOAuth() {
        return null;
    }

    /**
     * (experimental) Whether to generate a client secret.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getGenerateSecret() {
        return null;
    }

    /**
     * (experimental) Validity of the ID token.
     * <p>
     * Values between 5 minutes and 1 day are valid. The duration can not be longer than the refresh token validity.
     * <p>
     * Default: Duration.minutes(60)
     * <p>
     * @see https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-id-token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getIdTokenValidity() {
        return null;
    }

    /**
     * (experimental) OAuth settings for this client to interact with the app.
     * <p>
     * An error is thrown when this is specified and <code>disableOAuth</code> is set.
     * <p>
     * Default: - see defaults in `OAuthSettings`. meaningless if `disableOAuth` is set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.OAuthSettings getOAuth() {
        return null;
    }

    /**
     * (experimental) Whether Cognito returns a UserNotFoundException exception when the user does not exist in the user pool (false), or whether it returns another type of error that doesn't reveal the user's absence.
     * <p>
     * Default: true for new stacks
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-managing-errors.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPreventUserExistenceErrors() {
        return null;
    }

    /**
     * (experimental) The set of attributes this client will be able to read.
     * <p>
     * Default: - all standard and custom attributes
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-attribute-permissions-and-scopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ClientAttributes getReadAttributes() {
        return null;
    }

    /**
     * (experimental) Validity of the refresh token.
     * <p>
     * Values between 60 minutes and 10 years are valid.
     * <p>
     * Default: Duration.days(30)
     * <p>
     * @see https://docs.aws.amazon.com/en_us/cognito/latest/developerguide/amazon-cognito-user-pools-using-tokens-with-identity-providers.html#amazon-cognito-user-pools-using-the-refresh-token
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getRefreshTokenValidity() {
        return null;
    }

    /**
     * (experimental) The list of identity providers that users should be able to use to sign in using this client.
     * <p>
     * Default: - supports all identity providers that are registered with the user pool. If the user pool and/or
     * identity providers are imported, either specify this option explicitly or ensure that the identity providers are
     * registered with the user pool using the `UserPool.registerIdentityProvider()` API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> getSupportedIdentityProviders() {
        return null;
    }

    /**
     * (experimental) Name of the application client.
     * <p>
     * Default: - cloudformation generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolClientName() {
        return null;
    }

    /**
     * (experimental) The set of attributes this client will be able to write.
     * <p>
     * Default: - all standard and custom attributes
     * <p>
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-attributes.html#user-pool-settings-attribute-permissions-and-scopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cognito.ClientAttributes getWriteAttributes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UserPoolClientOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UserPoolClientOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<UserPoolClientOptions> {
        private software.amazon.awscdk.Duration accessTokenValidity;
        private software.amazon.awscdk.services.cognito.AuthFlow authFlows;
        private java.lang.Boolean disableOAuth;
        private java.lang.Boolean generateSecret;
        private software.amazon.awscdk.Duration idTokenValidity;
        private software.amazon.awscdk.services.cognito.OAuthSettings oAuth;
        private java.lang.Boolean preventUserExistenceErrors;
        private software.amazon.awscdk.services.cognito.ClientAttributes readAttributes;
        private software.amazon.awscdk.Duration refreshTokenValidity;
        private java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders;
        private java.lang.String userPoolClientName;
        private software.amazon.awscdk.services.cognito.ClientAttributes writeAttributes;

        /**
         * Sets the value of {@link UserPoolClientOptions#getAccessTokenValidity}
         * @param accessTokenValidity Validity of the access token.
         *                            Values between 5 minutes and 1 day are valid. The duration can not be longer than the refresh token validity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder accessTokenValidity(software.amazon.awscdk.Duration accessTokenValidity) {
            this.accessTokenValidity = accessTokenValidity;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getAuthFlows}
         * @param authFlows The set of OAuth authentication flows to enable on the client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder authFlows(software.amazon.awscdk.services.cognito.AuthFlow authFlows) {
            this.authFlows = authFlows;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getDisableOAuth}
         * @param disableOAuth Turns off all OAuth interactions for this client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder disableOAuth(java.lang.Boolean disableOAuth) {
            this.disableOAuth = disableOAuth;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getGenerateSecret}
         * @param generateSecret Whether to generate a client secret.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder generateSecret(java.lang.Boolean generateSecret) {
            this.generateSecret = generateSecret;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getIdTokenValidity}
         * @param idTokenValidity Validity of the ID token.
         *                        Values between 5 minutes and 1 day are valid. The duration can not be longer than the refresh token validity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder idTokenValidity(software.amazon.awscdk.Duration idTokenValidity) {
            this.idTokenValidity = idTokenValidity;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getOAuth}
         * @param oAuth OAuth settings for this client to interact with the app.
         *              An error is thrown when this is specified and <code>disableOAuth</code> is set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder oAuth(software.amazon.awscdk.services.cognito.OAuthSettings oAuth) {
            this.oAuth = oAuth;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getPreventUserExistenceErrors}
         * @param preventUserExistenceErrors Whether Cognito returns a UserNotFoundException exception when the user does not exist in the user pool (false), or whether it returns another type of error that doesn't reveal the user's absence.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder preventUserExistenceErrors(java.lang.Boolean preventUserExistenceErrors) {
            this.preventUserExistenceErrors = preventUserExistenceErrors;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getReadAttributes}
         * @param readAttributes The set of attributes this client will be able to read.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder readAttributes(software.amazon.awscdk.services.cognito.ClientAttributes readAttributes) {
            this.readAttributes = readAttributes;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getRefreshTokenValidity}
         * @param refreshTokenValidity Validity of the refresh token.
         *                             Values between 60 minutes and 10 years are valid.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder refreshTokenValidity(software.amazon.awscdk.Duration refreshTokenValidity) {
            this.refreshTokenValidity = refreshTokenValidity;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getSupportedIdentityProviders}
         * @param supportedIdentityProviders The list of identity providers that users should be able to use to sign in using this client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder supportedIdentityProviders(java.util.List<? extends software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders) {
            this.supportedIdentityProviders = (java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider>)supportedIdentityProviders;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getUserPoolClientName}
         * @param userPoolClientName Name of the application client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder userPoolClientName(java.lang.String userPoolClientName) {
            this.userPoolClientName = userPoolClientName;
            return this;
        }

        /**
         * Sets the value of {@link UserPoolClientOptions#getWriteAttributes}
         * @param writeAttributes The set of attributes this client will be able to write.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder writeAttributes(software.amazon.awscdk.services.cognito.ClientAttributes writeAttributes) {
            this.writeAttributes = writeAttributes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UserPoolClientOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public UserPoolClientOptions build() {
            return new Jsii$Proxy(accessTokenValidity, authFlows, disableOAuth, generateSecret, idTokenValidity, oAuth, preventUserExistenceErrors, readAttributes, refreshTokenValidity, supportedIdentityProviders, userPoolClientName, writeAttributes);
        }
    }

    /**
     * An implementation for {@link UserPoolClientOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UserPoolClientOptions {
        private final software.amazon.awscdk.Duration accessTokenValidity;
        private final software.amazon.awscdk.services.cognito.AuthFlow authFlows;
        private final java.lang.Boolean disableOAuth;
        private final java.lang.Boolean generateSecret;
        private final software.amazon.awscdk.Duration idTokenValidity;
        private final software.amazon.awscdk.services.cognito.OAuthSettings oAuth;
        private final java.lang.Boolean preventUserExistenceErrors;
        private final software.amazon.awscdk.services.cognito.ClientAttributes readAttributes;
        private final software.amazon.awscdk.Duration refreshTokenValidity;
        private final java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders;
        private final java.lang.String userPoolClientName;
        private final software.amazon.awscdk.services.cognito.ClientAttributes writeAttributes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accessTokenValidity = software.amazon.jsii.Kernel.get(this, "accessTokenValidity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.authFlows = software.amazon.jsii.Kernel.get(this, "authFlows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.AuthFlow.class));
            this.disableOAuth = software.amazon.jsii.Kernel.get(this, "disableOAuth", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.generateSecret = software.amazon.jsii.Kernel.get(this, "generateSecret", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.idTokenValidity = software.amazon.jsii.Kernel.get(this, "idTokenValidity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.oAuth = software.amazon.jsii.Kernel.get(this, "oAuth", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.OAuthSettings.class));
            this.preventUserExistenceErrors = software.amazon.jsii.Kernel.get(this, "preventUserExistenceErrors", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.readAttributes = software.amazon.jsii.Kernel.get(this, "readAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ClientAttributes.class));
            this.refreshTokenValidity = software.amazon.jsii.Kernel.get(this, "refreshTokenValidity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.supportedIdentityProviders = software.amazon.jsii.Kernel.get(this, "supportedIdentityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider.class)));
            this.userPoolClientName = software.amazon.jsii.Kernel.get(this, "userPoolClientName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.writeAttributes = software.amazon.jsii.Kernel.get(this, "writeAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.ClientAttributes.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.Duration accessTokenValidity, final software.amazon.awscdk.services.cognito.AuthFlow authFlows, final java.lang.Boolean disableOAuth, final java.lang.Boolean generateSecret, final software.amazon.awscdk.Duration idTokenValidity, final software.amazon.awscdk.services.cognito.OAuthSettings oAuth, final java.lang.Boolean preventUserExistenceErrors, final software.amazon.awscdk.services.cognito.ClientAttributes readAttributes, final software.amazon.awscdk.Duration refreshTokenValidity, final java.util.List<? extends software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> supportedIdentityProviders, final java.lang.String userPoolClientName, final software.amazon.awscdk.services.cognito.ClientAttributes writeAttributes) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accessTokenValidity = accessTokenValidity;
            this.authFlows = authFlows;
            this.disableOAuth = disableOAuth;
            this.generateSecret = generateSecret;
            this.idTokenValidity = idTokenValidity;
            this.oAuth = oAuth;
            this.preventUserExistenceErrors = preventUserExistenceErrors;
            this.readAttributes = readAttributes;
            this.refreshTokenValidity = refreshTokenValidity;
            this.supportedIdentityProviders = (java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider>)supportedIdentityProviders;
            this.userPoolClientName = userPoolClientName;
            this.writeAttributes = writeAttributes;
        }

        @Override
        public final software.amazon.awscdk.Duration getAccessTokenValidity() {
            return this.accessTokenValidity;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.AuthFlow getAuthFlows() {
            return this.authFlows;
        }

        @Override
        public final java.lang.Boolean getDisableOAuth() {
            return this.disableOAuth;
        }

        @Override
        public final java.lang.Boolean getGenerateSecret() {
            return this.generateSecret;
        }

        @Override
        public final software.amazon.awscdk.Duration getIdTokenValidity() {
            return this.idTokenValidity;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.OAuthSettings getOAuth() {
            return this.oAuth;
        }

        @Override
        public final java.lang.Boolean getPreventUserExistenceErrors() {
            return this.preventUserExistenceErrors;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ClientAttributes getReadAttributes() {
            return this.readAttributes;
        }

        @Override
        public final software.amazon.awscdk.Duration getRefreshTokenValidity() {
            return this.refreshTokenValidity;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cognito.UserPoolClientIdentityProvider> getSupportedIdentityProviders() {
            return this.supportedIdentityProviders;
        }

        @Override
        public final java.lang.String getUserPoolClientName() {
            return this.userPoolClientName;
        }

        @Override
        public final software.amazon.awscdk.services.cognito.ClientAttributes getWriteAttributes() {
            return this.writeAttributes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAccessTokenValidity() != null) {
                data.set("accessTokenValidity", om.valueToTree(this.getAccessTokenValidity()));
            }
            if (this.getAuthFlows() != null) {
                data.set("authFlows", om.valueToTree(this.getAuthFlows()));
            }
            if (this.getDisableOAuth() != null) {
                data.set("disableOAuth", om.valueToTree(this.getDisableOAuth()));
            }
            if (this.getGenerateSecret() != null) {
                data.set("generateSecret", om.valueToTree(this.getGenerateSecret()));
            }
            if (this.getIdTokenValidity() != null) {
                data.set("idTokenValidity", om.valueToTree(this.getIdTokenValidity()));
            }
            if (this.getOAuth() != null) {
                data.set("oAuth", om.valueToTree(this.getOAuth()));
            }
            if (this.getPreventUserExistenceErrors() != null) {
                data.set("preventUserExistenceErrors", om.valueToTree(this.getPreventUserExistenceErrors()));
            }
            if (this.getReadAttributes() != null) {
                data.set("readAttributes", om.valueToTree(this.getReadAttributes()));
            }
            if (this.getRefreshTokenValidity() != null) {
                data.set("refreshTokenValidity", om.valueToTree(this.getRefreshTokenValidity()));
            }
            if (this.getSupportedIdentityProviders() != null) {
                data.set("supportedIdentityProviders", om.valueToTree(this.getSupportedIdentityProviders()));
            }
            if (this.getUserPoolClientName() != null) {
                data.set("userPoolClientName", om.valueToTree(this.getUserPoolClientName()));
            }
            if (this.getWriteAttributes() != null) {
                data.set("writeAttributes", om.valueToTree(this.getWriteAttributes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.UserPoolClientOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UserPoolClientOptions.Jsii$Proxy that = (UserPoolClientOptions.Jsii$Proxy) o;

            if (this.accessTokenValidity != null ? !this.accessTokenValidity.equals(that.accessTokenValidity) : that.accessTokenValidity != null) return false;
            if (this.authFlows != null ? !this.authFlows.equals(that.authFlows) : that.authFlows != null) return false;
            if (this.disableOAuth != null ? !this.disableOAuth.equals(that.disableOAuth) : that.disableOAuth != null) return false;
            if (this.generateSecret != null ? !this.generateSecret.equals(that.generateSecret) : that.generateSecret != null) return false;
            if (this.idTokenValidity != null ? !this.idTokenValidity.equals(that.idTokenValidity) : that.idTokenValidity != null) return false;
            if (this.oAuth != null ? !this.oAuth.equals(that.oAuth) : that.oAuth != null) return false;
            if (this.preventUserExistenceErrors != null ? !this.preventUserExistenceErrors.equals(that.preventUserExistenceErrors) : that.preventUserExistenceErrors != null) return false;
            if (this.readAttributes != null ? !this.readAttributes.equals(that.readAttributes) : that.readAttributes != null) return false;
            if (this.refreshTokenValidity != null ? !this.refreshTokenValidity.equals(that.refreshTokenValidity) : that.refreshTokenValidity != null) return false;
            if (this.supportedIdentityProviders != null ? !this.supportedIdentityProviders.equals(that.supportedIdentityProviders) : that.supportedIdentityProviders != null) return false;
            if (this.userPoolClientName != null ? !this.userPoolClientName.equals(that.userPoolClientName) : that.userPoolClientName != null) return false;
            return this.writeAttributes != null ? this.writeAttributes.equals(that.writeAttributes) : that.writeAttributes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.accessTokenValidity != null ? this.accessTokenValidity.hashCode() : 0;
            result = 31 * result + (this.authFlows != null ? this.authFlows.hashCode() : 0);
            result = 31 * result + (this.disableOAuth != null ? this.disableOAuth.hashCode() : 0);
            result = 31 * result + (this.generateSecret != null ? this.generateSecret.hashCode() : 0);
            result = 31 * result + (this.idTokenValidity != null ? this.idTokenValidity.hashCode() : 0);
            result = 31 * result + (this.oAuth != null ? this.oAuth.hashCode() : 0);
            result = 31 * result + (this.preventUserExistenceErrors != null ? this.preventUserExistenceErrors.hashCode() : 0);
            result = 31 * result + (this.readAttributes != null ? this.readAttributes.hashCode() : 0);
            result = 31 * result + (this.refreshTokenValidity != null ? this.refreshTokenValidity.hashCode() : 0);
            result = 31 * result + (this.supportedIdentityProviders != null ? this.supportedIdentityProviders.hashCode() : 0);
            result = 31 * result + (this.userPoolClientName != null ? this.userPoolClientName.hashCode() : 0);
            result = 31 * result + (this.writeAttributes != null ? this.writeAttributes.hashCode() : 0);
            return result;
        }
    }
}
