package software.amazon.awscdk.services.ecs;

/**
 * (experimental) The base class for Ec2Service and FargateService services.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:20.450Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.BaseService")
public abstract class BaseService extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.ecs.IBaseService, software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget, software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget, software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget {

    protected BaseService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected BaseService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Constructs a new instance of the BaseService class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     * @param additionalProps This parameter is required.
     * @param taskDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected BaseService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.BaseServiceProps props, final @org.jetbrains.annotations.NotNull java.lang.Object additionalProps, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition taskDefinition) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required"), additionalProps, java.util.Objects.requireNonNull(taskDefinition, "taskDefinition is required") });
    }

    /**
     * (experimental) Associates this service with a CloudMap service.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void associateCloudMapService(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.AssociateCloudMapServiceOptions options) {
        software.amazon.jsii.Kernel.call(this, "associateCloudMapService", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) This method is called to attach this service to an Application Load Balancer.
     * <p>
     * Don't call this function directly. Instead, call <code>listener.addTargets()</code>
     * to add this service to a load balancer.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToApplicationTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup targetGroup) {
        return software.amazon.jsii.Kernel.call(this, "attachToApplicationTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * (experimental) Registers the service as a target of a Classic Load Balancer (CLB).
     * <p>
     * Don't call this. Call <code>loadBalancer.addTarget()</code> instead.
     * <p>
     * @param loadBalancer This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void attachToClassicLB(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancing.LoadBalancer loadBalancer) {
        software.amazon.jsii.Kernel.call(this, "attachToClassicLB", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(loadBalancer, "loadBalancer is required") });
    }

    /**
     * (experimental) This method is called to attach this service to a Network Load Balancer.
     * <p>
     * Don't call this function directly. Instead, call <code>listener.addTargets()</code>
     * to add this service to a load balancer.
     * <p>
     * @param targetGroup This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps attachToNetworkTargetGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.INetworkTargetGroup targetGroup) {
        return software.amazon.jsii.Kernel.call(this, "attachToNetworkTargetGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.LoadBalancerTargetProps.class), new Object[] { java.util.Objects.requireNonNull(targetGroup, "targetGroup is required") });
    }

    /**
     * (experimental) An attribute representing the minimum and maximum task count for an AutoScalingGroup.
     * <p>
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ScalableTaskCount autoScaleTaskCount(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.applicationautoscaling.EnableScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "autoScaleTaskCount", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ScalableTaskCount.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * (experimental) This method is called to create a networkConfiguration.
     * <p>
     * @param vpc This parameter is required.
     * @param assignPublicIp
     * @param vpcSubnets
     * @param securityGroups
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean assignPublicIp, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets, final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
        software.amazon.jsii.Kernel.call(this, "configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets, securityGroups });
    }

    /**
     * (experimental) This method is called to create a networkConfiguration.
     * <p>
     * @param vpc This parameter is required.
     * @param assignPublicIp
     * @param vpcSubnets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean assignPublicIp, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
        software.amazon.jsii.Kernel.call(this, "configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp, vpcSubnets });
    }

    /**
     * (experimental) This method is called to create a networkConfiguration.
     * <p>
     * @param vpc This parameter is required.
     * @param assignPublicIp
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc, final @org.jetbrains.annotations.Nullable java.lang.Boolean assignPublicIp) {
        software.amazon.jsii.Kernel.call(this, "configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required"), assignPublicIp });
    }

    /**
     * (experimental) This method is called to create a networkConfiguration.
     * <p>
     * @param vpc This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void configureAwsVpcNetworkingWithSecurityGroups(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc vpc) {
        software.amazon.jsii.Kernel.call(this, "configureAwsVpcNetworkingWithSecurityGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(vpc, "vpc is required") });
    }

    /**
     * (experimental) Enable CloudMap service discovery for the service.
     * <p>
     * @return The created CloudMap service
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.servicediscovery.Service enableCloudMap(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CloudMapOptions options) {
        return software.amazon.jsii.Kernel.call(this, "enableCloudMap", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.Service.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) Return a load balancing target for a specific container and port.
     * <p>
     * Use this function to create a load balancer target if you want to load balance to
     * another container than the first essential container or the first mapped port on
     * the container.
     * <p>
     * Use the return value of this function where you would normally use a load balancer
     * target, instead of the <code>Service</code> object itself.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * listener.addTargets("ECS", Map.of(
     *         "port", 80,
     *         "targets", asList(service.loadBalancerTarget(Map.of(
     *                 "containerName", "MyContainer",
     *                 "containerPort", 1234)))));}</pre></blockquote>
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.IEcsLoadBalancerTarget loadBalancerTarget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LoadBalancerTargetOptions options) {
        return software.amazon.jsii.Kernel.call(this, "loadBalancerTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.IEcsLoadBalancerTarget.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * (experimental) This method returns the specified CloudWatch metric name for this service.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * (experimental) This method returns the specified CloudWatch metric name for this service.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * (experimental) This method returns the CloudWatch metric for this service's CPU utilization.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricCpuUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) This method returns the CloudWatch metric for this service's CPU utilization.
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricCpuUtilization() {
        return software.amazon.jsii.Kernel.call(this, "metricCpuUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) This method returns the CloudWatch metric for this service's memory utilization.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMemoryUtilization(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metricMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { props });
    }

    /**
     * (experimental) This method returns the CloudWatch metric for this service's memory utilization.
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricMemoryUtilization() {
        return software.amazon.jsii.Kernel.call(this, "metricMemoryUtilization", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class));
    }

    /**
     * (experimental) Use this function to create all load balancer targets to be registered in this service, add them to target groups, and attach target groups to listeners accordingly.
     * <p>
     * Alternatively, you can use <code>listener.addTargets()</code> to create targets and add them to target groups.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * service.registerLoadBalancerTargets(Map.of(
     *         "containerName", "web",
     *         "containerPort", 80,
     *         "newTargetGroupId", "ECS",
     *         "listener", ecs.ListenerConfig.applicationListener(listener, Map.of(
     *                 "protocol", elbv2.ApplicationProtocol.getHTTPS()))));}</pre></blockquote>
     * <p>
     * @param targets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void registerLoadBalancerTargets(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsTarget... targets) {
        software.amazon.jsii.Kernel.call(this, "registerLoadBalancerTargets", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(targets).toArray(Object[]::new));
    }

    /**
     * (experimental) The cluster that hosts the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ICluster getCluster() {
        return software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
    }

    /**
     * (experimental) The security groups which manage the allowed network traffic for the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * (experimental) The Amazon Resource Name (ARN) of the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceArn() {
        return software.amazon.jsii.Kernel.get(this, "serviceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The name of the service.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull java.lang.String getServiceName() {
        return software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (experimental) The task definition to use for tasks in the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.TaskDefinition getTaskDefinition() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.TaskDefinition.class));
    }

    /**
     * (experimental) The CloudMap service created for this service, if any.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.IService getCloudMapService() {
        return software.amazon.jsii.Kernel.get(this, "cloudMapService", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.IService.class));
    }

    /**
     * (experimental) A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty> getLoadBalancers() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "loadBalancers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty.class))));
    }

    /**
     * (experimental) A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setLoadBalancers(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty> value) {
        software.amazon.jsii.Kernel.set(this, "loadBalancers", java.util.Objects.requireNonNull(value, "loadBalancers is required"));
    }

    /**
     * (experimental) The details of the service discovery registries to assign to this service.
     * <p>
     * For more information, see Service Discovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty> getServiceRegistries() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "serviceRegistries", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty.class))));
    }

    /**
     * (experimental) The details of the service discovery registries to assign to this service.
     * <p>
     * For more information, see Service Discovery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setServiceRegistries(final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty> value) {
        software.amazon.jsii.Kernel.set(this, "serviceRegistries", java.util.Objects.requireNonNull(value, "serviceRegistries is required"));
    }

    /**
     * (experimental) The details of the AWS Cloud Map service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.Service getCloudmapService() {
        return software.amazon.jsii.Kernel.get(this, "cloudmapService", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.servicediscovery.Service.class));
    }

    /**
     * (experimental) The details of the AWS Cloud Map service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setCloudmapService(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.servicediscovery.Service value) {
        software.amazon.jsii.Kernel.set(this, "cloudmapService", value);
    }

    /**
     * (experimental) A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty getNetworkConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty.class));
    }

    /**
     * (experimental) A list of Elastic Load Balancing load balancer objects, containing the load balancer name, the container name (as it appears in a container definition), and the container port to access from the load balancer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    protected void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.ecs.BaseService implements software.amazon.awscdk.services.ecs.IBaseService.Jsii$Default, software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancerTarget.Jsii$Default, software.amazon.awscdk.services.elasticloadbalancingv2.INetworkLoadBalancerTarget.Jsii$Default, software.amazon.awscdk.services.elasticloadbalancing.ILoadBalancerTarget.Jsii$Default, software.amazon.awscdk.IResource.Jsii$Default, software.constructs.IConstruct.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
