package software.amazon.awscdk.services.ecs;

/**
 * (experimental) Linux-specific options that are applied to the container.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:20.539Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.LinuxParameters")
public class LinuxParameters extends software.constructs.Construct {

    protected LinuxParameters(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LinuxParameters(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * (experimental) Constructs a new instance of the LinuxParameters class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public LinuxParameters(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.LinuxParametersProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * (experimental) Constructs a new instance of the LinuxParameters class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public LinuxParameters(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * (experimental) Adds one or more Linux capabilities to the Docker configuration of a container.
     * <p>
     * Only works with EC2 launch type.
     * <p>
     * @param cap This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addCapabilities(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Capability... cap) {
        software.amazon.jsii.Kernel.call(this, "addCapabilities", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(cap).toArray(Object[]::new));
    }

    /**
     * (experimental) Adds one or more host devices to a container.
     * <p>
     * @param device This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addDevices(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Device... device) {
        software.amazon.jsii.Kernel.call(this, "addDevices", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(device).toArray(Object[]::new));
    }

    /**
     * (experimental) Specifies the container path, mount options, and size (in MiB) of the tmpfs mount for a container.
     * <p>
     * Only works with EC2 launch type.
     * <p>
     * @param tmpfs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void addTmpfs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Tmpfs... tmpfs) {
        software.amazon.jsii.Kernel.call(this, "addTmpfs", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(tmpfs).toArray(Object[]::new));
    }

    /**
     * (experimental) Removes one or more Linux capabilities to the Docker configuration of a container.
     * <p>
     * Only works with EC2 launch type.
     * <p>
     * @param cap This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public void dropCapabilities(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.Capability... cap) {
        software.amazon.jsii.Kernel.call(this, "dropCapabilities", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(cap).toArray(Object[]::new));
    }

    /**
     * (experimental) Renders the Linux parameters to a CloudFormation object.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.CfnTaskDefinition.LinuxParametersProperty renderLinuxParameters() {
        return software.amazon.jsii.Kernel.call(this, "renderLinuxParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.CfnTaskDefinition.LinuxParametersProperty.class));
    }

    /**
     * (experimental) A fluent builder for {@link software.amazon.awscdk.services.ecs.LinuxParameters}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.LinuxParameters> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.LinuxParametersProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * (experimental) Specifies whether to run an init process inside the container that forwards signals and reaps processes.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param initProcessEnabled Specifies whether to run an init process inside the container that forwards signals and reaps processes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder initProcessEnabled(final java.lang.Boolean initProcessEnabled) {
            this.props().initProcessEnabled(initProcessEnabled);
            return this;
        }

        /**
         * (experimental) The value for the size (in MiB) of the /dev/shm volume.
         * <p>
         * Default: No shared memory.
         * <p>
         * @return {@code this}
         * @param sharedMemorySize The value for the size (in MiB) of the /dev/shm volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sharedMemorySize(final java.lang.Number sharedMemorySize) {
            this.props().sharedMemorySize(sharedMemorySize);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.ecs.LinuxParameters}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public software.amazon.awscdk.services.ecs.LinuxParameters build() {
            return new software.amazon.awscdk.services.ecs.LinuxParameters(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.LinuxParametersProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.LinuxParametersProps.Builder();
            }
            return this.props;
        }
    }
}
