package software.amazon.awscdk.services.ecs.patterns;

/**
 * (experimental) The properties for the QueueProcessingFargateService service.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:20.601Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.QueueProcessingFargateServiceProps")
@software.amazon.jsii.Jsii.Proxy(QueueProcessingFargateServiceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface QueueProcessingFargateServiceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ecs.patterns.QueueProcessingServiceBaseProps {

    /**
     * (experimental) Specifies whether the task's elastic network interface receives a public IP address.
     * <p>
     * If true, each task will receive a public IP address.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssignPublicIp() {
        return null;
    }

    /**
     * (experimental) Optional name for the container added.
     * <p>
     * Default: - QueueProcessingContainer
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.String getContainerName() {
        return null;
    }

    /**
     * (experimental) The number of cpu units used by the task.
     * <p>
     * Valid values, which determines your range of valid values for the memory parameter:
     * <p>
     * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
     * <p>
     * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
     * <p>
     * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
     * <p>
     * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
     * <p>
     * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
     * <p>
     * This default is set in the underlying FargateTaskDefinition construct.
     * <p>
     * Default: 256
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCpu() {
        return null;
    }

    /**
     * (experimental) The amount (in MiB) of memory used by the task.
     * <p>
     * This field is required and you must use one of the following values, which determines your range of valid values
     * for the cpu parameter:
     * <p>
     * 0.5GB, 1GB, 2GB - Available cpu values: 256 (.25 vCPU)
     * <p>
     * 1GB, 2GB, 3GB, 4GB - Available cpu values: 512 (.5 vCPU)
     * <p>
     * 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB - Available cpu values: 1024 (1 vCPU)
     * <p>
     * Between 4GB and 16GB in 1GB increments - Available cpu values: 2048 (2 vCPU)
     * <p>
     * Between 8GB and 30GB in 1GB increments - Available cpu values: 4096 (4 vCPU)
     * <p>
     * This default is set in the underlying FargateTaskDefinition construct.
     * <p>
     * Default: 512
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemoryLimitMiB() {
        return null;
    }

    /**
     * (experimental) The platform version on which to run your service.
     * <p>
     * If one is not specified, the LATEST platform version is used by default. For more information, see
     * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a>
     * in the Amazon Elastic Container Service Developer Guide.
     * <p>
     * Default: Latest
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
        return null;
    }

    /**
     * (experimental) The security groups to associate with the service.
     * <p>
     * If you do not specify a security group, the default security group for the VPC is used.
     * <p>
     * Default: - A new security group is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
        return null;
    }

    /**
     * (experimental) The subnets to associate with the service.
     * <p>
     * Default: - Public subnets if `assignPublicIp` is set, otherwise the first available one of Private, Isolated, Public, in that order.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getTaskSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link QueueProcessingFargateServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueueProcessingFargateServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<QueueProcessingFargateServiceProps> {
        private java.lang.Boolean assignPublicIp;
        private java.lang.String containerName;
        private java.lang.Number cpu;
        private java.lang.Number memoryLimitMiB;
        private software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        private java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private software.amazon.awscdk.services.ec2.SubnetSelection taskSubnets;
        private software.amazon.awscdk.services.ecs.ContainerImage image;
        private software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker;
        private software.amazon.awscdk.services.ecs.ICluster cluster;
        private java.util.List<java.lang.String> command;
        private software.amazon.awscdk.services.ecs.DeploymentController deploymentController;
        private java.lang.Boolean enableEcsManagedTags;
        private java.lang.Boolean enableLogging;
        private java.util.Map<java.lang.String, java.lang.String> environment;
        private java.lang.String family;
        private software.amazon.awscdk.services.ecs.LogDriver logDriver;
        private java.lang.Number maxHealthyPercent;
        private java.lang.Number maxReceiveCount;
        private java.lang.Number maxScalingCapacity;
        private java.lang.Number minHealthyPercent;
        private java.lang.Number minScalingCapacity;
        private software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private software.amazon.awscdk.services.sqs.IQueue queue;
        private software.amazon.awscdk.Duration retentionPeriod;
        private java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;
        private java.lang.String serviceName;
        private software.amazon.awscdk.Duration visibilityTimeout;
        private software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getAssignPublicIp}
         * @param assignPublicIp Specifies whether the task's elastic network interface receives a public IP address.
         *                       If true, each task will receive a public IP address.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder assignPublicIp(java.lang.Boolean assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getContainerName}
         * @param containerName Optional name for the container added.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder containerName(java.lang.String containerName) {
            this.containerName = containerName;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getCpu}
         * @param cpu The number of cpu units used by the task.
         *            Valid values, which determines your range of valid values for the memory parameter:
         *            <p>
         *            256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
         *            <p>
         *            512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
         *            <p>
         *            1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
         *            <p>
         *            2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
         *            <p>
         *            4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
         *            <p>
         *            This default is set in the underlying FargateTaskDefinition construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cpu(java.lang.Number cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getMemoryLimitMiB}
         * @param memoryLimitMiB The amount (in MiB) of memory used by the task.
         *                       This field is required and you must use one of the following values, which determines your range of valid values
         *                       for the cpu parameter:
         *                       <p>
         *                       0.5GB, 1GB, 2GB - Available cpu values: 256 (.25 vCPU)
         *                       <p>
         *                       1GB, 2GB, 3GB, 4GB - Available cpu values: 512 (.5 vCPU)
         *                       <p>
         *                       2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB - Available cpu values: 1024 (1 vCPU)
         *                       <p>
         *                       Between 4GB and 16GB in 1GB increments - Available cpu values: 2048 (2 vCPU)
         *                       <p>
         *                       Between 8GB and 30GB in 1GB increments - Available cpu values: 4096 (4 vCPU)
         *                       <p>
         *                       This default is set in the underlying FargateTaskDefinition construct.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder memoryLimitMiB(java.lang.Number memoryLimitMiB) {
            this.memoryLimitMiB = memoryLimitMiB;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getPlatformVersion}
         * @param platformVersion The platform version on which to run your service.
         *                        If one is not specified, the LATEST platform version is used by default. For more information, see
         *                        <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a>
         *                        in the Amazon Elastic Container Service Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder platformVersion(software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getSecurityGroups}
         * @param securityGroups The security groups to associate with the service.
         *                       If you do not specify a security group, the default security group for the VPC is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getTaskSubnets}
         * @param taskSubnets The subnets to associate with the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder taskSubnets(software.amazon.awscdk.services.ec2.SubnetSelection taskSubnets) {
            this.taskSubnets = taskSubnets;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getImage}
         * @param image The image used to start a container. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder image(software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.image = image;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getCircuitBreaker}
         * @param circuitBreaker Whether to enable the deployment circuit breaker.
         *                       If this property is defined, circuit breaker will be implicitly
         *                       enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder circuitBreaker(software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker) {
            this.circuitBreaker = circuitBreaker;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getCluster}
         * @param cluster The name of the cluster that hosts the service.
         *                If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder cluster(software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.cluster = cluster;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getCommand}
         * @param command The command that is passed to the container.
         *                If you provide a shell command as a single string, you have to quote command-line arguments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder command(java.util.List<java.lang.String> command) {
            this.command = command;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getDeploymentController}
         * @param deploymentController Specifies which deployment controller to use for the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder deploymentController(software.amazon.awscdk.services.ecs.DeploymentController deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getEnableEcsManagedTags}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         *                             For more information, see
         *                             <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableEcsManagedTags(java.lang.Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getEnableLogging}
         * @param enableLogging Flag to indicate whether to enable logging.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder enableLogging(java.lang.Boolean enableLogging) {
            this.enableLogging = enableLogging;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getEnvironment}
         * @param environment The environment variables to pass to the container.
         *                    The variable <code>QUEUE_NAME</code> with value <code>queue.queueName</code> will
         *                    always be passed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder environment(java.util.Map<java.lang.String, java.lang.String> environment) {
            this.environment = environment;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getFamily}
         * @param family The name of a family that the task definition is registered to.
         *               A family groups multiple versions of a task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder family(java.lang.String family) {
            this.family = family;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getLogDriver}
         * @param logDriver The log driver to use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder logDriver(software.amazon.awscdk.services.ecs.LogDriver logDriver) {
            this.logDriver = logDriver;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getMaxHealthyPercent}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxHealthyPercent(java.lang.Number maxHealthyPercent) {
            this.maxHealthyPercent = maxHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getMaxReceiveCount}
         * @param maxReceiveCount The maximum number of times that a message can be received by consumers.
         *                        When this value is exceeded for a message the message will be automatically sent to the Dead Letter Queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxReceiveCount(java.lang.Number maxReceiveCount) {
            this.maxReceiveCount = maxReceiveCount;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getMaxScalingCapacity}
         * @param maxScalingCapacity Maximum capacity to scale to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder maxScalingCapacity(java.lang.Number maxScalingCapacity) {
            this.maxScalingCapacity = maxScalingCapacity;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getMinHealthyPercent}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minHealthyPercent(java.lang.Number minHealthyPercent) {
            this.minHealthyPercent = minHealthyPercent;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getMinScalingCapacity}
         * @param minScalingCapacity Minimum capacity to scale to.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder minScalingCapacity(java.lang.Number minScalingCapacity) {
            this.minScalingCapacity = minScalingCapacity;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getPropagateTags}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         *                      Tags can only be propagated to the tasks within the service during service creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder propagateTags(software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getQueue}
         * @param queue A queue for which to process items from.
         *              If specified and this is a FIFO queue, the queue name must end in the string '.fifo'. See
         *              <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html">CreateQueue</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder queue(software.amazon.awscdk.services.sqs.IQueue queue) {
            this.queue = queue;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getRetentionPeriod}
         * @param retentionPeriod The number of seconds that Dead Letter Queue retains a message.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder retentionPeriod(software.amazon.awscdk.Duration retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getScalingSteps}
         * @param scalingSteps The intervals for scaling based on the SQS queue's ApproximateNumberOfMessagesVisible metric.
         *                     Maps a range of metric values to a particular scaling behavior. See
         *                     <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Simple and Step Scaling Policies for Amazon EC2 Auto Scaling</a>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder scalingSteps(java.util.List<? extends software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps) {
            this.scalingSteps = (java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval>)scalingSteps;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getSecrets}
         * @param secrets The secret to expose to the container as an environment variable.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder secrets(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secrets) {
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)secrets;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getServiceName}
         * @param serviceName The name of the service.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder serviceName(java.lang.String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getVisibilityTimeout}
         * @param visibilityTimeout Timeout of processing a single message.
         *                          After dequeuing, the processor has this much time to handle the message and delete it from the queue
         *                          before it becomes visible again for dequeueing by another processor. Values must be between 0 and (12 hours).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder visibilityTimeout(software.amazon.awscdk.Duration visibilityTimeout) {
            this.visibilityTimeout = visibilityTimeout;
            return this;
        }

        /**
         * Sets the value of {@link QueueProcessingFargateServiceProps#getVpc}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         *            If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueueProcessingFargateServiceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public QueueProcessingFargateServiceProps build() {
            return new Jsii$Proxy(assignPublicIp, containerName, cpu, memoryLimitMiB, platformVersion, securityGroups, taskSubnets, image, circuitBreaker, cluster, command, deploymentController, enableEcsManagedTags, enableLogging, environment, family, logDriver, maxHealthyPercent, maxReceiveCount, maxScalingCapacity, minHealthyPercent, minScalingCapacity, propagateTags, queue, retentionPeriod, scalingSteps, secrets, serviceName, visibilityTimeout, vpc);
        }
    }

    /**
     * An implementation for {@link QueueProcessingFargateServiceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueueProcessingFargateServiceProps {
        private final java.lang.Boolean assignPublicIp;
        private final java.lang.String containerName;
        private final java.lang.Number cpu;
        private final java.lang.Number memoryLimitMiB;
        private final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final software.amazon.awscdk.services.ec2.SubnetSelection taskSubnets;
        private final software.amazon.awscdk.services.ecs.ContainerImage image;
        private final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker;
        private final software.amazon.awscdk.services.ecs.ICluster cluster;
        private final java.util.List<java.lang.String> command;
        private final software.amazon.awscdk.services.ecs.DeploymentController deploymentController;
        private final java.lang.Boolean enableEcsManagedTags;
        private final java.lang.Boolean enableLogging;
        private final java.util.Map<java.lang.String, java.lang.String> environment;
        private final java.lang.String family;
        private final software.amazon.awscdk.services.ecs.LogDriver logDriver;
        private final java.lang.Number maxHealthyPercent;
        private final java.lang.Number maxReceiveCount;
        private final java.lang.Number maxScalingCapacity;
        private final java.lang.Number minHealthyPercent;
        private final java.lang.Number minScalingCapacity;
        private final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags;
        private final software.amazon.awscdk.services.sqs.IQueue queue;
        private final software.amazon.awscdk.Duration retentionPeriod;
        private final java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> secrets;
        private final java.lang.String serviceName;
        private final software.amazon.awscdk.Duration visibilityTimeout;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.assignPublicIp = software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.memoryLimitMiB = software.amazon.jsii.Kernel.get(this, "memoryLimitMiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.platformVersion = software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargatePlatformVersion.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.taskSubnets = software.amazon.jsii.Kernel.get(this, "taskSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.image = software.amazon.jsii.Kernel.get(this, "image", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ContainerImage.class));
            this.circuitBreaker = software.amazon.jsii.Kernel.get(this, "circuitBreaker", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker.class));
            this.cluster = software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.ICluster.class));
            this.command = software.amazon.jsii.Kernel.get(this, "command", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.deploymentController = software.amazon.jsii.Kernel.get(this, "deploymentController", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.DeploymentController.class));
            this.enableEcsManagedTags = software.amazon.jsii.Kernel.get(this, "enableECSManagedTags", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enableLogging = software.amazon.jsii.Kernel.get(this, "enableLogging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.environment = software.amazon.jsii.Kernel.get(this, "environment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.family = software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logDriver = software.amazon.jsii.Kernel.get(this, "logDriver", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriver.class));
            this.maxHealthyPercent = software.amazon.jsii.Kernel.get(this, "maxHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxReceiveCount = software.amazon.jsii.Kernel.get(this, "maxReceiveCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maxScalingCapacity = software.amazon.jsii.Kernel.get(this, "maxScalingCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minHealthyPercent = software.amazon.jsii.Kernel.get(this, "minHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minScalingCapacity = software.amazon.jsii.Kernel.get(this, "minScalingCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.PropagatedTagSource.class));
            this.queue = software.amazon.jsii.Kernel.get(this, "queue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.retentionPeriod = software.amazon.jsii.Kernel.get(this, "retentionPeriod", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.scalingSteps = software.amazon.jsii.Kernel.get(this, "scalingSteps", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.applicationautoscaling.ScalingInterval.class)));
            this.secrets = software.amazon.jsii.Kernel.get(this, "secrets", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.Secret.class)));
            this.serviceName = software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.visibilityTimeout = software.amazon.jsii.Kernel.get(this, "visibilityTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.lang.Boolean assignPublicIp, final java.lang.String containerName, final java.lang.Number cpu, final java.lang.Number memoryLimitMiB, final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion, final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups, final software.amazon.awscdk.services.ec2.SubnetSelection taskSubnets, final software.amazon.awscdk.services.ecs.ContainerImage image, final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker, final software.amazon.awscdk.services.ecs.ICluster cluster, final java.util.List<java.lang.String> command, final software.amazon.awscdk.services.ecs.DeploymentController deploymentController, final java.lang.Boolean enableEcsManagedTags, final java.lang.Boolean enableLogging, final java.util.Map<java.lang.String, java.lang.String> environment, final java.lang.String family, final software.amazon.awscdk.services.ecs.LogDriver logDriver, final java.lang.Number maxHealthyPercent, final java.lang.Number maxReceiveCount, final java.lang.Number maxScalingCapacity, final java.lang.Number minHealthyPercent, final java.lang.Number minScalingCapacity, final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags, final software.amazon.awscdk.services.sqs.IQueue queue, final software.amazon.awscdk.Duration retentionPeriod, final java.util.List<? extends software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps, final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secrets, final java.lang.String serviceName, final software.amazon.awscdk.Duration visibilityTimeout, final software.amazon.awscdk.services.ec2.IVpc vpc) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.assignPublicIp = assignPublicIp;
            this.containerName = containerName;
            this.cpu = cpu;
            this.memoryLimitMiB = memoryLimitMiB;
            this.platformVersion = platformVersion;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            this.taskSubnets = taskSubnets;
            this.image = java.util.Objects.requireNonNull(image, "image is required");
            this.circuitBreaker = circuitBreaker;
            this.cluster = cluster;
            this.command = command;
            this.deploymentController = deploymentController;
            this.enableEcsManagedTags = enableEcsManagedTags;
            this.enableLogging = enableLogging;
            this.environment = environment;
            this.family = family;
            this.logDriver = logDriver;
            this.maxHealthyPercent = maxHealthyPercent;
            this.maxReceiveCount = maxReceiveCount;
            this.maxScalingCapacity = maxScalingCapacity;
            this.minHealthyPercent = minHealthyPercent;
            this.minScalingCapacity = minScalingCapacity;
            this.propagateTags = propagateTags;
            this.queue = queue;
            this.retentionPeriod = retentionPeriod;
            this.scalingSteps = (java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval>)scalingSteps;
            this.secrets = (java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret>)secrets;
            this.serviceName = serviceName;
            this.visibilityTimeout = visibilityTimeout;
            this.vpc = vpc;
        }

        @Override
        public final java.lang.Boolean getAssignPublicIp() {
            return this.assignPublicIp;
        }

        @Override
        public final java.lang.String getContainerName() {
            return this.containerName;
        }

        @Override
        public final java.lang.Number getCpu() {
            return this.cpu;
        }

        @Override
        public final java.lang.Number getMemoryLimitMiB() {
            return this.memoryLimitMiB;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.FargatePlatformVersion getPlatformVersion() {
            return this.platformVersion;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getTaskSubnets() {
            return this.taskSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ContainerImage getImage() {
            return this.image;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker getCircuitBreaker() {
            return this.circuitBreaker;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.ICluster getCluster() {
            return this.cluster;
        }

        @Override
        public final java.util.List<java.lang.String> getCommand() {
            return this.command;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.DeploymentController getDeploymentController() {
            return this.deploymentController;
        }

        @Override
        public final java.lang.Boolean getEnableECSManagedTags() {
            return this.enableEcsManagedTags;
        }

        @Override
        public final java.lang.Boolean getEnableLogging() {
            return this.enableLogging;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getEnvironment() {
            return this.environment;
        }

        @Override
        public final java.lang.String getFamily() {
            return this.family;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.LogDriver getLogDriver() {
            return this.logDriver;
        }

        @Override
        public final java.lang.Number getMaxHealthyPercent() {
            return this.maxHealthyPercent;
        }

        @Override
        public final java.lang.Number getMaxReceiveCount() {
            return this.maxReceiveCount;
        }

        @Override
        public final java.lang.Number getMaxScalingCapacity() {
            return this.maxScalingCapacity;
        }

        @Override
        public final java.lang.Number getMinHealthyPercent() {
            return this.minHealthyPercent;
        }

        @Override
        public final java.lang.Number getMinScalingCapacity() {
            return this.minScalingCapacity;
        }

        @Override
        public final software.amazon.awscdk.services.ecs.PropagatedTagSource getPropagateTags() {
            return this.propagateTags;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getQueue() {
            return this.queue;
        }

        @Override
        public final software.amazon.awscdk.Duration getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> getScalingSteps() {
            return this.scalingSteps;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.services.ecs.Secret> getSecrets() {
            return this.secrets;
        }

        @Override
        public final java.lang.String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final software.amazon.awscdk.Duration getVisibilityTimeout() {
            return this.visibilityTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAssignPublicIp() != null) {
                data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
            }
            if (this.getContainerName() != null) {
                data.set("containerName", om.valueToTree(this.getContainerName()));
            }
            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getMemoryLimitMiB() != null) {
                data.set("memoryLimitMiB", om.valueToTree(this.getMemoryLimitMiB()));
            }
            if (this.getPlatformVersion() != null) {
                data.set("platformVersion", om.valueToTree(this.getPlatformVersion()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getTaskSubnets() != null) {
                data.set("taskSubnets", om.valueToTree(this.getTaskSubnets()));
            }
            data.set("image", om.valueToTree(this.getImage()));
            if (this.getCircuitBreaker() != null) {
                data.set("circuitBreaker", om.valueToTree(this.getCircuitBreaker()));
            }
            if (this.getCluster() != null) {
                data.set("cluster", om.valueToTree(this.getCluster()));
            }
            if (this.getCommand() != null) {
                data.set("command", om.valueToTree(this.getCommand()));
            }
            if (this.getDeploymentController() != null) {
                data.set("deploymentController", om.valueToTree(this.getDeploymentController()));
            }
            if (this.getEnableECSManagedTags() != null) {
                data.set("enableECSManagedTags", om.valueToTree(this.getEnableECSManagedTags()));
            }
            if (this.getEnableLogging() != null) {
                data.set("enableLogging", om.valueToTree(this.getEnableLogging()));
            }
            if (this.getEnvironment() != null) {
                data.set("environment", om.valueToTree(this.getEnvironment()));
            }
            if (this.getFamily() != null) {
                data.set("family", om.valueToTree(this.getFamily()));
            }
            if (this.getLogDriver() != null) {
                data.set("logDriver", om.valueToTree(this.getLogDriver()));
            }
            if (this.getMaxHealthyPercent() != null) {
                data.set("maxHealthyPercent", om.valueToTree(this.getMaxHealthyPercent()));
            }
            if (this.getMaxReceiveCount() != null) {
                data.set("maxReceiveCount", om.valueToTree(this.getMaxReceiveCount()));
            }
            if (this.getMaxScalingCapacity() != null) {
                data.set("maxScalingCapacity", om.valueToTree(this.getMaxScalingCapacity()));
            }
            if (this.getMinHealthyPercent() != null) {
                data.set("minHealthyPercent", om.valueToTree(this.getMinHealthyPercent()));
            }
            if (this.getMinScalingCapacity() != null) {
                data.set("minScalingCapacity", om.valueToTree(this.getMinScalingCapacity()));
            }
            if (this.getPropagateTags() != null) {
                data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
            }
            if (this.getQueue() != null) {
                data.set("queue", om.valueToTree(this.getQueue()));
            }
            if (this.getRetentionPeriod() != null) {
                data.set("retentionPeriod", om.valueToTree(this.getRetentionPeriod()));
            }
            if (this.getScalingSteps() != null) {
                data.set("scalingSteps", om.valueToTree(this.getScalingSteps()));
            }
            if (this.getSecrets() != null) {
                data.set("secrets", om.valueToTree(this.getSecrets()));
            }
            if (this.getServiceName() != null) {
                data.set("serviceName", om.valueToTree(this.getServiceName()));
            }
            if (this.getVisibilityTimeout() != null) {
                data.set("visibilityTimeout", om.valueToTree(this.getVisibilityTimeout()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs_patterns.QueueProcessingFargateServiceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueueProcessingFargateServiceProps.Jsii$Proxy that = (QueueProcessingFargateServiceProps.Jsii$Proxy) o;

            if (this.assignPublicIp != null ? !this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp != null) return false;
            if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) return false;
            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.memoryLimitMiB != null ? !this.memoryLimitMiB.equals(that.memoryLimitMiB) : that.memoryLimitMiB != null) return false;
            if (this.platformVersion != null ? !this.platformVersion.equals(that.platformVersion) : that.platformVersion != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.taskSubnets != null ? !this.taskSubnets.equals(that.taskSubnets) : that.taskSubnets != null) return false;
            if (!image.equals(that.image)) return false;
            if (this.circuitBreaker != null ? !this.circuitBreaker.equals(that.circuitBreaker) : that.circuitBreaker != null) return false;
            if (this.cluster != null ? !this.cluster.equals(that.cluster) : that.cluster != null) return false;
            if (this.command != null ? !this.command.equals(that.command) : that.command != null) return false;
            if (this.deploymentController != null ? !this.deploymentController.equals(that.deploymentController) : that.deploymentController != null) return false;
            if (this.enableEcsManagedTags != null ? !this.enableEcsManagedTags.equals(that.enableEcsManagedTags) : that.enableEcsManagedTags != null) return false;
            if (this.enableLogging != null ? !this.enableLogging.equals(that.enableLogging) : that.enableLogging != null) return false;
            if (this.environment != null ? !this.environment.equals(that.environment) : that.environment != null) return false;
            if (this.family != null ? !this.family.equals(that.family) : that.family != null) return false;
            if (this.logDriver != null ? !this.logDriver.equals(that.logDriver) : that.logDriver != null) return false;
            if (this.maxHealthyPercent != null ? !this.maxHealthyPercent.equals(that.maxHealthyPercent) : that.maxHealthyPercent != null) return false;
            if (this.maxReceiveCount != null ? !this.maxReceiveCount.equals(that.maxReceiveCount) : that.maxReceiveCount != null) return false;
            if (this.maxScalingCapacity != null ? !this.maxScalingCapacity.equals(that.maxScalingCapacity) : that.maxScalingCapacity != null) return false;
            if (this.minHealthyPercent != null ? !this.minHealthyPercent.equals(that.minHealthyPercent) : that.minHealthyPercent != null) return false;
            if (this.minScalingCapacity != null ? !this.minScalingCapacity.equals(that.minScalingCapacity) : that.minScalingCapacity != null) return false;
            if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
            if (this.queue != null ? !this.queue.equals(that.queue) : that.queue != null) return false;
            if (this.retentionPeriod != null ? !this.retentionPeriod.equals(that.retentionPeriod) : that.retentionPeriod != null) return false;
            if (this.scalingSteps != null ? !this.scalingSteps.equals(that.scalingSteps) : that.scalingSteps != null) return false;
            if (this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null) return false;
            if (this.serviceName != null ? !this.serviceName.equals(that.serviceName) : that.serviceName != null) return false;
            if (this.visibilityTimeout != null ? !this.visibilityTimeout.equals(that.visibilityTimeout) : that.visibilityTimeout != null) return false;
            return this.vpc != null ? this.vpc.equals(that.vpc) : that.vpc == null;
        }

        @Override
        public final int hashCode() {
            int result = this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0;
            result = 31 * result + (this.containerName != null ? this.containerName.hashCode() : 0);
            result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
            result = 31 * result + (this.memoryLimitMiB != null ? this.memoryLimitMiB.hashCode() : 0);
            result = 31 * result + (this.platformVersion != null ? this.platformVersion.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.taskSubnets != null ? this.taskSubnets.hashCode() : 0);
            result = 31 * result + (this.image.hashCode());
            result = 31 * result + (this.circuitBreaker != null ? this.circuitBreaker.hashCode() : 0);
            result = 31 * result + (this.cluster != null ? this.cluster.hashCode() : 0);
            result = 31 * result + (this.command != null ? this.command.hashCode() : 0);
            result = 31 * result + (this.deploymentController != null ? this.deploymentController.hashCode() : 0);
            result = 31 * result + (this.enableEcsManagedTags != null ? this.enableEcsManagedTags.hashCode() : 0);
            result = 31 * result + (this.enableLogging != null ? this.enableLogging.hashCode() : 0);
            result = 31 * result + (this.environment != null ? this.environment.hashCode() : 0);
            result = 31 * result + (this.family != null ? this.family.hashCode() : 0);
            result = 31 * result + (this.logDriver != null ? this.logDriver.hashCode() : 0);
            result = 31 * result + (this.maxHealthyPercent != null ? this.maxHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.maxReceiveCount != null ? this.maxReceiveCount.hashCode() : 0);
            result = 31 * result + (this.maxScalingCapacity != null ? this.maxScalingCapacity.hashCode() : 0);
            result = 31 * result + (this.minHealthyPercent != null ? this.minHealthyPercent.hashCode() : 0);
            result = 31 * result + (this.minScalingCapacity != null ? this.minScalingCapacity.hashCode() : 0);
            result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
            result = 31 * result + (this.queue != null ? this.queue.hashCode() : 0);
            result = 31 * result + (this.retentionPeriod != null ? this.retentionPeriod.hashCode() : 0);
            result = 31 * result + (this.scalingSteps != null ? this.scalingSteps.hashCode() : 0);
            result = 31 * result + (this.secrets != null ? this.secrets.hashCode() : 0);
            result = 31 * result + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            result = 31 * result + (this.visibilityTimeout != null ? this.visibilityTimeout.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            return result;
        }
    }
}
