package software.amazon.awscdk.services.eks;

/**
 * (experimental) Configuration props for EKS Fargate.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.31.0 (build 6fa403d)", date = "2021-07-21T10:24:21.886Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.FargateClusterProps")
@software.amazon.jsii.Jsii.Proxy(FargateClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface FargateClusterProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.eks.ClusterOptions {

    /**
     * (experimental) Fargate Profile to create along with the cluster.
     * <p>
     * Default: - A profile called "default" with 'default' and 'kube-system'
     *   selectors will be created if this is left undefined.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.eks.FargateProfileOptions getDefaultProfile() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link FargateClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link FargateClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<FargateClusterProps> {
        private software.amazon.awscdk.services.eks.FargateProfileOptions defaultProfile;
        private java.util.Map<java.lang.String, java.lang.String> clusterHandlerEnvironment;
        private software.amazon.awscdk.services.eks.CoreDnsComputeType coreDnsComputeType;
        private software.amazon.awscdk.services.eks.EndpointAccess endpointAccess;
        private java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment;
        private software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer;
        private software.amazon.awscdk.Size kubectlMemory;
        private software.amazon.awscdk.services.iam.IRole mastersRole;
        private java.lang.Boolean outputMastersRoleArn;
        private java.lang.Boolean placeClusterHandlerInVpc;
        private java.lang.Boolean prune;
        private software.amazon.awscdk.services.kms.IKey secretsEncryptionKey;
        private software.amazon.awscdk.services.eks.KubernetesVersion version;
        private java.lang.String clusterName;
        private java.lang.Boolean outputClusterName;
        private java.lang.Boolean outputConfigCommand;
        private software.amazon.awscdk.services.iam.IRole role;
        private software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private software.amazon.awscdk.services.ec2.IVpc vpc;
        private java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets;

        /**
         * Sets the value of {@link FargateClusterProps#getDefaultProfile}
         * @param defaultProfile Fargate Profile to create along with the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder defaultProfile(software.amazon.awscdk.services.eks.FargateProfileOptions defaultProfile) {
            this.defaultProfile = defaultProfile;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getClusterHandlerEnvironment}
         * @param clusterHandlerEnvironment Custom environment variables when interacting with the EKS endpoint to manage the cluster lifecycle.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterHandlerEnvironment(java.util.Map<java.lang.String, java.lang.String> clusterHandlerEnvironment) {
            this.clusterHandlerEnvironment = clusterHandlerEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getCoreDnsComputeType}
         * @param coreDnsComputeType Controls the "eks.amazonaws.com/compute-type" annotation in the CoreDNS configuration on your cluster to determine which compute type to use for CoreDNS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder coreDnsComputeType(software.amazon.awscdk.services.eks.CoreDnsComputeType coreDnsComputeType) {
            this.coreDnsComputeType = coreDnsComputeType;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getEndpointAccess}
         * @param endpointAccess Configure access to the Kubernetes API server endpoint..
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder endpointAccess(software.amazon.awscdk.services.eks.EndpointAccess endpointAccess) {
            this.endpointAccess = endpointAccess;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getKubectlEnvironment}
         * @param kubectlEnvironment Environment variables for the kubectl execution.
         *                           Only relevant for kubectl enabled clusters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlEnvironment(java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment) {
            this.kubectlEnvironment = kubectlEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getKubectlLayer}
         * @param kubectlLayer An AWS Lambda Layer which includes `kubectl`, Helm and the AWS CLI.
         *                     By default, the provider will use the layer included in the
         *                     "aws-lambda-layer-kubectl" SAR application which is available in all
         *                     commercial regions.
         *                     <p>
         *                     To deploy the layer locally, visit
         *                     https://github.com/aws-samples/aws-lambda-layer-kubectl/blob/master/cdk/README.md
         *                     for instructions on how to prepare the .zip file and then define it in your
         *                     app as follows:
         *                     <p>
         *                     <blockquote><pre>
         *                     // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         *                     LayerVersion layer = new LayerVersion(this, "kubectl-layer", new LayerVersionProps()
         *                             .code(lambda.Code.fromAsset(String.format("%s/layer.zip", __dirname))));
         *                     Object compatibleRuntimes;
         *                     </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlLayer(software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer) {
            this.kubectlLayer = kubectlLayer;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getKubectlMemory}
         * @param kubectlMemory Amount of memory to allocate to the provider's lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder kubectlMemory(software.amazon.awscdk.Size kubectlMemory) {
            this.kubectlMemory = kubectlMemory;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getMastersRole}
         * @param mastersRole An IAM role that will be added to the `system:masters` Kubernetes RBAC group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder mastersRole(software.amazon.awscdk.services.iam.IRole mastersRole) {
            this.mastersRole = mastersRole;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getOutputMastersRoleArn}
         * @param outputMastersRoleArn Determines whether a CloudFormation output with the ARN of the "masters" IAM role will be synthesized (if `mastersRole` is specified).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputMastersRoleArn(java.lang.Boolean outputMastersRoleArn) {
            this.outputMastersRoleArn = outputMastersRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getPlaceClusterHandlerInVpc}
         * @param placeClusterHandlerInVpc If set to true, the cluster handler functions will be placed in the private subnets of the cluster vpc, subject to the `vpcSubnets` selection strategy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder placeClusterHandlerInVpc(java.lang.Boolean placeClusterHandlerInVpc) {
            this.placeClusterHandlerInVpc = placeClusterHandlerInVpc;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getPrune}
         * @param prune Indicates whether Kubernetes resources added through `addManifest()` can be automatically pruned.
         *              When this is enabled (default), prune labels will be
         *              allocated and injected to each resource. These labels will then be used
         *              when issuing the <code>kubectl apply</code> operation with the <code>--prune</code> switch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder prune(java.lang.Boolean prune) {
            this.prune = prune;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getSecretsEncryptionKey}
         * @param secretsEncryptionKey KMS secret for envelope encryption for Kubernetes secrets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder secretsEncryptionKey(software.amazon.awscdk.services.kms.IKey secretsEncryptionKey) {
            this.secretsEncryptionKey = secretsEncryptionKey;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getVersion}
         * @param version The Kubernetes version to run in the cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder version(software.amazon.awscdk.services.eks.KubernetesVersion version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getClusterName}
         * @param clusterName Name for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getOutputClusterName}
         * @param outputClusterName Determines whether a CloudFormation output with the name of the cluster will be synthesized.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputClusterName(java.lang.Boolean outputClusterName) {
            this.outputClusterName = outputClusterName;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getOutputConfigCommand}
         * @param outputConfigCommand Determines whether a CloudFormation output with the `aws eks update-kubeconfig` command will be synthesized.
         *                            This command will include
         *                            the cluster name and, if applicable, the ARN of the masters IAM role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder outputConfigCommand(java.lang.Boolean outputConfigCommand) {
            this.outputConfigCommand = outputConfigCommand;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getRole}
         * @param role Role that provides permissions for the Kubernetes control plane to make calls to AWS API operations on your behalf.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getSecurityGroup}
         * @param securityGroup Security Group to use for Control Plane ENIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getVpc}
         * @param vpc The VPC in which to create the Cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link FargateClusterProps#getVpcSubnets}
         * @param vpcSubnets Where to place EKS Control Plane ENIs.
         *                   If you want to create public load balancers, this must include public subnets.
         *                   <p>
         *                   For example, to only select private subnets, supply the following:
         *                   <p>
         *                   <blockquote><pre>
         *                   // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
         *                   vpcSubnets: [
         *                      { subnetType: ec2.SubnetType.Private }
         *                   ]
         *                   </pre></blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @SuppressWarnings("unchecked")
        public Builder vpcSubnets(java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets) {
            this.vpcSubnets = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link FargateClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public FargateClusterProps build() {
            return new Jsii$Proxy(defaultProfile, clusterHandlerEnvironment, coreDnsComputeType, endpointAccess, kubectlEnvironment, kubectlLayer, kubectlMemory, mastersRole, outputMastersRoleArn, placeClusterHandlerInVpc, prune, secretsEncryptionKey, version, clusterName, outputClusterName, outputConfigCommand, role, securityGroup, vpc, vpcSubnets);
        }
    }

    /**
     * An implementation for {@link FargateClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FargateClusterProps {
        private final software.amazon.awscdk.services.eks.FargateProfileOptions defaultProfile;
        private final java.util.Map<java.lang.String, java.lang.String> clusterHandlerEnvironment;
        private final software.amazon.awscdk.services.eks.CoreDnsComputeType coreDnsComputeType;
        private final software.amazon.awscdk.services.eks.EndpointAccess endpointAccess;
        private final java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment;
        private final software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer;
        private final software.amazon.awscdk.Size kubectlMemory;
        private final software.amazon.awscdk.services.iam.IRole mastersRole;
        private final java.lang.Boolean outputMastersRoleArn;
        private final java.lang.Boolean placeClusterHandlerInVpc;
        private final java.lang.Boolean prune;
        private final software.amazon.awscdk.services.kms.IKey secretsEncryptionKey;
        private final software.amazon.awscdk.services.eks.KubernetesVersion version;
        private final java.lang.String clusterName;
        private final java.lang.Boolean outputClusterName;
        private final java.lang.Boolean outputConfigCommand;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.defaultProfile = software.amazon.jsii.Kernel.get(this, "defaultProfile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.FargateProfileOptions.class));
            this.clusterHandlerEnvironment = software.amazon.jsii.Kernel.get(this, "clusterHandlerEnvironment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.coreDnsComputeType = software.amazon.jsii.Kernel.get(this, "coreDnsComputeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.CoreDnsComputeType.class));
            this.endpointAccess = software.amazon.jsii.Kernel.get(this, "endpointAccess", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.EndpointAccess.class));
            this.kubectlEnvironment = software.amazon.jsii.Kernel.get(this, "kubectlEnvironment", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.kubectlLayer = software.amazon.jsii.Kernel.get(this, "kubectlLayer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.ILayerVersion.class));
            this.kubectlMemory = software.amazon.jsii.Kernel.get(this, "kubectlMemory", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Size.class));
            this.mastersRole = software.amazon.jsii.Kernel.get(this, "mastersRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.outputMastersRoleArn = software.amazon.jsii.Kernel.get(this, "outputMastersRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.placeClusterHandlerInVpc = software.amazon.jsii.Kernel.get(this, "placeClusterHandlerInVpc", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.prune = software.amazon.jsii.Kernel.get(this, "prune", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.secretsEncryptionKey = software.amazon.jsii.Kernel.get(this, "secretsEncryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.KubernetesVersion.class));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputClusterName = software.amazon.jsii.Kernel.get(this, "outputClusterName", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.outputConfigCommand = software.amazon.jsii.Kernel.get(this, "outputConfigCommand", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final software.amazon.awscdk.services.eks.FargateProfileOptions defaultProfile, final java.util.Map<java.lang.String, java.lang.String> clusterHandlerEnvironment, final software.amazon.awscdk.services.eks.CoreDnsComputeType coreDnsComputeType, final software.amazon.awscdk.services.eks.EndpointAccess endpointAccess, final java.util.Map<java.lang.String, java.lang.String> kubectlEnvironment, final software.amazon.awscdk.services.lambda.ILayerVersion kubectlLayer, final software.amazon.awscdk.Size kubectlMemory, final software.amazon.awscdk.services.iam.IRole mastersRole, final java.lang.Boolean outputMastersRoleArn, final java.lang.Boolean placeClusterHandlerInVpc, final java.lang.Boolean prune, final software.amazon.awscdk.services.kms.IKey secretsEncryptionKey, final software.amazon.awscdk.services.eks.KubernetesVersion version, final java.lang.String clusterName, final java.lang.Boolean outputClusterName, final java.lang.Boolean outputConfigCommand, final software.amazon.awscdk.services.iam.IRole role, final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup, final software.amazon.awscdk.services.ec2.IVpc vpc, final java.util.List<? extends software.amazon.awscdk.services.ec2.SubnetSelection> vpcSubnets) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.defaultProfile = defaultProfile;
            this.clusterHandlerEnvironment = clusterHandlerEnvironment;
            this.coreDnsComputeType = coreDnsComputeType;
            this.endpointAccess = endpointAccess;
            this.kubectlEnvironment = kubectlEnvironment;
            this.kubectlLayer = kubectlLayer;
            this.kubectlMemory = kubectlMemory;
            this.mastersRole = mastersRole;
            this.outputMastersRoleArn = outputMastersRoleArn;
            this.placeClusterHandlerInVpc = placeClusterHandlerInVpc;
            this.prune = prune;
            this.secretsEncryptionKey = secretsEncryptionKey;
            this.version = java.util.Objects.requireNonNull(version, "version is required");
            this.clusterName = clusterName;
            this.outputClusterName = outputClusterName;
            this.outputConfigCommand = outputConfigCommand;
            this.role = role;
            this.securityGroup = securityGroup;
            this.vpc = vpc;
            this.vpcSubnets = (java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection>)vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.eks.FargateProfileOptions getDefaultProfile() {
            return this.defaultProfile;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getClusterHandlerEnvironment() {
            return this.clusterHandlerEnvironment;
        }

        @Override
        public final software.amazon.awscdk.services.eks.CoreDnsComputeType getCoreDnsComputeType() {
            return this.coreDnsComputeType;
        }

        @Override
        public final software.amazon.awscdk.services.eks.EndpointAccess getEndpointAccess() {
            return this.endpointAccess;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getKubectlEnvironment() {
            return this.kubectlEnvironment;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.ILayerVersion getKubectlLayer() {
            return this.kubectlLayer;
        }

        @Override
        public final software.amazon.awscdk.Size getKubectlMemory() {
            return this.kubectlMemory;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getMastersRole() {
            return this.mastersRole;
        }

        @Override
        public final java.lang.Boolean getOutputMastersRoleArn() {
            return this.outputMastersRoleArn;
        }

        @Override
        public final java.lang.Boolean getPlaceClusterHandlerInVpc() {
            return this.placeClusterHandlerInVpc;
        }

        @Override
        public final java.lang.Boolean getPrune() {
            return this.prune;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getSecretsEncryptionKey() {
            return this.secretsEncryptionKey;
        }

        @Override
        public final software.amazon.awscdk.services.eks.KubernetesVersion getVersion() {
            return this.version;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.Boolean getOutputClusterName() {
            return this.outputClusterName;
        }

        @Override
        public final java.lang.Boolean getOutputConfigCommand() {
            return this.outputConfigCommand;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.SubnetSelection> getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDefaultProfile() != null) {
                data.set("defaultProfile", om.valueToTree(this.getDefaultProfile()));
            }
            if (this.getClusterHandlerEnvironment() != null) {
                data.set("clusterHandlerEnvironment", om.valueToTree(this.getClusterHandlerEnvironment()));
            }
            if (this.getCoreDnsComputeType() != null) {
                data.set("coreDnsComputeType", om.valueToTree(this.getCoreDnsComputeType()));
            }
            if (this.getEndpointAccess() != null) {
                data.set("endpointAccess", om.valueToTree(this.getEndpointAccess()));
            }
            if (this.getKubectlEnvironment() != null) {
                data.set("kubectlEnvironment", om.valueToTree(this.getKubectlEnvironment()));
            }
            if (this.getKubectlLayer() != null) {
                data.set("kubectlLayer", om.valueToTree(this.getKubectlLayer()));
            }
            if (this.getKubectlMemory() != null) {
                data.set("kubectlMemory", om.valueToTree(this.getKubectlMemory()));
            }
            if (this.getMastersRole() != null) {
                data.set("mastersRole", om.valueToTree(this.getMastersRole()));
            }
            if (this.getOutputMastersRoleArn() != null) {
                data.set("outputMastersRoleArn", om.valueToTree(this.getOutputMastersRoleArn()));
            }
            if (this.getPlaceClusterHandlerInVpc() != null) {
                data.set("placeClusterHandlerInVpc", om.valueToTree(this.getPlaceClusterHandlerInVpc()));
            }
            if (this.getPrune() != null) {
                data.set("prune", om.valueToTree(this.getPrune()));
            }
            if (this.getSecretsEncryptionKey() != null) {
                data.set("secretsEncryptionKey", om.valueToTree(this.getSecretsEncryptionKey()));
            }
            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getClusterName() != null) {
                data.set("clusterName", om.valueToTree(this.getClusterName()));
            }
            if (this.getOutputClusterName() != null) {
                data.set("outputClusterName", om.valueToTree(this.getOutputClusterName()));
            }
            if (this.getOutputConfigCommand() != null) {
                data.set("outputConfigCommand", om.valueToTree(this.getOutputConfigCommand()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_eks.FargateClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            FargateClusterProps.Jsii$Proxy that = (FargateClusterProps.Jsii$Proxy) o;

            if (this.defaultProfile != null ? !this.defaultProfile.equals(that.defaultProfile) : that.defaultProfile != null) return false;
            if (this.clusterHandlerEnvironment != null ? !this.clusterHandlerEnvironment.equals(that.clusterHandlerEnvironment) : that.clusterHandlerEnvironment != null) return false;
            if (this.coreDnsComputeType != null ? !this.coreDnsComputeType.equals(that.coreDnsComputeType) : that.coreDnsComputeType != null) return false;
            if (this.endpointAccess != null ? !this.endpointAccess.equals(that.endpointAccess) : that.endpointAccess != null) return false;
            if (this.kubectlEnvironment != null ? !this.kubectlEnvironment.equals(that.kubectlEnvironment) : that.kubectlEnvironment != null) return false;
            if (this.kubectlLayer != null ? !this.kubectlLayer.equals(that.kubectlLayer) : that.kubectlLayer != null) return false;
            if (this.kubectlMemory != null ? !this.kubectlMemory.equals(that.kubectlMemory) : that.kubectlMemory != null) return false;
            if (this.mastersRole != null ? !this.mastersRole.equals(that.mastersRole) : that.mastersRole != null) return false;
            if (this.outputMastersRoleArn != null ? !this.outputMastersRoleArn.equals(that.outputMastersRoleArn) : that.outputMastersRoleArn != null) return false;
            if (this.placeClusterHandlerInVpc != null ? !this.placeClusterHandlerInVpc.equals(that.placeClusterHandlerInVpc) : that.placeClusterHandlerInVpc != null) return false;
            if (this.prune != null ? !this.prune.equals(that.prune) : that.prune != null) return false;
            if (this.secretsEncryptionKey != null ? !this.secretsEncryptionKey.equals(that.secretsEncryptionKey) : that.secretsEncryptionKey != null) return false;
            if (!version.equals(that.version)) return false;
            if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) return false;
            if (this.outputClusterName != null ? !this.outputClusterName.equals(that.outputClusterName) : that.outputClusterName != null) return false;
            if (this.outputConfigCommand != null ? !this.outputConfigCommand.equals(that.outputConfigCommand) : that.outputConfigCommand != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.defaultProfile != null ? this.defaultProfile.hashCode() : 0;
            result = 31 * result + (this.clusterHandlerEnvironment != null ? this.clusterHandlerEnvironment.hashCode() : 0);
            result = 31 * result + (this.coreDnsComputeType != null ? this.coreDnsComputeType.hashCode() : 0);
            result = 31 * result + (this.endpointAccess != null ? this.endpointAccess.hashCode() : 0);
            result = 31 * result + (this.kubectlEnvironment != null ? this.kubectlEnvironment.hashCode() : 0);
            result = 31 * result + (this.kubectlLayer != null ? this.kubectlLayer.hashCode() : 0);
            result = 31 * result + (this.kubectlMemory != null ? this.kubectlMemory.hashCode() : 0);
            result = 31 * result + (this.mastersRole != null ? this.mastersRole.hashCode() : 0);
            result = 31 * result + (this.outputMastersRoleArn != null ? this.outputMastersRoleArn.hashCode() : 0);
            result = 31 * result + (this.placeClusterHandlerInVpc != null ? this.placeClusterHandlerInVpc.hashCode() : 0);
            result = 31 * result + (this.prune != null ? this.prune.hashCode() : 0);
            result = 31 * result + (this.secretsEncryptionKey != null ? this.secretsEncryptionKey.hashCode() : 0);
            result = 31 * result + (this.version.hashCode());
            result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
            result = 31 * result + (this.outputClusterName != null ? this.outputClusterName.hashCode() : 0);
            result = 31 * result + (this.outputConfigCommand != null ? this.outputConfigCommand.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
